/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class BlockProperties
extends MarkupComponent
implements Nameable {
    private XMLEventFactory eventFactory;
    private StartElement startElement;
    private EndElement endElement;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<BlockProperty> properties = new ArrayList<BlockProperty>();

    BlockProperties(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement, List<BlockProperty> properties) {
        this.eventFactory = eventFactory;
        this.startElement = startElement;
        this.endElement = endElement;
        Iterator<Attribute> iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            this.attributes.add(iterator.next());
        }
        this.properties.addAll(properties);
    }

    @Override
    public QName getName() {
        return this.startElement.getName();
    }

    @Override
    public List<XMLEvent> getEvents() {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
        events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
        for (BlockProperty property : this.properties) {
            events.addAll(property.getEvents());
        }
        events.add(this.endElement);
        return events;
    }

    List<Attribute> getAttributes() {
        return this.attributes;
    }

    List<BlockProperty> getProperties() {
        return this.properties;
    }

    BlockProperty getParagraphStyleProperty() {
        for (BlockProperty property : this.properties) {
            if (!XMLEventHelpers.WPML_PARAGRAPH_STYLE.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    Attribute getParagraphLevelAttribute() {
        for (Attribute attribute : this.attributes) {
            if (!"lvl".equals(attribute.getName().getLocalPart())) continue;
            return attribute;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockProperties that = (BlockProperties)o;
        return Objects.equals(this.startElement, that.startElement) && Objects.equals(this.endElement, that.endElement) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.startElement, this.endElement, this.attributes, this.properties);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.properties.size() + ")" + this.properties;
    }
}

