/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.GenericPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class ExcelFormulaPartHandler
extends GenericPartHandler {
    private ISkeleton skeleton;
    private String documentId;
    private String subDocumentId;
    private XMLEventReader xmlReader;
    private Map<String, String> sharedStrings;
    private XMLEventFactory eventFactory;
    private static final String NAME = "name";
    private static Pattern FORMULA_PATTERN = Pattern.compile("(.*?[\\[\"]{1})([a-zA-Z0-9 \\*]+?)([\\]\"]{1}.*)", 32);
    private Iterator<Event> filterEventIterator;

    ExcelFormulaPartHandler(ConditionalParameters params, OpenXMLZipFile zipFile, ZipEntry entry, Map<String, String> sharedStrings) {
        this(params, sharedStrings, entry.getName());
        this.zipFile = zipFile;
        this.entry = entry;
    }

    ExcelFormulaPartHandler(ConditionalParameters params, ISkeleton skeleton, Map<String, String> sharedStrings, ZipEntry entry) {
        this(params, sharedStrings, entry.getName());
        this.skeleton = skeleton;
    }

    private ExcelFormulaPartHandler(ConditionalParameters params, Map<String, String> sharedStrings, String partName) {
        super(params, partName);
        this.sharedStrings = sharedStrings;
        this.eventFactory = XMLEventFactory.newInstance();
    }

    private void process() throws XMLStreamException, IOException {
        DocumentPart documentPart = new DocumentPart(this.documentPartIdGenerator.createId(), false);
        documentPart.setSkeleton(new GenericSkeleton(this.getModifiedContent()));
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, documentPart));
        this.filterEvents.add(new Event(EventType.END_DOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    public String getModifiedContent() throws XMLStreamException, IOException {
        StringWriter sw = new StringWriter();
        XMLEventWriter xmlEventWriter = XMLOutputFactory.newInstance().createXMLEventWriter(sw);
        this.xmlReader = this.createXMLReader();
        while (this.xmlReader.hasNext()) {
            XMLEvent e = this.xmlReader.nextEvent();
            if (XMLEventHelpers.isTableColumnEvent(e)) {
                e = this.rewriteNameAttribute(e);
            } else if (XMLEventHelpers.isExcelFormula(e)) {
                xmlEventWriter.add(e);
                e = this.xmlReader.nextEvent();
                if (e.isCharacters()) {
                    e = this.eventFactory.createCharacters(this.updateTextualReferencesInParsedCharacterData(e.asCharacters()));
                }
            }
            xmlEventWriter.add(e);
        }
        return sw.toString();
    }

    private XMLEventReader createXMLReader() throws XMLStreamException, IOException {
        if (this.zipFile == null && this.entry == null && this.skeleton != null) {
            return XMLInputFactory.newInstance().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(new ByteArrayInputStream(this.skeleton.toString().getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8));
        }
        if (this.skeleton == null && this.zipFile != null && this.entry != null) {
            return this.zipFile.getInputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.zipFile.getInputStream(this.entry)), StandardCharsets.UTF_8));
        }
        throw new OkapiException("XMLReader should be initialized with zip file configuration or with string content");
    }

    private XMLEvent rewriteNameAttribute(XMLEvent e) {
        String value = e.asStartElement().getAttributeByName(new QName(NAME)).getValue();
        String translatedSharedString = this.sharedStrings.get(value);
        if (translatedSharedString == null) {
            return e;
        }
        Attribute attr = this.eventFactory.createAttribute(NAME, translatedSharedString);
        Iterator<Attribute> attributeIterator = e.asStartElement().getAttributes();
        ArrayList<Attribute> updatedAttributes = new ArrayList<Attribute>();
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            if (NAME.equalsIgnoreCase(attribute.getName().toString())) {
                updatedAttributes.add(attr);
                continue;
            }
            updatedAttributes.add(attribute);
        }
        return this.eventFactory.createStartElement(e.asStartElement().getName(), updatedAttributes.iterator(), e.asStartElement().getNamespaces());
    }

    private String updateTextualReferencesInParsedCharacterData(Characters pcdata) {
        StringBuilder result = new StringBuilder();
        String text = pcdata.getData();
        Matcher formulaMatcher = FORMULA_PATTERN.matcher(text);
        String formulaPart = null;
        if (!formulaMatcher.find()) {
            return text;
        }
        while (formulaMatcher.groupCount() == FORMULA_MATCHER_GROUPS.values().length) {
            result.append(formulaMatcher.group(FORMULA_MATCHER_GROUPS.NON_TRANSLATABLE.getValue()));
            String textUnitPart = formulaMatcher.group(FORMULA_MATCHER_GROUPS.TRANSLATABLE.getValue());
            if (this.sharedStrings.get(textUnitPart) == null) {
                result.append(textUnitPart);
            } else {
                result.append(this.sharedStrings.get(textUnitPart));
            }
            formulaPart = formulaMatcher.group(FORMULA_MATCHER_GROUPS.UNPROCESSED.getValue());
            formulaMatcher.reset(formulaPart);
            if (formulaMatcher.find()) continue;
        }
        if (formulaPart != null) {
            result.append(formulaPart);
        }
        return result.toString();
    }

    @Override
    public Event open(String documentId, String subDocumentId, LocaleId srcLang) throws IOException, XMLStreamException {
        this.documentId = documentId;
        this.subDocumentId = subDocumentId;
        this.process();
        return this.createStartSubDocumentEvent(documentId, subDocumentId);
    }

    @Override
    public boolean hasNext() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event next() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }

    private static enum FORMULA_MATCHER_GROUPS {
        NON_TRANSLATABLE(1),
        TRANSLATABLE(2),
        UNPROCESSED(3);

        int value;

        private FORMULA_MATCHER_GROUPS(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

