/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiEncryptedDataException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.AbstractTranslator;
import net.sf.okapi.filters.openxml.ClarifiablePartHandler;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelFormulaPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFileProxy;
import net.sf.okapi.filters.openxml.OpenXMLZipFilterWriter;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.PostponedDocumentPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=ConditionalParameters.class)
public class OpenXMLFilter
implements IFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String MIMETYPE = "text/xml";
    private static final String documentId = "sd";
    private OpenXMLZipFileProxy zipFile;
    private File tempFile;
    private ZipEntry entry;
    private NextAction nextAction;
    private URI docURI;
    private Enumeration<? extends ZipEntry> entries;
    private int subDocumentId;
    private LinkedList<Event> queue;
    private LinkedList<Event> postponedEventsQueue;
    private LocaleId srcLang;
    private OpenXMLPartHandler currentPartHandler;
    private ConditionalParameters cparams = null;
    private DocumentType nZipType = null;
    private ParseType nFileType = ParseType.MSWORD;
    private AbstractTranslator translator = null;
    private LocaleId sOutputLanguage = LocaleId.US_ENGLISH;
    private String encoding = "UTF-8";
    private EncoderManager encoderManager;
    private XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private RawDocument input;
    private Map<String, String> sharedStrings;

    public OpenXMLFilter() {
        this.cparams = new ConditionalParameters();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        this.sharedStrings = new HashMap<String, String>();
        this.postponedEventsQueue = new LinkedList();
    }

    public OpenXMLFilter(AbstractTranslator translator, LocaleId sOutputLanguage) {
        this.translator = translator;
        this.sOutputLanguage = sOutputLanguage;
        this.cparams = new ConditionalParameters();
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        this.sharedStrings = new HashMap<String, String>();
        this.postponedEventsQueue = new LinkedList();
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
        try {
            this.nextAction = NextAction.DONE;
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zipped output file.");
        }
        if (this.currentPartHandler != null) {
            this.currentPartHandler.close();
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new OpenXMLZipFilterWriter(this.cparams, this.inputFactory, this.outputFactory, this.eventFactory);
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(MIMETYPE, "net.sf.okapi.common.encoder.XMLEncoder");
            this.encoderManager.setMapping("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return "okf_openxml";
    }

    @Override
    public String getDisplayName() {
        return "OpenXML Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Microsoft Office Document", "Microsoft Office documents (DOCX, DOCM, DOTX, DOTM, PPTX, PPTM, PPSX, PPSM, POTX, POTM, XLSX, XLSM, XLTX, XLTM, VSDX, VSDM).", null, ".docx;.docm;.dotx;.dotm;.pptx;.pptm;.ppsx;.ppsm;.potx;.potm;.xlsx;.xlsm;.xltx;.xltm;.vsdx;.vsdm;"));
        return list;
    }

    @Override
    public ConditionalParameters getParameters() {
        return this.cparams;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null && !this.queue.isEmpty() || this.nextAction != NextAction.DONE;
    }

    @Override
    public Event next() {
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        try {
            switch (this.nextAction) {
                case OPENZIP: {
                    return this.openZipFile();
                }
                case NEXTINZIP: {
                    Event e = this.nextInZipFile();
                    if (e.getEventType() == EventType.CUSTOM) {
                        this.postponedEventsQueue.add(e);
                    }
                    return e;
                }
                case NEXTINSUBDOC: {
                    Event e = this.nextInSubDocument();
                    if (e != null) {
                        return e;
                    }
                    this.nextAction = NextAction.NEXTINZIP;
                    return this.next();
                }
                case POSTPONED: {
                    return this.handlePostponedEvent();
                }
            }
            throw new OkapiException("Invalid next() call.");
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiException("An error occurred during extraction", e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (input == null) {
            throw new OkapiException("RawDocument is null");
        }
        this.input = input;
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), input.getEncoding(), generateSkeleton);
        if (input.getInputCharSequence() != null) {
            this.open(input.getInputCharSequence());
        } else if (input.getInputURI() != null) {
            this.open(input.getInputURI());
            this.LOGGER.debug("\nOpening {}", (Object)input.getInputURI().toString());
        } else if (input.getStream() != null) {
            this.open(input.getStream());
        } else {
            throw new OkapiException("InputResource has no input defined.");
        }
    }

    public void open(InputStream input) {
        this.tempFile = FileUtil.createTempFile("~okapi-23_OpenXMLFilter_");
        StreamUtil.copy(input, this.tempFile);
        this.open(Util.toURI(this.tempFile.getAbsolutePath()));
    }

    private void open(CharSequence inputText) {
        throw new UnsupportedOperationException("Method is not supported for this filter.");
    }

    public void open(URI inputURI) {
        this.docURI = inputURI;
        this.nextAction = NextAction.OPENZIP;
        this.queue = new LinkedList();
        this.LOGGER.debug("\nOpening {}", (Object)inputURI.toString());
    }

    public void setOptions(LocaleId sourceLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.setOptions(sourceLanguage, null, defaultEncoding, generateSkeleton);
    }

    public void setOptions(LocaleId sourceLanguage, LocaleId targetLanguage, String defaultEncoding, boolean generateSkeleton) {
        this.srcLang = sourceLanguage;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.cparams = (ConditionalParameters)params;
    }

    private Event openZipFile() {
        try {
            File fZip = new File(this.docURI.getPath());
            if (this.isZipFileEncrypted(fZip)) {
                throw new OkapiEncryptedDataException();
            }
            this.zipFile = new OpenXMLZipFileProxy(new ZipFile(fZip, 1), this.inputFactory, this.outputFactory, this.eventFactory, this.encoding, this.sharedStrings);
            this.nZipType = this.zipFile.createDocument(this.cparams);
            if (this.nZipType == null) {
                throw new OkapiBadFilterInputException("MS Office 2007 filter tried to open a file that is not aMicrosoft Office 2007 Word, Excel, or Powerpoint file.");
            }
            this.entries = this.nZipType.getZipFileEntries();
            this.subDocumentId = 0;
            this.nextAction = NextAction.NEXTINZIP;
            StartDocument startDoc = new StartDocument(documentId);
            startDoc.setName(this.docURI.getPath());
            startDoc.setLocale(this.srcLang);
            startDoc.setMimeType(MIMETYPE);
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setLineBreak("\n");
            startDoc.setEncoding(this.encoding, false);
            startDoc.setFilterParameters(this.cparams);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile.getZip(), null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }
        catch (ZipException e) {
            throw new OkapiIOException("Error opening zipped input file.");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading zipped input file.", e);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Error parsing XML content", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isZipFileEncrypted(File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            new CompoundDocument(is);
            boolean bl = true;
            return bl;
        }
        catch (CorruptDocumentException e) {
            return false;
        }
    }

    private Event nextInZipFile() throws IOException, XMLStreamException {
        if (this.entries.hasMoreElements()) {
            this.entry = this.entries.nextElement();
            String sEntryName = this.entry.getName();
            String sDocType = this.zipFile.getContentTypes().getContentType("/" + sEntryName);
            this.LOGGER.debug("\n\n<<<<<<< {} : {} >>>>>>>", (Object)sEntryName, (Object)sDocType);
            this.currentPartHandler = this.nZipType.getHandlerForFile(this.entry, sDocType);
            this.nextAction = NextAction.NEXTINSUBDOC;
            return this.currentPartHandler.open(documentId, String.valueOf(++this.subDocumentId), this.srcLang);
        }
        if (this.postponedEventsQueue.isEmpty()) {
            return this.completeDocument();
        }
        this.nextAction = NextAction.POSTPONED;
        return new Event(EventType.NO_OP);
    }

    private Event completeDocument() {
        this.close();
        Ending ending = new Ending("ed");
        return new Event(EventType.END_DOCUMENT, ending);
    }

    private Event handlePostponedEvent() throws IOException, XMLStreamException {
        if (this.postponedEventsQueue.isEmpty()) {
            return this.completeDocument();
        }
        Event event = this.postponedEventsQueue.poll();
        PostponedDocumentPart postponedDocumentPart = (PostponedDocumentPart)event.getResource();
        if (!postponedDocumentPart.isPartHidden()) {
            ExcelFormulaPartHandler excelContentPartHandler = new ExcelFormulaPartHandler(this.cparams, postponedDocumentPart.getSkeleton(), this.sharedStrings, postponedDocumentPart.getZipEntry());
            this.nextAction = NextAction.NEXTINSUBDOC;
            ClarifiablePartHandler clarifiablePartHandler = new ClarifiablePartHandler(this.zipFile, postponedDocumentPart.getZipEntry());
            this.currentPartHandler = clarifiablePartHandler;
            ByteArrayInputStream bis = new ByteArrayInputStream(excelContentPartHandler.getModifiedContent().getBytes(StandardCharsets.UTF_8));
            return clarifiablePartHandler.open(bis);
        }
        ClarifiablePartHandler clarifiableParthandler = new ClarifiablePartHandler(this.zipFile, postponedDocumentPart.getZipEntry());
        this.currentPartHandler = clarifiableParthandler;
        ByteArrayInputStream bis = new ByteArrayInputStream(postponedDocumentPart.getSkeleton().toString().getBytes(StandardCharsets.UTF_8));
        return clarifiableParthandler.open(bis);
    }

    private Event nextInSubDocument() {
        if (this.currentPartHandler.hasNext()) {
            Event event = this.currentPartHandler.next();
            switch (event.getEventType()) {
                case TEXT_UNIT: {
                    if (this.translator != null) {
                        this.translator.addToReferents(event);
                        ITextUnit tu = event.getTextUnit();
                        TextFragment tfSource = tu.getSource().getFirstContent();
                        String torg = this.translator.translate(tfSource, this.LOGGER, this.nFileType);
                        TextFragment tfTarget = tfSource.clone();
                        tfTarget.setCodedText(torg);
                        TextContainer tc = new TextContainer();
                        tc.setContent(tfTarget);
                        tu.setTarget(this.sOutputLanguage, tc);
                        this.sharedStrings.put(tfSource.getCodedText(), torg);
                        tfSource = null;
                    }
                    this.currentPartHandler.logEvent(event);
                    return event;
                }
                case END_DOCUMENT: {
                    Ending ending = new Ending(String.valueOf(this.subDocumentId));
                    this.nextAction = NextAction.NEXTINZIP;
                    ZipSkeleton skel = new ZipSkeleton((GenericSkeleton)event.getResource().getSkeleton(), this.zipFile.getZip(), this.entry);
                    this.currentPartHandler.close();
                    return new Event(EventType.END_SUBDOCUMENT, ending, skel);
                }
                case DOCUMENT_PART: 
                case START_GROUP: 
                case START_SUBFILTER: {
                    if (this.translator == null) break;
                    this.translator.addToReferents(event);
                }
            }
            this.currentPartHandler.logEvent(event);
            return event;
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    private static enum NextAction {
        OPENZIP,
        NEXTINZIP,
        NEXTINSUBDOC,
        POSTPONED,
        DONE;

    }
}

