/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.openxml.BlockSkeleton;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemSkeleton;
import net.sf.okapi.filters.openxml.StyledText;
import net.sf.okapi.filters.openxml.TextUnitMapper;
import net.sf.okapi.filters.openxml.XMLEvents;

class StringItemTextUnitMapper
extends TextUnitMapper {
    private StringItem stringItem;

    public StringItemTextUnitMapper(StringItem stringItem, IdGenerator idGenerator) {
        super(idGenerator);
        this.stringItem = stringItem;
    }

    @Override
    public List<ITextUnit> getTextUnits() {
        if (this.textUnits == null) {
            this.textUnits = this.stringItem.isStyled() ? this.process() : this.createTextUnit();
        }
        return this.textUnits;
    }

    public List<ITextUnit> process() {
        if (this.stringItem.getChunks().size() <= 2) {
            for (XMLEvents xMLEvents : this.stringItem.getChunks()) {
                if (!(xMLEvents instanceof Run) && !(xMLEvents instanceof StyledText)) continue;
                throw new IllegalStateException("Unexpected structure");
            }
            return Collections.emptyList();
        }
        TextUnit textUnit = new TextUnit(this.idGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        textUnit.setSource(new TextContainer(textFragment));
        List<Chunk> chunks = this.stringItem.getChunks().subList(1, this.stringItem.getChunks().size() - 1);
        boolean runHasText = false;
        for (Chunk chunk : chunks) {
            if (chunk instanceof Run) {
                runHasText |= this.processRun(textFragment, (Run)chunk, textUnit);
                continue;
            }
            this.addIsolatedCode(textFragment, chunk);
        }
        this.popAllRunCodes(textFragment);
        ArrayList<ITextUnit> tus = new ArrayList<ITextUnit>();
        tus.addAll(this.referentTus);
        if (runHasText || !this.referentTus.isEmpty()) {
            BlockSkeleton skel = new BlockSkeleton(this.stringItem.getBlock(), this.codeMap);
            skel.setParent(textUnit);
            textUnit.setSkeleton(skel);
            tus.add(textUnit);
        }
        return tus;
    }

    private List<ITextUnit> createTextUnit() {
        TextUnit textUnit = new TextUnit(this.idGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment tf = new TextFragment();
        textUnit.setSource(new TextContainer(tf));
        StyledText styledText = (StyledText)this.stringItem.getChunks().get(1);
        this.addText(tf, styledText.getText());
        StringItemSkeleton skel = new StringItemSkeleton(this.stringItem, this.codeMap);
        skel.setParent(textUnit);
        textUnit.setSkeleton(skel);
        return Arrays.asList(textUnit);
    }
}

