/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StyledText;
import net.sf.okapi.filters.openxml.TextUnitWriter;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

public class StringItemTextUnitWriter
implements TextUnitWriter {
    private final XMLEventFactory eventFactory;
    private final StringItem stringItem;
    private final XMLEventSerializer xmlWriter;

    public StringItemTextUnitWriter(XMLEventFactory eventFactory, StringItem stringItem, XMLEventSerializer xmlWriter) {
        this.eventFactory = eventFactory;
        this.stringItem = stringItem;
        this.xmlWriter = xmlWriter;
    }

    @Override
    public void write(TextContainer tc) {
        StyledText styledText = (StyledText)this.stringItem.getChunks().get(1);
        this.xmlWriter.add(styledText.startElement);
        String textContent = new TextContentAssembler(tc.getSegments()).assemble();
        if (!textContent.isEmpty()) {
            this.xmlWriter.add(this.eventFactory.createCharacters(textContent));
        }
        this.xmlWriter.add(styledText.endElement);
    }

    private static class TextContentAssembler {
        private ISegments segments;

        TextContentAssembler(ISegments segments) {
            this.segments = segments;
        }

        String assemble() {
            StringBuilder textContentBuilder = new StringBuilder();
            for (Segment segment : this.segments) {
                this.assembleSegmentContent(segment, textContentBuilder);
            }
            return textContentBuilder.toString();
        }

        private void assembleSegmentContent(Segment segment, StringBuilder textContentBuilder) {
            TextFragment content = segment.getContent();
            String codedText = content.getCodedText();
            for (int i = 0; i < codedText.length(); ++i) {
                char c = codedText.charAt(i);
                textContentBuilder.append(c);
            }
        }
    }
}

