/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String COMMAND = "command";
    private static final String ORIGIN = "origin";
    private static final String MARKASMT = "markAsMT";
    private static final String MAKETM = "makeTM";
    private static final String TMDIRECTORY = "tmDirectory";
    private static final String MAKETMX = "makeTMX";
    private static final String TMXPATH = "tmxPath";
    private static final String SENDTMX = "sendTMX";
    private static final String BLOCKSIZE = "blockSize";
    private static final String CHECKEXISTINGTM = "checkExistingTm";
    private static final String EXISTINGTM = "existingTm";
    private static final String SEGMENT = "segment";
    private static final String SRXPATH = "srxPath";

    public String getCommand() {
        return this.getString(COMMAND);
    }

    public void setCommand(String command) {
        this.setString(COMMAND, command);
    }

    public String getOrigin() {
        return this.getString(ORIGIN);
    }

    public void setOrigin(String origin) {
        this.setString(ORIGIN, origin);
    }

    public boolean getMarkAsMT() {
        return this.getBoolean(MARKASMT);
    }

    public void setMarkAsMT(boolean markAsMT) {
        this.setBoolean(MARKASMT, markAsMT);
    }

    public boolean getMakeTMX() {
        return this.getBoolean(MAKETMX);
    }

    public void setMakeTMX(boolean makeTMX) {
        this.setBoolean(MAKETMX, makeTMX);
    }

    public String getTmxPath() {
        return this.getString(TMXPATH);
    }

    public void setTmxPath(String tmxPath) {
        this.setString(TMXPATH, tmxPath);
    }

    public boolean getSendTMX() {
        return this.getBoolean(SENDTMX);
    }

    public void setSendTMX(boolean sendTMX) {
        this.setBoolean(SENDTMX, sendTMX);
    }

    public boolean getMakeTM() {
        return this.getBoolean(MAKETM);
    }

    public void setMakeTM(boolean makeTM) {
        this.setBoolean(MAKETM, makeTM);
    }

    public String getTmDirectory() {
        return this.getString(TMDIRECTORY);
    }

    public void setTmDirectory(String tmDirectory) {
        this.setString(TMDIRECTORY, tmDirectory);
    }

    public int getBlockSize() {
        return this.getInteger(BLOCKSIZE);
    }

    public void setBlockSize(int blockSize) {
        this.setInteger(BLOCKSIZE, blockSize);
    }

    public boolean getCheckExistingTm() {
        return this.getBoolean(CHECKEXISTINGTM);
    }

    public void setCheckExistingTm(boolean checkExistingTm) {
        this.setBoolean(CHECKEXISTINGTM, checkExistingTm);
    }

    public String getExistingTm() {
        return this.getString(EXISTINGTM);
    }

    public void setExistingTm(String existingTm) {
        this.setString(EXISTINGTM, existingTm);
    }

    public boolean getSegment() {
        return this.getBoolean(SEGMENT);
    }

    public void setSegment(boolean segment) {
        this.setBoolean(SEGMENT, segment);
    }

    public String getSrxPath() {
        return this.getString(SRXPATH);
    }

    public void setSrxPath(String srxPath) {
        this.setString(SRXPATH, srxPath);
    }

    @Override
    public void reset() {
        super.reset();
        this.setCommand("");
        this.setOrigin("");
        this.setMarkAsMT(true);
        this.setMakeTM(false);
        this.setTmDirectory("");
        this.setMakeTMX(false);
        this.setTmxPath("");
        this.setSendTMX(false);
        this.setBlockSize(1000);
        this.setCheckExistingTm(false);
        this.setExistingTm("");
        this.setSegment(false);
        this.setSrxPath("");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COMMAND, "Command line", "Command line to execute the batch translation");
        desc.add(ORIGIN, "Origin identifier", "String that identifies the origin of the translation");
        desc.add(BLOCKSIZE, "Block size", "Maximum number of text units to process together");
        desc.add(MARKASMT, "Mark the generated translation as machine translation results", null);
        desc.add(SEGMENT, "Segment the text units, using the following SRX rules:", null);
        desc.add(SRXPATH, "", "Full path of the segmentation rules file to use");
        desc.add(MAKETM, "Import into the following Pensieve TM:", null);
        desc.add(TMDIRECTORY, "", "Location of the TM to create or use");
        desc.add(MAKETMX, "Create the following TMX document:", null);
        desc.add(TMXPATH, "", "Full path of the new TMX document to create");
        desc.add(SENDTMX, "Send the TMX document to the next step", null);
        desc.add(CHECKEXISTINGTM, "Check for existing entries in an existing Pensieve TM:", null);
        desc.add(EXISTINGTM, "", "Location of the TM to lookup");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Batch Translation", true, false);
        desc.addTextInputPart(paramDesc.get(COMMAND));
        SpinInputPart sip = desc.addSpinInputPart(paramDesc.get(BLOCKSIZE));
        sip.setVertical(false);
        sip.setRange(1, Integer.MAX_VALUE);
        TextInputPart tip = desc.addTextInputPart(paramDesc.get(ORIGIN));
        tip.setAllowEmpty(true);
        tip.setVertical(false);
        desc.addCheckboxPart(paramDesc.get(MARKASMT));
        desc.addSeparatorPart();
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(SEGMENT));
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(SRXPATH), "SRX Path", false);
        pip.setBrowseFilters("SRX Documents (*.srx)\tAll Files (*.*)", "*.srx\t*.*");
        pip.setMasterPart(cbp, true);
        pip.setWithLabel(false);
        cbp = desc.addCheckboxPart(paramDesc.get(MAKETM));
        FolderInputPart fip = desc.addFolderInputPart(paramDesc.get(TMDIRECTORY), "TM Directory");
        fip.setMasterPart(cbp, true);
        fip.setWithLabel(false);
        cbp = desc.addCheckboxPart(paramDesc.get(MAKETMX));
        pip = desc.addPathInputPart(paramDesc.get(TMXPATH), "TMX Path", true);
        pip.setBrowseFilters("TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
        pip.setMasterPart(cbp, true);
        pip.setWithLabel(false);
        CheckboxPart cbp2 = desc.addCheckboxPart(paramDesc.get(SENDTMX));
        cbp2.setMasterPart(cbp, true);
        cbp = desc.addCheckboxPart(paramDesc.get(CHECKEXISTINGTM));
        fip = desc.addFolderInputPart(paramDesc.get(EXISTINGTM), "TM Directory");
        fip.setMasterPart(cbp, true);
        fip.setWithLabel(false);
        return desc;
    }
}

