/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rtfconversion;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.rtf.RTFFilter;
import net.sf.okapi.steps.rtfconversion.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class RTFConversionStep
extends BasePipelineStep {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Pattern reXML;
    private final String strXMLReplace;
    private final Pattern reXMLVersion;
    private final Pattern reHTML;
    private final String strHTMLReplace;
    private Parameters params = new Parameters();
    private URI outputURI;
    private String outputEncoding;
    private RTFFilter filter;
    private CharsetEncoder encoder;

    public RTFConversionStep() {
        this.reXML = Pattern.compile("<\\?xml(.*?)encoding(\\s*?)=(\\s*?)(\"|')(.*?)(\"|')(.*?)\\?>");
        this.strXMLReplace = "<?xml$1encoding$2=$3$4ZZZ$6$7?>";
        this.reXMLVersion = Pattern.compile("<\\?xml(.*?)version(\\s*?)=(\\s*?)(\"|')(.*?)(\"|')");
        this.reHTML = Pattern.compile("(content)(\\s*?)=(.*?)(charset)(\\s*?)=(.*?)(\\s|\"|')", 2);
        this.strHTMLReplace = "$1$2=$3$4$5=ZZZ$7";
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public String getDescription() {
        return "Remove the RTF layer from a text-based file. Expects: raw document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "RTF Conversion";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        if (this.filter != null) {
            this.filter.close();
        }
        this.filter = new RTFFilter();
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        RawDocument rawDoc = event.getRawDocument();
        OutputStreamWriter writer = null;
        try {
            File outFile;
            this.filter.open(rawDoc);
            if (this.isLastOutputStep()) {
                outFile = rawDoc.createOutputFile(this.outputURI);
            } else {
                try {
                    outFile = File.createTempFile("~okapi-49_okp-rtf_", ".tmp");
                }
                catch (Throwable e) {
                    throw new OkapiIOException("Cannot create temporary output.", e);
                }
            }
            this.encoder = Charset.forName(this.outputEncoding).newEncoder();
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), this.outputEncoding);
            Util.writeBOMIfNeeded(writer, this.params.getBomOnUTF8(), this.outputEncoding);
            String xmlReplace = this.strXMLReplace.replace("ZZZ", this.outputEncoding);
            String htmlReplace = this.strHTMLReplace.replace("ZZZ", this.outputEncoding);
            boolean declDone = !this.params.getUpdateEncoding();
            int lines = 0;
            int declState = 0;
            StringBuilder buf = new StringBuilder();
            while (this.filter.getTextUntil(buf, -1, 0) == 0) {
                if (!declDone) {
                    String sTmp = buf.toString();
                    switch (declState) {
                        case 0: {
                            Matcher m;
                            if (sTmp.indexOf("<?xml ") != -1) {
                                declState = 1;
                                m = this.reXML.matcher(sTmp);
                                if (m.find()) {
                                    buf.setLength(0);
                                    buf.append(m.replaceFirst(xmlReplace));
                                } else {
                                    m = this.reXMLVersion.matcher(sTmp);
                                    if (m.find()) {
                                        buf.insert(m.end(), " encoding=\"" + this.outputEncoding + "\"");
                                    }
                                }
                            }
                            if (sTmp.toLowerCase().indexOf("<html") == -1) break;
                            declState = 2;
                            break;
                        }
                        case 1: {
                            if (sTmp.toLowerCase().indexOf("<html") == -1) break;
                            declState = 2;
                            break;
                        }
                        case 2: {
                            Matcher m = this.reHTML.matcher(sTmp);
                            if (!m.find()) break;
                            buf.setLength(0);
                            buf.append(m.replaceFirst(htmlReplace));
                            if (sTmp.equals(buf.toString())) break;
                            declDone = true;
                        }
                    }
                    if (++lines > 20) {
                        declDone = true;
                    }
                }
                if (!this.encoder.canEncode(buf.toString())) {
                    this.logger.warn("At least one character cannot be encoded in '{}' in '{}'.", (Object)this.outputEncoding, (Object)buf.toString());
                }
                writer.write(buf.toString());
                writer.write(this.params.getLineBreak());
            }
            this.filter.close();
            writer.close();
            writer = null;
            rawDoc.finalizeOutput();
            RawDocument newDoc = new RawDocument(outFile.toURI(), this.outputEncoding, rawDoc.getSourceLocale(), rawDoc.getTargetLocale());
            event.setResource(newDoc);
        }
        catch (Throwable e) {
            throw new OkapiException("Error during RTF conversion.\n" + e.getMessage(), e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException outFile) {}
            }
            if (this.filter != null) {
                this.filter.close();
            }
        }
        return event;
    }
}

