/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util;

import com.vladsch.flexmark.util.Paired;

public class Pair<K, V>
implements Paired<K, V> {
    private final K myFirst;
    private final V mySecond;

    public static <K1, V1> Pair<K1, V1> of(K1 first, V1 second) {
        return new Pair<K1, V1>(first, second);
    }

    public Pair(K first, V second) {
        this.myFirst = first;
        this.mySecond = second;
    }

    @Override
    public K getFirst() {
        return this.myFirst;
    }

    @Override
    public V getSecond() {
        return this.mySecond;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('(');
        if (this.myFirst == null) {
            out.append("null");
        } else {
            out.append(this.myFirst.getClass().getName().substring(this.myFirst.getClass().getPackage().getName().length() + 1)).append(' ').append(this.myFirst);
        }
        out.append(", ");
        if (this.mySecond == null) {
            out.append("null");
        } else {
            out.append(this.mySecond.getClass().getName().substring(this.mySecond.getClass().getPackage().getName().length() + 1)).append(' ').append(this.mySecond);
        }
        out.append(')');
        return out.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.myFirst != null ? !this.myFirst.equals(pair.myFirst) : pair.myFirst != null) {
            return false;
        }
        return this.mySecond != null ? this.mySecond.equals(pair.mySecond) : pair.mySecond == null;
    }

    public int hashCode() {
        int result = this.myFirst != null ? this.myFirst.hashCode() : 0;
        result = 31 * result + (this.mySecond != null ? this.mySecond.hashCode() : 0);
        return result;
    }
}

