/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown.ui;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.filters.InlineCodeFinderPanel;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.ui.Res;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@EditorFor(value=Parameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkTranslateURLs;
    private Text edUrlToTranslatePattern;
    private Button chkTranslateCodeBlocks;
    private Button chkTranslateHeaderMetadata;
    private Button chkTranslateImageAltText;
    private Button chkUseCodeFinder;
    private InlineCodeFinderPanel pnlCodeFinder;
    private Text edHtmlSubfilter;
    private Text nonTranslateText;
    private IHelp help;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters p_Options, boolean readOnly, IContext context) {
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (Parameters)p_Options;
        try {
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell p_Parent, boolean readOnly) {
        this.shell.setText(Res.getString("editorCaption"));
        if (p_Parent != null) {
            this.shell.setImage(p_Parent.getImage());
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        Composite cmpTmp = new Composite(this.shell, 0);
        layTmp = new GridLayout();
        cmpTmp.setLayout(layTmp);
        this.chkTranslateURLs = new Button(cmpTmp, 32);
        this.chkTranslateURLs.setText(Res.getString("translateUrls"));
        Label urlToTransPatLabel = new Label(cmpTmp, 0);
        urlToTransPatLabel.setText(Res.getString("urlToTranslatePattern"));
        this.edUrlToTranslatePattern = new Text(cmpTmp, 2048);
        this.edUrlToTranslatePattern.setLayoutData(new GridData(768));
        this.chkTranslateCodeBlocks = new Button(cmpTmp, 32);
        this.chkTranslateCodeBlocks.setText(Res.getString("translateCodeBlocks"));
        this.chkTranslateHeaderMetadata = new Button(cmpTmp, 32);
        this.chkTranslateHeaderMetadata.setText(Res.getString("translateHeaderMetadata"));
        this.chkTranslateImageAltText = new Button(cmpTmp, 32);
        this.chkTranslateImageAltText.setText(Res.getString("translateImageAltText"));
        Label label = new Label(cmpTmp, 0);
        label.setText(Res.getString("htmlSubfilter"));
        this.edHtmlSubfilter = new Text(cmpTmp, 2048);
        this.edHtmlSubfilter.setLayoutData(new GridData(768));
        Label nonTranslatelabel = new Label(cmpTmp, 0);
        nonTranslatelabel.setText(Res.getString("nonTranslateBlocks"));
        this.nonTranslateText = new Text(cmpTmp, 2048);
        this.nonTranslateText.setLayoutData(new GridData(768));
        this.chkUseCodeFinder = new Button(cmpTmp, 32);
        this.chkUseCodeFinder.setText(Res.getString("useInlineCodes"));
        this.chkUseCodeFinder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateInlineCodes();
            }
        });
        this.pnlCodeFinder = new InlineCodeFinderPanel(cmpTmp, 0);
        this.pnlCodeFinder.setLayoutData(new GridData(1808));
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("Markdown Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, p_Parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.chkTranslateURLs.setSelection(this.params.getTranslateUrls());
        this.edUrlToTranslatePattern.setText(this.params.getUrlToTranslatePattern());
        this.chkTranslateCodeBlocks.setSelection(this.params.getTranslateCodeBlocks());
        this.chkTranslateHeaderMetadata.setSelection(this.params.getTranslateHeaderMetadata());
        this.chkTranslateImageAltText.setSelection(this.params.getTranslateImageAltText());
        this.edHtmlSubfilter.setText(this.params.getHtmlSubfilter() == null ? "" : this.params.getHtmlSubfilter());
        this.chkUseCodeFinder.setSelection(this.params.getUseCodeFinder());
        this.pnlCodeFinder.setRules(this.params.getCodeFinder().toString());
        this.updateInlineCodes();
        this.pnlCodeFinder.updateDisplay();
        this.nonTranslateText.setText(this.params.getNonTranslateBlocks() == null ? "" : this.params.getNonTranslateBlocks());
    }

    private boolean saveData() {
        String tmp = this.pnlCodeFinder.getRules();
        if (tmp == null) {
            return false;
        }
        this.params.getCodeFinder().fromString(tmp);
        this.params.setTranslateUrls(this.chkTranslateURLs.getSelection());
        this.params.setUrlToTranslatePattern(this.edUrlToTranslatePattern.getText().trim());
        this.params.setTranslateCodeBlocks(this.chkTranslateCodeBlocks.getSelection());
        this.params.setTranslateHeaderMetadata(this.chkTranslateHeaderMetadata.getSelection());
        this.params.setTranslateImageAltText(this.chkTranslateImageAltText.getSelection());
        String s = this.edHtmlSubfilter.getText().trim();
        this.params.setHtmlSubfilter(s.isEmpty() ? null : s);
        this.params.setUseCodeFinder(this.chkUseCodeFinder.getSelection());
        s = this.nonTranslateText.getText().trim();
        this.params.setNonTranslateBlocks(s.isEmpty() ? null : s);
        return true;
    }

    private void updateInlineCodes() {
        this.pnlCodeFinder.setEnabled(this.chkUseCodeFinder.getSelection());
    }
}

