/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.editor;

import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.TextOptions;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class OptionsDialog {
    private Shell dialog;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private IHelp help;
    private final String exampleText = "{Marker}This is an <Code>example</Code>{/Marker}";
    private TextOptions opt;
    private TextStyle codeStyle;
    private TextStyle markStyle;
    private StyledText edExample;
    private Device device;

    public OptionsDialog(Shell parent, IHelp paramHelp) {
        this.help = paramHelp;
        this.dialog = new Shell(parent, 65648);
        this.dialog.setText("Options");
        this.dialog.setLayout(new GridLayout());
        this.dialog.setLayoutData(new GridData(1808));
        UIUtil.inheritIcon(this.dialog, parent);
        this.device = this.dialog.getDisplay();
        Group grpTmp = new Group(this.dialog, 0);
        grpTmp.setText("Font and Colors");
        grpTmp.setLayout(new GridLayout(4, false));
        grpTmp.setLayoutData(new GridData(1808));
        this.edExample = new StyledText(grpTmp, 2052);
        this.edExample.setText("{Marker}This is an <Code>example</Code>{/Marker}");
        GridData gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 4;
        gdTmp.heightHint = 50;
        gdTmp.widthHint = 500;
        this.edExample.setLayoutData(gdTmp);
        Label label = new Label(grpTmp, 0);
        label.setText("Text:");
        Button btTextColor = UIUtil.createGridButton(grpTmp, 8, "Text Color...", 80, 1);
        btTextColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(false, null);
            }
        });
        Button btBackColor = UIUtil.createGridButton(grpTmp, 8, "Background...", 80, 1);
        btBackColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(true, null);
            }
        });
        Button btFont = UIUtil.createGridButton(grpTmp, 8, "Font...", 80, 1);
        btFont.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectFont();
            }
        });
        label = new Label(grpTmp, 0);
        label.setText("Codes:");
        btTextColor = UIUtil.createGridButton(grpTmp, 8, "Text Color...", 80, 1);
        btTextColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(false, OptionsDialog.this.codeStyle);
            }
        });
        btBackColor = UIUtil.createGridButton(grpTmp, 8, "Background...", 80, 1);
        btBackColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(true, OptionsDialog.this.codeStyle);
            }
        });
        new Label(grpTmp, 0);
        label = new Label(grpTmp, 0);
        label.setText("Markers:");
        btTextColor = UIUtil.createGridButton(grpTmp, 8, "Text Color...", 80, 1);
        btTextColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(false, OptionsDialog.this.markStyle);
            }
        });
        btBackColor = UIUtil.createGridButton(grpTmp, 8, "Background...", 80, 1);
        btBackColor.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.selectColor(true, OptionsDialog.this.markStyle);
            }
        });
        new Label(grpTmp, 0);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                OptionsDialog.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (OptionsDialog.this.help != null) {
                        OptionsDialog.this.help.showTopic((Object)this, "options");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    OptionsDialog.this.result = true;
                }
                OptionsDialog.this.dialog.close();
            }
        };
        this.pnlActions = new OKCancelPanel(this.dialog, 0, OKCancelActions, this.help != null);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.pnlActions.setLayoutData(gdTmp);
        this.dialog.pack();
        Point size = this.dialog.getSize();
        this.dialog.setMinimumSize(size);
        Dialogs.centerWindow(this.dialog, parent);
    }

    protected void finalize() {
        if (this.opt != null) {
            this.opt.dispose();
        }
        UIUtil.disposeTextStyle(this.codeStyle);
        UIUtil.disposeTextStyle(this.markStyle);
    }

    public void setData(TextOptions textOptions, TextStyle paramCodeStyle, TextStyle paramMarkStyle) {
        this.opt = new TextOptions(this.device, textOptions);
        this.codeStyle = UIUtil.cloneTextStyle(this.device, paramCodeStyle);
        this.markStyle = UIUtil.cloneTextStyle(this.device, paramMarkStyle);
        this.updateExample();
    }

    public boolean showDialog() {
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.dialog.getDisplay().readAndDispatch()) continue;
            this.dialog.getDisplay().sleep();
        }
        return this.result;
    }

    public TextOptions getTextOptions() {
        return new TextOptions(this.device, this.opt);
    }

    public TextStyle getCodeStyle() {
        return UIUtil.cloneTextStyle(this.device, this.codeStyle);
    }

    public TextStyle getMarkStyle() {
        return UIUtil.cloneTextStyle(this.device, this.markStyle);
    }

    private void updateExample() {
        this.edExample.setText("{Marker}This is an <Code>example</Code>{/Marker}");
        this.opt.applyTo(this.edExample);
        StyleRange sr = new StyleRange(this.markStyle);
        sr.start = 0;
        sr.length = 8;
        this.edExample.setStyleRange(sr);
        sr = new StyleRange(this.markStyle);
        sr.start = 39;
        sr.length = 9;
        this.edExample.setStyleRange(sr);
        sr = new StyleRange(this.codeStyle);
        sr.start = 19;
        sr.length = 6;
        this.edExample.setStyleRange(sr);
        sr = new StyleRange(this.codeStyle);
        sr.start = 32;
        sr.length = 7;
        this.edExample.setStyleRange(sr);
    }

    private void selectColor(boolean background, TextStyle ts) {
        try {
            ColorDialog dlg = new ColorDialog(this.dialog);
            if (background) {
                if (ts == null) {
                    dlg.setRGB(this.opt.background.getRGB());
                } else if (ts.background != null) {
                    dlg.setRGB(ts.background.getRGB());
                }
                dlg.setText("Select Background Color");
            } else {
                if (ts == null) {
                    dlg.setRGB(this.opt.foreground.getRGB());
                } else if (ts.foreground != null) {
                    dlg.setRGB(ts.foreground.getRGB());
                }
                dlg.setText("Select Text Color");
            }
            RGB rgb = dlg.open();
            if (rgb == null) {
                return;
            }
            if (ts == null) {
                if (background) {
                    this.opt.background.dispose();
                    this.opt.background = new Color(this.device, rgb);
                } else {
                    this.opt.foreground.dispose();
                    this.opt.foreground = new Color(this.device, rgb);
                }
            } else if (background) {
                if (ts.background != null) {
                    ts.background.dispose();
                }
                ts.background = new Color(this.device, rgb);
            } else {
                if (ts.foreground != null) {
                    ts.foreground.dispose();
                }
                ts.foreground = new Color(this.device, rgb);
            }
            this.updateExample();
        }
        catch (Throwable e) {
            Dialogs.showError(this.dialog, e.getLocalizedMessage(), null);
        }
    }

    private void selectFont() {
        try {
            FontDialog dlg = new FontDialog(this.dialog);
            dlg.setText("Select Font");
            dlg.setFontList(this.opt.font.getFontData());
            dlg.setRGB(this.opt.foreground.getRGB());
            FontData fontData = dlg.open();
            if (fontData == null) {
                return;
            }
            Font tmp = this.opt.font;
            this.opt.font = new Font(this.device, fontData);
            this.edExample.setFont(this.opt.font);
            tmp.dispose();
            this.opt.foreground.dispose();
            this.opt.foreground = new Color(this.device, dlg.getRGB());
            this.updateExample();
        }
        catch (Throwable e) {
            Dialogs.showError(this.dialog, e.getLocalizedMessage(), null);
        }
    }
}

