/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.verification;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.sf.okapi.common.BaseContext;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UserConfiguration;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.ui.AboutDialog;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.InputDocumentDialog;
import net.sf.okapi.common.ui.MRUList;
import net.sf.okapi.common.ui.ResourceManager;
import net.sf.okapi.common.ui.TextOptions;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.lib.ui.verification.IssuesTableModel;
import net.sf.okapi.lib.ui.verification.ParametersEditor;
import net.sf.okapi.lib.ui.verification.PreferencesDialog;
import net.sf.okapi.lib.ui.verification.SessionSettingsDialog;
import net.sf.okapi.lib.ui.verification.StatusBar;
import net.sf.okapi.lib.ui.verification.Watcher;
import net.sf.okapi.lib.verification.IQualityCheckEditor;
import net.sf.okapi.lib.verification.Issue;
import net.sf.okapi.lib.verification.IssueComparator;
import net.sf.okapi.lib.verification.Parameters;
import net.sf.okapi.lib.verification.QualityCheckSession;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class QualityCheckEditor
implements IQualityCheckEditor {
    static final int ISSUETYPE_ALL = 0;
    static final int ISSUETYPE_ENABLED = 1;
    static final int ISSUETYPE_DISABLED = 2;
    static final int CONTEXTMENU_COUNT = 8;
    private static final String OPT_BOUNDS = "bounds";
    private static final String OPT_MAXIMIZED = "maximized";
    private static final String APPNAME = "CheckMate";
    private static final String CFG_SOURCELOCALE = "sourceLocale";
    private static final String CFG_TARGETLOCALE = "targetLocale";
    private static final String CFG_SOURCETEXTOPTIONS = "sourceTextOptions";
    private static final String CFG_TARGETTEXTOPTIONS = "targetTextOptions";
    private String qcsPath;
    private UserConfiguration config;
    private MRUList mruList;
    private MenuItem miMRU;
    private IHelp help;
    private Shell shell;
    private ResourceManager rm;
    private Table tblIssues;
    private Text edMessage;
    private Combo cbDocument;
    private SashForm sashDisplay;
    private StyledText edSource;
    private StyledText edTarget;
    private TextOptions srcTextOpt;
    private TextOptions trgTextOpt;
    private IssuesTableModel issuesModel;
    private StatusBar statusBar;
    private QualityCheckSession session;
    private Combo cbDisplay;
    private Combo cbTypes;
    private int waitCount;
    private Menu contextMenu;
    private SelectionAdapter allowExtraCodesAdapter;
    private SelectionAdapter allowMissingCodesAdapter;
    private SelectionAdapter copyItemDataAdapter;
    private Timer watcherTimer;
    private Watcher watcher;
    private int displayType = 1;
    private int issueType = 0;

    public void edit(boolean processOnStart) {
        this.showDialog(null, processOnStart);
    }

    public void initialize(Object parent, boolean asDialog, IHelp helpParam, IFilterConfigurationMapper fcMapper, QualityCheckSession paramSession) {
        this.help = helpParam;
        this.config = new UserConfiguration();
        this.config.load(APPNAME);
        this.mruList = new MRUList(9);
        this.mruList.getFromProperties((Properties)this.config);
        if (parent == null) {
            Display dispMain = new Display();
            parent = new Shell(dispMain);
        }
        this.session = paramSession == null ? new QualityCheckSession() : paramSession;
        this.session.setFilterConfigurationMapper(fcMapper);
        try {
            LocaleId tmpLoc = LocaleId.fromString((String)this.config.getProperty(CFG_SOURCELOCALE, "en"));
            this.session.setSourceLocale(tmpLoc);
            tmpLoc = LocaleId.fromString((String)this.config.getProperty(CFG_TARGETLOCALE, "fr"));
            this.session.setTargetLocale(tmpLoc);
            this.session.setModified(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.shell = asDialog ? new Shell((Shell)parent, 66800) : (Shell)parent;
        this.shell.setLayout(new GridLayout());
        this.rm = new ResourceManager(QualityCheckEditor.class, this.shell.getDisplay());
        this.rm.loadCommands("net.sf.okapi.lib.ui.verification.Commands");
        this.rm.addImages("checkmate", "checkmate16", "checkmate32");
        this.shell.setImages(this.rm.getImages("checkmate"));
        this.createMenus();
        this.createContent();
        if (asDialog) {
            Dialogs.centerWindow(this.shell, (Shell)parent);
        }
        this.tblIssues.setFocus();
    }

    public void addRawDocument(RawDocument rawDoc) {
        this.session.addRawDocument(rawDoc);
    }

    protected void finalize() {
        this.dispose();
    }

    private void deleteWatcher() {
        if (this.watcherTimer != null) {
            this.watcherTimer.cancel();
            this.watcherTimer.purge();
            this.watcherTimer = null;
        }
    }

    private void dispose() {
        this.deleteWatcher();
        if (this.srcTextOpt != null) {
            this.srcTextOpt.dispose();
            this.srcTextOpt = null;
        }
        if (this.trgTextOpt != null) {
            this.trgTextOpt.dispose();
            this.trgTextOpt = null;
        }
        if (this.rm != null) {
            this.rm.dispose();
            this.rm = null;
        }
    }

    public void showDialog(String path, boolean processOnStart) {
        this.shell.open();
        if (path != null) {
            String ext = Util.getExtension((String)path);
            if (ext.equalsIgnoreCase(".qcs")) {
                this.loadSession(path);
            } else {
                this.addDocumentFromUI(path, false, false);
                if (processOnStart) {
                    this.checkAll();
                }
            }
        } else if (processOnStart) {
            this.fillDocumentCombo(null);
            this.checkAll();
        }
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        this.dispose();
    }

    private void createMenus() {
        Menu menuBar = new Menu(this.shell, 2);
        this.shell.setMenuBar(menuBar);
        MenuItem topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("file"));
        Menu dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        MenuItem menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.new");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.newSession();
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.open");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.loadSession(null);
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.save");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.saveSessionAs(QualityCheckEditor.this.qcsPath);
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.saveas");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.saveSessionAs(null);
            }
        });
        new MenuItem(dropMenu, 2);
        this.miMRU = new MenuItem(dropMenu, 64);
        this.rm.setCommand(this.miMRU, "file.mru");
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.clearmru");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.clearMRU();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.adddocument");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.addDocumentFromUI(null, false, false);
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.sessionsettings");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.editSessionSettings();
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.preferences");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.editPreferences();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "file.exit");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.shell.close();
            }
        });
        topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("issues"));
        dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.resetdisabledissues");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.resetDisabledIssues();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.editConfiguration");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.editConfiguration();
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.saveConfiguration");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.saveConfiguration();
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.loadConfiguration");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.loadConfiguration();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.checkall");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.checkAll();
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.checkdocument");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.checkCurrentDocument();
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "issues.generatereport");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.generateReport();
            }
        });
        topItem = new MenuItem(menuBar, 64);
        topItem.setText(this.rm.getCommandLabel("help"));
        dropMenu = new Menu(this.shell, 4);
        topItem.setMenu(dropMenu);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.topics");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (QualityCheckEditor.this.help != null) {
                    QualityCheckEditor.this.help.showWiki(QualityCheckEditor.APPNAME);
                }
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.howtouse");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (QualityCheckEditor.this.help != null) {
                    QualityCheckEditor.this.help.showWiki("CheckMate - Usage");
                }
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.update");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("http://okapiframework.org/updates.html?" + this.getClass().getPackage().getImplementationTitle() + "=" + this.getClass().getPackage().getImplementationVersion());
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.feedback");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("mailto:okapitools@opentag.com&subject=Feedback (CheckMate: Quality Checker)");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.bugreport");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("https://bitbucket.org/okapiframework/okapi/issues");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.featurerequest");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("https://bitbucket.org/okapiframework/okapi/issues");
            }
        });
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.users");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                UIUtil.start("http://groups.yahoo.com/group/okapitools/");
            }
        });
        new MenuItem(dropMenu, 2);
        menuItem = new MenuItem(dropMenu, 8);
        this.rm.setCommand(menuItem, "help.about");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                AboutDialog dlg = new AboutDialog(QualityCheckEditor.this.shell, "About CheckMate", "CheckMate - Okapi Quality Checker", this.getClass().getPackage().getImplementationVersion());
                dlg.showDialog();
            }
        });
    }

    private Menu createIssuesContextMenu() {
        this.contextMenu = new Menu(this.shell, 8);
        MenuItem menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "context.opendocument");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.openDocument();
            }
        });
        menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "context.openfolder");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.openContainingFolder();
            }
        });
        new MenuItem(this.contextMenu, 2);
        menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "issues.editConfiguration");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.editConfiguration();
            }
        });
        menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "issues.checkall");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.checkAll();
            }
        });
        menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "issues.checkdocument");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.checkCurrentDocument();
            }
        });
        new MenuItem(this.contextMenu, 2);
        menuItem = new MenuItem(this.contextMenu, 8);
        this.rm.setCommand(menuItem, "file.adddocument");
        menuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                QualityCheckEditor.this.addDocumentFromUI(null, false, false);
            }
        });
        this.allowExtraCodesAdapter = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String code;
                List list = QualityCheckEditor.this.session.getParameters().getExtraCodesAllowed();
                if (list.contains(code = (String)((MenuItem)event.getSource()).getData())) {
                    return;
                }
                list.add(code);
                QualityCheckEditor.this.session.setModified(true);
            }
        };
        this.allowMissingCodesAdapter = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String code;
                List list = QualityCheckEditor.this.session.getParameters().getMissingCodesAllowed();
                if (list.contains(code = (String)((MenuItem)event.getSource()).getData())) {
                    return;
                }
                list.add(code);
                QualityCheckEditor.this.session.setModified(true);
            }
        };
        this.copyItemDataAdapter = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                String data = (String)((MenuItem)event.getSource()).getData();
                Clipboard cb = new Clipboard(QualityCheckEditor.this.shell.getDisplay());
                cb.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
            }
        };
        this.contextMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuShown(MenuEvent arg0) {
                QualityCheckEditor.this.clearContextMenu();
                int n = QualityCheckEditor.this.tblIssues.getSelectionIndex();
                if (n == -1) {
                    return;
                }
                Issue issue = (Issue)QualityCheckEditor.this.tblIssues.getItem(n).getData();
                MenuItem item = new MenuItem(QualityCheckEditor.this.contextMenu, 8);
                item.setText(String.format("Copy Text Unit Extraction ID (\"%s\")", issue.getTuId()));
                item.setData(issue.getTuId());
                item.addSelectionListener(QualityCheckEditor.this.copyItemDataAdapter);
                if (!Util.isEmpty((String)issue.getTuName())) {
                    item = new MenuItem(QualityCheckEditor.this.contextMenu, 8);
                    item.setText(String.format("Copy Text Unit Resource ID/Name (\"%s\")", issue.getTuName()));
                    item.setData(issue.getTuName());
                    item.addSelectionListener(QualityCheckEditor.this.copyItemDataAdapter);
                }
                if (Util.isEmpty((List)issue.getCodes())) {
                    return;
                }
                new MenuItem(QualityCheckEditor.this.contextMenu, 2);
                for (Code code : issue.getCodes()) {
                    item = new MenuItem(QualityCheckEditor.this.contextMenu, 8);
                    item.setData(code.getData());
                    if (issue.getIssueType() == IssueType.EXTRA_CODE) {
                        item.setText(String.format("Allow \"%s\" as an Extra Code", code.getData()));
                        item.addSelectionListener(QualityCheckEditor.this.allowExtraCodesAdapter);
                        continue;
                    }
                    item.setText(String.format("Allow \"%s\" as a Missing Code", code.getData()));
                    item.addSelectionListener(QualityCheckEditor.this.allowMissingCodesAdapter);
                }
            }

            @Override
            public void menuHidden(MenuEvent arg0) {
            }
        });
        return this.contextMenu;
    }

    private void clearContextMenu() {
        MenuItem[] list = this.contextMenu.getItems();
        if (list.length <= 8) {
            return;
        }
        for (int i = list.length - 1; i >= 8; --i) {
            this.contextMenu.getItem(i).dispose();
        }
    }

    private void createContent() {
        this.shell.addShellListener(new ShellListener(){

            @Override
            public void shellActivated(ShellEvent event) {
            }

            @Override
            public void shellClosed(ShellEvent event) {
                if (!QualityCheckEditor.this.saveSessionIfNeeded()) {
                    event.doit = false;
                }
            }

            @Override
            public void shellDeactivated(ShellEvent event) {
            }

            @Override
            public void shellDeiconified(ShellEvent event) {
            }

            @Override
            public void shellIconified(ShellEvent event) {
            }
        });
        SashForm sashMain = new SashForm(this.shell, 512);
        sashMain.setLayoutData(new GridData(1808));
        sashMain.setSashWidth(4);
        DropTarget dropTarget = new DropTarget(sashMain, 19);
        dropTarget.setTransfer(FileTransfer.getInstance());
        dropTarget.addDropListener(new DropTargetAdapter(){

            @Override
            public void drop(DropTargetEvent e) {
                String[] paths;
                FileTransfer FT = FileTransfer.getInstance();
                if (FT.isSupportedType(e.currentDataType) && (paths = (String[])e.data) != null) {
                    boolean acceptAll = false;
                    for (String path : paths) {
                        Boolean res = QualityCheckEditor.this.addDocumentFromUI(path, paths.length > 1, acceptAll);
                        if (res == null) {
                            return;
                        }
                        acceptAll = res;
                    }
                }
            }
        });
        Composite cmpTmp = new Composite(sashMain, 0);
        cmpTmp.setLayoutData(new GridData(1808));
        GridLayout layTmp = new GridLayout();
        layTmp.marginWidth = 0;
        layTmp.marginHeight = 0;
        cmpTmp.setLayout(layTmp);
        this.sashDisplay = new SashForm(cmpTmp, 512);
        this.sashDisplay.setLayoutData(new GridData(1808));
        this.sashDisplay.setSashWidth(2);
        this.edSource = new StyledText(this.sashDisplay, 2624);
        this.edSource.setLayoutData(new GridData(1808));
        this.edSource.setEditable(false);
        this.edTarget = new StyledText(this.sashDisplay, 2624);
        this.edTarget.setLayoutData(new GridData(1808));
        this.edTarget.setEditable(false);
        String data = this.config.getProperty(CFG_SOURCETEXTOPTIONS, "");
        if (!Util.isEmpty((String)data)) {
            try {
                this.srcTextOpt = new TextOptions((Device)this.shell.getDisplay(), data);
            }
            catch (Throwable e) {
                data = null;
            }
        }
        if (Util.isEmpty((String)data)) {
            this.srcTextOpt = new TextOptions(this.shell.getDisplay(), this.edSource, 2);
        }
        this.srcTextOpt.applyTo(this.edSource);
        data = this.config.getProperty(CFG_TARGETTEXTOPTIONS, "");
        if (!Util.isEmpty((String)data)) {
            try {
                this.trgTextOpt = new TextOptions((Device)this.shell.getDisplay(), data);
            }
            catch (Throwable e) {
                data = null;
            }
        }
        if (Util.isEmpty((String)data)) {
            this.trgTextOpt = new TextOptions((Device)this.shell.getDisplay(), this.srcTextOpt);
        }
        this.trgTextOpt.applyTo(this.edTarget);
        cmpTmp = new Composite(sashMain, 2048);
        layTmp = new GridLayout(3, false);
        cmpTmp.setLayout(layTmp);
        cmpTmp.setLayoutData(new GridData(1808));
        this.edMessage = new Text(cmpTmp, 2048);
        GridData gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.edMessage.setLayoutData(gdTmp);
        this.edMessage.setEditable(false);
        this.cbDocument = new Combo(cmpTmp, 12);
        this.cbDocument.setVisibleItemCount(20);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 3;
        this.cbDocument.setLayoutData(gdTmp);
        this.cbDocument.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.updateCurrentDocument();
            }
        });
        Composite cmpButtons = new Composite(cmpTmp, 0);
        layTmp = new GridLayout(4, true);
        layTmp.marginHeight = 0;
        layTmp.marginWidth = 0;
        cmpButtons.setLayout(layTmp);
        cmpButtons.setLayoutData(new GridData(768));
        Button btCheckAll = new Button(cmpButtons, 8);
        btCheckAll.setLayoutData(new GridData(768));
        btCheckAll.setText("Check All");
        btCheckAll.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.checkAll();
            }
        });
        Button btCheckDoc = new Button(cmpButtons, 8);
        btCheckDoc.setLayoutData(new GridData(768));
        btCheckDoc.setText("Check Document");
        btCheckDoc.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.checkCurrentDocument();
            }
        });
        Button btOptions = new Button(cmpButtons, 8);
        btOptions.setLayoutData(new GridData(768));
        btOptions.setText("Configuration...");
        btOptions.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.editConfiguration();
            }
        });
        Button btSession = new Button(cmpButtons, 8);
        btSession.setLayoutData(new GridData(768));
        btSession.setText("Session...");
        btSession.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.editSessionSettings();
            }
        });
        this.cbTypes = new Combo(cmpTmp, 12);
        this.cbTypes.add("<All types of issues>");
        this.cbTypes.add("Missing target");
        this.cbTypes.add("Missing and extra segments");
        this.cbTypes.add("Empty segments");
        this.cbTypes.add("Target same as source");
        this.cbTypes.add("White spaces differences");
        this.cbTypes.add("Inline codes differences");
        this.cbTypes.add("Unexpected patterns");
        this.cbTypes.add("Suspect patterns");
        this.cbTypes.add("Text length");
        this.cbTypes.add("Allowed characters");
        this.cbTypes.add("Terminology");
        this.cbTypes.add("LanguageTool checker warnings");
        this.cbTypes.add("Other issues");
        this.cbTypes.setVisibleItemCount(this.cbTypes.getItemCount());
        this.cbTypes.setLayoutData(new GridData());
        this.cbTypes.select(this.issueType);
        this.cbTypes.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.refreshTableDisplay();
            }
        });
        this.cbDisplay = new Combo(cmpTmp, 12);
        this.cbDisplay.add("Enabled and disabled issues");
        this.cbDisplay.add("Only enabled issues");
        this.cbDisplay.add("Only disabled issues");
        this.cbDisplay.setLayoutData(new GridData());
        this.cbDisplay.select(this.displayType);
        this.cbDisplay.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                QualityCheckEditor.this.refreshTableDisplay();
            }
        });
        this.tblIssues = new Table(cmpTmp, 68130);
        this.tblIssues.setHeaderVisible(true);
        this.tblIssues.setLinesVisible(true);
        gdTmp = new GridData(1808);
        gdTmp.horizontalSpan = 3;
        this.tblIssues.setLayoutData(gdTmp);
        this.tblIssues.setMenu(this.createIssuesContextMenu());
        this.tblIssues.addControlListener(new ControlAdapter(){

            @Override
            public void controlResized(ControlEvent e) {
                Rectangle rect = QualityCheckEditor.this.tblIssues.getClientArea();
                int checkColWidth = 32;
                int severityColWidth = 28;
                int part = (rect.width - (checkColWidth + severityColWidth)) / 100;
                int remainder = (rect.width - (checkColWidth + severityColWidth)) % 100;
                QualityCheckEditor.this.tblIssues.getColumn(0).setWidth(checkColWidth);
                QualityCheckEditor.this.tblIssues.getColumn(1).setWidth(severityColWidth);
                QualityCheckEditor.this.tblIssues.getColumn(2).setWidth(part * 10);
                QualityCheckEditor.this.tblIssues.getColumn(3).setWidth(part * 5);
                QualityCheckEditor.this.tblIssues.getColumn(4).setWidth(remainder + part * 85);
            }
        });
        this.tblIssues.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 32) {
                    Issue issue;
                    issue.setEnabled(!(issue = (Issue)event.item.getData()).getEnabled());
                    QualityCheckEditor.this.session.setModified(true);
                }
                QualityCheckEditor.this.updateCurrentIssue();
            }
        });
        this.tblIssues.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.character == ' ') {
                    TableItem si = QualityCheckEditor.this.tblIssues.getItem(QualityCheckEditor.this.tblIssues.getSelectionIndex());
                    for (TableItem ti : QualityCheckEditor.this.tblIssues.getSelection()) {
                        Issue issue;
                        if (ti == si) continue;
                        issue.setEnabled(!(issue = (Issue)ti.getData()).getEnabled());
                        ti.setChecked(issue.getEnabled());
                        QualityCheckEditor.this.session.setModified(true);
                    }
                }
            }
        });
        Listener sortListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                TableColumn sortCol = QualityCheckEditor.this.tblIssues.getSortColumn();
                TableColumn curCol = (TableColumn)event.widget;
                int dir = QualityCheckEditor.this.tblIssues.getSortDirection();
                if (sortCol == curCol) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    QualityCheckEditor.this.tblIssues.setSortColumn(curCol);
                    dir = 128;
                }
                int type = 0;
                if (QualityCheckEditor.this.tblIssues.indexOf(curCol) == 1) {
                    type = 1;
                } else if (QualityCheckEditor.this.tblIssues.indexOf(curCol) == 2) {
                    type = 2;
                } else if (QualityCheckEditor.this.tblIssues.indexOf(curCol) == 3) {
                    type = 3;
                } else if (QualityCheckEditor.this.tblIssues.indexOf(curCol) == 4) {
                    type = 4;
                }
                Collections.sort(QualityCheckEditor.this.session.getIssues(), new IssueComparator(type, dir == 128 ? 1 : -1));
                QualityCheckEditor.this.tblIssues.setSortDirection(dir);
                QualityCheckEditor.this.refreshTableDisplay();
            }
        };
        this.issuesModel = new IssuesTableModel(this.shell.getDisplay());
        this.issuesModel.linkTable(this.tblIssues, sortListener);
        sashMain.setWeights(new int[]{30, 70});
        this.statusBar = new StatusBar(this.shell, 0);
        this.updateMRU();
        if (!this.shell.getMaximized()) {
            Point defaultSize = this.shell.getSize();
            this.shell.pack();
            this.shell.setMinimumSize(this.shell.getSize());
            Point startSize = defaultSize;
            this.shell.setSize(startSize);
            this.shell.setMaximized(true);
            this.shell.setMaximized(false);
            UIUtil.centerShell(this.shell);
            if (this.config.getBoolean(OPT_MAXIMIZED)) {
                this.shell.setMaximized(true);
            } else {
                Rectangle dr;
                Rectangle ar = UIUtil.StringToRectangle(this.config.getProperty(OPT_BOUNDS));
                if (ar != null && (dr = this.shell.getDisplay().getBounds()).contains(ar.x + ar.width, ar.y + ar.height) && dr.contains(ar.x, ar.y)) {
                    this.shell.setBounds(ar);
                }
            }
        }
        this.updateCaption();
        this.resetTextFieldOrientation();
        this.resetTableDisplay();
    }

    private void resetTextFieldOrientation() {
        this.srcTextOpt.isBidirectional = LocaleId.isBidirectional((LocaleId)this.session.getSourceLocale());
        this.edSource.setOrientation(this.srcTextOpt.isBidirectional ? 0x4000000 : 0x2000000);
        this.trgTextOpt.isBidirectional = LocaleId.isBidirectional((LocaleId)this.session.getTargetLocale());
        this.edTarget.setOrientation(this.trgTextOpt.isBidirectional ? 0x4000000 : 0x2000000);
    }

    private void openDocument() {
        try {
            String path = this.cbDocument.getText();
            if (Util.isEmpty((String)path)) {
                return;
            }
            path = new File(path).getPath();
            Program.launch(path);
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void openContainingFolder() {
        try {
            String path = this.cbDocument.getText();
            if (Util.isEmpty((String)path)) {
                return;
            }
            path = new File(path).getPath();
            Program.launch(Util.getDirectoryName((String)path));
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void resetTableDisplay() {
        try {
            this.issuesModel.setIssues(this.session.getIssues());
            this.tblIssues.setSortColumn(null);
            this.displayType = this.cbDisplay.getSelectionIndex();
            this.issueType = this.cbTypes.getSelectionIndex();
            this.issuesModel.updateTable(0, this.displayType, this.issueType);
            this.updateCurrentIssue();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error resetting the table.\n" + e.getMessage(), null);
        }
    }

    private void refreshTableDisplay() {
        this.displayType = this.cbDisplay.getSelectionIndex();
        this.issueType = this.cbTypes.getSelectionIndex();
        this.issuesModel.updateTable(this.tblIssues.getSelectionIndex(), this.displayType, this.issueType);
        this.updateCurrentIssue();
    }

    ArrayList<URI> getDocumentURIs() {
        ArrayList<URI> list = new ArrayList<URI>();
        for (String path : this.cbDocument.getItems()) {
            list.add((URI)this.cbDocument.getData(path));
        }
        return list;
    }

    private void fillDocumentCombo(URI docURI) {
        URI requested = docURI;
        docURI = null;
        this.cbDocument.removeAll();
        for (RawDocument rd : this.session.getDocuments()) {
            String path = rd.getInputURI().getPath();
            this.cbDocument.add(path);
            this.cbDocument.setData(path, rd.getInputURI());
            if (requested == null || !requested.equals(rd.getInputURI())) continue;
            docURI = requested;
        }
        if (docURI == null && this.cbDocument.getItemCount() > 0) {
            docURI = (URI)this.cbDocument.getData(this.cbDocument.getItem(0));
        }
        if (docURI != null) {
            this.cbDocument.setText(docURI.getPath());
        }
        this.updateCurrentIssue();
    }

    private void editPreferences() {
        try {
            PreferencesDialog dlg = new PreferencesDialog(this.shell, this.help);
            dlg.setData(this.srcTextOpt, this.trgTextOpt);
            Object[] res = dlg.showDialog();
            if (res == null) {
                return;
            }
            TextOptions tmp = this.srcTextOpt;
            this.srcTextOpt = (TextOptions)res[0];
            this.srcTextOpt.applyTo(this.edSource);
            tmp.dispose();
            tmp = this.trgTextOpt;
            this.trgTextOpt = (TextOptions)res[1];
            this.trgTextOpt.applyTo(this.edTarget);
            tmp.dispose();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error editing preferences.\n" + e.getMessage(), null);
        }
    }

    private void editSessionSettings() {
        try {
            ArrayList<URI> prevList = this.getDocumentURIs();
            SessionSettingsDialog dlg = new SessionSettingsDialog(this.shell, this.help);
            dlg.setData(this.session);
            if (!dlg.showDialog()) {
                return;
            }
            this.resetTextFieldOrientation();
            this.fillDocumentCombo(null);
            prevList.removeAll(this.getDocumentURIs());
            for (URI uri : prevList) {
                this.session.clearIssues(uri, false);
            }
            this.refreshTableDisplay();
            this.resetWatcher();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error editing session settings.\n" + e.getMessage(), null);
        }
    }

    private void resetWatcher() {
        this.deleteWatcher();
        if (this.session.getAutoRefresh()) {
            this.watcher = new Watcher(this, this.shell.getDisplay());
            if (this.watcherTimer == null) {
                this.watcherTimer = new Timer();
            }
            this.watcherTimer.schedule((TimerTask)this.watcher, new Date(), 2000L);
        }
    }

    private Boolean addDocumentFromUI(String path, boolean batchMode, boolean acceptAll) {
        try {
            Object[] data;
            InputDocumentDialog dlg = new InputDocumentDialog(this.shell, "Input Document", this.session.getFilterConfigurationMapper(), batchMode);
            boolean canChangeLocales = this.session.getDocumentCount() == 0;
            dlg.setLocalesEditable(canChangeLocales);
            dlg.setData(path, null, "UTF-8", this.session.getSourceLocale(), this.session.getTargetLocale());
            if (batchMode && path != null) {
                dlg.setAcceptAll(acceptAll);
            }
            if ((data = dlg.showDialog()) == null) {
                return null;
            }
            URI uri = new File((String)data[0]).toURI();
            RawDocument rd = new RawDocument(uri, (String)data[2], (LocaleId)data[3], (LocaleId)data[4]);
            rd.setFilterConfigId((String)data[1]);
            this.session.addRawDocument(rd);
            if (canChangeLocales) {
                this.resetTextFieldOrientation();
            }
            this.fillDocumentCombo(null);
            return (Boolean)data[5];
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error adding document.\n" + e.getMessage(), null);
            return null;
        }
    }

    private void updateCaption() {
        String filename = this.qcsPath != null ? Util.getFilename((String)this.qcsPath, (boolean)true) : "Untitled";
        String text = APPNAME;
        this.shell.setText(filename + " - " + text);
    }

    private void updateCurrentDocument() {
        int n = this.cbDocument.getSelectionIndex();
        if (n == -1) {
            return;
        }
        URI uri = (URI)this.cbDocument.getData(this.cbDocument.getItem(n));
        for (int i = 0; i < this.tblIssues.getItemCount(); ++i) {
            Issue issue = (Issue)this.tblIssues.getItem(i).getData();
            if (!uri.equals(issue.getDocumentURI())) continue;
            this.tblIssues.setTopIndex(i);
            this.tblIssues.setSelection(i);
            this.updateCurrentIssue();
            return;
        }
    }

    private void updateCurrentIssue() {
        try {
            int n = this.tblIssues.getSelectionIndex();
            if (n == -1) {
                this.cbDocument.setText("");
                this.edMessage.setText("");
                this.edSource.setText("");
                this.edTarget.setText("");
            } else {
                Issue issue = (Issue)this.tblIssues.getItem(n).getData();
                this.cbDocument.setText(issue.getDocumentURI().getPath());
                this.edMessage.setText(issue.getMessage());
                this.setTexts(issue);
            }
            this.statusBar.setCounter(n, this.tblIssues.getItemCount(), this.session.getIssues().size());
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while updating table.\n" + e.getMessage(), null);
        }
    }

    private void setTexts(Issue issue) {
        StyleRange sr;
        this.edSource.setText(issue.getSource());
        this.edTarget.setText(issue.getTarget());
        if (issue.getSourceEnd() > 0) {
            sr = new StyleRange();
            sr.background = this.shell.getDisplay().getSystemColor(7);
            sr.start = issue.getSourceStart();
            sr.length = issue.getSourceEnd() - issue.getSourceStart();
            this.edSource.setStyleRange(sr);
            this.edSource.setCaretOffset(issue.getSourceEnd());
            this.edSource.showSelection();
        }
        if (issue.getTargetEnd() > 0) {
            sr = new StyleRange();
            sr.background = this.shell.getDisplay().getSystemColor(7);
            sr.start = issue.getTargetStart();
            sr.length = issue.getTargetEnd() - issue.getTargetStart();
            this.edTarget.setStyleRange(sr);
            this.edTarget.setCaretOffset(issue.getTargetEnd());
            this.edTarget.showSelection();
        }
    }

    private void startWaiting(String text) {
        if (++this.waitCount > 1) {
            this.shell.getDisplay().update();
            return;
        }
        if (text != null) {
            this.statusBar.setInfo(text);
        }
        this.shell.getDisplay().update();
    }

    private void stopWaiting() {
        --this.waitCount;
        if (this.waitCount < 1) {
            this.statusBar.clearInfo();
        }
        this.shell.getDisplay().update();
    }

    private void generateReport() {
        try {
            this.startWaiting("Generating report...");
            String rootDir = this.qcsPath == null ? null : Util.getDirectoryName((String)this.qcsPath);
            this.session.generateReport(rootDir);
            String finalPath = Util.fillRootDirectoryVariable((String)this.session.getParameters().getOutputPath(), (String)rootDir);
            if (this.session.getParameters().getAutoOpen()) {
                Util.openURL((String)new File(finalPath).getAbsolutePath());
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while generating report.\n" + e.getMessage(), null);
        }
        finally {
            this.stopWaiting();
        }
    }

    private void resetDisabledIssues() {
        MessageBox dlg = new MessageBox(this.shell, 452);
        dlg.setText(this.shell.getText());
        dlg.setMessage("This command will re-enabled all issues that have been disabled.\nDo you want to proceed?");
        if (dlg.open() != 64) {
            return;
        }
        this.session.resetDisabledIssues();
        this.issuesModel.updateTable(0, this.displayType, this.issueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCurrentDocument() {
        try {
            int n = this.cbDocument.getSelectionIndex();
            if (n == -1) {
                return;
            }
            URI uri = (URI)this.cbDocument.getData(this.cbDocument.getItem(n));
            this.startWaiting("Checking current document...");
            this.session.recheckDocument(uri);
            this.resetTableDisplay();
            String curPath = uri.getPath();
            n = 0;
            for (String path : this.cbDocument.getItems()) {
                if (path.equals(curPath)) {
                    this.cbDocument.select(n);
                    this.updateCurrentDocument();
                    break;
                }
                ++n;
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while running the verification.\n" + e.getMessage(), null);
        }
        finally {
            this.stopWaiting();
        }
    }

    void checkAll() {
        try {
            this.startWaiting("Checking all documents...");
            this.session.recheckAll(null);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while running the verification.\n" + e.getMessage(), null);
        }
        finally {
            this.resetTableDisplay();
            this.stopWaiting();
        }
    }

    private void editConfiguration() {
        try {
            ParametersEditor editor = new ParametersEditor(false);
            BaseContext context = new BaseContext();
            if (this.help != null) {
                context.setObject("help", (Object)this.help);
            }
            context.setObject("shell", (Object)this.shell);
            context.setBoolean("stepMode", false);
            String old = this.session.getParameters().toString();
            if (editor.edit((IParameters)this.session.getParameters(), false, (IContext)context) && !old.equals(this.session.getParameters().toString())) {
                this.session.setModified(true);
            }
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error editing options.\n" + e.getMessage(), null);
        }
    }

    private void saveConfiguration() {
        try {
            String path = Dialogs.browseFilenamesForSave(this.shell, "Save Configuration", null, null, String.format("Quality Check Configurations (*%s)\tAll Files (*.*)", ".qccfg"), String.format("*%s\t*.*", ".qccfg"));
            if (path == null) {
                return;
            }
            this.startWaiting("Saving configuration...");
            Parameters params = this.session.getParameters();
            params.save(path);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while saving configuration.\n" + e.getMessage(), null);
        }
        finally {
            this.stopWaiting();
        }
    }

    private void loadConfiguration() {
        try {
            String[] paths = Dialogs.browseFilenames(this.shell, "Load Configuration", false, null, String.format("Quality Check Configurations (*%s)\tAll Files (*.*)", ".qccfg"), String.format("*%s\t*.*", ".qccfg"));
            if (paths == null) {
                return;
            }
            this.startWaiting("Loading configuration...");
            Parameters params = this.session.getParameters();
            params.load(Util.toURL((String)paths[0]), false);
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while saving configuration.\n" + e.getMessage(), null);
        }
        finally {
            this.stopWaiting();
        }
    }

    private void saveSessionAs(String path) {
        try {
            if (path == null) {
                path = Dialogs.browseFilenamesForSave(this.shell, "Save Session", null, null, String.format("Quality Check Sessions (*%s)\tAll Files (*.*)", ".qcs"), String.format("*%s\t*.*", ".qcs"));
                if (path == null) {
                    return;
                }
                this.qcsPath = path;
                this.mruList.add(path);
                this.updateMRU();
            }
            this.startWaiting("Saving session...");
            this.session.saveSession(this.qcsPath);
            this.updateCaption();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while saving.\n" + e.getMessage(), null);
        }
        finally {
            this.stopWaiting();
        }
    }

    private void newSession() {
        try {
            if (!this.saveSessionIfNeeded()) {
                return;
            }
            this.session.reset();
            this.qcsPath = null;
            this.updateCaption();
            this.fillDocumentCombo(null);
            this.resetTableDisplay();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void loadSession(String path) {
        try {
            if (!this.saveSessionIfNeeded()) {
                return;
            }
            if (path == null) {
                String[] paths = Dialogs.browseFilenames(this.shell, "Open Session", false, null, String.format("Quality Check Sessions (*%s)\tAll Files (*.*)", ".qcs"), String.format("*%s\t*.*", ".qcs"));
                if (paths == null) {
                    return;
                }
                path = paths[0];
            }
            if (!new File(path).exists()) {
                Dialogs.showError(this.shell, "The settings file cannot be found:\n" + path, null);
                this.mruList.remove(path);
                this.updateMRU();
                return;
            }
            this.startWaiting("Loading session and processing documents...");
            this.session.loadSession(path);
            this.qcsPath = path;
            this.updateCaption();
            this.mruList.add(path);
            this.updateMRU();
        }
        catch (Throwable e) {
            Dialogs.showError(this.shell, "Error while loading.\n" + e.getMessage(), null);
        }
        finally {
            this.fillDocumentCombo(null);
            this.resetTableDisplay();
            this.stopWaiting();
        }
    }

    private boolean saveSessionIfNeeded() {
        this.config.setProperty(CFG_SOURCELOCALE, this.session.getSourceLocale().toString());
        this.config.setProperty(CFG_TARGETLOCALE, this.session.getTargetLocale().toString());
        this.config.setProperty(OPT_MAXIMIZED, this.shell.getMaximized());
        Rectangle r = this.shell.getBounds();
        this.config.setProperty(OPT_BOUNDS, String.format("%d,%d,%d,%d", r.x, r.y, r.width, r.height));
        this.config.setProperty(CFG_SOURCETEXTOPTIONS, this.srcTextOpt.toString());
        this.config.setProperty(CFG_TARGETTEXTOPTIONS, this.trgTextOpt.toString());
        this.mruList.copyToProperties((Properties)this.config);
        this.config.save(APPNAME, this.getClass().getPackage().getImplementationVersion());
        if (this.session.isModified()) {
            MessageBox dlg = new MessageBox(this.shell, 452);
            dlg.setText(this.shell.getText());
            dlg.setMessage("The session has been modified. Do you want to save it?");
            switch (dlg.open()) {
                case 256: {
                    return false;
                }
                case 64: {
                    this.saveSessionAs(this.qcsPath);
                }
            }
        }
        return true;
    }

    private void clearMRU() {
        try {
            this.mruList.clear();
            this.updateMRU();
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    private void updateMRU() {
        try {
            Menu oldMenu = this.miMRU.getMenu();
            this.miMRU.setMenu(null);
            if (oldMenu != null) {
                oldMenu.dispose();
            }
            if (this.mruList.getfirst() == null) {
                this.miMRU.setEnabled(false);
            } else {
                Menu submenu = new Menu(this.shell, 4);
                int i = 0;
                Iterator<String> iter = this.mruList.getIterator();
                while (iter.hasNext()) {
                    MenuItem menuItem = new MenuItem(submenu, 8);
                    String path = iter.next();
                    menuItem.setText(String.format("&%d %s", ++i, path));
                    menuItem.setData(path);
                    menuItem.addSelectionListener(new SelectionAdapter(){

                        @Override
                        public void widgetSelected(SelectionEvent event) {
                            QualityCheckEditor.this.loadSession((String)((MenuItem)event.getSource()).getData());
                        }
                    });
                }
                this.miMRU.setMenu(submenu);
                this.miMRU.setEnabled(true);
            }
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getMessage(), null);
        }
    }

    public QualityCheckSession getSession() {
        return this.session;
    }
}

