/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.ui;

import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.LocaleFilter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.common.ui.abstracteditor.SWTUtil;
import net.sf.okapi.steps.tokenization.Parameters;
import net.sf.okapi.steps.tokenization.ui.locale.LanguageSelector;
import net.sf.okapi.steps.tokenization.ui.locale.LanguageSelectorPePage;
import net.sf.okapi.steps.tokenization.ui.tokens.TokenSelector;
import net.sf.okapi.steps.tokenization.ui.tokens.TokenSelectorPePage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class OptionsTab
extends Composite
implements IDialogPage {
    private Group grpTokenizeInThe;
    private Button source;
    private Button targets;
    private Button langC;
    private Button tokensC;
    private Group grpLanguagesToTokenize;
    private Text langE;
    private Text tokensE;
    private Label label_2;
    private Label languages;
    private Label tokens;

    public OptionsTab(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new GridLayout(1, false));
        this.grpTokenizeInThe = new Group(this, 0);
        this.grpTokenizeInThe.setText("General");
        this.grpTokenizeInThe.setToolTipText("");
        this.grpTokenizeInThe.setLayout(new GridLayout(3, false));
        this.grpTokenizeInThe.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.grpTokenizeInThe.setData("name", "grpTokenizeInThe");
        this.source = new Button(this.grpTokenizeInThe, 32);
        this.source.setData("name", "source");
        this.source.setText("Tokenize source");
        this.label_2 = new Label(this.grpTokenizeInThe, 0);
        GridData gridData_4 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_4.widthHint = 100;
        this.label_2.setLayoutData(gridData_4);
        this.label_2.setData("name", "label_2");
        this.targets = new Button(this.grpTokenizeInThe, 32);
        this.targets.setData("name", "targets");
        this.targets.setText("Tokenize targets");
        this.grpLanguagesToTokenize = new Group(this, 0);
        this.grpLanguagesToTokenize.setText("Languages");
        this.grpLanguagesToTokenize.setLayout(new GridLayout(2, false));
        this.grpLanguagesToTokenize.setLayoutData(new GridData(4, 4, true, false, 1, 1));
        this.languages = new Label(this.grpLanguagesToTokenize, 0);
        this.languages.setLayoutData(new GridData(16384, 0x1000000, false, false, 2, 1));
        this.languages.setData("name", "languages");
        this.languages.setText("Select languages, or specify a locale filter string (empty = all languages):");
        this.langE = new Text(this.grpLanguagesToTokenize, 2048);
        GridData gridData_2 = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData_2.widthHint = 311;
        this.langE.setLayoutData(gridData_2);
        this.langE.setData("name", "langE");
        this.langE.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent e) {
                e.text = e.text.toLowerCase();
            }
        });
        this.langC = new Button(this.grpLanguagesToTokenize, 0);
        GridData gridData_1 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_1.widthHint = 70;
        this.langC.setLayoutData(gridData_1);
        this.langC.setData("name", "langC");
        this.langC.setText("Select...");
        Group grpTokensToCapture = new Group(this, 0);
        grpTokensToCapture.setText("Tokens");
        grpTokensToCapture.setLayout(new GridLayout(2, false));
        GridData gridData_3 = new GridData(4, 4, true, true, 1, 1);
        gridData_3.heightHint = 100;
        gridData_3.widthHint = 500;
        grpTokensToCapture.setLayoutData(gridData_3);
        this.tokens = new Label(grpTokensToCapture, 0);
        this.tokens.setLayoutData(new GridData(16384, 0x1000000, false, false, 2, 1));
        this.tokens.setData("name", "tokens");
        this.tokens.setText("Select tokens to extract (empty = all tokens):");
        this.tokensE = new Text(grpTokensToCapture, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false, 1, 1);
        gridData.widthHint = 296;
        this.tokensE.setLayoutData(gridData);
        this.tokensE.setData("name", "tokensE");
        this.tokensE.addVerifyListener(new VerifyListener(){

            @Override
            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.tokensC = new Button(grpTokensToCapture, 0);
        GridData gridData_12 = new GridData(16384, 0x1000000, false, false, 1, 1);
        gridData_12.widthHint = 70;
        this.tokensC.setLayoutData(gridData_12);
        this.tokensC.setData("name", "tokensC");
        this.tokensC.setText("Select...");
    }

    @Override
    protected void checkSubclass() {
    }

    @Override
    public boolean canClose(boolean isOK) {
        return true;
    }

    @Override
    public void interop(Widget speaker) {
        if (speaker == this.source && (SWTUtil.getNotSelected(this.targets) || SWTUtil.getDisabled(this.targets)) && SWTUtil.getNotSelected(this.source)) {
            Dialogs.showWarning(this.getShell(), "You cannot unselect this check-box, otherwise there's noting to tokenize.", null);
            SWTUtil.setSelected(this.source, true);
        }
        if (speaker == this.targets && (SWTUtil.getNotSelected(this.source) || SWTUtil.getDisabled(this.source)) && SWTUtil.getNotSelected(this.targets)) {
            Dialogs.showWarning(this.getShell(), "You cannot unselect this check-box, otherwise there's noting to tokenize.", null);
            SWTUtil.setSelected(this.targets, true);
        }
        if (speaker == this.langC) {
            String explicitLocales = LocaleFilter.getExplicitLocaleIds((String)this.langE.getText());
            if (!Util.isEmpty((String)explicitLocales)) {
                SWTUtil.setText(this.langE, explicitLocales);
            }
            String res = ListUtil.arrayAsString((String[])LanguageSelector.select(this.getShell(), LanguageSelectorPePage.class, explicitLocales), (String)" ");
            if (Util.isEmpty((String)explicitLocales) && !Util.isEmpty((String)this.langE.getText())) {
                if (!Util.isEmpty((String)res)) {
                    SWTUtil.setText(this.langE, this.langE.getText() + " " + res);
                }
            } else {
                SWTUtil.setText(this.langE, res);
            }
            this.langE.setFocus();
            this.langE.setSelection(this.langE.getText().length());
        }
        if (speaker == this.tokensC) {
            String[] res = TokenSelector.select(this.getShell(), TokenSelectorPePage.class, this.tokensE.getText());
            SWTUtil.setText(this.tokensE, ListUtil.arrayAsString((String[])res));
            this.tokensE.setFocus();
        }
    }

    @Override
    public boolean load(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            SWTUtil.setSelected(this.source, params.tokenizeSource);
            SWTUtil.setSelected(this.targets, params.tokenizeTargets);
            SWTUtil.setText(this.langE, params.getLanguages());
            SWTUtil.setText(this.tokensE, ListUtil.listAsString((List)params.getTokenNames()));
        }
        SWTUtil.addSpeakers(this, this.source, this.targets, this.langC, this.langE, this.tokensC, this.tokensE);
        this.langE.setFocus();
        return true;
    }

    @Override
    public boolean save(Object data) {
        if (data instanceof Parameters) {
            Parameters params = (Parameters)data;
            params.tokenizeSource = SWTUtil.getSelected(this.source);
            params.tokenizeTargets = SWTUtil.getSelected(this.targets);
            params.setLocaleFilter(this.langE.getText());
            params.setTokenNames(ListUtil.stringAsArray((String)this.tokensE.getText(), (String)" "));
        }
        return true;
    }
}

