/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.lang;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.okapi.lib.xliff2.InvalidParameterException;
import net.sf.okapi.lib.xliff2.XLIFFException;
import net.sf.okapi.lib.xliff2.lang.LanguageData;

public final class Language {
    public static final Language THE_INSTANCE = new Language();
    private static final Pattern HYPHEN = Pattern.compile("-");
    private static final boolean WARN = true;
    private static String[] languages = null;
    private static String[] extlangs = null;
    private static String[] scripts = null;
    private static String[] regions = null;
    private static String[] variants = null;
    private static String[] grandfathered = null;
    private static String[] redundant = null;
    private static String[] deprecated = null;
    private static String[] deprecatedLang = null;
    private static int[] suppressedScriptByLanguage = null;
    private static Map<String, String> preferredValueByLanguageMap = new HashMap<String, String>();
    private static String[][][] prefixesByVariant = null;
    private static int[] prefixByExtlang = null;

    private Language() {
    }

    public void checkValid(String literal) {
        if (literal.length() == 0) {
            throw new InvalidParameterException("The empty string is not a valid language tag.");
        }
        if (this.isGrandfathered(literal = this.toAsciiLowerCase(literal))) {
            if (this.isDeprecated(literal)) {
                throw new InvalidParameterException("Warning: The grandfathered language tag " + literal + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
            }
            return;
        }
        if (this.isRedundant(literal)) {
            if (this.isDeprecated(literal)) {
                throw new InvalidParameterException("Warning: The language tag " + literal + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
            }
            return;
        }
        if (literal.startsWith("-")) {
            throw new InvalidParameterException("Language tag must not start with HYPHEN-MINUS.");
        }
        if (literal.endsWith("-")) {
            throw new InvalidParameterException("Language tag must not end with HYPHEN-MINUS.");
        }
        String[] subtags = HYPHEN.split(literal);
        for (int j = 0; j < subtags.length; ++j) {
            int len = subtags[j].length();
            if (len == 0) {
                throw new InvalidParameterException("Zero-length subtag.");
            }
            if (len <= 8) continue;
            throw new InvalidParameterException("Subtags must not exceed 8 characters in length.");
        }
        int i = 0;
        String subtag = subtags[i];
        int len = subtag.length();
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if ((len == 2 || len == 3) && this.isLowerCaseAlpha(subtag)) {
            if (!this.isLanguage(subtag)) {
                throw new InvalidParameterException("The language subtag " + subtag + " is not a valid ISO language part of a language tag.");
            }
            if (this.isDeprecatedLang(subtag)) {
                throw new InvalidParameterException("Warning: The language subtag " + subtag + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        } else {
            if (len == 4 && this.isLowerCaseAlpha(subtag)) {
                throw new InvalidParameterException("Found reserved language tag: " + subtag + ".");
            }
            if (len >= 5 && this.isLowerCaseAlpha(subtag)) {
                if (!this.isLanguage(subtag)) {
                    throw new InvalidParameterException("The language subtag " + subtag + " is not a valid IANA language part of a language tag.");
                }
                if (this.isDeprecatedLang(subtag)) {
                    throw new InvalidParameterException("Warning: The language subtag " + subtag + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
                }
                if (++i == subtags.length) {
                    return;
                }
                subtag = subtags[i];
                len = subtag.length();
            } else {
                throw new InvalidParameterException("The language subtag " + subtag + " is not a valid language subtag.");
            }
        }
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if (subtag.length() == 3 && this.isLowerCaseAlpha(subtag)) {
            if (!this.isExtlang(subtag)) {
                throw new InvalidParameterException("Bad extlang subtag " + subtag + ".");
            }
            if (!this.usesPrefixByExtlang(subtags[0], subtag)) {
                throw new InvalidParameterException("Extlang subtag " + subtag + " has an incorrect prefix.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        if ("x".equals(subtag)) {
            this.checkPrivateUse(i, subtags);
            return;
        }
        if (subtag.length() == 4 & this.isLowerCaseAlpha(subtag)) {
            if (!this.isScript(subtag)) {
                throw new InvalidParameterException("Bad script subtag.");
            }
            if (this.isDeprecated(subtag)) {
                throw new InvalidParameterException("Warning: The script subtag " + subtag + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
            }
            if (this.shouldSuppressScript(subtags[0], subtag)) {
                throw new InvalidParameterException("Warning: Language tag should omit the default script for the language.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        if (len == 3 && this.isDigit(subtag) || len == 2 && this.isLowerCaseAlpha(subtag)) {
            if (!this.isRegion(subtag)) {
                throw new InvalidParameterException("Bad region subtag.");
            }
            if (this.isDeprecated(subtag)) {
                throw new InvalidParameterException("Warning: The region subtag " + subtag + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
        while (true) {
            if ("x".equals(subtag)) {
                this.checkPrivateUse(i, subtags);
                return;
            }
            if (len == 1 && this.isLowerCaseAlphaNumeric(subtag)) {
                throw new InvalidParameterException("Unknown extension " + subtag + ".");
            }
            if (len == 4 && this.isDigit(subtag.charAt(0)) && this.isLowerCaseAlphaNumeric(subtag) || len >= 5 && this.isLowerCaseAlphaNumeric(subtag)) {
                if (!this.isVariant(subtag)) {
                    throw new InvalidParameterException("Bad variant subtag " + subtag + ".");
                }
                if (this.isDeprecated(subtag)) {
                    throw new InvalidParameterException("Warning: The variant subtag " + subtag + " is deprecated. Use \u201c" + preferredValueByLanguageMap.get(literal) + "\u201d instead.");
                }
                if (!this.hasGoodPrefix(subtags, i)) {
                    throw new InvalidParameterException("Variant " + subtag + " lacks required prefix.");
                }
            } else {
                throw new InvalidParameterException("The subtag " + subtag + " does not match the format for any permissible subtag type.");
            }
            if (++i == subtags.length) {
                return;
            }
            subtag = subtags[i];
            len = subtag.length();
        }
    }

    private boolean hasGoodPrefix(String[] subtags, int i) {
        String variant = subtags[i];
        int index = Arrays.binarySearch(variants, variant);
        assert (index >= 0);
        String[][] prefixes = prefixesByVariant[index];
        if (prefixes.length == 0) {
            return true;
        }
        for (int j = 0; j < prefixes.length; ++j) {
            String[] prefix = prefixes[j];
            if (!this.prefixMatches(prefix, subtags, i)) continue;
            return true;
        }
        return false;
    }

    private boolean prefixMatches(String[] prefix, String[] subtags, int limit) {
        for (int i = 0; i < prefix.length; ++i) {
            String prefixComponent = prefix[i];
            if (this.subtagsContainPrefixComponent(prefixComponent, subtags, limit)) continue;
            return false;
        }
        return true;
    }

    private boolean subtagsContainPrefixComponent(String prefixComponent, String[] subtags, int limit) {
        for (int i = 0; i < limit; ++i) {
            String subtag = subtags[i];
            if (!subtag.equals(prefixComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean usesPrefixByExtlang(String language, String extlang) {
        int langIndex = Arrays.binarySearch(languages, language);
        int extlangIndex = Arrays.binarySearch(extlangs, extlang);
        assert (langIndex > -1);
        int prefixExpected = prefixByExtlang[extlangIndex];
        return prefixExpected == langIndex;
    }

    private boolean shouldSuppressScript(String language, String script) {
        int langIndex = Arrays.binarySearch(languages, language);
        assert (langIndex > -1);
        int scriptIndex = suppressedScriptByLanguage[langIndex];
        if (scriptIndex < 0) {
            return false;
        }
        return scripts[scriptIndex].equals(script);
    }

    private boolean isVariant(String subtag) {
        return Arrays.binarySearch(variants, subtag) > -1;
    }

    private boolean isRegion(String subtag) {
        return Arrays.binarySearch(regions, subtag) > -1 || "aa".equals(subtag) || "qm".compareTo(subtag) <= 0 && "qz".compareTo(subtag) >= 0 || "xa".compareTo(subtag) <= 0 && "xz".compareTo(subtag) >= 0 || "zz".equals(subtag);
    }

    private boolean isScript(String subtag) {
        return Arrays.binarySearch(scripts, subtag) > -1 || "qaaa".compareTo(subtag) <= 0 && "qabx".compareTo(subtag) >= 0;
    }

    private boolean isExtlang(String subtag) {
        return Arrays.binarySearch(extlangs, subtag) > -1;
    }

    private boolean isLanguage(String subtag) {
        return Arrays.binarySearch(languages, subtag) > -1 || "qaa".compareTo(subtag) <= 0 && "qtz".compareTo(subtag) >= 0;
    }

    private void checkPrivateUse(int i, String[] subtags) {
        int len = subtags.length;
        if (++i == len) {
            throw new InvalidParameterException("No subtags in private use sequence.");
        }
        while (i < len) {
            String subtag = subtags[i];
            if (!this.isLowerCaseAlphaNumeric(subtag)) {
                throw new InvalidParameterException("Bad character in private use subtag " + subtag + ".");
            }
            ++i;
        }
    }

    private final boolean isLowerCaseAlphaNumeric(char c) {
        return this.isLowerCaseAlpha(c) || this.isDigit(c);
    }

    private final boolean isLowerCaseAlphaNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isLowerCaseAlphaNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private final boolean isDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean isLowerCaseAlpha(char c) {
        return c >= 'a' && c <= 'z';
    }

    private final boolean isLowerCaseAlpha(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (this.isLowerCaseAlpha(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isGrandfathered(String literal) {
        return Arrays.binarySearch(grandfathered, literal) > -1;
    }

    private boolean isRedundant(String literal) {
        return Arrays.binarySearch(redundant, literal) > -1;
    }

    private boolean isDeprecated(String subtag) {
        return Arrays.binarySearch(deprecated, subtag) > -1;
    }

    private boolean isDeprecatedLang(String subtag) {
        return Arrays.binarySearch(deprecatedLang, subtag) > -1;
    }

    private String toAsciiLowerCase(CharSequence str) {
        if (str == null) {
            return null;
        }
        char[] buf = new char[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            buf[i] = c;
        }
        return new String(buf);
    }

    static {
        try {
            LanguageData data = new LanguageData();
            languages = data.getLanguages();
            extlangs = data.getExtlangs();
            scripts = data.getScripts();
            regions = data.getRegions();
            variants = data.getVariants();
            grandfathered = data.getGrandfathered();
            redundant = data.getRedundant();
            deprecated = data.getDeprecated();
            deprecatedLang = data.getDeprecatedLang();
            suppressedScriptByLanguage = data.getSuppressedScriptByLanguage();
            prefixByExtlang = data.getPrefixByExtlang();
            preferredValueByLanguageMap = data.getPreferredValueByLanguageMap();
            prefixesByVariant = data.getPrefixesByVariant();
        }
        catch (IOException e) {
            throw new XLIFFException(e);
        }
    }
}

