/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.ui.CommandItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MenuItem;

public class ResourceManager {
    private Class cls;
    private Display display;
    private Hashtable<String, Image> images;
    private Hashtable<String, Color> colors1;
    private Hashtable<Integer, Color> colors2;
    private String ext = ".png";
    private String subdir = "images";
    private Hashtable<String, CommandItem> commands;
    private Hashtable<String, Image[]> imageLists;

    public ResourceManager(Class p_Class, Display p_Display) {
        this.display = p_Display;
        this.cls = p_Class;
        this.images = new Hashtable();
        this.colors1 = new Hashtable();
        this.colors2 = new Hashtable();
        this.commands = new Hashtable();
        this.imageLists = new Hashtable();
    }

    public void dispose() {
        Enumeration<Image> e1 = this.images.elements();
        while (e1.hasMoreElements()) {
            e1.nextElement().dispose();
        }
        this.images.clear();
        Enumeration<Image[]> e2 = this.imageLists.elements();
        while (e2.hasMoreElements()) {
            Image[] list;
            for (Image image : list = e2.nextElement()) {
                image.dispose();
            }
        }
        this.imageLists.clear();
        Enumeration<Color> e3 = this.colors1.elements();
        while (e3.hasMoreElements()) {
            e3.nextElement().dispose();
        }
        this.colors1.clear();
        e3 = this.colors2.elements();
        while (e3.hasMoreElements()) {
            e3.nextElement().dispose();
        }
        this.colors2.clear();
        if (this.commands != null) {
            this.commands.clear();
        }
    }

    public void setDefaultExtension(String p_sValue) {
        this.ext = p_sValue;
    }

    public void setSubDirectory(String p_sValue) {
        this.subdir = p_sValue;
    }

    public void addImage(String name) {
        String sKey = name;
        if (name.lastIndexOf(46) == -1) {
            name = name + this.ext;
        }
        if (name.indexOf(File.separatorChar) == -1 && this.subdir.length() != 0) {
            name = this.subdir + "/" + name;
        }
        this.images.put(sKey, new Image((Device)this.display, this.cls.getResourceAsStream(name)));
    }

    public void addImages(String listName, String name1, String name2) {
        if (name1.lastIndexOf(46) == -1) {
            name1 = name1 + this.ext;
        }
        if (name1.indexOf(File.separatorChar) == -1 && this.subdir.length() != 0) {
            name1 = this.subdir + "/" + name1;
        }
        Image image1 = new Image((Device)this.display, this.cls.getResourceAsStream(name1));
        if (name2.lastIndexOf(46) == -1) {
            name2 = name2 + this.ext;
        }
        if (name2.indexOf(File.separatorChar) == -1 && this.subdir.length() != 0) {
            name2 = this.subdir + "/" + name2;
        }
        Image image2 = new Image((Device)this.display, this.cls.getResourceAsStream(name2));
        this.imageLists.put(listName, new Image[]{image1, image2});
    }

    public Image[] getImages(String name) {
        return this.imageLists.get(name);
    }

    public void addColor(String name, int p_nRed, int p_nGreen, int p_nBlue) {
        this.colors1.put(name, new Color(this.display, p_nRed, p_nGreen, p_nBlue));
    }

    public void addColor(int id, int red, int green, int blue) {
        this.colors2.put(id, new Color(this.display, red, green, blue));
    }

    public Image getImage(String name) {
        return this.images.get(name);
    }

    public Color getColor(String name) {
        return this.colors1.get(name);
    }

    public Color getColor(int id) {
        return this.colors2.get(id);
    }

    public void setCommand(MenuItem menuItem, String resName) {
        CommandItem cmd = this.commands.get(resName);
        menuItem.setText(cmd.label);
        if (cmd.accelerator != 0) {
            menuItem.setAccelerator(cmd.accelerator);
        }
    }

    public String getCommandLabel(String resName) {
        CommandItem cmd = this.commands.get(resName);
        if (cmd == null) {
            return "!" + resName + "!";
        }
        return cmd.label;
    }

    public void loadCommands(String baseName) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName);
            this.commands.clear();
            Enumeration<String> enumKeys = bundle.getKeys();
            Vector<String> vect = new Vector<String>(Collections.list(enumKeys));
            Collections.sort(vect);
            String rootKey = "";
            CommandItem item = null;
            for (String key : vect) {
                int n;
                if (!key.substring(0, n = key.lastIndexOf(46)).equals(rootKey)) {
                    if (item != null) {
                        this.commands.put(rootKey, item);
                    }
                    item = new CommandItem();
                    rootKey = key.substring(0, n);
                }
                if (key.endsWith(".text")) {
                    item.label = bundle.getString(key);
                    continue;
                }
                if (key.endsWith(".alt")) {
                    if (!bundle.getString(key).equals("1")) continue;
                    item.accelerator |= 0x10000;
                    continue;
                }
                if (key.endsWith(".ctrl")) {
                    if (!bundle.getString(key).equals("1")) continue;
                    item.accelerator = item.accelerator | (Util.getOS() == Util.SUPPORTED_OS.MAC ? 0x400000 : 262144);
                    continue;
                }
                if (key.endsWith(".shift")) {
                    if (!bundle.getString(key).equals("1")) continue;
                    item.accelerator |= 0x20000;
                    continue;
                }
                if (key.endsWith(".cmd")) {
                    if (!bundle.getString(key).equals("1")) continue;
                    item.accelerator |= 0x400000;
                    continue;
                }
                if (key.endsWith(".key")) {
                    String tmp;
                    switch (tmp = bundle.getString(key)) {
                        case "F1": {
                            item.accelerator |= 0x100000A;
                            break;
                        }
                        case "F2": {
                            item.accelerator |= 0x100000B;
                            break;
                        }
                        case "F3": {
                            item.accelerator |= 0x100000C;
                            break;
                        }
                        case "F4": {
                            item.accelerator |= 0x100000D;
                            break;
                        }
                        case "F5": {
                            item.accelerator |= 0x100000E;
                            break;
                        }
                        case "F6": {
                            item.accelerator |= 0x100000F;
                            break;
                        }
                        case "F7": {
                            item.accelerator |= 0x1000010;
                            break;
                        }
                        case "F8": {
                            item.accelerator |= 0x1000011;
                            break;
                        }
                        case "F9": {
                            item.accelerator |= 0x1000012;
                            break;
                        }
                        case "F10": {
                            item.accelerator |= 0x1000013;
                            break;
                        }
                        case "F11": {
                            item.accelerator |= 0x1000014;
                            break;
                        }
                        case "F12": {
                            item.accelerator |= 0x1000015;
                            break;
                        }
                        case "F13": {
                            item.accelerator |= 0x1000016;
                            break;
                        }
                        case "F14": {
                            item.accelerator |= 0x1000017;
                            break;
                        }
                        case "F15": {
                            item.accelerator |= 0x1000018;
                            break;
                        }
                        case "Up": {
                            item.accelerator |= 0x1000001;
                            break;
                        }
                        case "Down": {
                            item.accelerator |= 0x1000002;
                            break;
                        }
                        case "Left": {
                            item.accelerator |= 0x1000003;
                            break;
                        }
                        case "Right": {
                            item.accelerator |= 0x1000004;
                            break;
                        }
                        case "PageUp": {
                            item.accelerator |= 0x1000005;
                            break;
                        }
                        case "PageDown": {
                            item.accelerator |= 0x1000006;
                            break;
                        }
                        case "Home": {
                            item.accelerator |= 0x1000007;
                            break;
                        }
                        case "End": {
                            item.accelerator |= 0x1000008;
                            break;
                        }
                        case "Insert": {
                            item.accelerator |= 0x1000009;
                            break;
                        }
                        case "Enter": {
                            item.accelerator |= 0xD;
                            break;
                        }
                        case "Delete": {
                            item.accelerator |= 0x7F;
                            break;
                        }
                        default: {
                            if (tmp.length() == 1) {
                                item.accelerator |= tmp.codePointAt(0);
                                break;
                            }
                            throw new OkapiIOException("Invalid key in command: " + tmp);
                        }
                    }
                    continue;
                }
                throw new OkapiIOException("Invalid keyword in command: " + key);
            }
            if (rootKey.length() > 0) {
                this.commands.put(rootKey, item);
            }
        }
        catch (Exception e) {
            throw new OkapiException((Throwable)e);
        }
    }
}

