/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.abstracteditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.common.ui.abstracteditor.IDialogPage;
import net.sf.okapi.lib.extra.INotifiable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractBaseDialog
implements INotifiable {
    public static final String REGISTER_DIALOG_PAGE = "REGISTER_DIALOG_PAGE";
    public static final String UNREGISTER_DIALOG_PAGE = "UNREGISTER_DIALOG_PAGE";
    public static final String NOTIFICATION_OK = "NOTIFICATION_OK";
    public static final String NOTIFICATION_CANCEL = "NOTIFICATION_CANCEL";
    protected boolean result = true;
    protected Shell shell;
    protected Shell parent;
    private String caption;
    private Object data = null;
    private IHelp help;
    protected IDialogPage page;
    protected Composite pageC;
    private Class<? extends Composite> pageClass;
    private int style;
    private boolean sizeable;

    public AbstractBaseDialog(boolean sizeable) {
        this.style = sizeable ? 67696 : 67680;
        this.sizeable = sizeable;
    }

    protected abstract void setActionButtonsPanel(Shell var1, SelectionAdapter var2, boolean var3);

    protected abstract void init();

    protected abstract void done();

    protected void create(Shell p_Parent) {
        try {
            this.result = false;
            this.shell = new Shell(p_Parent, this.style);
            if (this.shell == null) {
                return;
            }
            this.shell.setText(this.caption);
            this.shell.setData("owner", this);
            this.shell.setData("parent", p_Parent);
            if (this.sizeable) {
                UIUtil.inheritIcon(this.shell, p_Parent);
            }
            GridLayout layTmp = new GridLayout();
            layTmp.marginBottom = 0;
            layTmp.verticalSpacing = 0;
            this.shell.setLayout(layTmp);
            if (this.pageClass == null) {
                return;
            }
            Constructor<? extends Composite> cc = this.pageClass.getConstructor(Composite.class, Integer.TYPE);
            if (cc == null) {
                return;
            }
            this.pageC = cc.newInstance(this.shell, 0);
            if (this.pageC instanceof IDialogPage) {
                this.page = (IDialogPage)((Object)this.pageC);
                this.pageC.setData("dialog", this);
            } else {
                this.page = null;
            }
            this.shell.addDisposeListener(new DisposeListener(){

                @Override
                public void widgetDisposed(DisposeEvent e) {
                    Object owner;
                    if (AbstractBaseDialog.this.parent != null && (owner = AbstractBaseDialog.this.parent.getData("owner")) instanceof INotifiable) {
                        ((INotifiable)owner).exec((Object)this, AbstractBaseDialog.UNREGISTER_DIALOG_PAGE, (Object)AbstractBaseDialog.this.page);
                    }
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.result = false;
            return;
        }
        this.result = true;
        this.pageC.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        if (!this.result) {
            return;
        }
        this.init();
        if (this.page != null) {
            this.page.load(this.data);
        }
        if (this.page != null) {
            this.page.interop(null);
        }
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals("h")) {
                    if (AbstractBaseDialog.this.help != null) {
                        AbstractBaseDialog.this.help.showTopic((Object)this, "index");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (AbstractBaseDialog.this.page != null) {
                        AbstractBaseDialog.this.result = AbstractBaseDialog.this.page.save(AbstractBaseDialog.this.data);
                    }
                } else {
                    AbstractBaseDialog.this.result = false;
                }
                AbstractBaseDialog.this.shell.close();
            }
        };
        this.setActionButtonsPanel(this.shell, OKCancelActions, this.help != null);
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Dialogs.centerWindow(this.shell, p_Parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean run(Shell parent, Class<? extends Composite> pageClass, String caption, Object initialData, IHelp help) {
        try {
            this.parent = parent;
            this.pageClass = pageClass;
            this.caption = caption;
            this.data = initialData;
            this.help = help;
            this.create(parent);
            if (!this.result) {
                boolean bl = false;
                return bl;
            }
            this.showDialog();
            if (!this.result) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (this.shell != null) {
                this.done();
                this.shell.dispose();
            }
        }
        return this.result;
    }

    protected void showDialog() {
        Object owner;
        if (!this.result) {
            return;
        }
        if (this.parent != null && (owner = this.parent.getData("owner")) instanceof INotifiable && this.page != null) {
            ((INotifiable)owner).exec((Object)this, REGISTER_DIALOG_PAGE, (Object)this.page);
        }
        this.result = false;
        this.shell.open();
        this.shell.update();
        if (this.page != null) {
            this.page.interop(this.shell);
        }
        while (!this.shell.isDisposed()) {
            try {
                if (this.shell.getDisplay().readAndDispatch()) continue;
                this.shell.getDisplay().sleep();
            }
            catch (Exception E) {
                Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            }
        }
    }

    public Object getResult() {
        return this.data;
    }

    public <T> T getResult(Class<T> classRef) {
        return classRef.cast(this.data);
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean exec(Object sender, String command, Object info) {
        if (command.equalsIgnoreCase(NOTIFICATION_OK)) {
            if (this.page != null) {
                this.result = this.page.save(this.data);
            }
            this.shell.close();
            return true;
        }
        return false;
    }
}

