/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Excell;
import net.sf.okapi.filters.openxml.ParseType;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

@EditorFor(value=ConditionalParameters.class)
public class Editor
implements IParametersEditor {
    private Shell shell;
    private IContext context;
    private boolean readOnly = false;
    private boolean result = false;
    private ConditionalParameters params;
    private IHelp help;
    private Button btnHelp;
    private Button btnOk;
    private Button btnCancel;
    private Button btnTranslateDocumentProperties;
    private Button btnTranslateComments;
    private Button btnCleanAggressively;
    private Button btnTreatTabAsChar;
    private Button btnTreatLineBreakAsChar;
    private Button btnTranslateHeadersAndFooters;
    private Button btnTranslateHiddenText;
    private Button btnExcludeGraphicMetadata;
    private Button btnAutomaticallyAcceptRevisions;
    private Button btnIgnoreSoftHyphen;
    private Button btnReplaceNonBreakingHyphen;
    private Button btnStylesFromDocument;
    private Button btnColorsFromDocument;
    private Button btnExcludeExcelColumns;
    private Button btnTranslateHiddenCells;
    private Button btnTranslateSheetNames;
    private Button btnTranslateDiagramData;
    private Button btnTranslateDrawings;
    private Button btnExtractExternalHyperlinks;
    private List listExcludedWordStyles;
    private List listTranslatableFields;
    private List listExcelColorsToExclude;
    private List listExcelSheet1ColumnsToExclude;
    private List listExcelSheet2ColumnsToExclude;
    private List listExcelSheet3ColumnsToExclude;
    private Button btnTranslateNotes;
    private Button btnTranslateMasters;
    private Button btnIgnorePlaceholdersInMasters;
    private Button btnIncludedSlideNumbersOnly;
    private List listPowerpointIncludedSlideNumbers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit(IParameters options, boolean readOnly, IContext context) {
        this.context = context;
        this.readOnly = readOnly;
        this.help = (IHelp)context.getObject("help");
        boolean bRes = false;
        this.shell = null;
        this.params = (ConditionalParameters)options;
        try {
            this.createContents();
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception E) {
            Dialogs.showError(this.shell, E.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    public IParameters createParameters() {
        return new ConditionalParameters();
    }

    protected void createContents() {
        Shell parent = (Shell)this.context.getObject("shell");
        this.shell = new Shell(parent, 65648);
        this.shell.setText("Office 2007 Filter Parameters");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout(layTmp);
        TabFolder tabFolder = new TabFolder(this.shell, 0);
        GridData gdTmp = new GridData(1808);
        tabFolder.setLayoutData(gdTmp);
        TabItem tbtmGeneralOptions_1 = new TabItem(tabFolder, 0);
        tbtmGeneralOptions_1.setText("General Options");
        Composite composite = new Composite(tabFolder, 0);
        tbtmGeneralOptions_1.setControl(composite);
        composite.setLayout(new GridLayout(1, false));
        this.btnTranslateDocumentProperties = new Button(composite, 32);
        this.btnTranslateDocumentProperties.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateDocumentProperties.setSelection(true);
        this.btnTranslateDocumentProperties.setText("Translate Document Properties");
        this.btnTranslateComments = new Button(composite, 32);
        this.btnTranslateComments.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTranslateComments.setSelection(true);
        this.btnTranslateComments.setText("Translate Comments");
        this.btnCleanAggressively = new Button(composite, 32);
        this.btnCleanAggressively.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnCleanAggressively.setSelection(true);
        this.btnCleanAggressively.setText("Clean Tags Aggressively");
        this.btnTreatTabAsChar = new Button(composite, 32);
        this.btnTreatTabAsChar.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTreatTabAsChar.setSelection(false);
        this.btnTreatTabAsChar.setText("Treat Tab as Character");
        this.btnTreatLineBreakAsChar = new Button(composite, 32);
        this.btnTreatLineBreakAsChar.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnTreatLineBreakAsChar.setSelection(false);
        this.btnTreatLineBreakAsChar.setText("Treat Line Break as Character");
        TabItem tbtmWordOptions = new TabItem(tabFolder, 0);
        tbtmWordOptions.setText("Word Options");
        composite = new Composite(tabFolder, 0);
        tbtmWordOptions.setControl(composite);
        composite.setLayout(new GridLayout(2, false));
        Composite leftOptions = new Composite(composite, 0);
        leftOptions.setLayout(new GridLayout());
        leftOptions.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.btnTranslateHeadersAndFooters = new Button(leftOptions, 32);
        this.btnTranslateHeadersAndFooters.setSelection(true);
        this.btnTranslateHeadersAndFooters.setText("Translate Headers and Footers");
        this.btnTranslateHiddenText = new Button(leftOptions, 32);
        this.btnTranslateHiddenText.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnTranslateHiddenText.setSelection(true);
        this.btnTranslateHiddenText.setText("Translate Hidden Text");
        this.btnExcludeGraphicMetadata = new Button(leftOptions, 32);
        this.btnExcludeGraphicMetadata.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnExcludeGraphicMetadata.setSelection(false);
        this.btnExcludeGraphicMetadata.setText("Exclude Graphical Metadata");
        this.btnAutomaticallyAcceptRevisions = new Button(leftOptions, 32);
        this.btnAutomaticallyAcceptRevisions.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnAutomaticallyAcceptRevisions.setSelection(true);
        this.btnAutomaticallyAcceptRevisions.setText("Automatically Accept Revisions");
        this.btnIgnoreSoftHyphen = new Button(leftOptions, 32);
        this.btnIgnoreSoftHyphen.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnIgnoreSoftHyphen.setSelection(false);
        this.btnIgnoreSoftHyphen.setText("Ignore Soft Hyphens");
        this.btnReplaceNonBreakingHyphen = new Button(leftOptions, 32);
        this.btnReplaceNonBreakingHyphen.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnReplaceNonBreakingHyphen.setSelection(false);
        this.btnReplaceNonBreakingHyphen.setText("Replace Non-Breaking Hyphen with Regular Hyphen");
        this.btnExtractExternalHyperlinks = new Button(leftOptions, 32);
        this.btnExtractExternalHyperlinks.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.btnExtractExternalHyperlinks.setSelection(false);
        this.btnExtractExternalHyperlinks.setText("Translate Hyperlink URLs");
        Label lblStyles = new Label(leftOptions, 0);
        lblStyles.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        lblStyles.setText("Translatable Fields:");
        this.listTranslatableFields = new List(leftOptions, 2562);
        GridData gd_listTranslatableFields = new GridData(4, 4, true, true, 1, 1);
        gd_listTranslatableFields.heightHint = 40;
        this.listTranslatableFields.setLayoutData(gd_listTranslatableFields);
        this.listTranslatableFields.setItems("HYPERLINK", "FORMTEXT", "TOC");
        Composite rightOptions = new Composite(composite, 0);
        rightOptions.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        rightOptions.setLayout(new GridLayout());
        Label lblStyles2 = new Label(rightOptions, 0);
        lblStyles2.setLayoutData(new GridData(16384, 0x1000000, true, false, 1, 1));
        lblStyles2.setText("Styles to Exclude:");
        this.listExcludedWordStyles = new List(rightOptions, 2562);
        GridData gd_listExcludedWordStyles = new GridData(4, 4, true, true, 1, 1);
        gd_listExcludedWordStyles.heightHint = 40;
        this.listExcludedWordStyles.setLayoutData(gd_listExcludedWordStyles);
        this.listExcludedWordStyles.setItems("Emphasis", "ExcludeCharacterStyle", "ExcludeParagraphStyle", "Heading1", "Heading2", "Normal", "Title", "Strong", "Subtitle", "tw4winExternal");
        TabItem tbtmExcelOptions = new TabItem(tabFolder, 0);
        tbtmExcelOptions.setText("Excel Options");
        composite = new Composite(tabFolder, 0);
        tbtmExcelOptions.setControl(composite);
        composite.setLayout(new GridLayout(2, false));
        this.btnTranslateHiddenCells = new Button(composite, 32);
        this.btnTranslateHiddenCells.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateHiddenCells.setSelection(false);
        this.btnTranslateHiddenCells.setText("Translate Hidden Rows and Columns");
        new Label(composite, 0);
        this.btnExcludeExcelColumns = new Button(composite, 32);
        this.btnExcludeExcelColumns.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnExcludeExcelColumns.setSelection(true);
        this.btnExcludeExcelColumns.setText("Exclude Marked Columns in Each Sheet");
        new Label(composite, 0);
        this.btnTranslateSheetNames = new Button(composite, 32);
        this.btnTranslateSheetNames.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateSheetNames.setSelection(true);
        this.btnTranslateSheetNames.setText("Translate Sheet Names");
        new Label(composite, 0);
        this.btnTranslateDiagramData = new Button(composite, 32);
        this.btnTranslateDiagramData.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateDiagramData.setSelection(true);
        this.btnTranslateDiagramData.setText("Translate Diagram Data (e.g. Smart Art)");
        new Label(composite, 0);
        this.btnTranslateDrawings = new Button(composite, 32);
        this.btnTranslateDrawings.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateDrawings.setSelection(true);
        this.btnTranslateDrawings.setText("Translate Drawings (e.g. Text fields)");
        new Label(composite, 0);
        Label lblColorsToExclude = new Label(composite, 0);
        lblColorsToExclude.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        lblColorsToExclude.setText("Colors to Exclude:");
        Label lblSheetColumns = new Label(composite, 0);
        lblSheetColumns.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        lblSheetColumns.setText("Sheet 1 Columns to Exlude:");
        this.listExcelColorsToExclude = new List(composite, 2562);
        GridData gd_listExcelColorsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listExcelColorsToExclude.heightHint = 40;
        this.listExcelColorsToExclude.setLayoutData(gd_listExcelColorsToExclude);
        this.listExcelColorsToExclude.setItems("blue", "dark blue", "dark red", "green", "light blue", "light green", "orange", "purple", "red", "yellow");
        this.listExcelSheet1ColumnsToExclude = new List(composite, 2562);
        GridData gd_listExcelSheet1ColumnsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listExcelSheet1ColumnsToExclude.heightHint = 40;
        this.listExcelSheet1ColumnsToExclude.setLayoutData(gd_listExcelSheet1ColumnsToExclude);
        this.listExcelSheet1ColumnsToExclude.setItems("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "Y", "Z", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AI", "AJ", "AK", "AL", "AM", "AN", "AO", "AP", "AQ", "AR", "AS", "AT", "AU", "AV", "AX", "AY", "AZ", "BA", "BB", "BC", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BK", "BL", "BM", "BN", "BO", "BP", "BQ", "BR", "BS", "BT", "BU", "BV", "BX", "BY", "BZ", "CA", "CB", "CC", "CD", "CE", "CF", "CG", "CH", "CI", "CJ", "CK", "CL", "CM", "CN", "CO", "CP", "CQ", "CR", "CS", "CT", "CU", "CV", "CX", "CY", "CZ", "DA", "DB", "DC", "DD", "DE", "DF", "DG", "DH", "DI", "DJ", "DK", "DL", "DM", "DN", "DO", "DP", "DQ", "DR", "DS", "DT", "DU", "DV", "DX", "DY", "DZ", "EA", "EB", "EC", "ED", "EE", "EF", "EG", "EH", "EI", "EJ", "EK", "EL", "EM", "EN", "EO", "EP", "EQ", "ER", "ES", "ET", "EU", "EV", "EX", "EY", "EZ");
        Label lblSheetColumns_1 = new Label(composite, 0);
        lblSheetColumns_1.setLayoutData(new GridData(4, 0x1000000, false, false, 1, 1));
        lblSheetColumns_1.setText("Sheet 2 Columns to Exlude:");
        Label lblSheetColumns_2 = new Label(composite, 0);
        lblSheetColumns_2.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        lblSheetColumns_2.setText("Sheets 3 (and higher) Columns to Exlude:");
        this.listExcelSheet2ColumnsToExclude = new List(composite, 2562);
        GridData gd_listExcelSheet2ColumnsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listExcelSheet2ColumnsToExclude.heightHint = 40;
        this.listExcelSheet2ColumnsToExclude.setLayoutData(gd_listExcelSheet2ColumnsToExclude);
        this.listExcelSheet2ColumnsToExclude.setItems("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "Y", "Z", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AI", "AJ", "AK", "AL", "AM", "AN", "AO", "AP", "AQ", "AR", "AS", "AT", "AU", "AV", "AX", "AY", "AZ", "BA", "BB", "BC", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BK", "BL", "BM", "BN", "BO", "BP", "BQ", "BR", "BS", "BT", "BU", "BV", "BX", "BY", "BZ", "CA", "CB", "CC", "CD", "CE", "CF", "CG", "CH", "CI", "CJ", "CK", "CL", "CM", "CN", "CO", "CP", "CQ", "CR", "CS", "CT", "CU", "CV", "CX", "CY", "CZ", "DA", "DB", "DC", "DD", "DE", "DF", "DG", "DH", "DI", "DJ", "DK", "DL", "DM", "DN", "DO", "DP", "DQ", "DR", "DS", "DT", "DU", "DV", "DX", "DY", "DZ", "EA", "EB", "EC", "ED", "EE", "EF", "EG", "EH", "EI", "EJ", "EK", "EL", "EM", "EN", "EO", "EP", "EQ", "ER", "ES", "ET", "EU", "EV", "EX", "EY", "EZ");
        this.listExcelSheet3ColumnsToExclude = new List(composite, 2562);
        GridData gd_listExcelSheet3ColumnsToExclude = new GridData(4, 4, true, true, 1, 1);
        gd_listExcelSheet3ColumnsToExclude.heightHint = 40;
        this.listExcelSheet3ColumnsToExclude.setLayoutData(gd_listExcelSheet3ColumnsToExclude);
        this.listExcelSheet3ColumnsToExclude.setItems("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "X", "Y", "Z", "AA", "AB", "AC", "AD", "AE", "AF", "AG", "AH", "AI", "AJ", "AK", "AL", "AM", "AN", "AO", "AP", "AQ", "AR", "AS", "AT", "AU", "AV", "AX", "AY", "AZ", "BA", "BB", "BC", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BK", "BL", "BM", "BN", "BO", "BP", "BQ", "BR", "BS", "BT", "BU", "BV", "BX", "BY", "BZ", "CA", "CB", "CC", "CD", "CE", "CF", "CG", "CH", "CI", "CJ", "CK", "CL", "CM", "CN", "CO", "CP", "CQ", "CR", "CS", "CT", "CU", "CV", "CX", "CY", "CZ", "DA", "DB", "DC", "DD", "DE", "DF", "DG", "DH", "DI", "DJ", "DK", "DL", "DM", "DN", "DO", "DP", "DQ", "DR", "DS", "DT", "DU", "DV", "DX", "DY", "DZ", "EA", "EB", "EC", "ED", "EE", "EF", "EG", "EH", "EI", "EJ", "EK", "EL", "EM", "EN", "EO", "EP", "EQ", "ER", "ES", "ET", "EU", "EV", "EX", "EY", "EZ");
        TabItem tbtmPowerpointOptions = new TabItem(tabFolder, 0);
        tbtmPowerpointOptions.setText("Powerpoint Options");
        composite = new Composite(tabFolder, 0);
        tbtmPowerpointOptions.setControl(composite);
        composite.setLayout(new GridLayout(1, false));
        this.btnTranslateNotes = new Button(composite, 32);
        this.btnTranslateNotes.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateNotes.setSelection(true);
        this.btnTranslateNotes.setText("Translate Notes");
        this.btnTranslateMasters = new Button(composite, 32);
        this.btnTranslateMasters.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnTranslateMasters.setSelection(true);
        this.btnTranslateMasters.setText("Translate Masters");
        this.btnIgnorePlaceholdersInMasters = new Button(composite, 32);
        this.btnIgnorePlaceholdersInMasters.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnIgnorePlaceholdersInMasters.setSelection(true);
        this.btnIgnorePlaceholdersInMasters.setText("Ignore Placeholder Text in Masters");
        this.btnIncludedSlideNumbersOnly = new Button(composite, 32);
        this.btnIncludedSlideNumbersOnly.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnIncludedSlideNumbersOnly.setSelection(false);
        this.btnIncludedSlideNumbersOnly.setText("Translate included slide numbers only");
        this.listPowerpointIncludedSlideNumbers = new List(composite, 2562);
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 40;
        this.listPowerpointIncludedSlideNumbers.setLayoutData(gridData);
        ArrayList<String> slideNumbers = new ArrayList<String>();
        for (int i = 1; i < 100; ++i) {
            slideNumbers.add(String.valueOf(i));
        }
        this.listPowerpointIncludedSlideNumbers.setItems(slideNumbers.toArray(new String[0]));
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("OpenOffice Filter");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        OKCancelPanel pnlActions = new OKCancelPanel(this.shell, 0, OKCancelActions, true);
        gdTmp = new GridData(768);
        pnlActions.setLayoutData(gdTmp);
        pnlActions.btOK.setEnabled(!this.readOnly);
        if (!this.readOnly) {
            this.shell.setDefaultButton(pnlActions.btOK);
        }
        this.shell.pack();
        Rectangle Rect = this.shell.getBounds();
        this.shell.setMinimumSize(Rect.width, Rect.height);
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 300) {
            startSize.x = 300;
        }
        if (startSize.y < 200) {
            startSize.y = 200;
        }
        this.shell.setSize(new Point(541, 367));
        Dialogs.centerWindow(this.shell, parent);
        this.setData();
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    protected void setData() {
        int ndx;
        String[] sMulti;
        int siz;
        Iterator it;
        this.btnTranslateDocumentProperties.setSelection(this.params.getTranslateDocProperties());
        this.btnTranslateComments.setSelection(this.params.getTranslateComments());
        this.btnCleanAggressively.setSelection(this.params.getCleanupAggressively());
        this.btnTreatTabAsChar.setSelection(this.params.getAddTabAsCharacter());
        this.btnTreatLineBreakAsChar.setSelection(this.params.getAddLineSeparatorCharacter());
        this.btnTranslateHeadersAndFooters.setSelection(this.params.getTranslateWordHeadersFooters());
        this.btnTranslateHiddenText.setSelection(this.params.getTranslateWordHidden() || this.params.getTranslatePowerpointHidden() || this.params.getTranslateExcelHidden());
        this.btnExcludeGraphicMetadata.setSelection(this.params.getTranslateWordExcludeGraphicMetaData());
        this.btnAutomaticallyAcceptRevisions.setSelection(this.params.getAutomaticallyAcceptRevisions());
        this.btnIgnoreSoftHyphen.setSelection(this.params.getIgnoreSoftHyphenTag());
        this.btnReplaceNonBreakingHyphen.setSelection(this.params.getReplaceNoBreakHyphenTag());
        this.btnTranslateNotes.setSelection(this.params.getTranslatePowerpointNotes());
        this.btnTranslateMasters.setSelection(this.params.getTranslatePowerpointMasters());
        this.btnIgnorePlaceholdersInMasters.setSelection(this.params.getIgnorePlaceholdersInPowerpointMasters());
        this.btnTranslateSheetNames.setSelection(this.params.getTranslateExcelSheetNames());
        this.btnTranslateDiagramData.setSelection(this.params.getTranslateExcelDiagramData());
        this.btnTranslateDrawings.setSelection(this.params.getTranslateExcelDrawings());
        if (this.params.tsExcludeWordStyles != null && !this.params.tsExcludeWordStyles.isEmpty()) {
            it = this.params.tsExcludeWordStyles.iterator();
            siz = this.params.tsExcludeWordStyles.size();
            if (siz > 0) {
                sMulti = new String[siz];
                ndx = 0;
                while (it.hasNext()) {
                    sMulti[ndx++] = (String)it.next();
                }
                this.listExcludedWordStyles.setSelection(sMulti);
            }
        }
        if (this.params.tsComplexFieldDefinitionsToExtract != null && !this.params.tsComplexFieldDefinitionsToExtract.isEmpty()) {
            it = this.params.tsComplexFieldDefinitionsToExtract.iterator();
            siz = this.params.tsComplexFieldDefinitionsToExtract.size();
            if (siz > 0) {
                sMulti = new String[siz];
                ndx = 0;
                while (it.hasNext()) {
                    sMulti[ndx++] = (String)it.next();
                }
                this.listTranslatableFields.setSelection(sMulti);
            }
        }
        if (this.params.getTranslateExcelExcludeColors() && this.params.tsExcelExcludedColors != null && !this.params.tsExcelExcludedColors.isEmpty()) {
            TreeSet<String> tsColors = new TreeSet<String>();
            it = this.params.tsExcelExcludedColors.iterator();
            while (it.hasNext()) {
                String sRGB;
                switch (sRGB = (String)it.next()) {
                    case "FF0000FF": {
                        sRGB = "blue";
                        break;
                    }
                    case "FF3366FF": {
                        sRGB = "light blue";
                        break;
                    }
                    case "FF008000": {
                        sRGB = "green";
                        break;
                    }
                    case "FF660066": {
                        sRGB = "purple";
                        break;
                    }
                    case "FFFF0000": {
                        sRGB = "red";
                        break;
                    }
                    case "FFFFFF00": {
                        sRGB = "yellow";
                        break;
                    }
                    case "FF800000": {
                        sRGB = "dark red";
                        break;
                    }
                    case "FFCCFFCC": {
                        sRGB = "light green";
                        break;
                    }
                    case "FFFF6600": {
                        sRGB = "orange";
                        break;
                    }
                    case "FF000090": {
                        sRGB = "dark blue";
                    }
                }
                tsColors.add(sRGB);
            }
            siz = tsColors.size();
            if (siz > 0) {
                sMulti = new String[siz];
                it = tsColors.iterator();
                ndx = 0;
                while (it.hasNext()) {
                    sMulti[ndx++] = (String)it.next();
                }
                this.listExcelColorsToExclude.setSelection(sMulti);
            }
        }
        this.btnExcludeExcelColumns.setSelection(this.params.getTranslateExcelExcludeColumns());
        this.btnTranslateHiddenCells.setSelection(this.params.getTranslateExcelHidden());
        if (this.params.getTranslateExcelExcludeColumns() && this.params.tsExcelExcludedColumns != null && !this.params.tsExcelExcludedColumns.isEmpty()) {
            String sDuraCell;
            Excell eggshell;
            siz = 0;
            for (String sYmphony : this.params.tsExcelExcludedColumns) {
                eggshell = new Excell(sYmphony);
                sDuraCell = eggshell.getColumn();
                if (!eggshell.getSheet().equals("1")) continue;
                ++siz;
            }
            if (siz > 0) {
                ndx = 0;
                sMulti = new String[siz];
                for (String sYmphony : this.params.tsExcelExcludedColumns) {
                    eggshell = new Excell(sYmphony);
                    sDuraCell = eggshell.getColumn();
                    if (!eggshell.getSheet().equals("1")) continue;
                    sMulti[ndx++] = sDuraCell;
                }
                this.listExcelSheet1ColumnsToExclude.setSelection(sMulti);
            }
            siz = 0;
            for (String sYmphony : this.params.tsExcelExcludedColumns) {
                eggshell = new Excell(sYmphony);
                sDuraCell = eggshell.getColumn();
                if (!eggshell.getSheet().equals("2")) continue;
                ++siz;
            }
            if (siz > 0) {
                ndx = 0;
                sMulti = new String[siz];
                for (String sYmphony : this.params.tsExcelExcludedColumns) {
                    eggshell = new Excell(sYmphony);
                    sDuraCell = eggshell.getColumn();
                    if (!eggshell.getSheet().equals("2")) continue;
                    sMulti[ndx++] = sDuraCell;
                }
                this.listExcelSheet2ColumnsToExclude.setSelection(sMulti);
            }
            siz = 0;
            for (String sYmphony : this.params.tsExcelExcludedColumns) {
                eggshell = new Excell(sYmphony);
                sDuraCell = eggshell.getColumn();
                if (!eggshell.getSheet().equals("3")) continue;
                ++siz;
            }
            if (siz > 0) {
                ndx = 0;
                sMulti = new String[siz];
                for (String sYmphony : this.params.tsExcelExcludedColumns) {
                    eggshell = new Excell(sYmphony);
                    sDuraCell = eggshell.getColumn();
                    if (!eggshell.getSheet().equals("3")) continue;
                    sMulti[ndx++] = sDuraCell;
                }
                this.listExcelSheet3ColumnsToExclude.setSelection(sMulti);
            }
        }
        this.btnIncludedSlideNumbersOnly.setSelection(this.params.getPowerpointIncludedSlideNumbersOnly());
        ArrayList<String> selectedSlideNumbers = new ArrayList<String>();
        for (Integer slideNumber : this.params.tsPowerpointIncludedSlideNumbers) {
            selectedSlideNumbers.add(slideNumber.toString());
        }
        this.listPowerpointIncludedSlideNumbers.setSelection(selectedSlideNumbers.toArray(new String[0]));
    }

    private boolean saveData() {
        int i;
        this.params.setTranslateDocProperties(this.btnTranslateDocumentProperties.getSelection());
        this.params.setTranslateComments(this.btnTranslateComments.getSelection());
        this.params.setCleanupAggressively(this.btnCleanAggressively.getSelection());
        this.params.setAddTabAsCharacter(this.btnTreatTabAsChar.getSelection());
        this.params.setAddLineSeparatorCharacter(this.btnTreatLineBreakAsChar.getSelection());
        this.params.setTranslateWordHeadersFooters(this.btnTranslateHeadersAndFooters.getSelection());
        this.params.setTranslateWordHidden(this.btnTranslateHiddenText.getSelection());
        this.params.setTranslateWordExcludeGraphicMetaData(this.btnExcludeGraphicMetadata.getSelection());
        this.params.setTranslatePowerpointHidden(this.btnTranslateHiddenCells.getSelection());
        this.params.setAutomaticallyAcceptRevisions(this.btnAutomaticallyAcceptRevisions.getSelection());
        this.params.setIgnoreSoftHyphenTag(this.btnIgnoreSoftHyphen.getSelection());
        this.params.setReplaceNoBreakHyphenTag(this.btnReplaceNonBreakingHyphen.getSelection());
        this.params.setTranslatePowerpointNotes(this.btnTranslateNotes.getSelection());
        this.params.setTranslatePowerpointMasters(this.btnTranslateMasters.getSelection());
        this.params.setIgnorePlaceholdersInPowerpointMasters(this.btnIgnorePlaceholdersInMasters.getSelection());
        this.params.setTranslateExcelSheetNames(this.btnTranslateSheetNames.getSelection());
        this.params.setTranslateExcelDiagramData(this.btnTranslateDiagramData.getSelection());
        this.params.setTranslateExcelDrawings(this.btnTranslateDrawings.getSelection());
        this.params.setExtractExternalHyperlinks(this.btnExtractExternalHyperlinks.getSelection());
        String[] sArray = this.listExcludedWordStyles.getSelection();
        if (this.params.tsExcludeWordStyles == null) {
            this.params.tsExcludeWordStyles = new TreeSet();
        } else {
            this.params.tsExcludeWordStyles.clear();
        }
        int len = sArray.length;
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                this.params.tsExcludeWordStyles.add(sArray[i]);
            }
        }
        sArray = this.listTranslatableFields.getSelection();
        if (this.params.tsComplexFieldDefinitionsToExtract == null) {
            this.params.tsComplexFieldDefinitionsToExtract = new TreeSet();
        } else {
            this.params.tsComplexFieldDefinitionsToExtract.clear();
        }
        len = sArray.length;
        if (len > 0) {
            for (i = 0; i < len; ++i) {
                this.params.tsComplexFieldDefinitionsToExtract.add(sArray[i]);
            }
        }
        sArray = this.listExcelColorsToExclude.getSelection();
        if (this.params.tsExcelExcludedColors == null) {
            this.params.tsExcelExcludedColors = new TreeSet();
        } else {
            this.params.tsExcelExcludedColors.clear();
        }
        len = sArray.length;
        if (len > 0) {
            this.params.setTranslateExcelExcludeColors(true);
            for (i = 0; i < len; ++i) {
                String[] sColor = sArray[i];
                String sRGB = null;
                switch (sColor) {
                    case "blue": {
                        sRGB = "FF0000FF";
                        break;
                    }
                    case "light blue": {
                        sRGB = "FF3366FF";
                        break;
                    }
                    case "green": {
                        sRGB = "FF008000";
                        break;
                    }
                    case "purple": {
                        sRGB = "FF660066";
                        break;
                    }
                    case "red": {
                        sRGB = "FFFF0000";
                        break;
                    }
                    case "yellow": {
                        sRGB = "FFFFFF00";
                        break;
                    }
                    case "dark red": {
                        sRGB = "FF800000";
                        break;
                    }
                    case "light green": {
                        sRGB = "FFCCFFCC";
                        break;
                    }
                    case "orange": {
                        sRGB = "FFFF6600";
                        break;
                    }
                    case "dark blue": {
                        sRGB = "FF000090";
                    }
                }
                if (sRGB == null) continue;
                this.params.tsExcelExcludedColors.add(sRGB);
            }
        } else {
            this.params.setTranslateExcelExcludeColors(false);
        }
        this.params.setTranslateExcelHidden(this.btnTranslateHiddenCells.getSelection());
        this.params.setTranslateExcelExcludeColumns(this.btnExcludeExcelColumns.getSelection());
        if (this.params.tsExcelExcludedColumns == null) {
            this.params.tsExcelExcludedColumns = new TreeSet();
        } else {
            this.params.tsExcelExcludedColumns.clear();
        }
        this.params.setTranslateExcelExcludeColumns(this.btnExcludeExcelColumns.getSelection());
        if (this.params.getTranslateExcelExcludeColumns()) {
            sArray = this.listExcelSheet1ColumnsToExclude.getSelection();
            len = sArray.length;
            if (len > 0) {
                for (i = 0; i < len; ++i) {
                    this.params.tsExcelExcludedColumns.add("1" + sArray[i]);
                }
            }
            if ((len = (sArray = this.listExcelSheet2ColumnsToExclude.getSelection()).length) > 0) {
                for (i = 0; i < len; ++i) {
                    this.params.tsExcelExcludedColumns.add("2" + sArray[i]);
                }
            }
            if ((len = (sArray = this.listExcelSheet3ColumnsToExclude.getSelection()).length) > 0) {
                for (i = 0; i < len; ++i) {
                    this.params.tsExcelExcludedColumns.add("3" + sArray[i]);
                }
            }
        }
        this.params.setPowerpointIncludedSlideNumbersOnly(this.btnIncludedSlideNumbersOnly.getSelection());
        if (this.params.tsPowerpointIncludedSlideNumbers == null) {
            this.params.tsPowerpointIncludedSlideNumbers = new TreeSet();
        } else {
            this.params.tsPowerpointIncludedSlideNumbers.clear();
        }
        if (this.btnIncludedSlideNumbersOnly.getSelection()) {
            ArrayList<Integer> slideNumbers = new ArrayList<Integer>();
            for (String s : this.listPowerpointIncludedSlideNumbers.getSelection()) {
                slideNumbers.add(Integer.valueOf(s));
            }
            this.params.tsPowerpointIncludedSlideNumbers.addAll(slideNumbers);
        }
        this.params.nFileType = ParseType.MSWORD;
        return true;
    }
}

