/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.ui.segmentation;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class FileProcessor {
    private Pattern patternOpening = Pattern.compile("\\<(\\w+[^\\>]*)\\>");
    private Pattern patternClosing = Pattern.compile("\\</(\\w+[^\\>]*)\\>");
    private Pattern patternPlaceholder = Pattern.compile("\\<(\\w+[^\\>]*)/\\>");
    private GenericContent sampleOutput = new GenericContent();

    public void populateTextContainer(String text, TextContainer textCont) {
        int n;
        int start = 0;
        int diff = 0;
        TextFragment tf = new TextFragment();
        block10: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    try {
                        Code code = null;
                        switch (text.charAt(i)) {
                            case '\ue101': {
                                code = new Code(TextFragment.TagType.OPENING, "");
                                break;
                            }
                            case '\ue102': {
                                code = new Code(TextFragment.TagType.CLOSING, "");
                                break;
                            }
                            case '\ue103': {
                                code = new Code(TextFragment.TagType.PLACEHOLDER, "");
                            }
                        }
                        int id = TextFragment.toIndex((char)text.charAt(++i));
                        code.setId(id);
                        tf.append(code);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    continue block10;
                }
                default: {
                    tf.append(text.charAt(i));
                }
            }
        }
        Matcher m = this.patternOpening.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.OPENING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = this.patternClosing.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.CLOSING, m.group(1));
            start = n + m.group().length();
        }
        text = tf.getCodedText();
        diff = 0;
        start = 0;
        m = this.patternPlaceholder.matcher(text);
        while (m.find(start)) {
            n = m.start();
            diff += tf.changeToCode(n + diff, n + diff + m.group().length(), TextFragment.TagType.PLACEHOLDER, null);
            start = n + m.group().length();
        }
        textCont.clear();
        textCont.setContent(tf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String inputPath, String outputPath, boolean htmlOutput, ISegmenter segmenter) throws IOException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputPath), "UTF-8"));
            Util.createDirectories((String)outputPath);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputPath)), "UTF-8"));
            if (htmlOutput) {
                writer.write("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\"/>");
                writer.write("<style>p {white-space: pre; font-family: monospace; border: 1px solid; padding: 4; margin-top: 0; margin-bottom: -1;}</style></head><body>");
            }
            StringBuilder tmp = new StringBuilder();
            char[] buf = new char[1024];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
            TextContainer textCont = new TextContainer();
            this.populateTextContainer(tmp.toString(), textCont);
            segmenter.computeSegments(textCont);
            textCont.getSegments().create(segmenter.getRanges());
            if (htmlOutput) {
                for (Segment seg : textCont.getSegments()) {
                    writer.write("<p>");
                    writer.write(Util.escapeToXML((String)this.sampleOutput.setContent(seg.text).toString(true), (int)0, (boolean)false, null));
                    writer.write("</p>");
                }
            } else {
                writer.write(this.sampleOutput.printSegmentedContent(textCont, true, true));
            }
            if (htmlOutput) {
                writer.write("</body></html>");
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }
}

