/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.LinkedHashMap;
import net.sf.okapi.common.ClassInfo;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.IParametersEditorMapper;
import net.sf.okapi.common.exceptions.OkapiEditorCreationException;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class ParametersEditorMapper
implements IParametersEditorMapper {
    protected LinkedHashMap<String, ClassInfo> editorMap = new LinkedHashMap();
    protected LinkedHashMap<String, ClassInfo> descMap = new LinkedHashMap();

    @Override
    public void addEditor(ClassInfo editorClass, String parametersClassName) {
        this.editorMap.put(parametersClassName, editorClass);
    }

    @Override
    public void addEditor(String editorClassName, String parametersClassName) {
        this.editorMap.put(parametersClassName, new ClassInfo(editorClassName));
    }

    @Override
    public void addDescriptionProvider(ClassInfo descriptionProviderClass, String parametersClassName) {
        this.descMap.put(parametersClassName, descriptionProviderClass);
    }

    @Override
    public void addDescriptionProvider(String descriptionProviderClassName, String parametersClassName) {
        this.descMap.put(parametersClassName, new ClassInfo(descriptionProviderClassName));
    }

    @Override
    public void clearEditors() {
        this.editorMap.clear();
    }

    @Override
    public void clearDescriptionProviders() {
        this.descMap.clear();
    }

    @Override
    public void removeEditor(String className) {
        String found = null;
        for (String key : this.editorMap.keySet()) {
            if (!this.editorMap.get((Object)key).name.equals(className)) continue;
            found = key;
            break;
        }
        if (found != null) {
            this.editorMap.remove(found);
        }
    }

    @Override
    public void removeDescriptionProvider(String className) {
        String found = null;
        for (String key : this.descMap.keySet()) {
            if (!this.descMap.get((Object)key).name.equals(className)) continue;
            found = key;
            break;
        }
        if (found != null) {
            this.descMap.remove(found);
        }
    }

    @Override
    public IParametersEditor createParametersEditor(String parametersClassName) {
        ClassInfo ci = this.editorMap.get(parametersClassName);
        if (ci == null) {
            return null;
        }
        IParametersEditor editor = null;
        try {
            editor = ci.loader == null ? (IParametersEditor)Class.forName(ci.name).newInstance() : (IParametersEditor)Class.forName(ci.name, true, ci.loader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiEditorCreationException(String.format("Cannot instantiate the editor '%s'", ci.name), e);
        }
        return editor;
    }

    @Override
    public IEditorDescriptionProvider getDescriptionProvider(String parametersClassName) {
        ClassInfo ci = this.descMap.get(parametersClassName);
        if (ci == null) {
            return null;
        }
        IEditorDescriptionProvider descProv = null;
        try {
            descProv = ci.loader == null ? (IEditorDescriptionProvider)Class.forName(ci.name).newInstance() : (IEditorDescriptionProvider)Class.forName(ci.name, true, ci.loader).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new OkapiEditorCreationException(String.format("Cannot instantiate the description provider '%s'", ci.name), e);
        }
        return descProv;
    }
}

