/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.DefaultFilenameFilter;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ParametersEditorMapper;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterInfo;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.plugins.PluginsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterConfigurationMapper
extends ParametersEditorMapper
implements IFilterConfigurationMapper {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String CONFIGFILE_EXT = ".fprm";
    public static final char CONFIGFILE_SEPARATOR = '@';
    private LinkedHashMap<String, FilterConfiguration> configMap = new LinkedHashMap();
    private ArrayList<FilterInfo> filters = new ArrayList();
    private String customParmsDir;
    private IFilter tmpFilter;

    public static String[] splitFilterFromConfiguration(String configId) {
        String[] res = new String[2];
        int n = configId.indexOf(64);
        if (n == -1 && (n = configId.indexOf(45)) == -1) {
            n = configId.indexOf(95);
            if (n == -1) {
                res[0] = configId;
                return res;
            }
            if (configId.substring(0, n).equals("okf") && (n = configId.indexOf(95, n + 1)) == -1) {
                res[0] = configId;
                return res;
            }
        }
        res[0] = configId.substring(0, n);
        res[1] = configId.substring(n + 1);
        return res;
    }

    public FilterConfigurationMapper() {
        String customDir;
        try {
            customDir = Util.getDirectoryName(new File(".").getAbsolutePath());
        }
        catch (SecurityException ex) {
            customDir = "/";
        }
        this.setCustomConfigurationsDirectory(customDir);
    }

    public void addFromPlugins(PluginsManager pm) {
        List<PluginItem> list = pm.getList();
        for (PluginItem item : list) {
            if (item.getType() != 1) continue;
            String paramsClassName = this.addConfigurations(item.getClassName(), pm.getClassLoader());
            if (item.getEditorDescriptionProvider() != null) {
                this.addDescriptionProvider(item.getEditorDescriptionProvider(), paramsClassName);
            }
            if (item.getParamsEditor() == null) continue;
            this.addEditor(item.getParamsEditor(), paramsClassName);
        }
    }

    @Override
    public void addConfigurations(String filterClass) {
        this.addConfigurations(filterClass, null);
    }

    @Override
    public void addConfiguration(FilterConfiguration config) {
        this.configMap.put(config.configId, config);
    }

    @Override
    public IFilter createFilter(String configId) {
        return this.createFilter(configId, null);
    }

    @Override
    public IFilter createFilter(String configId, IFilter existingFilter) {
        FilterConfiguration fc = this.configMap.get(configId);
        if (fc == null) {
            this.LOGGER.error("Cannot find filter configuration '{}'", (Object)configId);
            return null;
        }
        IFilter filter = this.instantiateFilter(fc, existingFilter);
        IParameters params = filter.getParameters();
        if (params == null) {
            if (fc.custom) {
                throw new OkapiFilterCreationException(String.format("Cannot create default parameters for '%s'.", fc.configId));
            }
            return filter;
        }
        if (fc.parametersLocation != null) {
            if (fc.custom) {
                params = this.getCustomParameters(fc, filter);
            } else if (fc.parametersLocation != null) {
                params.load(filter.getClass().getResourceAsStream(fc.parametersLocation), false);
            }
        } else if (fc.parameters != null) {
            params.fromString(fc.parameters.toString());
        } else {
            params.reset();
        }
        return filter;
    }

    @Override
    public IParameters getParameters(FilterConfiguration config) {
        return this.getParameters(config, null);
    }

    @Override
    public IParameters getParameters(FilterConfiguration config, IFilter existingFilter) {
        IFilter filter = this.instantiateFilter(config, existingFilter);
        IParameters params = filter.getParameters();
        if (params == null) {
            return null;
        }
        if (config.parametersLocation == null && config.parameters == null) {
            return params;
        }
        if (config.custom) {
            params = this.getCustomParameters(config, filter);
        } else if (config.parametersLocation != null) {
            URL url = filter.getClass().getResource(config.parametersLocation);
            params.load(url, false);
        } else if (config.parameters != null) {
            params.fromString(config.parameters.toString());
        }
        return params;
    }

    @Override
    public IParametersEditor createConfigurationEditor(String configId) {
        return this.createConfigurationEditor(configId, null);
    }

    @Override
    public IParametersEditor createConfigurationEditor(String configId, IFilter existingFilter) {
        FilterConfiguration fc = this.configMap.get(configId);
        if (fc == null) {
            return null;
        }
        IFilter filter = this.instantiateFilter(fc, existingFilter);
        IParameters params = filter.getParameters();
        if (params == null) {
            return null;
        }
        return this.createParametersEditor(params.getClass().getName());
    }

    @Override
    public FilterConfiguration getConfiguration(String configId) {
        return this.configMap.get(configId);
    }

    @Override
    public Iterator<FilterConfiguration> getAllConfigurations() {
        return this.configMap.values().iterator();
    }

    @Override
    public List<FilterConfiguration> getMimeConfigurations(String mimeType) {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration config : this.configMap.values()) {
            if (config.mimeType == null || !config.mimeType.equals(mimeType)) continue;
            list.add(config);
        }
        return list;
    }

    @Override
    public List<FilterConfiguration> getFilterConfigurations(String filterClass) {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration config : this.configMap.values()) {
            if (config.filterClass == null || !config.filterClass.equals(filterClass)) continue;
            list.add(config);
        }
        return list;
    }

    @Override
    public FilterConfiguration getDefaultConfiguration(String mimeType) {
        for (FilterConfiguration config : this.configMap.values()) {
            if (config.mimeType == null || !config.mimeType.equals(mimeType)) continue;
            return config;
        }
        return null;
    }

    @Override
    public FilterConfiguration getDefaultConfigurationFromExtension(String ext) {
        String tmp = ext.toLowerCase() + ";";
        for (FilterConfiguration config : this.configMap.values()) {
            if (config.extensions == null || !config.extensions.contains(tmp)) continue;
            return config;
        }
        return null;
    }

    @Override
    public void removeConfiguration(String configId) {
        this.configMap.remove(configId);
    }

    @Override
    public void removeConfigurations(String filterClass) {
        Iterator<Map.Entry<String, FilterConfiguration>> iter = this.configMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, FilterConfiguration> entry = iter.next();
            if (!entry.getValue().filterClass.equals(filterClass)) continue;
            iter.remove();
        }
    }

    @Override
    public IParameters getCustomParameters(FilterConfiguration config) {
        return this.getCustomParameters(config, null);
    }

    @Override
    public IParameters getCustomParameters(FilterConfiguration config, IFilter existingFilter) {
        IFilter filter = this.instantiateFilter(config, existingFilter);
        IParameters params = filter.getParameters();
        if (params == null) {
            return null;
        }
        if (config.parametersLocation != null) {
            File file = new File(this.customParmsDir + config.parametersLocation);
            params.load(Util.URItoURL(file.toURI()), false);
        } else if (config.parameters != null) {
            params.fromString(config.parameters.toString());
        }
        return params;
    }

    @Override
    public void deleteCustomParameters(FilterConfiguration config) {
        File file = new File(this.customParmsDir + config.parametersLocation);
        file.delete();
        config.parameters = null;
    }

    @Override
    public void saveCustomParameters(FilterConfiguration config, IParameters params) {
        if (config.parametersLocation != null) {
            File file = new File(this.customParmsDir + config.parametersLocation);
            params.save(file.getAbsolutePath());
        } else if (config.parameters != null) {
            File file = new File(this.customParmsDir + config.configId);
            params.save(file.getAbsolutePath());
        }
    }

    @Override
    public FilterConfiguration createCustomConfiguration(FilterConfiguration baseConfig) {
        FilterConfiguration newConfig = new FilterConfiguration();
        String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(baseConfig.configId);
        if (res == null) {
            return null;
        }
        newConfig.custom = true;
        newConfig.configId = res[1] == null ? String.format("%s%ccopy-of-default", res[0], Character.valueOf('@')) : String.format("%s%ccopy-of-%s", res[0], Character.valueOf('@'), res[1]);
        newConfig.classLoader = baseConfig.classLoader;
        newConfig.name = newConfig.configId;
        newConfig.description = "";
        newConfig.filterClass = baseConfig.filterClass;
        newConfig.mimeType = baseConfig.mimeType;
        newConfig.parametersLocation = newConfig.configId + CONFIGFILE_EXT;
        newConfig.parameters = baseConfig.parameters;
        IFilter filter = this.instantiateFilter(baseConfig, null);
        IParameters baseParams = this.getParameters(baseConfig, filter);
        if (baseParams == null) {
            return null;
        }
        IParameters newParams = filter.getParameters();
        newParams.fromString(baseParams.toString());
        newParams.setPath(null);
        return newConfig;
    }

    @Override
    public void clearConfigurations(boolean customOnly) {
        if (customOnly) {
            Iterator<Map.Entry<String, FilterConfiguration>> iter = this.configMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, FilterConfiguration> entry = iter.next();
                if (!entry.getValue().custom) continue;
                iter.remove();
            }
        } else {
            this.configMap.clear();
        }
    }

    public String getCustomConfigurationsDirectory() {
        return this.customParmsDir;
    }

    public void setCustomConfigurationsDirectory(String dir) {
        this.customParmsDir = dir;
        if (!dir.endsWith(File.separator)) {
            this.customParmsDir = this.customParmsDir + File.separator;
        }
    }

    public void addCustomConfiguration(String configId, IParameters parameters) {
        FilterConfiguration fc = new FilterConfiguration();
        fc.custom = true;
        fc.configId = configId;
        String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(fc.configId);
        if (res == null) {
            this.LOGGER.error("Cannot find filter ID in: {}. Cannot add configuration", (Object)configId);
            return;
        }
        this.tmpFilter = this.createFilter(res[0], this.tmpFilter);
        if (this.tmpFilter == null) {
            this.LOGGER.error("Cannot find filter with ID: {}. Cannot add configuration", (Object)res[0]);
            return;
        }
        fc.parametersLocation = fc.configId + CONFIGFILE_EXT;
        fc.filterClass = this.tmpFilter.getClass().getName();
        fc.mimeType = this.tmpFilter.getMimeType();
        fc.description = "Configuration " + fc.configId;
        fc.name = fc.configId;
        fc.parameters = parameters;
        this.addConfiguration(fc);
    }

    public void addCustomConfiguration(String configId) {
        this.addCustomConfiguration(configId, null);
    }

    public void updateCustomConfigurations() {
        File dir = new File(this.customParmsDir);
        String[] res = dir.list(new DefaultFilenameFilter(CONFIGFILE_EXT));
        this.clearConfigurations(true);
        if (res == null) {
            return;
        }
        for (String r : res) {
            this.addCustomConfiguration(Util.getFilename(r, false));
        }
    }

    protected IFilter instantiateFilter(FilterConfiguration config, IFilter existingFilter) {
        IFilter filter = null;
        if (existingFilter != null && config.filterClass.equals(existingFilter.getClass().getName())) {
            filter = existingFilter;
        }
        if (filter == null) {
            try {
                if (config.classLoader == null) {
                    String[] res = FilterConfigurationMapper.splitFilterFromConfiguration(config.configId);
                    config.classLoader = this.configMap.containsKey(res[0]) ? this.configMap.get((Object)res[0]).classLoader : null;
                }
                filter = config.classLoader == null ? (IFilter)Class.forName(config.filterClass).newInstance() : (IFilter)Class.forName(config.filterClass, true, config.classLoader).newInstance();
                filter.setFilterConfigurationMapper(this);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new OkapiFilterCreationException(String.format("Cannot instantiate a filter from the configuration '%s'", config.configId), e);
            }
        }
        return filter;
    }

    @Override
    public List<FilterInfo> getFiltersInfo() {
        Collections.sort(this.filters);
        return this.filters;
    }

    private String addConfigurations(String filterClass, URLClassLoader classLoader) {
        IFilter filter = null;
        try {
            filter = classLoader == null ? (IFilter)Class.forName(filterClass).newInstance() : (IFilter)Class.forName(filterClass, true, classLoader).newInstance();
            filter.setFilterConfigurationMapper(this);
        }
        catch (InstantiationException e) {
            this.LOGGER.warn(String.format("Cannot instantiate the filter '%s'. (InstantiationException)", filterClass));
            return null;
        }
        catch (IllegalAccessException e) {
            this.LOGGER.warn(String.format("Cannot instantiate the filter '%s'. (IllegalAccessException)", filterClass));
            return null;
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.debug(String.format("Cannot instantiate the filter '%s'. (ClassNotFoundException)", filterClass));
            return null;
        }
        FilterInfo info = new FilterInfo();
        info.className = filterClass;
        info.name = filter.getName();
        info.displayName = filter.getDisplayName();
        this.filters.add(info);
        List<FilterConfiguration> list = filter.getConfigurations();
        if (list == null || list.size() == 0) {
            this.LOGGER.warn(String.format("No configuration provided for '%s'", filterClass));
            return null;
        }
        for (FilterConfiguration config : list) {
            if (config.filterClass == null) {
                this.LOGGER.warn(String.format("Configuration without filter class name in '%s'", config.toString()));
                config.filterClass = filterClass;
            }
            if (config.name == null) {
                this.LOGGER.warn(String.format("Configuration without name in '%s'", config.toString()));
                config.name = config.toString();
            }
            if (config.description == null) {
                this.LOGGER.warn(String.format("Configuration without description in '%s'", config.toString()));
                config.description = config.toString();
            }
            config.classLoader = classLoader;
            this.configMap.put(config.configId, config);
        }
        IParameters params = filter.getParameters();
        if (params == null) {
            return null;
        }
        return params.getClass().getName();
    }
}

