/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.autoxliff;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.autoxliff.AutoXLIFFParameters;

@UsingParameters(value=AutoXLIFFParameters.class)
public class AutoXLIFFFilter
implements IFilter {
    private IFilter delegate = null;
    private IFilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
    private AutoXLIFFParameters params = new AutoXLIFFParameters();

    public AutoXLIFFFilter() {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff2.XLIFF2Filter");
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        XMLInputFactory fact = XMLInputFactory.newInstance();
        fact.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        fact.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
        fact.setProperty("javax.xml.stream.supportDTD", false);
        input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectBom();
        String inStreamCharset = "UTF-8";
        if (detector.isAutodetected()) {
            inStreamCharset = detector.getEncoding();
        }
        boolean isXLIFF2 = false;
        XMLEventReader xmlEventReader = null;
        try (InputStreamReader r = new InputStreamReader(input.getStream(), inStreamCharset);){
            xmlEventReader = fact.createXMLEventReader(r);
            isXLIFF2 = this.detectXLIFF2(xmlEventReader);
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        finally {
            try {
                if (xmlEventReader != null) {
                    xmlEventReader.close();
                }
            }
            catch (XMLStreamException xMLStreamException) {}
        }
        this.delegate = isXLIFF2 ? this.fcMapper.createFilter(this.params.getXLIFF20Config()) : this.fcMapper.createFilter(this.params.getXLIFF12Config());
        this.delegate.setFilterConfigurationMapper(this.fcMapper);
        this.delegate.open(input, generateSkeleton);
    }

    @Override
    public boolean hasNext() {
        if (this.delegate != null) {
            return this.delegate.hasNext();
        }
        return false;
    }

    @Override
    public Event next() {
        if (this.delegate != null) {
            Event e = this.delegate.next();
            if (e.isStartDocument()) {
                StartDocument sd = e.getStartDocument();
                sd.setFilterParameters(this.getParameters());
            }
            return e;
        }
        return null;
    }

    @Override
    public AutoXLIFFParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (AutoXLIFFParameters)params;
    }

    private boolean detectXLIFF2(XMLEventReader xmlReader) throws XMLStreamException {
        XMLEvent e = null;
        e = xmlReader.nextEvent();
        while (e != null && !e.isStartElement()) {
            e = xmlReader.nextEvent();
        }
        if (e == null) {
            return false;
        }
        StartElement start = e.asStartElement();
        QName qname = start.getName();
        if (!"urn:oasis:names:tc:xliff:document:2.0".equals(qname.getNamespaceURI()) || !"xliff".equals(qname.getLocalPart())) {
            return false;
        }
        Attribute version = start.getAttributeByName(new QName("version"));
        if (version == null) {
            return false;
        }
        try {
            double v = Double.parseDouble(version.getValue());
            return v >= 2.0 && v < 3.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getName() {
        return "okf_autoxliff";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF 1.2 and 2.0 Filter";
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void cancel() {
        if (this.delegate != null) {
            this.delegate.cancel();
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        if (this.delegate != null) {
            this.delegate.setFilterConfigurationMapper(fcMapper);
        }
        this.fcMapper = fcMapper;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        if (this.delegate != null) {
            return this.delegate.createSkeletonWriter();
        }
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        if (this.delegate != null) {
            IFilterWriter delegateWriter = this.delegate.createFilterWriter();
            return new ProxyFilterWriter(delegateWriter, this.delegate.getParameters());
        }
        return null;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.delegate != null) {
            return this.delegate.getEncoderManager();
        }
        return null;
    }

    @Override
    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        return Collections.singletonList(new FilterConfiguration(this.getName(), "application/xliff+xml", this.getClass().getName(), this.getDisplayName(), "Calls the appropriate filter for any version of XLIFF", null, ".xlf;.xliff"));
    }

    static class ProxyFilterWriter
    implements IFilterWriter {
        private final IFilterWriter delegate;
        private final IParameters params;

        ProxyFilterWriter(IFilterWriter delegate, IParameters params) {
            this.delegate = delegate;
            this.params = params;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public void setOptions(LocaleId locale, String defaultEncoding) {
            this.delegate.setOptions(locale, defaultEncoding);
        }

        @Override
        public void setOutput(String path) {
            this.delegate.setOutput(path);
        }

        @Override
        public void setOutput(OutputStream output) {
            this.delegate.setOutput(output);
        }

        @Override
        public Event handleEvent(Event event) {
            if (event.isStartDocument()) {
                event.getStartDocument().setFilterParameters(this.params);
            }
            return this.delegate.handleEvent(event);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public IParameters getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public void setParameters(IParameters params) {
            this.delegate.setParameters(params);
        }

        @Override
        public void cancel() {
            this.delegate.cancel();
        }

        @Override
        public EncoderManager getEncoderManager() {
            return this.delegate.getEncoderManager();
        }

        @Override
        public ISkeletonWriter getSkeletonWriter() {
            return this.delegate.getSkeletonWriter();
        }
    }
}

