/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.html;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EmptyStackException;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.EndTagType;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.abstractmarkup.AbstractMarkupFilter;
import net.sf.okapi.filters.abstractmarkup.ExtractionRuleState;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;
import net.sf.okapi.filters.html.HtmlSkeletonWriter;
import net.sf.okapi.filters.html.Parameters;
import net.sf.okapi.filters.html.StreamedSourceCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class HtmlFilter
extends AbstractMarkupFilter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Parameters parameters;
    private RawDocument tempSourceInput;
    private File tempSourceFile;

    public HtmlFilter() {
        this.setMimeType("text/html");
        this.setFilterWriter(this.createFilterWriter());
        this.setParameters(new Parameters());
        this.setName("okf_html");
        this.setDisplayName("HTML/XHTML Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), "text/html", this.getClass().getName(), "HTML", "HTML or XHTML documents", "nonwellformedConfiguration.yml", ".html;.htm;"));
        this.addConfiguration(new FilterConfiguration(this.getName() + "-wellFormed", "text/xhtml", this.getClass().getName(), "HTML (Well-Formed)", "XHTML and well-formed HTML documents", "wellformedConfiguration.yml"));
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new HtmlSkeletonWriter();
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        String encoding = this.detectEncoding(input);
        this.setCurrentDocName(input.getInputURI() == null ? "" : input.getInputURI().getPath());
        try {
            this.tempSourceInput = StreamedSourceCopy.htmlTidiedRewrite(input, this.isDocumentEncoding(), encoding, this.isBOM());
            this.tempSourceFile = new File(this.tempSourceInput.getInputURI());
        }
        catch (IOException e) {
            throw new OkapiIOException("Error generating tidied source temp file", e);
        }
        super.open(this.tempSourceInput, generateSkeleton);
    }

    @Override
    public void close() {
        super.close();
        if (this.tempSourceFile != null) {
            this.tempSourceFile.delete();
        }
    }

    @Override
    protected void startFilter() {
        super.startFilter();
        if (!this.getConfig().isGlobalPreserveWhitespace()) {
            this.LOGGER.debug("By default the HTML filter will collapse whitespace unless overridden in the configuration");
        }
        this.getEventBuilder().initializeCodeFinder(this.getConfig().isUseCodeFinder(), this.getConfig().getCodeFinderRules());
    }

    @Override
    protected void endFilter() {
        super.endFilter();
        if (this.tempSourceInput != null) {
            this.tempSourceInput.close();
            boolean success = new File(this.tempSourceInput.getInputURI()).delete();
            if (!success) {
                this.LOGGER.warn("Couldn't delete HTML Filter tidied temp file");
            }
        }
    }

    @Override
    protected void preProcess(Segment segment) {
        super.preProcess(segment);
        if (this.getConfig().isWellformed()) {
            return;
        }
        if (segment instanceof Tag) {
            Tag tag = (Tag)segment;
            boolean inlineTag = false;
            TaggedFilterConfiguration.RULE_TYPE elementRuleTypeCandidate = this.getConfig().getElementRuleTypeCandidate(tag.getName());
            if (elementRuleTypeCandidate == TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT || elementRuleTypeCandidate == TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT || this.getEventBuilder().isInsideTextRun() && (tag.getTagType() == StartTagType.COMMENT || tag.getTagType() == StartTagType.XML_PROCESSING_INSTRUCTION) || this.getConfig().isInlineCdata() && tag.getName().equals("![cdata[")) {
                inlineTag = true;
            }
            if (this.getEventBuilder().isCurrentTextUnit() && !inlineTag) {
                this.getEventBuilder().endTextUnit();
            }
        }
    }

    @Override
    protected TaggedFilterConfiguration.RULE_TYPE updateEndTagRuleState(EndTag endTag) {
        TaggedFilterConfiguration.RULE_TYPE ruleType = this.getConfig().getElementRuleTypeCandidate(endTag.getName());
        ExtractionRuleState.RuleType currentState = null;
        switch (ruleType) {
            case INLINE_EXCLUDED_ELEMENT: 
            case INLINE_ELEMENT: {
                try {
                    currentState = this.getRuleState().peekInlineRule();
                    if (currentState.ruleName.equalsIgnoreCase(endTag.getName())) {
                        currentState = this.getRuleState().popInlineRule();
                        ruleType = currentState.ruleType;
                        break;
                    }
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT;
                }
                catch (EmptyStackException e) {
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.INLINE_ELEMENT;
                }
                break;
            }
            case ATTRIBUTES_ONLY: {
                break;
            }
            case GROUP_ELEMENT: {
                try {
                    currentState = this.getRuleState().popGroupRule();
                    ruleType = currentState.ruleType;
                }
                catch (EmptyStackException e) {
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND;
                }
                break;
            }
            case EXCLUDED_ELEMENT: {
                try {
                    currentState = this.getRuleState().popExcludedIncludedRule();
                    ruleType = currentState.ruleType;
                }
                catch (EmptyStackException e) {
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND;
                }
                break;
            }
            case INCLUDED_ELEMENT: {
                try {
                    currentState = this.getRuleState().popExcludedIncludedRule();
                    ruleType = currentState.ruleType;
                }
                catch (EmptyStackException e) {
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND;
                }
                break;
            }
            case TEXT_UNIT_ELEMENT: {
                try {
                    currentState = this.getRuleState().popTextUnitRule();
                    ruleType = currentState.ruleType;
                }
                catch (EmptyStackException e) {
                    ruleType = TaggedFilterConfiguration.RULE_TYPE.RULE_NOT_FOUND;
                }
                break;
            }
        }
        if (currentState != null && !currentState.ruleName.equalsIgnoreCase(endTag.getName())) {
            String character = Integer.toString(endTag.getBegin());
            this.LOGGER.debug("End tag {} and start tag {} do not match at character number {}", endTag.getName(), currentState.ruleName, character);
        }
        return ruleType;
    }

    @Override
    protected PropertyTextUnitPlaceholder createPropertyTextUnitPlaceholder(PropertyTextUnitPlaceholder.PlaceholderAccessType type, String name, String value, Tag tag, Attribute attribute) {
        String normalizeAttributeName = this.normalizeAttributeName(name, value, tag);
        if (this.isMetaCharset(name, value, tag) && value.toLowerCase().contains("charset=")) {
            int mainStartPos = attribute.getBegin() - tag.getBegin();
            int mainEndPos = attribute.getEnd() - tag.getBegin();
            int charsetValueOffset = value.toLowerCase().lastIndexOf("charset=") + "charset=".length();
            int valueStartPos = attribute.getValueSegment().getBegin() + charsetValueOffset - tag.getBegin();
            int valueEndPos = attribute.getValueSegment().getEnd() - tag.getBegin();
            String v = tag.toString().substring(valueStartPos, valueEndPos);
            return new PropertyTextUnitPlaceholder(type, normalizeAttributeName, v, mainStartPos, mainEndPos, valueStartPos, valueEndPos);
        }
        return super.createPropertyTextUnitPlaceholder(type, name, this.getEventBuilder().normalizeHtmlText(value, true, this.isPreserveWhitespace()), tag, attribute);
    }

    @Override
    protected String normalizeAttributeName(String attrName, String attrValue, Tag tag) {
        StartTag st;
        String normalizedName = attrName;
        if (this.isMetaCharset(attrName, attrValue, tag)) {
            normalizedName = "encoding";
            return normalizedName;
        }
        if (tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("charset")) {
            normalizedName = "encoding";
            return normalizedName;
        }
        if (tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("content") && (st = (StartTag)tag).getAttributeValue("http-equiv") != null && st.getAttributeValue("http-equiv").equalsIgnoreCase("Content-Language")) {
            normalizedName = "language";
            return normalizedName;
        }
        if (attrName.equalsIgnoreCase("lang") || attrName.equalsIgnoreCase("xml:lang")) {
            normalizedName = "language";
            return normalizedName;
        }
        return normalizedName;
    }

    private boolean isMetaCharset(String attrName, String attrValue, Tag tag) {
        StartTag st;
        return tag.getName().equalsIgnoreCase("meta") && attrName.equalsIgnoreCase("content") && (st = (StartTag)tag).getAttributeValue("http-equiv") != null && st.getAttributeValue("content") != null && st.getAttributeValue("http-equiv").equalsIgnoreCase("Content-Type") && st.getAttributeValue("content").toLowerCase().contains("charset=");
    }

    @Override
    protected TaggedFilterConfiguration getConfig() {
        return this.parameters.getTaggedConfig();
    }

    @Override
    public void setParameters(IParameters params) {
        this.parameters = (Parameters)params;
    }

    @Override
    public IParameters getParameters() {
        return this.parameters;
    }

    public void setParametersFromURL(URL config) {
        this.parameters = new Parameters(config);
    }

    public void setParametersFromFile(File config) {
        this.parameters = new Parameters(config);
    }

    public void setParametersFromString(String config) {
        this.parameters = new Parameters(config);
    }

    @Override
    protected TextFragment.TagType determineTagType(Tag tag) {
        StartTag startTag;
        TextFragment.TagType codeType = tag.getTagType() == StartTagType.NORMAL || tag.getTagType() == StartTagType.UNREGISTERED ? ((startTag = (StartTag)tag).isSyntacticalEmptyElementTag() ? TextFragment.TagType.PLACEHOLDER : (startTag.isEndTagRequired() ? (this.getRuleState().isInlineExcludedState() ? TextFragment.TagType.PLACEHOLDER : TextFragment.TagType.OPENING) : (this.getConfig().isWellformed() ? TextFragment.TagType.OPENING : TextFragment.TagType.PLACEHOLDER))) : (tag.getTagType() == EndTagType.NORMAL || tag.getTagType() == EndTagType.UNREGISTERED ? TextFragment.TagType.CLOSING : TextFragment.TagType.PLACEHOLDER);
        return codeType;
    }
}

