/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.filters.openxml.ClarifiablePartHandler;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.EmptyStyleDefinitions;
import net.sf.okapi.filters.openxml.ExcelCommentPartHandler;
import net.sf.okapi.filters.openxml.ExcelFormulaPartHandler;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ExcelWorkbook;
import net.sf.okapi.filters.openxml.ExcelWorksheetPartHandler;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringsPartHandler;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyledTextPartHandler;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class ExcelDocument
extends DocumentType {
    private static final String COMMENTS_REL = Namespaces.DocumentRelationships.getDerivedURI("/comments");
    private static final String DRAWINGS_REL = Namespaces.DocumentRelationships.getDerivedURI("/drawing");
    private static final String CHART_REL = Namespaces.DocumentRelationships.getDerivedURI("/chart");
    private static final String DIAGRAM_DATA_REL = Namespaces.DocumentRelationships.getDerivedURI("/diagramData");
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<String, String> sharedStrings;
    private SharedStringMap sharedStringMap = new SharedStringMap();
    private List<String> worksheetEntryNames = null;
    private ExcelStyles styles;
    private Relationships workbookRels;
    private Map<String, ExcelWorkbook.Sheet> worksheets = new HashMap<String, ExcelWorkbook.Sheet>();
    private Map<String, Boolean> tableVisibility = new HashMap<String, Boolean>();
    private static final String SHARED_STRING_TABLE_REL = Namespaces.DocumentRelationships.getDerivedURI("/sharedStrings");
    private static final String STYLES_REL = Namespaces.DocumentRelationships.getDerivedURI("/styles");
    private Map<String, String> sheetsByComment = new HashMap<String, String>();
    private Map<String, String> sheetsByDrawing = new HashMap<String, String>();
    private Map<String, String> drawingsByChart = new HashMap<String, String>();
    private Map<String, String> drawingsByDiagramData = new HashMap<String, String>();

    ExcelDocument(OpenXMLZipFile zipFile, ConditionalParameters params, EncoderManager encoderManager, IFilter subfilter, Map<String, String> sharedStrings) {
        super(zipFile, params);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.sharedStrings = sharedStrings;
    }

    @Override
    boolean isClarifiablePart(String contentType) {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml".equals(contentType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(contentType);
    }

    @Override
    boolean isStyledTextPart(String entryName, String type) {
        switch (type) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": 
            case "application/vnd.openxmlformats-officedocument.drawing+xml": 
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return true;
            }
        }
        return false;
    }

    @Override
    void initialize() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentTarget();
        this.workbookRels = this.getZipFile().getRelationshipsForTarget(mainDocumentPart);
        this.worksheetEntryNames = this.findWorksheets();
        this.styles = this.parseStyles();
        this.sheetsByComment = this.findComments(this.worksheetEntryNames);
        this.sheetsByDrawing = this.findDrawings(this.worksheetEntryNames);
        this.drawingsByChart = this.findCharts(this.sheetsByDrawing.keySet());
        this.drawingsByDiagramData = this.findDiagramData(this.sheetsByDrawing.keySet());
    }

    @Override
    OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType) {
        if (this.isPartHidden(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        if (!this.isTranslatablePart(entry.getName(), contentType)) {
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
                return new ExcelWorksheetPartHandler(this.getZipFile(), entry, this.sharedStringMap, this.styles, this.tableVisibility, this.findWorksheetNumber(entry.getName()), this.getParams(), this.isSheetHidden(entry.getName()));
            }
            if (this.isClarifiablePart(contentType)) {
                return new ClarifiablePartHandler(this.getZipFile(), entry);
            }
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": {
                return new SharedStringsPartHandler(this.getParams(), this.getZipFile(), entry, new EmptyStyleDefinitions(), this.encoderManager, this.subfilter, this.sharedStringMap);
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return new ExcelCommentPartHandler(this.getParams(), this.getZipFile(), entry, (StyleDefinitions)new EmptyStyleDefinitions());
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return new StyledTextPartHandler(this.getParams(), this.getZipFile(), entry, (StyleDefinitions)new EmptyStyleDefinitions());
            }
        }
        ParseType parseType = null;
        switch (contentType) {
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                parseType = ParseType.MSWORDDOCPROPERTIES;
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
                parseType = ParseType.MSEXCEL;
            }
        }
        if (ParseType.MSWORDDOCPROPERTIES.equals((Object)parseType) || ParseType.MSEXCEL.equals((Object)parseType)) {
            OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getParams(), entry.getName());
            openXMLContentFilter.setUpConfig(parseType);
            return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry);
        }
        return new ExcelFormulaPartHandler(this.getParams(), this.getZipFile(), entry, this.sharedStrings);
    }

    private boolean isSheetHidden(String entryName) {
        ExcelWorkbook.Sheet sheet = this.worksheets.get(entryName);
        return sheet != null && !sheet.visible;
    }

    private boolean isTranslatablePart(String entryName, String contentType) {
        if ("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml".equals(contentType)) {
            Boolean b = this.tableVisibility.get(entryName);
            return b != null ? b : false;
        }
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": 
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return true;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
            case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": {
                return this.getParams().getTranslateExcelSheetNames();
            }
            case "application/vnd.openxmlformats-package.core-properties+xml": {
                return this.getParams().getTranslateDocProperties();
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.getParams().getTranslateComments();
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.getParams().getTranslateExcelDrawings();
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.getParams().getTranslateExcelDiagramData();
            }
        }
        return false;
    }

    @Override
    Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        ArrayList<String> worksheetsAndSharedStrings = new ArrayList<String>(this.worksheetEntryNames);
        worksheetsAndSharedStrings.add(this.findSharedStrings());
        Collections.sort(entryList, new ZipEntryComparator(worksheetsAndSharedStrings));
        return Collections.enumeration(entryList);
    }

    ExcelWorkbook parseWorkbook(String partName) throws IOException, XMLStreamException {
        XMLEventReader r = this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(partName));
        return ExcelWorkbook.parseFrom(r, this.getParams());
    }

    ExcelStyles parseStyles() throws IOException, XMLStreamException {
        Relationships.Rel stylesRel = this.workbookRels.getRelByType(STYLES_REL).get(0);
        ExcelStyles styles = new ExcelStyles();
        styles.parse(this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(stylesRel.target)));
        return styles;
    }

    List<String> findWorksheets() throws IOException, XMLStreamException {
        ArrayList<String> worksheetNames = new ArrayList<String>();
        ExcelWorkbook workbook = this.parseWorkbook(this.getZipFile().getMainDocumentTarget());
        List<ExcelWorkbook.Sheet> sheets = workbook.getSheets();
        for (ExcelWorkbook.Sheet sheet : sheets) {
            Relationships.Rel sheetRel = this.workbookRels.getRelById(sheet.relId);
            worksheetNames.add(sheetRel.target);
            this.worksheets.put(sheetRel.target, sheet);
        }
        return worksheetNames;
    }

    String findSharedStrings() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentTarget();
        Relationships rels = this.getZipFile().getRelationshipsForTarget(mainDocumentPart);
        List<Relationships.Rel> r = rels.getRelByType(SHARED_STRING_TABLE_REL);
        if (r == null || r.size() != 1) {
            throw new OkapiBadFilterInputException("Unexpected number of relationships");
        }
        return r.get((int)0).target;
    }

    private int findWorksheetNumber(String worksheetEntryName) {
        for (int i = 0; i < this.worksheetEntryNames.size(); ++i) {
            if (!worksheetEntryName.equals(this.worksheetEntryNames.get(i))) continue;
            return i + 1;
        }
        throw new IllegalStateException("No worksheet entry with name " + worksheetEntryName + " in " + this.worksheetEntryNames);
    }

    private boolean isPartHidden(String entryName, String contentType) {
        switch (contentType) {
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
                return this.isCommentHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawing+xml": {
                return this.isDrawingHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
                return this.isChartHidden(entryName);
            }
            case "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": {
                return this.isDiagramDataHidden(entryName);
            }
        }
        return false;
    }

    private boolean isCommentHidden(String entryName) {
        if (!this.sheetsByComment.containsKey(entryName)) {
            return false;
        }
        String sheetEntryName = this.sheetsByComment.get(entryName);
        return this.isSheetHidden(sheetEntryName);
    }

    private boolean isDrawingHidden(String entryName) {
        if (!this.sheetsByDrawing.containsKey(entryName)) {
            return false;
        }
        String sheetEntryName = this.sheetsByDrawing.get(entryName);
        return this.isSheetHidden(sheetEntryName);
    }

    private boolean isChartHidden(String entryName) {
        if (!this.drawingsByChart.containsKey(entryName)) {
            return false;
        }
        String drawingEntryName = this.drawingsByChart.get(entryName);
        return this.isDrawingHidden(drawingEntryName);
    }

    private boolean isDiagramDataHidden(String entryName) {
        if (!this.drawingsByDiagramData.containsKey(entryName)) {
            return false;
        }
        String drawingEntryName = this.drawingsByDiagramData.get(entryName);
        return this.isDrawingHidden(drawingEntryName);
    }

    private Map<String, String> findComments(List<String> sheetEntryNames) throws IOException, XMLStreamException {
        return this.initializeRelsByEntry(sheetEntryNames, COMMENTS_REL);
    }

    private Map<String, String> findDrawings(List<String> sheetEntryNames) throws IOException, XMLStreamException {
        return this.initializeRelsByEntry(sheetEntryNames, DRAWINGS_REL);
    }

    private Map<String, String> findCharts(Set<String> drawingEntryNames) throws IOException, XMLStreamException {
        return this.initializeRelsByEntry(new ArrayList<String>(drawingEntryNames), CHART_REL);
    }

    private Map<String, String> findDiagramData(Set<String> drawingEntryNames) throws IOException, XMLStreamException {
        return this.initializeRelsByEntry(new ArrayList<String>(drawingEntryNames), DIAGRAM_DATA_REL);
    }

    private Map<String, String> initializeRelsByEntry(List<String> entryNames, String relType) throws IOException, XMLStreamException {
        HashMap<String, String> result = new HashMap<String, String>();
        OpenXMLZipFile zipFile = this.getZipFile();
        for (String entryName : entryNames) {
            List<Relationships.Rel> rels = zipFile.getRelationshipsForTarget(entryName).getRelByType(relType);
            if (rels == null || rels.isEmpty()) continue;
            for (Relationships.Rel rel : rels) {
                result.put(rel.target, entryName);
            }
        }
        return result;
    }
}

