/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Nameable;
import net.sf.okapi.filters.openxml.XMLEventSerializer;
import net.sf.okapi.filters.openxml.XMLEvents;

abstract class MarkupComponent
implements XMLEvents {
    MarkupComponent() {
    }

    static boolean isSheetViewMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof StartMarkupComponent && "sheetView".equals(((StartMarkupComponent)markupComponent).getName().getLocalPart());
    }

    static boolean isAlignmentEmptyElementMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof EmptyElementMarkupComponent && "alignment".equals(((EmptyElementMarkupComponent)markupComponent).getName().getLocalPart());
    }

    static boolean isPresentationStartMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof StartMarkupComponent && "presentation".equals(((StartMarkupComponent)markupComponent).getName().getLocalPart());
    }

    static boolean isTableStartMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof StartMarkupComponent && "tbl".equals(((StartMarkupComponent)markupComponent).getName().getLocalPart());
    }

    static boolean isTextBodyStartMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof StartMarkupComponent && "txBody".equals(((StartMarkupComponent)markupComponent).getName().getLocalPart());
    }

    static boolean isParagraphStartMarkupComponent(MarkupComponent markupComponent) {
        return markupComponent instanceof StartMarkupComponent && "p".equals(((StartMarkupComponent)markupComponent).getName().getLocalPart());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
    }

    static class GeneralMarkupComponent
    extends MarkupComponent {
        private List<XMLEvent> events;

        GeneralMarkupComponent(List<XMLEvent> events) {
            this.events = events;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return this.events;
        }
    }

    static class EmptyElementMarkupComponent
    extends MarkupComponent
    implements Nameable {
        private static final int EMPTY_ELEMENT_EVENTS_SIZE = 2;
        private XMLEventFactory eventFactory;
        private StartElement startElement;
        private EndElement endElement;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        EmptyElementMarkupComponent(XMLEventFactory eventFactory, StartElement startElement, EndElement endElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            this.endElement = endElement;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
            events.add(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
            events.add(this.endElement);
            return events;
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }
    }

    static class EndMarkupComponent
    extends MarkupComponent {
        private EndElement endElement;

        EndMarkupComponent(EndElement endElement) {
            this.endElement = endElement;
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.endElement);
        }
    }

    static class StartMarkupComponent
    extends MarkupComponent
    implements Nameable {
        private XMLEventFactory eventFactory;
        private StartElement startElement;
        private List<Attribute> attributes = new ArrayList<Attribute>();

        StartMarkupComponent(XMLEventFactory eventFactory, StartElement startElement) {
            this.eventFactory = eventFactory;
            this.startElement = startElement;
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                this.attributes.add(iterator.next());
            }
        }

        @Override
        public List<XMLEvent> getEvents() {
            return Collections.singletonList(this.eventFactory.createStartElement(this.startElement.getName(), this.getAttributes().iterator(), this.startElement.getNamespaces()));
        }

        @Override
        public QName getName() {
            return this.startElement.getName();
        }

        List<Attribute> getAttributes() {
            return this.attributes;
        }
    }
}

