/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.openxml.AttributeStripper;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.BlockParser;
import net.sf.okapi.filters.openxml.BlockSkippableElements;
import net.sf.okapi.filters.openxml.Chunk;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.Parser;
import net.sf.okapi.filters.openxml.Run;
import net.sf.okapi.filters.openxml.RunBuilder;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleExclusionChecker;
import net.sf.okapi.filters.openxml.TranslatableAttributeText;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RunParser
implements Parser<RunBuilder> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final StartElementContext startElementContext;
    private final IdGenerator nestedTextualIds;
    private final Deque<ComplexCodeProcessingState> nestedComplexCodeProcessingStates;
    private final RunBuilder runBuilder;
    private final ElementSkipper elementSkipper;
    private final RunSkippableElements runSkippableElements;
    private final BlockSkippableElements blockSkippableElements;

    RunParser(StartElementContext startElementContext, IdGenerator nestedTextualIds, StyleDefinitions styleDefinitions, boolean hidden) {
        this.startElementContext = StartElementContextFactory.createStartElementContext(AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(startElementContext), startElementContext);
        this.nestedTextualIds = nestedTextualIds;
        this.nestedComplexCodeProcessingStates = new LinkedList<ComplexCodeProcessingState>();
        this.runBuilder = new RunBuilder(this.startElementContext, styleDefinitions);
        this.runBuilder.setHidden(hidden);
        this.elementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), new ElementSkipper.SkippableElement[0]);
        this.runSkippableElements = new RunSkippableElements(startElementContext);
        this.blockSkippableElements = new BlockSkippableElements(startElementContext);
    }

    @Override
    public RunBuilder parse() throws XMLStreamException {
        this.log("startRun: " + this.startElementContext.getStartElement());
        XMLEvent firstChild = this.startElementContext.getEventReader().nextTag();
        if (XMLEventHelpers.isRunPropsStartEvent(firstChild)) {
            this.parseRunProperties(firstChild.asStartElement());
        } else {
            if (XMLEventHelpers.isEndElement(firstChild, this.startElementContext.getStartElement())) {
                return this.endRunParsing(firstChild.asEndElement());
            }
            this.startRunParsing(firstChild);
        }
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = this.startElementContext.getEventReader().nextEvent();
            this.log("processRun: " + e);
            if (XMLEventHelpers.isEndElement(e, this.startElementContext.getStartElement())) {
                return this.endRunParsing(e.asEndElement());
            }
            this.startRunParsing(e);
        }
        throw new IllegalStateException("Invalid content? Unterminated run");
    }

    private RunBuilder endRunParsing(EndElement e) {
        this.runBuilder.flushText();
        this.runBuilder.flushMarkupChunk();
        this.runBuilder.setEndEvent(e);
        if (!this.runBuilder.hasNonWhitespaceText() && this.startElementContext.getConditionalParameters().getCleanupAggressively()) {
            this.runBuilder.setRunProperties(RunProperties.copiedRunProperties(this.runBuilder.getRunProperties(), true, false, false));
        }
        return this.runBuilder;
    }

    private void startRunParsing(XMLEvent e) throws XMLStreamException {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            this.parseNestedBlock(e);
        } else if (XMLEventHelpers.isComplexCodeStart(e)) {
            this.parseComplexCodes(e.asStartElement());
        } else if (!this.parseSkippableElements(e)) {
            this.parseContent(this.processTranslatableAttributes(e));
        }
    }

    private void parseRunProperties(StartElement startElement) throws XMLStreamException {
        StartElementContext runPropertiesElementContext = StartElementContextFactory.createStartElementContext(startElement, this.runBuilder.getStartElementContext());
        this.runBuilder.setRunProperties(new RunPropertiesParser(runPropertiesElementContext, this.runSkippableElements).parse());
        RunProperty.RunStyleProperty runStyleProperty = this.runBuilder.getRunProperties().getRunStyleProperty();
        if (null == runStyleProperty) {
            return;
        }
        this.runBuilder.setRunStyle(runStyleProperty.getValue());
        this.runBuilder.setHidden(StyleExclusionChecker.isStyleExcluded(runStyleProperty.getValue(), this.startElementContext.getConditionalParameters()));
    }

    private void parseNestedBlock(XMLEvent e) throws XMLStreamException {
        this.log("Nested block start event: " + e);
        this.runBuilder.flushText();
        StartElementContext blockElementContext = StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext);
        BlockParser nestedBlockParser = new BlockParser(blockElementContext, this.nestedTextualIds, this.runBuilder.getStyleDefinitions());
        Block nested = nestedBlockParser.parse();
        this.runBuilder.setContainsNestedItems(true);
        if (nested.hasVisibleRunContent()) {
            this.runBuilder.addToMarkupChunk(this.startElementContext.getEventFactory().createCharacters(TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
            this.runBuilder.getNestedTextualItems().add(nested);
        } else {
            for (XMLEvent nestedEvent : nested.getEvents()) {
                this.runBuilder.addToMarkupChunk(nestedEvent);
            }
            for (Chunk chunk : nested.getChunks()) {
                if (chunk instanceof Run) {
                    this.runBuilder.getNestedTextualItems().addAll(((Run)chunk).getNestedTextualItems());
                    continue;
                }
                if (!(chunk instanceof RunContainer)) continue;
                for (Block.BlockChunk nestedChunk : ((RunContainer)chunk).getChunks()) {
                    if (!(nestedChunk instanceof Run)) continue;
                    this.runBuilder.getNestedTextualItems().addAll(((Run)nestedChunk).getNestedTextualItems());
                }
            }
        }
    }

    private void parseComplexCodes(StartElement startElement) throws XMLStreamException {
        boolean isFieldCodeValue = false;
        this.nestedComplexCodeProcessingStates.add(new ComplexCodeProcessingState());
        this.runBuilder.setHasComplexCodes(true);
        this.runBuilder.addToMarkupChunk(startElement);
        while (this.startElementContext.getEventReader().hasNext()) {
            XMLEvent e = (XMLEvent)this.startElementContext.getEventReader().next();
            if (this.nestedComplexCodeProcessingStates.peek().isAfterSeparate().booleanValue() && this.nestedComplexCodeProcessingStates.peek().containsPersistentContent().booleanValue() && !XMLEventHelpers.isComplexCodeEnd(e) && !XMLEventHelpers.isComplexCodeStart(e)) {
                if (this.parseSkippableElements(e)) continue;
                this.parseContent(this.processTranslatableAttributes(this.stripRevisionAttributes(e)));
                continue;
            }
            if (this.parseSkippableElements(e)) continue;
            this.runBuilder.addToMarkupChunk(this.stripRevisionAttributes(e));
            if (XMLEventHelpers.isComplexCodeStart(e)) {
                this.nestedComplexCodeProcessingStates.add(new ComplexCodeProcessingState());
                continue;
            }
            if (XMLEventHelpers.isComplexCodeSeparate(e)) {
                this.nestedComplexCodeProcessingStates.peekLast().setAfterSeparate(true);
                continue;
            }
            if (XMLEventHelpers.isComplexCodeEnd(e)) {
                this.nestedComplexCodeProcessingStates.pollLast();
                if (this.nestedComplexCodeProcessingStates.peekLast() != null) continue;
                break;
            }
            if (this.nestedComplexCodeProcessingStates.peek().isAfterSeparate().booleanValue()) continue;
            if (XMLEventHelpers.isFieldCodeStartEvent(e)) {
                isFieldCodeValue = true;
                continue;
            }
            if (isFieldCodeValue && this.isFieldCodeWithPersistentContent(e)) {
                this.nestedComplexCodeProcessingStates.peek().setContainsPersistentContent(true);
                continue;
            }
            if (!XMLEventHelpers.isFieldCodeEndEvent(e)) continue;
            isFieldCodeValue = false;
        }
    }

    private XMLEvent stripRevisionAttributes(XMLEvent e) {
        if (XMLEventHelpers.isParagraphStartEvent(e)) {
            return AttributeStripper.RevisionAttributeStripper.stripParagraphRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
        }
        if (XMLEventHelpers.isRunStartEvent(e)) {
            return AttributeStripper.RevisionAttributeStripper.stripRunRevisionAttributes(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext));
        }
        return e;
    }

    private boolean parseSkippableElements(XMLEvent e) throws XMLStreamException {
        if (this.runSkippableElements.skip(e)) {
            return true;
        }
        return this.blockSkippableElements.skip(e);
    }

    private void parseContent(XMLEvent e) throws XMLStreamException {
        if (XMLEventHelpers.isTextStartEvent(e)) {
            this.runBuilder.flushMarkupChunk();
            this.parseText(e.asStartElement(), this.startElementContext.getEventReader());
        } else if (this.startElementContext.getConditionalParameters().getAddTabAsCharacter() && XMLEventHelpers.isTabStartEvent(e) && !this.runBuilder.isHidden()) {
            this.runBuilder.flushMarkupChunk();
            this.runBuilder.addText("\t", e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getAddLineSeparatorCharacter() && XMLEventHelpers.isLineBreakStartEvent(e) && !XMLEventHelpers.isPageBreak(e.asStartElement()) && !this.runBuilder.isHidden()) {
            this.runBuilder.flushMarkupChunk();
            char replacement = this.startElementContext.getConditionalParameters().getLineSeparatorReplacement();
            this.runBuilder.addText(String.valueOf(replacement), e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (this.startElementContext.getConditionalParameters().getReplaceNoBreakHyphenTag() && XMLEventHelpers.isNoBreakHyphenStartEvent(e)) {
            this.runBuilder.flushMarkupChunk();
            this.runBuilder.addText("-", e.asStartElement());
            this.elementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
        } else if (!XMLEventHelpers.isWhitespace(e) || this.runBuilder.preservingWhitespace()) {
            this.runBuilder.flushText();
            this.runBuilder.setTextPreservingWhitespace(false);
            this.runBuilder.addToMarkupChunk(e);
        }
    }

    private void parseText(StartElement startEvent, XMLEventReader events) throws XMLStreamException {
        this.runBuilder.setTextPreservingWhitespace(this.runBuilder.isTextPreservingWhitespace() || XMLEventHelpers.hasPreserveWhitespace(startEvent));
        while (events.hasNext()) {
            XMLEvent e = events.nextEvent();
            if (XMLEventHelpers.isEndElement(e, startEvent)) {
                return;
            }
            if (!e.isCharacters()) continue;
            String text = e.asCharacters().getData();
            if (text.trim().length() > 0) {
                this.runBuilder.setNonWhitespaceText(true);
            }
            this.runBuilder.addText(text, startEvent);
        }
    }

    private boolean isFieldCodeWithPersistentContent(XMLEvent e) {
        if (e.isCharacters()) {
            String data = e.asCharacters().getData().trim();
            int fieldCodeNameLength = data.indexOf(" ");
            String fieldCodeName = fieldCodeNameLength > 0 ? data.substring(0, fieldCodeNameLength) : data;
            return this.startElementContext.getConditionalParameters().tsComplexFieldDefinitionsToExtract.contains(fieldCodeName);
        }
        return false;
    }

    private XMLEvent processTranslatableAttributes(XMLEvent e) {
        if (!e.isStartElement()) {
            return e;
        }
        StartElement startEl = e.asStartElement();
        if (XMLEventHelpers.isGraphicsProperty(startEl) && !this.startElementContext.getConditionalParameters().getTranslateWordExcludeGraphicMetaData()) {
            startEl = this.processTranslatableAttribute(startEl, "name");
        } else if (XMLEventHelpers.isTextPath(startEl)) {
            startEl = this.processTranslatableAttribute(startEl, "string");
        }
        return startEl;
    }

    private StartElement processTranslatableAttribute(StartElement startEl, String attrName) {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> it = startEl.getAttributes();
        boolean dirty = false;
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.getName().getLocalPart().equals(attrName)) {
                this.runBuilder.setContainsNestedItems(true);
                this.runBuilder.getNestedTextualItems().add(new TranslatableAttributeText(a.getValue()));
                newAttrs.add(this.startElementContext.getEventFactory().createAttribute(a.getName(), TextFragment.makeRefMarker(this.nestedTextualIds.createId())));
                dirty = true;
                continue;
            }
            newAttrs.add(a);
        }
        return dirty ? this.startElementContext.getEventFactory().createStartElement(startEl.getName(), newAttrs.iterator(), startEl.getNamespaces()) : startEl;
    }

    private void log(String s) {
        this.LOGGER.debug(s);
    }

    private static class ComplexCodeProcessingState {
        private Boolean containsPersistentContent = false;
        private Boolean afterSeparate = false;

        private ComplexCodeProcessingState() {
        }

        Boolean containsPersistentContent() {
            return this.containsPersistentContent;
        }

        void setContainsPersistentContent(Boolean containsPersistentContent) {
            this.containsPersistentContent = containsPersistentContent;
        }

        Boolean isAfterSeparate() {
            return this.afterSeparate;
        }

        void setAfterSeparate(Boolean afterSeparate) {
            this.afterSeparate = afterSeparate;
        }
    }
}

