/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ElementSkipper;
import net.sf.okapi.filters.openxml.ElementSkipperFactory;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;

final class RunSkippableElements {
    private final StartElementContext startElementContext;
    private final ElementSkipper lastRenderedPageBreakElementSkipper;
    private final ElementSkipper softHyphenElementSkipper;
    private final ElementSkipper alternateContentFallbackElementSkipper;
    private final ElementSkipper runPropertiesSkipper;

    RunSkippableElements(StartElementContext startElementContext) {
        this.startElementContext = startElementContext;
        this.lastRenderedPageBreakElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.GeneralInlineSkippableElement.LAST_RENDERED_PAGE_BREAK);
        this.softHyphenElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.GeneralInlineSkippableElement.SOFT_HYPHEN);
        this.alternateContentFallbackElementSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.GeneralInlineSkippableElement.ALTERNATE_CONTENT_FALLBACK);
        this.runPropertiesSkipper = ElementSkipperFactory.createGeneralElementSkipper(startElementContext.getConditionalParameters(), ElementSkipper.RevisionPropertySkippableElement.RUN_PROPERTIES_CHANGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_LANGUAGE, ElementSkipper.RunPropertySkippableElement.RUN_PROPERTY_NO_SPELLING_OR_GRAMMAR);
    }

    boolean skip(XMLEvent e) throws XMLStreamException {
        if (e.isStartElement() && this.lastRenderedPageBreakElementSkipper.canSkip(e.asStartElement(), this.startElementContext.getStartElement())) {
            this.lastRenderedPageBreakElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
            return true;
        }
        if (this.startElementContext.getConditionalParameters().getIgnoreSoftHyphenTag() && e.isStartElement() && this.softHyphenElementSkipper.canSkip(e.asStartElement(), this.startElementContext.getStartElement())) {
            this.softHyphenElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
            return true;
        }
        if (e.isStartElement() && this.alternateContentFallbackElementSkipper.canSkip(e.asStartElement(), this.startElementContext.getStartElement())) {
            this.alternateContentFallbackElementSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), this.startElementContext.getEventReader(), null, this.startElementContext.getConditionalParameters()));
            return true;
        }
        return this.skipProperties(e, this.startElementContext);
    }

    boolean skipProperties(XMLEvent e, StartElementContext startElementContext) throws XMLStreamException {
        if (e.isStartElement() && this.runPropertiesSkipper.canSkip(e.asStartElement(), startElementContext.getStartElement())) {
            this.runPropertiesSkipper.skip(StartElementContextFactory.createStartElementContext(e.asStartElement(), startElementContext));
            return true;
        }
        return false;
    }
}

