/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XmlInputStreamReader;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.annotation.XLIFFNote;
import net.sf.okapi.common.annotation.XLIFFNoteAnnotation;
import net.sf.okapi.common.annotation.XLIFFPhase;
import net.sf.okapi.common.annotation.XLIFFPhaseAnnotation;
import net.sf.okapi.common.annotation.XLIFFTool;
import net.sf.okapi.common.annotation.XLIFFToolAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ITSAnnotatorsRefContext;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff.CodeTypeForPairedTagsHelper;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.SdlTagDef;
import net.sf.okapi.filters.xliff.SdlXliffConfLevel;
import net.sf.okapi.filters.xliff.SdlXliffSkeletonWriter;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.XliffSdlFilterExtension;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSDefaultDataStore;
import net.sf.okapi.filters.xliff.iws.IwsProperty;
import net.sf.okapi.filters.xliff.iws.IwsSegmentMetadataAttribute;
import net.sf.okapi.filters.xliff.iws.IwsStatusAttribute;
import net.sf.okapi.filters.xliff.iws.IwsXliffSkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class XLIFFFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_BUILDNUM = "build-num";
    public static final String PROP_EXTRADATA = "extradata";
    public static final String PROP_WASSEGMENTED = "wassegmented";
    private static final String ALTTRANSTYPE_PROPOSAL = "proposal";
    public static final String FINAL = "final";
    public static final String SIGNED_OFF = "signed-off";
    public static final String NEW = "new";
    public static final String TRANSLATED = "translated";
    public static final String EXACT_MATCH = "exact-match";
    public static final String FUZZY_MATCH = "fuzzy-match";
    public static final String ID_MATCH = "id-match";
    public static final String LEVERAGED_MT = "leveraged-mt";
    public static final String LEVERAGED_TM = "leveraged-tm";
    public static final String MT_SUGGESTION = "mt-suggestion";
    public static final String TM_SUGGESTION = "tm-suggestionn";
    public static final String LEVERAGED_INHERITED = "leveraged-inherited";
    public static final String ACCEPTED = "accepted";
    public static final String CDATA_START = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    private boolean hasNext;
    private XMLStreamReader xliffReader;
    private RawDocument input;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private IdGenerator groupId;
    private String startDocId;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private GenericSkeletonPart itsLQISource;
    private GenericSkeletonPart itsLQITarget;
    private GenericSkeletonPart itsProvSource;
    private GenericSkeletonPart itsProvTarget;
    private GenericSkeletonPart itsMtConfTarget;
    private Stack<String> inITSStandoff = new Stack();
    private StartSubDocument startSubDoc;
    private ITextUnit tu;
    private int approved;
    private Parameters params = new Parameters();
    private boolean sourceDone;
    private boolean targetDone;
    private boolean altTransDone;
    private boolean noteDone;
    private boolean segSourceDone;
    private String encoding;
    private Stack<String> parentIds;
    private List<String> groupUsedIds;
    private AltTranslationsAnnotation altTrans;
    private int altTransQuality;
    private MatchType altTransMatchType;
    private String altTransOrigin;
    private String altTransEngine;
    private boolean inAltTrans;
    private boolean processAltTrans;
    private Stack<Boolean> preserveSpaces;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private int autoMid;
    private XLIFFITSFilterExtension itsFilterHandler;
    private ITSAnnotatorsRefContext annotatorsRef;
    private int extraId;
    private StartDocument startDoc;
    private Map<String, SdlTagDef> sdlTagDefs;
    private String alttranstype;
    private InputStreamReader inStreamReader = null;
    private boolean inIwsSegmentMetadata;
    private Stack<Boolean> translateCtx;
    static final Pattern MATCH_QUALITY_PATTERN = Pattern.compile("\\s*(-?\\d+)(?:\\.\\d\\d)?%?\\s*");

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            if (this.inStreamReader != null) {
                try {
                    this.inStreamReader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot close inStreamReader. Memory leak.");
                }
            }
            if (this.xliffReader != null) {
                this.xliffReader.close();
                this.xliffReader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_xliff";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-xliff+xml", this.getClass().getName(), "XLIFF", "Configuration for XML Localisation Interchange File Format (XLIFF) documents.", null, ".xlf;.xliff;.mxliff;.mqxliff"));
        list.add(new FilterConfiguration(this.getName() + "-sdl", "application/x-xliff+xml", this.getClass().getName(), "SDLXLIFF", "Configuration for SDL XLIFF documents. Supports SDL specific metadata", "sdl.fprm", ".sdlxliff"));
        list.add(new FilterConfiguration(this.getName() + "-iws", "application/x-xliff+xml", this.getClass().getName(), "IWSXLIFF", "Configuration for IWS XLIFF documents. Supports IWS specific metadata", "iws.fprm", ".xlf"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public LocaleId getCurrentTargetLocale() {
        return this.trgLang;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.open(input, generateSkeleton, new ITSDefaultDataStore());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(RawDocument input, boolean generateSkeleton, IITSDataStore datastore) {
        try {
            this.canceled = false;
            this.input = input;
            XMLInputFactory fact = null;
            if (this.params.getUseCustomParser()) {
                Class<?> factClass = ClassUtil.getClass(this.params.getFactoryClass());
                fact = (XMLInputFactory)factClass.newInstance();
            } else {
                fact = XMLInputFactory.newInstance();
            }
            this.logger.debug("XMLInputFactory: {}", (Object)fact.getClass().getName());
            fact.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
            fact.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", Boolean.TRUE);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            String inStreamCharset = "UTF-8";
            if (detector.isAutodetected()) {
                inStreamCharset = detector.getEncoding();
            }
            XMLStreamReader sdlxliffReader = null;
            try {
                this.inStreamReader = this.createStreamReader(input, inStreamCharset);
                sdlxliffReader = null != input.getInputURI() ? fact.createXMLStreamReader(input.getInputURI().toString(), this.inStreamReader) : fact.createXMLStreamReader(this.inStreamReader);
                XliffSdlFilterExtension sdlFilterHandler = new XliffSdlFilterExtension();
                this.sdlTagDefs = sdlFilterHandler.parse(sdlxliffReader, this.params);
            }
            finally {
                try {
                    this.inStreamReader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot close inStreamReader. Memory leak.");
                }
                sdlxliffReader.close();
            }
            XMLEventReader eventReader = null;
            try {
                this.inStreamReader = this.createStreamReader(input, inStreamCharset);
                eventReader = null != input.getInputURI() ? fact.createXMLEventReader(input.getInputURI().toString(), this.inStreamReader) : fact.createXMLEventReader(this.inStreamReader);
                this.itsFilterHandler = new XLIFFITSFilterExtension(fact, datastore, input.getInputURI(), this);
                this.itsFilterHandler.parseInDocumentITSStandoff(eventReader, inStreamCharset);
            }
            finally {
                try {
                    this.inStreamReader.close();
                }
                catch (IOException e) {
                    this.logger.warn("Cannot close inStreamReader. Memory leak.");
                }
                eventReader.close();
            }
            this.inStreamReader = this.createStreamReader(input, inStreamCharset);
            this.xliffReader = null != input.getInputURI() ? fact.createXMLStreamReader(input.getInputURI().toString(), this.inStreamReader) : fact.createXMLStreamReader(this.inStreamReader);
            this.itsFilterHandler.setXLIFFReader(this.xliffReader);
            String realEnc = this.xliffReader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.annotatorsRef = new ITSAnnotatorsRefContext(this.xliffReader);
            if (input.getSourceLocale() == null || input.getTargetLocale() == null) {
                input.close();
                try {
                    this.inStreamReader.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.xliffReader.close();
                throw new OkapiIllegalFilterOperationException("Source or Target language is null.");
            }
            this.srcLang = input.getSourceLocale();
            this.trgLang = input.getTargetLocale();
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.getEncoderManager().setDefaultOptions(this.params, this.encoding, this.lineBreak);
            this.preserveSpaces = new Stack();
            this.preserveSpaces.push(this.params.isPreserveSpaceByDefault());
            this.translateCtx = new Stack();
            this.translateCtx.push(true);
            this.parentIds = new Stack();
            this.parentIds.push("p0");
            this.tuId = 0;
            this.groupId = new IdGenerator(null, "g");
            this.otherId = new IdGenerator(null, "d");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.groupUsedIds = new ArrayList<String>();
            this.startDocId = this.otherId.createId();
            this.startDoc = new StartDocument(this.startDocId);
            this.startDoc.setName(this.docName);
            this.startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            this.startDoc.setLocale(this.srcLang);
            this.startDoc.setFilterParameters(this.getParameters());
            this.startDoc.setFilterWriter(this.createFilterWriter());
            this.startDoc.setType("application/x-xliff+xml");
            this.startDoc.setMimeType("application/x-xliff+xml");
            this.startDoc.setMultilingual(true);
            this.startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, this.startDoc));
            if (!Util.isEmpty(this.getParameters().getSimplifierRules())) {
                Event cs = FilterUtil.createCodeSimplifierEvent(this.getParameters().getSimplifierRules());
                this.queue.add(cs);
            }
            this.skel = new GenericSkeleton();
            this.startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(this.startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>" + this.lineBreak);
            this.startDoc.setSkeleton(this.skel);
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().compile();
            }
        }
        catch (IllegalAccessException | InstantiationException | XMLStreamException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        XLIFFSkeletonWriter writer = this.params.isUseSdlXliffWriter() ? new SdlXliffSkeletonWriter(this.params) : (this.params.isUseIwsXliffWriter() ? new IwsXliffSkeletonWriter(this.params) : new XLIFFSkeletonWriter(this.params));
        if (this.itsFilterHandler != null && this.itsFilterHandler.getITSStandoffManager() != null) {
            writer.setITSStandoffManager(this.itsFilterHandler.getITSStandoffManager());
        }
        return writer;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    public InputStreamReader createStreamReader(RawDocument input, String charset) {
        XmlInputStreamReader inputStreamReader;
        try {
            inputStreamReader = new XmlInputStreamReader(input.getStream(), charset);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("Invalid encoding '{}', using default.", (Object)charset);
            inputStreamReader = new XmlInputStreamReader(input.getStream());
        }
        return inputStreamReader;
    }

    private boolean read() throws XMLStreamException, IOException {
        this.skel = new GenericSkeleton();
        while (this.xliffReader.hasNext()) {
            int eventType = this.xliffReader.next();
            switch (eventType) {
                case 1: {
                    String name = this.xliffReader.getLocalName();
                    if ("trans-unit".equals(name)) {
                        return this.processTransUnit();
                    }
                    if ("file".equals(name)) {
                        return this.processStartFile();
                    }
                    if ("group".equals(name)) {
                        if (!this.processStartGroup()) break;
                        return true;
                    }
                    if ("bin-unit".equals(name)) {
                        if (!this.processStartBinUnit()) break;
                        return true;
                    }
                    this.storeStartElement(false, false, false);
                    break;
                }
                case 2: {
                    this.storeEndElement();
                    if ("file".equals(this.xliffReader.getLocalName())) {
                        return this.processEndFile();
                    }
                    if ("group".equals(this.xliffReader.getLocalName())) {
                        return this.processEndGroup();
                    }
                    if (!"bin-unit".equals(this.xliffReader.getLocalName())) break;
                    return this.processEndBinUnit();
                }
                case 6: 
                case 12: {
                    if (!this.inITSStandoff.isEmpty()) break;
                    this.skel.append(CDATA_START);
                    this.skel.append(this.xliffReader.getText().replace("\n", this.lineBreak));
                    this.skel.append(CDATA_END);
                    break;
                }
                case 4: {
                    if (!this.inITSStandoff.isEmpty()) break;
                    this.skel.append(Util.escapeToXML(this.xliffReader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.xliffReader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.xliffReader.getPITarget() + " " + this.xliffReader.getPIData() + "?>");
                    break;
                }
                case 11: {
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return false;
    }

    private boolean processStartFile() {
        if (!this.skel.isEmpty(true)) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.skel = new GenericSkeleton();
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        }
        this.startSubDoc = new StartSubDocument(this.startDocId, this.otherId.createId());
        this.storeStartElementFile(this.startSubDoc);
        String tmp = this.xliffReader.getAttributeValue(null, "original");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'original'.");
        }
        this.startSubDoc.setName(tmp);
        tmp = this.xliffReader.getAttributeValue(null, "source-language");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'source-language'.");
        }
        LocaleId srcXliffLang = LocaleId.fromString(tmp);
        if (!LocaleId.EMPTY.equals(this.input.getSourceLocale()) && !srcXliffLang.equals(this.srcLang)) {
            this.logger.warn("The source language declared in <file> is '{}' not '{}'.", (Object)tmp, (Object)this.srcLang);
        }
        Property prop = this.startSubDoc.getProperty("targetLanguage");
        LocaleId trgXliffLang = LocaleId.EMPTY;
        if (prop != null) {
            trgXliffLang = LocaleId.fromString(prop.getValue());
            if (this.params.getOverrideTargetLanguage()) {
                prop.setValue(this.trgLang.toBCP47());
            } else if (!LocaleId.EMPTY.equals(this.input.getTargetLocale()) && !trgXliffLang.sameLanguageAs(this.trgLang)) {
                this.logger.warn("The target language declared in <file> is '{}' not '{}'. '{}' will be used.", prop.getValue(), this.trgLang, prop.getValue());
                this.trgLang = trgXliffLang;
            }
        }
        if ((tmp = this.xliffReader.getAttributeValue(null, "datatype")) != null) {
            switch (tmp) {
                case "x-undefined": {
                    tmp = null;
                    break;
                }
                case "html": {
                    tmp = "text/html";
                    break;
                }
                case "xml": {
                    tmp = "text/xml";
                }
            }
            this.startSubDoc.setMimeType(tmp);
        }
        if ((tmp = this.xliffReader.getAttributeValue(null, PROP_BUILDNUM)) != null) {
            this.startSubDoc.setProperty(new Property(PROP_BUILDNUM, tmp, true));
        }
        if (this.annotatorsRef.peek() != null) {
            GenericAnnotations.addAnnotations(this.startSubDoc, new GenericAnnotations(this.annotatorsRef.getAnnotation()));
        }
        try {
            Stack<String> xmlDOMPosition = new Stack<String>();
            xmlDOMPosition.push("file");
            boolean addedToolProp = false;
            XLIFFToolAnnotation toolAnn = null;
            XLIFFTool tool = null;
            boolean addedPhaseProp = false;
            XLIFFPhaseAnnotation phaseAnn = null;
            XLIFFPhase phase = null;
            ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
            ITSProvenanceAnnotations.addAnnotations(this.startSubDoc, prov);
            block21: while (this.xliffReader.hasNext()) {
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 1: {
                        String startElementName = this.xliffReader.getLocalName();
                        if ("tool".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                            tool = new XLIFFTool(this.xliffReader.getAttributeValue(null, "tool-id"), this.xliffReader.getAttributeValue(null, "tool-name"));
                            tool.setVersion(this.xliffReader.getAttributeValue(null, "tool-version"));
                            tool.setCompany(this.xliffReader.getAttributeValue(null, "tool-company"));
                            toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class) == null ? new XLIFFToolAnnotation() : this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                            toolAnn.add(tool, this.startSubDoc);
                            this.startSubDoc.setAnnotation(toolAnn);
                        } else if ("phase-group".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                        } else if ("phase".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                            phase = new XLIFFPhase(this.xliffReader.getAttributeValue(null, "phase-name"), this.xliffReader.getAttributeValue(null, "process-name"));
                            phase.setCompanyName(this.xliffReader.getAttributeValue(null, "company-name"));
                            phase.setToolId(this.xliffReader.getAttributeValue(null, "tool-id"));
                            phase.setJobId(this.xliffReader.getAttributeValue(null, "job-id"));
                            phase.setContactName(this.xliffReader.getAttributeValue(null, "contact-name"));
                            phase.setContactEmail(this.xliffReader.getAttributeValue(null, "contact-email"));
                            phase.setContactPhone(this.xliffReader.getAttributeValue(null, "contact-phone"));
                            phaseAnn = this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class) == null ? new XLIFFPhaseAnnotation() : this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class);
                            phaseAnn.add(phase, this.startSubDoc);
                            this.startSubDoc.setAnnotation(phaseAnn);
                            if (!addedPhaseProp) {
                                this.addPhasePropertyPlaceholder(this.skel, this.startSubDoc, phaseAnn);
                                addedPhaseProp = true;
                            }
                        } else if (!("sk1".equals(startElementName) || "glossary".equals(startElementName) || "reference".equals(startElementName) || "count-group".equals(startElementName) || "prop-group".equals(startElementName) || "note".equals(startElementName) || !((String)xmlDOMPosition.peek()).equals("header"))) {
                            if (!addedToolProp) {
                                this.addToolPropertyPlaceholder(this.skel, this.startSubDoc, toolAnn);
                                addedToolProp = true;
                            }
                            this.storeStartElement(false, false, false);
                        } else {
                            if ("body".equals(startElementName)) {
                                this.storeStartElement(false, false, false);
                                this.startSubDoc.setSkeleton(this.skel);
                                this.queue.add(new Event(EventType.START_SUBDOCUMENT, this.startSubDoc));
                                PipelineParameters pp = null;
                                if (LocaleId.EMPTY.equals(this.input.getSourceLocale()) || LocaleId.EMPTY.equals(this.input.getTargetLocale())) {
                                    pp = new PipelineParameters(this.startDoc, this.input, null, null);
                                }
                                if (LocaleId.EMPTY.equals(this.input.getSourceLocale())) {
                                    this.srcLang = srcXliffLang;
                                    pp.setSourceLocale(this.srcLang);
                                }
                                if (LocaleId.EMPTY.equals(this.input.getTargetLocale())) {
                                    this.trgLang = trgXliffLang;
                                    pp.setTargetLocale(this.trgLang);
                                }
                                if (pp != null) {
                                    this.queue.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
                                }
                                return true;
                            }
                            if ("trans-unit".equals(startElementName) || "group".equals(startElementName)) {
                                throw new OkapiIOException("Missing <body> element.");
                            }
                            this.storeStartElement(false, false, false);
                        }
                        xmlDOMPosition.push(startElementName);
                        continue block21;
                    }
                    case 2: {
                        String startElement;
                        String prefix;
                        StringBuilder endElementXML;
                        String endElementName = this.xliffReader.getLocalName();
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            if (!endElementName.equals("tool")) {
                                endElementXML = new StringBuilder();
                                prefix = this.xliffReader.getPrefix();
                                endElementXML.append("</").append(prefix != null && prefix.length() > 0 ? prefix + ":" : "").append(endElementName).append(">");
                                tool.addSkeletonContent(endElementXML.toString());
                            }
                        } else if (!((String)xmlDOMPosition.peek()).equals("phase-group")) {
                            if (((String)xmlDOMPosition.peek()).equals("phase")) {
                                if (!endElementName.equals("phase")) {
                                    endElementXML = new StringBuilder();
                                    prefix = this.xliffReader.getPrefix();
                                    endElementXML.append("</").append(prefix != null && prefix.length() > 0 ? prefix + ":" : "").append(endElementName).append(">");
                                    phase.addSkeletonContent(endElementXML.toString());
                                }
                            } else if (endElementName.equals("header")) {
                                if (!addedToolProp) {
                                    this.addToolPropertyPlaceholder(this.skel, this.startSubDoc, toolAnn);
                                    addedToolProp = true;
                                }
                                this.storeEndElement();
                            } else {
                                this.storeEndElement();
                            }
                        }
                        if ((startElement = (String)xmlDOMPosition.pop()).equals(endElementName)) continue block21;
                        throw new OkapiIOException("Mismatch in start and end element XML stream events: " + startElement + " != " + endElementName);
                    }
                    case 6: {
                        String cdata = this.xliffReader.getText().replace("\n", this.lineBreak);
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(cdata);
                            continue block21;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(cdata);
                            continue block21;
                        }
                        this.skel.append(cdata);
                        continue block21;
                    }
                    case 12: {
                        this.skel.append(CDATA_START);
                        this.skel.append(this.xliffReader.getText().replace("\n", this.lineBreak));
                        this.skel.append(CDATA_END);
                        continue block21;
                    }
                    case 4: {
                        String skelChars = Util.escapeToXML(this.xliffReader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null);
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelChars);
                            continue block21;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelChars);
                            continue block21;
                        }
                        this.skel.append(skelChars);
                        continue block21;
                    }
                    case 5: {
                        String skelComment = "<!--" + this.xliffReader.getText().replace("\n", this.lineBreak) + "-->";
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelComment);
                            continue block21;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelComment);
                            continue block21;
                        }
                        this.skel.append(skelComment);
                        continue block21;
                    }
                    case 3: {
                        String skelPI = "<?" + this.xliffReader.getPITarget() + " " + this.xliffReader.getPIData() + "?>";
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelPI);
                            continue block21;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelPI);
                            continue block21;
                        }
                        this.skel.append(skelPI);
                        continue block21;
                    }
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException(e);
        }
        return true;
    }

    private void addToolPropertyPlaceholder(GenericSkeleton skeleton, StartSubDocument startSubDoc, XLIFFToolAnnotation toolAnn) {
        this.addPropertyPlaceholder(skeleton, "tool", startSubDoc, toolAnn != null ? toolAnn.toXML() : "");
    }

    private void addPhasePropertyPlaceholder(GenericSkeleton skeleton, StartSubDocument startSubDoc, XLIFFPhaseAnnotation phaseAnn) {
        this.addPropertyPlaceholder(skeleton, "phase", startSubDoc, phaseAnn != null ? phaseAnn.toXML() : "");
    }

    private void addPropertyPlaceholder(GenericSkeleton skeleton, String propertyName, INameable referent, String initialValue) {
        Property property;
        skeleton.addValuePlaceholder(referent, propertyName, LocaleId.EMPTY);
        Property property2 = property = referent.getProperty(propertyName) != null ? referent.getProperty(propertyName) : new Property(propertyName, "");
        if (initialValue != null) {
            property.setValue(initialValue);
        }
        referent.setProperty(property);
    }

    private boolean processEndFile() {
        Ending ending = new Ending(this.otherId.createId());
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_SUBDOCUMENT, ending));
        return true;
    }

    private void removeEndingSkeletonWhitespace() {
        GenericSkeletonPart part = this.skel.getLastPart();
        if (part != null) {
            part.setData(part.toString().replaceAll("[\\s\\n\\r]+$", ""));
        }
    }

    private void storeStartElement(boolean updateLangWithTarget, boolean addApprovedIfNeeded, boolean mtConfTarget) {
        this.annotatorsRef.readAndPush();
        String prefix = this.xliffReader.getPrefix();
        if (!"its".equals(prefix)) {
            this.storeElementName(prefix);
            boolean ps = this.preserveSpaces.peek();
            String itsLQIRef = "";
            String itsProvRef = "";
            boolean needToCheckforITSDecl = true;
            int count = this.xliffReader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.xliffReader.isAttributeSpecified(i)) continue;
                String attrPrefix = this.xliffReader.getAttributePrefix(i);
                String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.xliffReader.getAttributeLocalName(i);
                String attrValue = this.xliffReader.getAttributeValue(i);
                if (attrName.equals("xml:lang") && updateLangWithTarget) {
                    attrValue = this.trgLang.toBCP47();
                }
                if (attrName.equals("xml:space")) {
                    ps = this.isPreserveSpaceAttributeValue(attrValue);
                }
                if ("approved".equals(this.xliffReader.getAttributeLocalName(i))) {
                    this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
                    addApprovedIfNeeded = false;
                    continue;
                }
                if (attrName.equals("its:locQualityIssuesRef")) {
                    itsLQIRef = " its:locQualityIssuesRef=\"" + attrValue + "\"";
                    continue;
                }
                if (attrName.startsWith("its:locQuality")) {
                    itsLQIRef = " its:locQualityIssuesRef=\"\"";
                    continue;
                }
                if (attrName.equals("its:provenanceRecordsRef")) {
                    itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                    continue;
                }
                if (mtConfTarget && attrName.equals("its:mtConfidence") || mtConfTarget && attrName.equals("its:annotatorsRef") && attrValue.startsWith("mt-confidence|")) continue;
                if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                    itsProvRef = " its:provenanceRecordsRef=\"\"";
                    continue;
                }
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
                this.skel.append("\"");
            }
            switch (this.xliffReader.getLocalName()) {
                case "trans-unit": {
                    GenericSkeletonPart part = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                    if (needToCheckforITSDecl) {
                        needToCheckforITSDecl = !this.checkForITSNamespace(part);
                    }
                    this.tu.setProperty(new Property("locQualityIssuesRef", itsLQIRef));
                    part = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
                    if (needToCheckforITSDecl) {
                        needToCheckforITSDecl = !this.checkForITSNamespace(part);
                    }
                    this.tu.setProperty(new Property("provenanceRecordsRef", itsProvRef));
                    break;
                }
                case "source": {
                    this.itsLQISource = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                    if (needToCheckforITSDecl) {
                        needToCheckforITSDecl = !this.checkForITSNamespace(this.itsLQISource);
                    }
                    this.itsProvSource = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
                    if (!needToCheckforITSDecl) break;
                    needToCheckforITSDecl = !this.checkForITSNamespace(this.itsProvSource);
                    break;
                }
                case "target": {
                    if (mtConfTarget) {
                        this.itsMtConfTarget = this.skel.addValuePlaceholder(this.tu, "mtConfidence", LocaleId.EMPTY);
                    }
                    this.itsLQITarget = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                    if (needToCheckforITSDecl) {
                        needToCheckforITSDecl = !this.checkForITSNamespace(this.itsLQITarget);
                    }
                    this.itsProvTarget = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
                    if (!needToCheckforITSDecl) break;
                    boolean bl = needToCheckforITSDecl = !this.checkForITSNamespace(this.itsProvTarget);
                }
            }
            if (addApprovedIfNeeded) {
                this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
            }
            this.skel.append(">");
            this.preserveSpaces.push(ps);
        } else {
            this.removeEndingSkeletonWhitespace();
            this.inITSStandoff.push(prefix);
        }
    }

    private boolean checkForITSNamespace(GenericSkeletonPart part) {
        String p = this.xliffReader.getNamespaceContext().getPrefix("http://www.w3.org/2005/11/its");
        if (p != null && "its".equals(p)) {
            return true;
        }
        part.getData().insert(0, "[@#ITSNSDECL#@]");
        return true;
    }

    private void storeStartElementFile(StartSubDocument startSubDoc) {
        this.annotatorsRef.readAndPush();
        this.storeElementName(this.xliffReader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        boolean hasTargetlanguage = false;
        String itsProvRef = "";
        int count = this.xliffReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.xliffReader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.xliffReader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.xliffReader.getAttributeLocalName(i);
            String attrValue = this.xliffReader.getAttributeValue(i);
            if (this.xliffReader.getAttributeLocalName(i).equals("target-language")) {
                hasTargetlanguage = true;
                startSubDoc.setProperty(new Property("targetLanguage", attrValue, false));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (this.xliffReader.getAttributeLocalName(i).equals("source-language")) {
                startSubDoc.setProperty(new Property("sourceLanguage", attrValue));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "sourceLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                itsProvRef = " its:provenanceRecordsRef=\"\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
            if (!attrName.equals("xml:space")) continue;
            ps = this.isPreserveSpaceAttributeValue(attrValue);
        }
        this.skel.addValuePlaceholder(startSubDoc, "provenanceRecordsRef", LocaleId.EMPTY);
        startSubDoc.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        if (this.params.getAddTargetLanguage() && !hasTargetlanguage) {
            startSubDoc.setProperty(new Property("targetLanguage", this.trgLang.toBCP47(), false));
            this.skel.append(" target-language=\"");
            this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
            this.skel.append("\"");
        }
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeStartElementGroup(StartGroup group) {
        this.annotatorsRef.readAndPush();
        this.storeElementName(this.xliffReader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        String itsProvRef = "";
        int count = this.xliffReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.xliffReader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.xliffReader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.xliffReader.getAttributeLocalName(i);
            String attrValue = this.xliffReader.getAttributeValue(i);
            if (attrName.equals("xml:space")) {
                ps = this.isPreserveSpaceAttributeValue(attrValue);
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                itsProvRef = " its:provenanceRecordsRef=\"\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
        }
        this.skel.addValuePlaceholder(group, "provenanceRecordsRef", LocaleId.EMPTY);
        group.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeElementName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.skel.append("<" + this.xliffReader.getLocalName());
        } else {
            this.skel.append("<" + prefix + ":" + this.xliffReader.getLocalName());
        }
        int count = this.xliffReader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.xliffReader.getNamespacePrefix(i);
            this.skel.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                this.skel.append(":" + prefix);
            }
            this.skel.append("=\"");
            this.skel.append(this.xliffReader.getNamespaceURI(i));
            this.skel.append("\"");
        }
    }

    private void storeEndElement() {
        String prefix = this.xliffReader.getPrefix();
        if (!"its".equals(prefix)) {
            if (prefix != null && prefix.length() > 0) {
                this.skel.append("</" + prefix + ":" + this.xliffReader.getLocalName() + ">");
            } else {
                this.skel.append("</" + this.xliffReader.getLocalName() + ">");
            }
            this.preserveSpaces.pop();
        } else {
            this.inITSStandoff.pop();
        }
        this.annotatorsRef.pop();
    }

    private void storeSdlSeg() {
        this.storeElementName(this.xliffReader.getPrefix());
        int count = this.xliffReader.getAttributeCount();
        boolean conf = false;
        boolean origin = false;
        for (int i = 0; i < count; ++i) {
            if (!this.xliffReader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.xliffReader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.xliffReader.getAttributeLocalName(i);
            String attrValue = this.xliffReader.getAttributeValue(i);
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            switch (attrName) {
                case "locked": {
                    this.skel.append("[@#$SDLSEGLOCKED$#@]");
                    break;
                }
                case "conf": {
                    this.skel.append("[@#$SDLSEGCONF$#@]");
                    conf = true;
                    break;
                }
                case "origin": {
                    this.skel.append("[@#$SDLSEGORIGIN$#@]");
                    origin = true;
                    break;
                }
                default: {
                    this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
                }
            }
            this.skel.append("\"");
        }
        if (!conf && !Util.isEmpty(this.getParameters().getSdlSegConfValue()) && this.params.isUseSdlXliffWriter()) {
            this.skel.append(" ");
            this.skel.append("conf");
            this.skel.append("=\"");
            this.skel.append("[@#$SDLSEGCONF$#@]");
            this.skel.append("\"");
        }
        if (!origin && !Util.isEmpty(this.getParameters().getSdlSegOriginValue()) && this.params.isUseSdlXliffWriter()) {
            this.skel.append(" ");
            this.skel.append("origin");
            this.skel.append("=\"");
            this.skel.append("[@#$SDLSEGORIGIN$#@]");
            this.skel.append("\"");
        }
        this.skel.append(">");
    }

    private void storeIwsStatus() {
        boolean transStatus = false;
        boolean transType = false;
        boolean blockedTransUnit = !this.tu.isTranslatable();
        this.storeElementName(this.xliffReader.getPrefix());
        int count = this.xliffReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.xliffReader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.xliffReader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.xliffReader.getAttributeLocalName(i);
            String attrValue = this.xliffReader.getAttributeValue(i);
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            if (!blockedTransUnit && !this.inAltTrans && new IwsStatusAttribute(IwsProperty.TRANSLATION_STATUS).getAttributeName().equals(attrName)) {
                this.skel.append("[@#$IWSTRANSSTATUS$#@]");
                transStatus = true;
            } else if (!blockedTransUnit && !this.inAltTrans && new IwsStatusAttribute(IwsProperty.TRANSLATION_TYPE).getAttributeName().equals(attrName)) {
                this.skel.append("[@#$IWSTRANSTYPE$#@]");
                transType = true;
            } else {
                this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            }
            this.skel.append("\"");
        }
        if (!(blockedTransUnit || transStatus || this.inAltTrans || !this.getParameters().isUseIwsXliffWriter() || Util.isEmpty(this.getParameters().getIwsTransStatusValue()))) {
            this.skel.append(" ");
            this.skel.append(new IwsStatusAttribute(IwsProperty.TRANSLATION_STATUS).getAttributeName());
            this.skel.append("=\"");
            this.skel.append("[@#$IWSTRANSSTATUS$#@]");
            this.skel.append("\"");
        }
        if (!(blockedTransUnit || transType || this.inAltTrans || !this.getParameters().isUseIwsXliffWriter() || Util.isEmpty(this.getParameters().getIwsTransTypeValue()))) {
            this.skel.append(" ");
            this.skel.append(new IwsStatusAttribute(IwsProperty.TRANSLATION_TYPE).getAttributeName());
            this.skel.append("=\"");
            this.skel.append("[@#$IWSTRANSTYPE$#@]");
            this.skel.append("\"");
        }
        this.skel.append(">");
    }

    private boolean processTransUnit() throws IOException {
        try {
            XLIFFPhaseAnnotation phaseAnn;
            if (!this.skel.isEmpty(true)) {
                DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                this.skel = new GenericSkeleton();
                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            }
            this.sourceDone = false;
            this.targetDone = false;
            this.altTransDone = false;
            this.noteDone = false;
            this.segSourceDone = false;
            this.altTrans = null;
            this.processAltTrans = false;
            this.inAltTrans = false;
            this.segSourceDone = false;
            this.extraId = Integer.MAX_VALUE;
            this.tu = new TextUnit(String.valueOf(++this.tuId));
            this.storeStartElement(false, true, false);
            this.tu.setIsTranslatable(this.isTranslatable(this.xliffReader.getAttributeValue(null, "translate")));
            String tmp = this.xliffReader.getAttributeValue(null, "id");
            if (tmp == null) {
                throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
            }
            this.tu.setId(tmp);
            tmp = this.xliffReader.getAttributeValue(null, "resname");
            if (tmp != null) {
                this.tu.setName(tmp);
            } else if (this.params.getFallbackToID()) {
                this.tu.setName(this.tu.getId());
            }
            tmp = this.xliffReader.getAttributeValue(null, "phase-name");
            if (tmp != null && (phaseAnn = this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class)) != null && phaseAnn.get(tmp) != null) {
                XLIFFPhaseAnnotation tuPhaseAnn = new XLIFFPhaseAnnotation();
                tuPhaseAnn.add(phaseAnn.get(tmp));
                this.tu.setAnnotation(tuPhaseAnn);
            }
            if ((tmp = this.xliffReader.getAttributeValue(null, PROP_EXTRADATA)) != null) {
                this.tu.setProperty(new Property(PROP_EXTRADATA, tmp, true));
            }
            this.approved = -1;
            tmp = this.xliffReader.getAttributeValue(null, "approved");
            if (tmp != null) {
                this.approved = 0;
                if (tmp.equals("yes")) {
                    this.approved = 1;
                }
            }
            this.itsFilterHandler.readTextUnitITSAttributes(this.tu);
            this.tu.setType(this.xliffReader.getAttributeValue(null, "restype"));
            this.addLengthConstraints(this.tu);
            while (this.xliffReader.hasNext()) {
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 1: {
                        if (this.xliffReader.getNamespaceURI().startsWith("MQXliff")) {
                            this.storeWholeElement(this.xliffReader.getName());
                            break;
                        }
                        String name = this.xliffReader.getLocalName();
                        if ("source".equals(name)) {
                            if (this.inAltTrans) {
                                if (!this.params.getEditAltTrans()) {
                                    this.storeStartElement(false, false, false);
                                }
                            } else {
                                this.storeStartElement(false, false, false);
                            }
                            this.processSource(false);
                            if (this.inAltTrans) {
                                if (this.params.getEditAltTrans()) break;
                                this.storeEndElement();
                                break;
                            }
                            this.storeEndElement();
                            break;
                        }
                        if ("target".equals(name)) {
                            this.addSegSourceIfNeeded();
                            if (this.inAltTrans) {
                                if (!this.params.getEditAltTrans()) {
                                    this.storeStartElement(this.params.getOverrideTargetLanguage(), false, false);
                                }
                            } else {
                                this.storeStartElement(this.params.getOverrideTargetLanguage(), false, true);
                            }
                            this.processTarget();
                            if (this.inAltTrans) {
                                if (this.params.getEditAltTrans()) break;
                                this.storeEndElement();
                                break;
                            }
                            this.storeEndElement();
                            break;
                        }
                        if ("seg-source".equals(name)) {
                            this.skel.add("[@#$SEGSRC$#@]");
                            this.skel.attachParent(this.tu);
                            this.storeStartElement(false, false, false);
                            this.processSource(true);
                            this.storeEndElement();
                            this.skel.flushPart();
                            this.segSourceDone = true;
                            if (!this.tu.getSource().hasBeenSegmented()) break;
                            this.tu.setProperty(new Property(PROP_WASSEGMENTED, "true", true));
                            break;
                        }
                        if ("note".equals(name)) {
                            this.addTargetIfNeeded();
                            this.processNote();
                            break;
                        }
                        if ("alt-trans".equals(name)) {
                            this.addTargetIfNeeded();
                            if (!this.params.getEditAltTrans()) {
                                this.storeStartElement(false, false, false);
                            }
                            this.processStartAltTrans();
                            break;
                        }
                        if (IwsSegmentMetadataAttribute.ELEMENT_NAME.equals(name) && IwsProperty.IWS_NAMESPACE.equals(this.xliffReader.getPrefix())) {
                            this.inIwsSegmentMetadata = true;
                            this.storeStartElement(false, false, false);
                            this.processIwsSegmentMetadata();
                            break;
                        }
                        if (IwsProperty.MARKUP_SEG_ELEMENT_NAME.equals(name) && IwsProperty.IWS_NAMESPACE.equals(this.xliffReader.getPrefix())) {
                            this.processIwsMarkupSeg();
                            break;
                        }
                        if (IwsStatusAttribute.ELEMENT_NAME.equals(name) && IwsProperty.IWS_NAMESPACE.equals(this.xliffReader.getPrefix())) {
                            this.processIwsStatus();
                            this.skel.flushPart();
                            this.storeIwsStatus();
                            break;
                        }
                        if ("seg".equals(name) && "sdl".equals(this.xliffReader.getPrefix()) && this.params.isUseSdlXliffWriter()) {
                            this.processSdlSeg();
                            this.skel.flushPart();
                            this.storeSdlSeg();
                            break;
                        }
                        this.addTargetIfNeeded();
                        this.storeStartElement(false, false, false);
                        break;
                    }
                    case 2: {
                        String name = this.xliffReader.getLocalName();
                        if ("trans-unit".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeEndElement();
                            if (this.altTrans != null) {
                                this.altTrans.sort();
                            }
                            if (this.params.getIgnoreInputSegmentation()) {
                                this.tu.removeAllSegmentations();
                            }
                            this.tu.setSkeleton(this.skel);
                            this.tu.setMimeType("application/x-xliff+xml");
                            if (XLIFFFilter.isUnsegmentedTextUnit(this.tu, this.params)) {
                                DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.tu.getSkeleton());
                                dp.getSkeleton().setParent(this.tu);
                                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                            } else {
                                this.queue.add(new Event(EventType.TEXT_UNIT, this.postProcessTextUnit(this.tu)));
                            }
                            return true;
                        }
                        if ("alt-trans".equals(name)) {
                            this.inAltTrans = false;
                            if (this.params.getEditAltTrans()) break;
                            this.storeEndElement();
                            break;
                        }
                        if ("seg".equals(name) && "sdl".equals(this.xliffReader.getPrefix())) {
                            this.skel.append("</sdl:seg>");
                            this.skel.flushPart();
                            break;
                        }
                        if (IwsStatusAttribute.ELEMENT_NAME.equals(name) && IwsProperty.IWS_NAMESPACE.equals(this.xliffReader.getPrefix())) {
                            this.skel.append("</iws:status>");
                            this.skel.flushPart();
                            break;
                        }
                        if (IwsSegmentMetadataAttribute.ELEMENT_NAME.equals(name) && IwsProperty.IWS_NAMESPACE.equals(this.xliffReader.getPrefix())) {
                            this.inIwsSegmentMetadata = false;
                            this.skel.append("</iws:segment-metadata>");
                            this.skel.flushPart();
                            break;
                        }
                        this.storeEndElement();
                        break;
                    }
                    case 4: 
                    case 6: {
                        if (!this.targetDone) {
                            tmp = this.xliffReader.getText();
                            for (int i = 0; i < tmp.length(); ++i) {
                                if (Character.isWhitespace(tmp.charAt(i))) continue;
                                this.addTargetIfNeeded();
                                break;
                            }
                        }
                        this.skel.append(Util.escapeToXML(this.xliffReader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 12: {
                        this.skel.append(CDATA_START);
                        this.skel.append(this.xliffReader.getText().replace("\n", this.lineBreak));
                        this.skel.append(CDATA_END);
                        break;
                    }
                    case 5: {
                        this.skel.append("<!--" + this.xliffReader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 3: {
                        this.skel.append("<?" + this.xliffReader.getPITarget() + " " + this.xliffReader.getPIData() + "?>");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return false;
    }

    private ITextUnit postProcessTextUnit(ITextUnit textUnit) {
        if (this.params.getUseCodeFinder()) {
            this.encoderManager.updateEncoder(textUnit.getMimeType());
            for (TextPart part : textUnit.getSource().getParts()) {
                part.text = this.applyCodeFinder(new TextFragment(part.text));
            }
        }
        return textUnit;
    }

    private TextFragment applyCodeFinder(TextFragment text) {
        this.params.getCodeFinder().process(text);
        text = text.subSequence(0, -1);
        boolean escapeCodeData = true;
        for (Code code : text.getCodes()) {
            if (this.params.isInlineCdata() && "cdata".equals(code.getType())) {
                if (code.getTagType() == TextFragment.TagType.OPENING) {
                    escapeCodeData = false;
                    continue;
                }
                if (code.getTagType() != TextFragment.TagType.CLOSING) continue;
                escapeCodeData = true;
                continue;
            }
            if (!escapeCodeData) continue;
            code.setData(this.encoderManager.encode(code.getData(), EncoderContext.TEXT));
        }
        return text;
    }

    private boolean isTranslatable(String trans) {
        if (trans != null) {
            return "yes".equals(trans);
        }
        return this.translateCtx.peek();
    }

    private void storeWholeElement(QName elemName) throws XMLStreamException {
        this.storeStartElement(false, false, false);
        int count = 1;
        while (this.xliffReader.hasNext()) {
            int eventType = this.xliffReader.next();
            switch (eventType) {
                case 1: {
                    if (this.xliffReader.getName().equals(elemName)) {
                        ++count;
                    }
                    this.storeStartElement(false, false, false);
                    break;
                }
                case 2: {
                    if (this.xliffReader.getName().equals(elemName)) {
                        --count;
                    }
                    this.storeEndElement();
                    if (count != 0) break;
                    return;
                }
                case 4: 
                case 6: {
                    this.skel.append(Util.escapeToXML(this.xliffReader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 12: {
                    this.skel.append(Util.escapeToXML(this.xliffReader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.xliffReader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.xliffReader.getPITarget() + " " + this.xliffReader.getPIData() + "?>");
                }
            }
        }
    }

    private void processSdlSeg() {
        if (!this.tu.hasTarget(this.trgLang)) {
            return;
        }
        String conf = this.xliffReader.getAttributeValue(null, "conf");
        String locked = this.xliffReader.getAttributeValue(null, "locked");
        String origin = this.xliffReader.getAttributeValue(null, "origin");
        TextContainer t = this.tu.getTarget(this.trgLang);
        if (!Util.isEmpty(conf) || !Util.isEmpty(this.getParameters().getSdlSegConfValue())) {
            t.setProperty(new Property("sdl_conf", conf, false));
        }
        if (!Util.isEmpty(origin) || !Util.isEmpty(this.getParameters().getSdlSegOriginValue())) {
            t.setProperty(new Property("sdl_origin", origin, false));
        }
        if (!Util.isEmpty(locked)) {
            t.setProperty(new Property("sdl_lock", locked, false));
        }
        String segId = this.xliffReader.getAttributeValue(null, "id");
        ISegments segs = t.getSegments();
        Segment seg = segs.get(segId);
        if (seg != null) {
            if (!Util.isEmpty(conf) || !Util.isEmpty(this.getParameters().getSdlSegConfValue())) {
                seg.setProperty(new Property("sdl_conf", conf, false));
            }
            if (!Util.isEmpty(origin) || !Util.isEmpty(this.getParameters().getSdlSegOriginValue())) {
                seg.setProperty(new Property("sdl_origin", origin, false));
            }
            if (!Util.isEmpty(locked)) {
                seg.setProperty(new Property("sdl_lock", locked, false));
            }
        }
        if (SdlXliffConfLevel.isValidConfValue(conf)) {
            SdlXliffConfLevel confLevel = SdlXliffConfLevel.fromConfValue(conf);
            t.setProperty(new Property("state", confLevel.getStateValue(), false));
        } else if (!Util.isEmpty(conf)) {
            t.setProperty(new Property("state", "x-" + conf, false));
        }
        if (!Util.isEmpty(conf)) {
            t.setProperty(new Property("orig_sdl_seg_conf", conf, false));
        }
    }

    private void processIwsStatus() {
        boolean blockedTransUnit;
        if (!this.inIwsSegmentMetadata) {
            return;
        }
        TextContainer t = this.tu.getTarget(this.trgLang);
        if (t == null) {
            return;
        }
        boolean bl = blockedTransUnit = this.getParameters().isIwsBlockFinished() && "finished".equals(this.xliffReader.getAttributeValue(null, IwsProperty.TRANSLATION_STATUS)) || this.getParameters().isIwsBlockLockStatus() && "locked".equals(this.xliffReader.getAttributeValue(null, IwsProperty.LOCK_STATUS)) || this.getParameters().isIwsBlockTmScore() && this.tu.getTarget(this.trgLang).hasProperty(new IwsSegmentMetadataAttribute(IwsProperty.TM_SCORE).getAttributeNamePrefixed()) && this.getParameters().getIwsBlockTmScoreValue().equals(this.tu.getTarget(this.trgLang).getProperty(new IwsSegmentMetadataAttribute(IwsProperty.TM_SCORE).getAttributeNamePrefixed()).getValue()) || this.getParameters().isIwsBlockMultipleExact() && "has_multiple_exact".equals(this.xliffReader.getAttributeValue(null, IwsProperty.MULTIPLE_EXACT));
        if (blockedTransUnit) {
            this.tu.setTargetProperty(this.trgLang, new Property("approved", "yes", false));
            this.tu.setIsTranslatable(false);
        }
        int count = this.xliffReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            t.setProperty(new Property(new IwsStatusAttribute(this.xliffReader.getAttributeLocalName(i)).getAttributeNamePrefixed(), this.xliffReader.getAttributeValue(i), true));
        }
    }

    private void processIwsSegmentMetadata() {
        TextContainer t = this.tu.getTarget(this.trgLang);
        if (t == null) {
            return;
        }
        int count = this.xliffReader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            t.setProperty(new Property(new IwsSegmentMetadataAttribute(this.xliffReader.getAttributeLocalName(i)).getAttributeNamePrefixed(), this.xliffReader.getAttributeValue(i), true));
        }
    }

    private void processIwsMarkupSeg() {
        this.storeStartElement(false, false, false);
        try {
            StringBuffer tmp = new StringBuffer();
            while (this.xliffReader.hasNext()) {
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        tmp.append(this.xliffReader.getText());
                        break;
                    }
                    case 2: {
                        String name = this.xliffReader.getLocalName();
                        if (!name.equals(IwsProperty.MARKUP_SEG_ELEMENT_NAME)) break;
                        TextContainer t = this.tu.getTarget(this.trgLang);
                        if (t == null) {
                            return;
                        }
                        if (!Util.isEmpty(tmp.toString())) {
                            t.setProperty(new Property(IwsProperty.MARKUP_SEG, Util.escapeToXML(tmp.toString(), 0, this.params.getEscapeGT(), null), false));
                        }
                        this.skel.append(Util.escapeToXML(tmp.toString(), 0, this.params.getEscapeGT(), null));
                        this.storeEndElement();
                        this.skel.flushPart();
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private void processSource(boolean isSegSource) throws IOException {
        if (this.sourceDone) {
            String tmp = this.xliffReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.srcLang : LocaleId.fromString(tmp);
            boolean tmpStore = true;
            if (this.inAltTrans && this.params.getEditAltTrans()) {
                tmpStore = false;
            }
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", tmpStore);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans) {
                if (this.processAltTrans) {
                    if (isSegSource) {
                        this.logger.warn("Segmented content in <alt-trans> is not supported (entry id='{}').", (Object)this.tu.getId());
                    } else {
                        AltTranslation alt = this.altTrans.add(lang, null, null, tc.getFirstContent(), null, this.altTransMatchType, 0, this.altTransOrigin);
                        alt.setAltTransType(this.alttranstype);
                        alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                        alt.setEngine(this.altTransEngine);
                        XLIFFToolAnnotation toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                        if (toolAnn != null) {
                            alt.setTool(toolAnn.get(this.altTrans.getCurrentToolId()));
                        }
                        if (this.altTransQuality > 0) {
                            alt.setCombinedScore(this.altTransQuality);
                        }
                    }
                }
            } else {
                TextContainer cont = tc.clone();
                cont.getSegments().joinAll();
                if (!this.params.isAlwaysUseSegSource() && cont.compareTo(this.tu.getSource(), true) != 0) {
                    this.logger.error("The <seg-source> content for the entry id='{}' is different from its <source>. The un-segmented content of <source> will be used.", (Object)this.tu.getId());
                } else {
                    GenericAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(GenericAnnotations.class));
                    ITSLQIAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSLQIAnnotations.class));
                    ITSProvenanceAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSProvenanceAnnotations.class));
                    tc.setProperty(this.tu.getSource().getProperty("locQualityIssuesRef"));
                    tc.setProperty(this.tu.getSource().getProperty("provenanceRecordsRef"));
                    tc.setHasBeenSegmentedFlag(true);
                    this.tu.setSource(tc);
                    this.itsLQISource.setParent(tc);
                    this.itsProvSource.setParent(tc);
                }
            }
        } else {
            String tmp = this.xliffReader.getAttributeValue(null, "coord");
            if (tmp != null) {
                this.tu.setSourceProperty(new Property("coordinates", tmp, true));
            }
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.xliffReader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.xliffReader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu);
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsLQISource.setParent(tc);
            this.itsProvSource.setParent(tc);
            this.tu.setSource(tc);
            this.sourceDone = true;
        }
    }

    private void processTarget() throws IOException {
        AltTranslation alt = null;
        String stateValue = this.xliffReader.getAttributeValue(null, "state");
        String stateQualifier = this.xliffReader.getAttributeValue(null, "state-qualifier");
        String coordValue = this.xliffReader.getAttributeValue(null, "coord");
        if (this.targetDone) {
            String tmp = this.xliffReader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.trgLang : LocaleId.fromString(tmp);
            boolean tmpStore = true;
            if (this.inAltTrans && this.params.getEditAltTrans()) {
                tmpStore = false;
            }
            TextContainer tc = this.processContent("target", tmpStore);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans && this.processAltTrans) {
                alt = this.altTrans.getLast();
                if (alt != null && alt.getTargetLocale() != null) {
                    alt = null;
                }
                if (alt == null) {
                    alt = this.altTrans.add(this.srcLang, null, null, null, null, this.altTransMatchType, 0, this.altTransOrigin);
                    alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                    alt.setEngine(this.altTransEngine);
                    alt.setAltTransType(this.alttranstype);
                    XLIFFToolAnnotation toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                    if (toolAnn != null) {
                        alt.setTool(toolAnn.get(this.altTrans.getCurrentToolId()));
                    }
                    if (this.altTransQuality > 0) {
                        alt.setCombinedScore(this.altTransQuality);
                    }
                }
                if (tc.contentIsOneSegment()) {
                    alt.setTarget(lang, tc.getFirstContent());
                } else {
                    alt.setTarget(lang, tc.getUnSegmentedContentCopy());
                }
                alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                alt.setFromOriginal(true);
                if (alt.getType().equals((Object)MatchType.UKNOWN)) {
                    if (FINAL.equals(stateValue) || SIGNED_OFF.equals(stateValue)) {
                        this.altTransMatchType = MatchType.ACCEPTED;
                    } else if (EXACT_MATCH.equals(stateQualifier)) {
                        this.altTransMatchType = MatchType.EXACT;
                    } else if (FUZZY_MATCH.equals(stateQualifier)) {
                        this.altTransMatchType = MatchType.FUZZY;
                    } else if (MT_SUGGESTION.equals(stateQualifier)) {
                        this.altTransMatchType = MatchType.MT;
                    } else if (ID_MATCH.equals(stateQualifier)) {
                        this.altTransMatchType = MatchType.EXACT_UNIQUE_ID;
                    }
                    alt.setType(this.altTransMatchType);
                }
            }
        } else {
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.xliffReader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.xliffReader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu, this.trgLang);
            TextContainer tc = this.processContent("target", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("mtConfidence", ""));
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsMtConfTarget.setParent(tc);
            this.itsLQITarget.setParent(tc);
            this.itsProvTarget.setParent(tc);
            this.tu.setTarget(this.trgLang, tc);
            if (this.approved > -1) {
                this.tu.setTargetProperty(this.trgLang, new Property("approved", this.approved == 1 ? "yes" : "no", false));
            }
            this.targetDone = true;
        }
        ITextUnit tmpTu = this.tu;
        if (alt != null) {
            tmpTu = alt.getEntry();
        }
        if (stateValue != null) {
            tmpTu.setTargetProperty(this.trgLang, new Property("state", stateValue, true));
        }
        if (stateQualifier != null) {
            tmpTu.setTargetProperty(this.trgLang, new Property("state-qualifier", stateQualifier, false));
        }
        if (coordValue != null) {
            tmpTu.setTargetProperty(this.trgLang, new Property("coordinates", coordValue, true));
        }
    }

    private void matchIdsAcrossParts(TextContainer tc) {
        Map<String, Code> openingCodeByOriginalIdMap = this.createOpeningCodeByOriginalIdMap(tc);
        List<TextPart> parts = tc.getParts();
        for (int i = parts.size() - 1; i > 0; --i) {
            TextFragment partContent = parts.get(i).getContent();
            List<Code> clonedCodes = partContent.getClonedCodes();
            boolean codeChanged = false;
            for (Code clonedCode : clonedCodes) {
                String originalId;
                Code openingCode;
                if (clonedCode.getTagType() != TextFragment.TagType.CLOSING || clonedCode.getOriginalId() == null || (openingCode = openingCodeByOriginalIdMap.get(originalId = clonedCode.getOriginalId())) == null) continue;
                clonedCode.setId(openingCode.getId());
                codeChanged = true;
            }
            if (!codeChanged) continue;
            partContent.setCodedText(partContent.getCodedText(), clonedCodes);
        }
    }

    private Map<String, Code> createOpeningCodeByOriginalIdMap(TextContainer tc) {
        HashMap<String, Code> openingCodeIdsByOriginalId = new HashMap<String, Code>();
        for (TextPart part : tc.getParts()) {
            for (Code code : part.getContent().getCodes()) {
                if (code.getTagType() != TextFragment.TagType.OPENING || code.getOriginalId() == null) continue;
                openingCodeIdsByOriginalId.put(code.getOriginalId(), code);
            }
        }
        return openingCodeIdsByOriginalId;
    }

    void parseMatchQualityValue(String rawValue) {
        if (rawValue == null) {
            return;
        }
        Matcher m = MATCH_QUALITY_PATTERN.matcher(rawValue);
        if (m.matches()) {
            try {
                this.altTransQuality = Integer.valueOf(m.group(1));
                if (this.altTransQuality < 1) {
                    this.altTransQuality = -1;
                }
            }
            catch (NumberFormatException e) {
                this.logger.warn("Invalid match-quality value: " + rawValue);
            }
        }
    }

    private void processStartAltTrans() {
        this.inAltTrans = true;
        this.processAltTrans = true;
        this.alttranstype = ALTTRANSTYPE_PROPOSAL;
        if (this.xliffReader.getAttributeValue(null, "alttranstype") != null) {
            this.alttranstype = this.xliffReader.getAttributeValue(null, "alttranstype");
        }
        String mid = this.xliffReader.getAttributeValue(null, "mid");
        this.altTransQuality = -1;
        this.parseMatchQualityValue(this.xliffReader.getAttributeValue(null, "match-quality"));
        this.altTransMatchType = MatchType.UKNOWN;
        String tmp = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "matchType");
        if (!Util.isEmpty(tmp)) {
            this.altTransMatchType = MatchType.valueOf(tmp);
        }
        if (this.altTransMatchType.equals((Object)MatchType.UKNOWN)) {
            String alttranstype = this.xliffReader.getAttributeValue(null, "alttranstype");
            if (ACCEPTED.equals(alttranstype)) {
                this.altTransMatchType = MatchType.ACCEPTED;
            } else if (this.altTransQuality > 99) {
                this.altTransMatchType = MatchType.EXACT;
            } else if (this.altTransQuality > 0) {
                this.altTransMatchType = MatchType.FUZZY;
            }
        }
        this.altTransOrigin = "SourceDoc";
        tmp = this.xliffReader.getAttributeValue(null, "origin");
        if (!Util.isEmpty(tmp)) {
            this.altTransOrigin = tmp;
        }
        this.altTransEngine = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "engine");
        TextContainer tc = this.tu.getTarget(this.trgLang);
        if (tc == null) {
            tc = this.tu.createTarget(this.trgLang, false, 4);
        }
        if (mid == null) {
            this.altTrans = tc.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                tc.setAnnotation(this.altTrans);
            }
            this.altTrans.setCurrentToolId(this.xliffReader.getAttributeValue(null, "tool-id"));
        } else {
            Segment seg = tc.getSegments().get(mid);
            if (seg == null) {
                this.logger.warn("An <alt-trans> element for an unknown segment '{}' was detected. It will be ignored.", (Object)mid);
                this.processAltTrans = false;
                return;
            }
            this.altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                seg.setAnnotation(this.altTrans);
            }
            this.altTrans.setCurrentToolId(this.xliffReader.getAttributeValue(null, "tool-id"));
        }
    }

    private void addSegSourceIfNeeded() {
        if (!this.segSourceDone) {
            this.skel.add("[@#$SEGSRC$#@]");
            this.skel.attachParent(this.tu);
            this.skel.flushPart();
            this.segSourceDone = true;
        }
    }

    private void addAltTransMarker() {
        if (this.altTransDone) {
            return;
        }
        this.skel.add("[@#$ALTTRANS$#@]");
        this.skel.attachParent(this.tu);
        this.skel.flushPart();
        this.altTransDone = true;
    }

    private void addNoteMarker() {
        if (this.noteDone) {
            return;
        }
        this.skel.add("[@#$NOTE$#@]");
        this.skel.attachParent(this.tu);
        this.skel.flushPart();
        this.noteDone = true;
    }

    private void addTargetIfNeeded() {
        if (!this.sourceDone) {
            throw new OkapiIllegalFilterOperationException("Element <source> missing or not placed properly.");
        }
        if (this.targetDone) {
            this.addAltTransMarker();
            this.addNoteMarker();
            return;
        }
        this.addSegSourceIfNeeded();
        if (this.srcLang.equals(this.trgLang)) {
            return;
        }
        this.skel.append("<target xml:lang=\"");
        this.skel.append(this.trgLang.toString());
        this.skel.append("\">");
        this.skel.addContentPlaceholder(this.tu, this.trgLang);
        this.skel.append("</target>");
        this.skel.append(this.lineBreak);
        this.targetDone = true;
        this.addAltTransMarker();
        this.addNoteMarker();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextContainer processContent(String tagName, boolean store) throws IOException {
        try {
            boolean changeFirstPart = false;
            TextContainer content = new TextContainer();
            ISegments segments = content.getSegments();
            int id = 0;
            this.autoMid = -1;
            Stack<Integer> idStack = new Stack<Integer>();
            Stack<String> originalIdStack = new Stack<String>();
            ArrayList<Integer> annIds = new ArrayList<Integer>();
            idStack.push(id);
            CodeTypeForPairedTagsHelper codeTypeForPairedTagsHelper = new CodeTypeForPairedTagsHelper();
            Segment segment = null;
            int segIdStack = -1;
            TextFragment current = new TextFragment();
            current.invalidate();
            while (true) {
                if (!this.xliffReader.hasNext()) {
                    return content;
                }
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 12: {
                        if (this.params.isInlineCdata()) {
                            current.append(new Code(TextFragment.TagType.OPENING, "cdata", CDATA_START));
                        }
                        current.append(this.xliffReader.getText());
                        if (this.params.isInlineCdata()) {
                            current.append(new Code(TextFragment.TagType.CLOSING, "cdata", CDATA_END));
                        }
                        if (!store) break;
                        if (this.params.isInlineCdata()) {
                            this.skel.append(CDATA_START + this.xliffReader.getText() + CDATA_END);
                            break;
                        }
                        this.skel.append(Util.escapeToXML(this.xliffReader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 4: 
                    case 6: {
                        current.append(this.xliffReader.getText());
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.xliffReader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 2: {
                        String tmp;
                        Code code;
                        String name = this.xliffReader.getLocalName();
                        if (name.equals(tagName)) {
                            if (!current.isEmpty()) {
                                content.append(current, !content.hasBeenSegmented(), !this.params.getBalanceCodes());
                                this.matchIdsAcrossParts(content);
                            }
                            return content;
                        }
                        if (name.equals("mrk")) {
                            if ((Integer)idStack.peek() == segIdStack) {
                                current = new TextFragment();
                                current.invalidate();
                                idStack.pop();
                                segIdStack = -1;
                                String oriId = segment.getId();
                                segments.append(segment, !content.hasBeenSegmented());
                                if (changeFirstPart && content.count() == 2) {
                                    changeFirstPart = false;
                                    content.changePart(0);
                                    segment.forceId(oriId);
                                }
                                if (store) {
                                    this.storeEndElement();
                                    break;
                                }
                                this.annotatorsRef.pop();
                                break;
                            }
                            if (store) {
                                this.storeEndElement();
                            } else {
                                this.annotatorsRef.pop();
                            }
                            code = current.append(TextFragment.TagType.CLOSING, name, "");
                            id = (Integer)idStack.pop();
                            code.setId(id);
                            tmp = this.xliffReader.getPrefix();
                            if (tmp != null && tmp.length() > 0) {
                                code.setOuterData("</" + tmp + ":" + name + ">");
                            } else {
                                code.setOuterData("</" + name + ">");
                            }
                            int n = annIds.indexOf(id);
                            if (n != -1) {
                                annIds.remove(n);
                                Code oc = current.getCode(current.getIndex(id));
                                GenericAnnotations.addAnnotations(code, oc.getGenericAnnotations());
                                code.setType("_annotation_");
                            }
                        }
                        if (!name.equals("g")) break;
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.annotatorsRef.pop();
                        }
                        id = (Integer)idStack.pop();
                        String type = name;
                        String elementName = this.getElementNameWithOptionalPrefix(name, this.xliffReader.getPrefix());
                        int index = current.getIndex(id);
                        if (index > -1) {
                            Code currentCode = current.getCode(index);
                            if (currentCode != null) {
                                type = currentCode.getType();
                            }
                        } else {
                            int closingTagCount = this.countClosingTags(current);
                            type = this.findMatchingCType(elementName, content, closingTagCount);
                        }
                        code = current.append(TextFragment.TagType.CLOSING, type, "");
                        code.setId(id);
                        code.setOuterData("</" + elementName + ">");
                        String originalEndId = (String)originalIdStack.pop();
                        code.setOriginalId(originalEndId);
                        this.addSdlCodeData(originalEndId, code);
                        break;
                    }
                    case 1: {
                        String tmp;
                        Code code;
                        if (store) {
                            this.storeStartElement(false, false, false);
                        } else {
                            this.annotatorsRef.readAndPush();
                        }
                        String name = this.xliffReader.getLocalName();
                        if (name.equals("mrk")) {
                            String type = this.xliffReader.getAttributeValue(null, "mtype");
                            if (type != null && type.equals("seg")) {
                                if (!current.isEmpty()) {
                                    content.append(current, !content.hasBeenSegmented());
                                    changeFirstPart = !content.hasBeenSegmented();
                                }
                                idStack.push(++id);
                                segIdStack = id;
                                segment = new Segment();
                                segment.id = this.xliffReader.getAttributeValue(null, "mid");
                                current = segment.text;
                                current.invalidate();
                                GenericAnnotations anns = this.itsFilterHandler.readInlineCodeITSAttributes();
                                segment.setAnnotation(anns);
                                break;
                            }
                            if (type != null && type.equals("protected")) {
                                String originalId = this.xliffReader.getAttributeValue(null, "mid");
                                int mid = this.retrieveId(id, originalId, false, true);
                                code = this.appendCode(TextFragment.TagType.PLACEHOLDER, mid, name, name, store, current);
                                code.setDeleteable(false);
                                code.setOriginalId(this.getOriginalIdOrNull(originalId));
                                break;
                            }
                        }
                        switch (name) {
                            case "g": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String ctype = this.xliffReader.getAttributeValue(null, "ctype");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                id = this.retrieveId(id, originalId, false, false);
                                idStack.push(id);
                                String codeType = ctype != null ? ctype : name;
                                code = current.append(TextFragment.TagType.OPENING, codeType, "", id);
                                code.setOriginalId(this.getOriginalIdOrNull(originalId));
                                code.setDisplayText(equivText);
                                code.setOuterData(this.buildStartCode());
                                if (merged != null) {
                                    code.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                }
                                this.addSdlCodeData(originalId, code);
                                originalIdStack.push(originalId);
                                break;
                            }
                            case "mrk": {
                                String originalId = this.xliffReader.getAttributeValue(null, "mid");
                                int mid = this.retrieveId(id, originalId, false, true);
                                idStack.push(mid);
                                code = current.append(TextFragment.TagType.OPENING, name, "", mid);
                                GenericAnnotations anns = this.itsFilterHandler.readInlineCodeITSAttributes();
                                if (anns != null) {
                                    annIds.add(mid);
                                    GenericAnnotations.addAnnotations(code, anns);
                                    code.setType("_annotation_");
                                }
                                code.setOuterData(this.buildStartCode());
                                break;
                            }
                            case "x": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String ctype = this.xliffReader.getAttributeValue(null, "ctype");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                id = this.retrieveId(id, originalId, false, false);
                                String codeType = ctype != null ? ctype : name;
                                Code c = this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, codeType, store, current);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged != null) {
                                    c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                }
                                this.addSdlCodeData(originalId, c);
                                break;
                            }
                            case "bx": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String rid = this.xliffReader.getAttributeValue(null, "rid");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String ctype = this.xliffReader.getAttributeValue(null, "ctype");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                id = this.retrieveId(id, originalId, false, false);
                                String codeType = codeTypeForPairedTagsHelper.store(rid, originalId, ctype);
                                Code c = this.appendCode(TextFragment.TagType.OPENING, id, name, codeType, store, current);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                            case "ex": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String rid = this.xliffReader.getAttributeValue(null, "rid");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                id = this.retrieveId(id, originalId, true, false);
                                String codeType = codeTypeForPairedTagsHelper.find(rid, originalId);
                                Code c = this.appendCode(TextFragment.TagType.CLOSING, id, name, codeType, store, current);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                            case "bpt": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String ctype = this.xliffReader.getAttributeValue(null, "ctype");
                                String rid = this.xliffReader.getAttributeValue(null, "rid");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                String codeType = codeTypeForPairedTagsHelper.store(rid, originalId, ctype);
                                id = this.retrieveId(id, originalId, false, false);
                                Code c = this.appendCode(TextFragment.TagType.OPENING, id, name, codeType, store, current);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                            case "ept": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String rid = this.xliffReader.getAttributeValue(null, "rid");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                String codeType = codeTypeForPairedTagsHelper.find(rid, originalId);
                                id = this.retrieveId(id, originalId, true, false);
                                Code c = this.appendCode(TextFragment.TagType.CLOSING, id, name, codeType, store, current);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                            case "ph": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                id = this.retrieveId(id, originalId, false, false);
                                Code c = this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, name, store, current);
                                this.addSdlCodeData(originalId, c);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                            case "it": {
                                String originalId = this.xliffReader.getAttributeValue(null, "id");
                                String merged = this.xliffReader.getAttributeValue("okapi-framework:xliff-extensions", "merged");
                                String equivText = this.xliffReader.getAttributeValue(null, "equiv-text");
                                id = this.retrieveId(id, originalId, false, false);
                                tmp = this.xliffReader.getAttributeValue(null, "pos");
                                TextFragment.TagType tt = TextFragment.TagType.PLACEHOLDER;
                                if (tmp == null) {
                                    this.logger.error("Missing pos attribute for <it> element.");
                                } else if (tmp.equals("close")) {
                                    tt = TextFragment.TagType.CLOSING;
                                } else if (tmp.equals("open")) {
                                    tt = TextFragment.TagType.OPENING;
                                } else {
                                    if (tmp.equals("end")) {
                                        tt = TextFragment.TagType.CLOSING;
                                    } else if (tmp.equals("begin")) {
                                        tt = TextFragment.TagType.OPENING;
                                    }
                                    if (tt == TextFragment.TagType.PLACEHOLDER) {
                                        this.logger.error("Invalid value '{}' for pos attribute.", (Object)tmp);
                                    } else {
                                        this.logger.warn("Invalid value '{}' for pos attribute.", (Object)tmp);
                                    }
                                }
                                Code c = this.appendCode(tt, id, name, name, store, current);
                                this.addSdlCodeData(originalId, c);
                                c.setOriginalId(this.getOriginalIdOrNull(originalId));
                                c.setDisplayText(equivText);
                                if (merged == null) break;
                                c.setMergedData(Util.unescapeWhitespaceForXML(merged));
                                break;
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private int countClosingTags(TextFragment current) {
        int closingTagCount = 0;
        for (Code code : current.getCodes()) {
            if (code.getTagType() != TextFragment.TagType.CLOSING) continue;
            ++closingTagCount;
        }
        return closingTagCount;
    }

    private String getElementNameWithOptionalPrefix(String elementName, String namespacePrefix) {
        String attributeName = elementName;
        if (namespacePrefix != null && namespacePrefix.length() > 0) {
            attributeName = namespacePrefix + ":" + elementName;
        }
        return attributeName;
    }

    private String findMatchingCType(String name, TextContainer content, int closingTagCount) {
        for (int j = content.getParts().size() - 1; j >= 0; --j) {
            TextPart textPart = content.getParts().get(j);
            if (textPart.isSegment()) continue;
            List<Code> codes = textPart.getContent().getCodes();
            for (int i = codes.size() - 1; i >= 0; --i) {
                Code code = codes.get(i);
                if (code.getTagType() == TextFragment.TagType.CLOSING) {
                    ++closingTagCount;
                    continue;
                }
                if (code.getTagType() == TextFragment.TagType.OPENING && closingTagCount > 0) {
                    --closingTagCount;
                    continue;
                }
                if (!code.getOuterData().startsWith("<" + name)) continue;
                return code.getType();
            }
        }
        return name;
    }

    private String getOriginalIdOrNull(String originalId) {
        try {
            Util.fastParseInt(originalId);
            return null;
        }
        catch (NumberFormatException e) {
            return originalId;
        }
    }

    private void addSdlCodeData(String id, Code c) {
        if (this.sdlTagDefs == null || this.sdlTagDefs.isEmpty()) {
            return;
        }
        if (this.sdlTagDefs.containsKey(id)) {
            SdlTagDef td = this.sdlTagDefs.get(id);
            if (!Util.isEmpty(td.equiv_text)) {
                c.setDisplayText(td.equiv_text);
            }
            switch (c.getTagType()) {
                case OPENING: {
                    if (td.bpt != null) {
                        c.setData(td.bpt.getData());
                        c.setType(td.bpt.getType());
                        break;
                    }
                    this.logger.debug("We have SDL Tag Defs and found the tag def, but no matching bpt data: {}", (Object)id);
                    break;
                }
                case CLOSING: {
                    if (td.ept != null) {
                        c.setData(td.ept.getData());
                        c.setType(td.ept.getType());
                        break;
                    }
                    if (!Util.isEmpty(td.name)) {
                        c.setType(td.name);
                        break;
                    }
                    this.logger.debug("We have SDL Tag Defs and found the tag def, but no matching ept data or name: {}", (Object)id);
                    break;
                }
                case PLACEHOLDER: {
                    if (td.ph != null) {
                        c.setData(td.ph.getData());
                        c.setType(td.ph.getType());
                        break;
                    }
                    if (td.it != null) {
                        c.setData(td.it.getData());
                        c.setType(td.it.getType());
                        break;
                    }
                    if (td.st != null) {
                        c.setData(td.st.getData());
                        c.setType(td.st.getType());
                        break;
                    }
                    this.logger.debug("We have SDL Tag Defs and found the tag def, but no matching ph/it data: {}", (Object)id);
                    break;
                }
            }
        } else {
            this.logger.debug("We have SDL Tag Defs but could not find code id: {}", (Object)id);
        }
    }

    private String buildStartCode() {
        return this.buildStartCode(this.xliffReader);
    }

    public String buildStartCode(XMLStreamReader reader) {
        int i;
        String prefix = reader.getPrefix();
        StringBuilder tmpg = new StringBuilder();
        boolean isMrk = false;
        if (prefix != null && prefix.length() > 0) {
            tmpg.append("<" + prefix + ":" + reader.getLocalName());
        } else {
            tmpg.append("<" + reader.getLocalName());
            isMrk = "mrk".equals(reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = reader.getNamespacePrefix(i);
            tmpg.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                tmpg.append(":" + prefix);
            }
            tmpg.append("=\"");
            tmpg.append(reader.getNamespaceURI(i));
            tmpg.append("\"");
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!reader.isAttributeSpecified(i)) continue;
            prefix = reader.getAttributePrefix(i);
            String attName = reader.getAttributeLocalName(i);
            if (isMrk && ("comment".equals(attName) || "http://www.w3.org/ns/its-xliff/".equals(reader.getAttributeNamespace(i)) || "http://www.w3.org/2005/11/its".equals(reader.getAttributeNamespace(i)) || "http://www.w3.org/XML/1998/namespace".equals(reader.getAttributeNamespace(i)) && ("lang".equals(attName) || "preserve".equals(attName)))) continue;
            tmpg.append(" ");
            if (prefix != null && prefix.length() != 0) {
                tmpg.append(prefix + ":");
            }
            tmpg.append(attName);
            tmpg.append("=\"");
            tmpg.append(Util.escapeToXML(reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
            tmpg.append("\"");
        }
        tmpg.append(">");
        return tmpg.toString();
    }

    private int retrieveId(int currentIdValue, String id, boolean useMinusOneasDefault, boolean useAutoMid) {
        if (id == null || id.length() == 0) {
            if (useAutoMid) {
                return --this.autoMid;
            }
            this.logger.warn("Missing id attribute in inline code. An auto-id is used instead, but may not provide a proper source/target alignment.");
            return useMinusOneasDefault ? -1 : ++currentIdValue;
        }
        try {
            return Util.fastParseInt(id);
        }
        catch (NumberFormatException e) {
            return id.hashCode();
        }
    }

    private Code appendCode(TextFragment.TagType tagType, int id, String tagName, String type, boolean store, TextFragment content) {
        try {
            String prefix;
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = new StringBuilder();
            String tagPrefix = this.xliffReader.getPrefix();
            if (!Util.isEmpty(tagPrefix)) {
                outerCode.append("<" + tagPrefix + ":" + tagName);
            } else {
                outerCode.append("<" + tagName);
            }
            int count = this.xliffReader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.xliffReader.isAttributeSpecified(i)) continue;
                prefix = this.xliffReader.getAttributePrefix(i);
                outerCode.append(" ");
                if (!Util.isEmpty(prefix)) {
                    outerCode.append(prefix + ":");
                }
                outerCode.append(this.xliffReader.getAttributeLocalName(i));
                outerCode.append("=\"");
                outerCode.append(Util.escapeToXML(this.xliffReader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
                outerCode.append("\"");
            }
            outerCode.append(">");
            boolean inSub = false;
            boolean hasSub = false;
            while (this.xliffReader.hasNext()) {
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 1: {
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (store) {
                            this.storeStartElement(false, false, false);
                        } else {
                            this.annotatorsRef.readAndPush();
                        }
                        if (!inSub && this.xliffReader.getLocalName().equals("sub")) {
                            inSub = true;
                        } else if (tagName.equals(this.xliffReader.getLocalName())) {
                            ++endStack;
                        }
                        String tmpg = this.buildStartCode();
                        if (!inSub) {
                            innerCode.append(tmpg.toString());
                        }
                        outerCode.append(tmpg.toString());
                        if (!inSub) break;
                        Code code = content.append(tagType, type, innerCode.toString(), id);
                        code.setOuterData(outerCode.toString());
                        List<Object> chunks = this.processSub();
                        for (Object obj : chunks) {
                            if (obj instanceof String) {
                                content.append((String)obj);
                                continue;
                            }
                            if (!(obj instanceof Code)) continue;
                            content.append((Code)obj);
                        }
                        innerCode.setLength(0);
                        outerCode.setLength(0);
                        outerCode.append("</sub>");
                        inSub = false;
                        hasSub = true;
                        break;
                    }
                    case 2: {
                        Code code;
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.annotatorsRef.pop();
                        }
                        prefix = this.xliffReader.getPrefix();
                        if (tagName.equals(this.xliffReader.getLocalName()) && --endStack == 0) {
                            code = content.append(tagType, type, innerCode.toString(), hasSub ? (this.extraId = this.extraId - 1) : id);
                            if (!hasSub && innerCode.length() == 0) {
                                outerCode.insert(outerCode.length() - 1, '/');
                            } else if (!Util.isEmpty(prefix)) {
                                outerCode.append("</" + prefix + ":" + tagName + ">");
                            } else {
                                outerCode.append("</" + tagName + ">");
                            }
                            code.setOuterData(outerCode.toString());
                            return code;
                        }
                        if (Util.isEmpty(prefix)) {
                            innerCode.append("</" + this.xliffReader.getLocalName() + ">");
                            outerCode.append("</" + this.xliffReader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.xliffReader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.xliffReader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.xliffReader.getText());
                        outerCode.append(Util.escapeToXML(this.xliffReader.getText(), 0, this.params.getEscapeGT(), null));
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.xliffReader.getText(), 0, this.params.getEscapeGT(), null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return null;
    }

    private List<Object> processSub() throws XMLStreamException {
        return this.processSub(this.xliffReader);
    }

    public List<Object> processSub(XMLStreamReader reader) throws XMLStreamException {
        ArrayList<Object> chunks = new ArrayList<Object>();
        boolean inText = true;
        StringBuilder buf = new StringBuilder();
        StringBuilder bufOuter = new StringBuilder();
        while (reader.hasNext()) {
            int eventType = reader.next();
            switch (eventType) {
                case 1: {
                    if (inText) {
                        chunks.add(buf.toString());
                        buf.setLength(0);
                        inText = false;
                        bufOuter.append(this.buildStartTag());
                        break;
                    }
                    Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", buf.toString());
                    code.setId(--this.extraId);
                    code.setOuterData(bufOuter.toString());
                    chunks.add(code);
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", null);
                    code.setId(--this.extraId);
                    code.setOuterData(this.buildStartTag());
                    chunks.addAll(this.processSub(reader));
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    bufOuter.append("</sub>");
                    break;
                }
                case 2: {
                    if (inText) {
                        chunks.add(buf.toString());
                        buf.setLength(0);
                        return chunks;
                    }
                    bufOuter.append("</" + reader.getLocalName() + ">");
                    Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", buf.toString());
                    code.setId(--this.extraId);
                    code.setOuterData(bufOuter.toString());
                    chunks.add(code);
                    inText = true;
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    if (inText) {
                        buf.append(reader.getText());
                        break;
                    }
                    String data = reader.getText();
                    buf.append(data);
                    bufOuter.append(Util.escapeToXML(data, 0, this.params.getEscapeGT(), null));
                }
            }
        }
        return null;
    }

    private String buildStartTag() {
        int i;
        StringBuilder tmp = new StringBuilder("<");
        String prefix = this.xliffReader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            tmp.append(this.xliffReader.getLocalName());
        } else {
            tmp.append(prefix + ":" + this.xliffReader.getLocalName());
        }
        int count = this.xliffReader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = this.xliffReader.getNamespacePrefix(i);
            tmp.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                tmp.append(":" + prefix);
            }
            tmp.append("=\"");
            tmp.append(this.xliffReader.getNamespaceURI(i));
            tmp.append("\"");
        }
        count = this.xliffReader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.xliffReader.isAttributeSpecified(i)) continue;
            prefix = this.xliffReader.getAttributePrefix(i);
            tmp.append(" ");
            if (prefix != null && prefix.length() != 0) {
                tmp.append(prefix + ":");
            }
            tmp.append(this.xliffReader.getAttributeLocalName(i));
            tmp.append("=\"");
            tmp.append(Util.escapeToXML(this.xliffReader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
            tmp.append("\"");
        }
        tmp.append(">");
        return tmp.toString();
    }

    private XLIFFNote createNote() {
        XLIFFNote n = new XLIFFNote();
        try {
            block12: for (int i = 0; i < this.xliffReader.getAttributeCount(); ++i) {
                switch (this.xliffReader.getAttributeLocalName(i)) {
                    case "annotates": {
                        n.setAnnotates(XLIFFNote.Annotates.fromString(this.xliffReader.getAttributeValue(i)));
                        continue block12;
                    }
                    case "from": {
                        n.setFrom(this.xliffReader.getAttributeValue(i));
                        continue block12;
                    }
                    case "priority": {
                        n.setPriority(XLIFFNote.Priority.fromInt(Integer.parseInt(this.xliffReader.getAttributeValue(i))));
                        continue block12;
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("XLIFF note attribute: {}", (Object)e.getMessage());
        }
        return n;
    }

    private void processNote() {
        try {
            String dest = this.xliffReader.getAttributeValue(null, "annotates");
            if (dest == null) {
                dest = "";
            }
            XLIFFNoteAnnotation notes = null;
            StringBuilder tmp = new StringBuilder();
            if (dest.equals("source")) {
                notes = this.tu.getSource().getAnnotation(XLIFFNoteAnnotation.class);
            } else if (dest.equals("target")) {
                if (!this.tu.hasTarget(this.trgLang)) {
                    this.tu.setTarget(this.trgLang, new TextContainer());
                }
                notes = this.tu.getTarget(this.trgLang).getAnnotation(XLIFFNoteAnnotation.class);
            } else {
                notes = this.tu.getAnnotation(XLIFFNoteAnnotation.class);
            }
            if (notes == null) {
                notes = new XLIFFNoteAnnotation();
            }
            XLIFFNote aNote = this.createNote();
            while (this.xliffReader.hasNext()) {
                int eventType = this.xliffReader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        tmp.append(this.xliffReader.getText());
                        break;
                    }
                    case 2: {
                        String name = this.xliffReader.getLocalName();
                        if (!name.equals("note")) break;
                        aNote.setNoteText(tmp.toString());
                        notes.add(aNote);
                        if (dest.equals("source")) {
                            this.tu.getSource().setAnnotation(notes);
                        } else if (dest.equals("target")) {
                            this.tu.getTarget(this.trgLang).setAnnotation(notes);
                        } else {
                            this.tu.setAnnotation(notes);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processStartGroup() throws IOException {
        String mergeTrans = this.xliffReader.getAttributeValue(null, "merge-trans");
        if (mergeTrans != null && mergeTrans.equals("yes")) {
            this.storeStartElement(false, false, false);
            this.parentIds.push(null);
            return false;
        }
        String grpId = this.xliffReader.getAttributeValue(null, "id");
        if (grpId == null || this.groupUsedIds.contains(grpId)) {
            grpId = this.groupId.createIdNotInList(this.groupUsedIds);
        } else {
            this.groupId.setLastId(grpId);
        }
        this.groupUsedIds.add(grpId);
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), grpId);
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        group.setIsTranslatable(this.isTranslatable(this.xliffReader.getAttributeValue(null, "translate")));
        this.translateCtx.push(group.isTranslatable());
        String tmp = this.xliffReader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.xliffReader.getAttributeValue(null, "id"));
        }
        group.setType(this.xliffReader.getAttributeValue(null, "restype"));
        this.addLengthConstraints(group);
        this.storeStartElementGroup(group);
        ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(group, prov);
        return true;
    }

    private boolean processEndGroup() {
        String id = this.parentIds.pop();
        if (id == null) {
            return false;
        }
        this.translateCtx.pop();
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    private boolean processStartBinUnit() {
        this.storeStartElement(false, false, false);
        String grpId = this.xliffReader.getAttributeValue(null, "id");
        if (grpId == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
        }
        if (this.groupUsedIds.contains(grpId)) {
            grpId = this.groupId.createIdNotInList(this.groupUsedIds);
        } else {
            this.groupId.setLastId(grpId);
        }
        this.groupUsedIds.add(grpId);
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), grpId);
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        group.setIsTranslatable(this.isTranslatable(this.xliffReader.getAttributeValue(null, "translate")));
        this.translateCtx.push(group.isTranslatable());
        String tmp = this.xliffReader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.xliffReader.getAttributeValue(null, "id"));
        }
        group.setType(this.xliffReader.getAttributeValue(null, "restype"));
        return true;
    }

    private boolean processEndBinUnit() {
        String id = this.parentIds.pop();
        this.translateCtx.pop();
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    private boolean isPreserveSpaceAttributeValue(String attrValue) {
        return this.params.isPreserveSpaceByDefault() || attrValue.equals("preserve");
    }

    private void addLengthConstraints(INameable resource) {
        String maxHeight;
        String sizeUnit;
        String maxWidth = this.xliffReader.getAttributeValue(null, "maxwidth");
        if (maxWidth != null) {
            Property property = new Property("maxwidth", maxWidth);
            resource.setProperty(property);
        }
        if ((sizeUnit = this.xliffReader.getAttributeValue(null, "size-unit")) != null) {
            Property property = new Property("size-unit", sizeUnit);
            resource.setProperty(property);
        }
        if ((maxHeight = this.xliffReader.getAttributeValue(null, "maxheight")) != null) {
            Property property = new Property("maxheight", maxHeight);
            resource.setProperty(property);
        }
    }

    public ITSAnnotatorsRefContext getAnnotatorsRefContext() {
        return this.annotatorsRef;
    }

    static boolean isUnsegmentedTextUnit(ITextUnit tu, Parameters params) {
        return params.getSkipNoMrkSegSource() && tu.getSource().getSegments().count() == 1 && !tu.getSkeleton().toString().contains("</mrk>");
    }
}

