/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.util.ArrayList;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X2ToOkpConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean originalWasX2;
    private final LocaleId trgLoc;

    public X2ToOkpConverter(boolean originalWasX2, LocaleId trgLoc) {
        this.originalWasX2 = originalWasX2;
        this.trgLoc = trgLoc;
    }

    public ITextUnit convert(Unit unit) {
        TextUnit tu = new TextUnit(unit.getId());
        tu.setName(unit.getName());
        tu.setType(unit.getType());
        if (unit.getNoteCount() > 0) {
            StringBuilder tmp = new StringBuilder();
            for (Note note : unit.getNotes()) {
                if (tmp.length() > 0) {
                    tmp.append("\n----------\n");
                }
                tmp.append(note.getText());
            }
            tu.setProperty(new Property("note", tmp.toString(), true));
        }
        TextContainer tc = tu.getSource();
        this.convert(unit, tc, false);
        boolean hasTarget = false;
        for (Part part : unit) {
            if (!part.hasTarget()) continue;
            hasTarget = true;
            break;
        }
        if (hasTarget) {
            tc = tu.createTarget(this.trgLoc, false, 0);
            this.convert(unit, tc, true);
        }
        return tu;
    }

    private void convert(Unit unit, TextContainer dest, boolean isTarget) {
        boolean first = true;
        ArrayList<TextPart> textParts = new ArrayList<TextPart>();
        int segId = 1;
        for (Part part : unit) {
            textParts.add(this.convert(first, part, dest, isTarget, segId));
            first = false;
            ++segId;
        }
        dest.setParts(textParts.toArray(new TextPart[0]));
    }

    private TextPart convert(boolean first, Part part, TextContainer dest, boolean isTarget, int segId) {
        TextPart tp;
        if (part.isSegment()) {
            String id = part.getId() == null ? Integer.toString(segId) : part.getId();
            Segment seg = new Segment(id);
            tp = seg;
        } else {
            tp = new TextPart();
        }
        if (isTarget) {
            if (part.hasTarget()) {
                this.convert(part.getTarget(), tp);
            }
        } else {
            this.convert(part.getSource(), tp);
        }
        return tp;
    }

    private void convert(Fragment frag, TextPart part) {
        TextFragment tf = part.text;
        for (Object obj : frag) {
            if (obj instanceof String) {
                tf.append((String)obj);
                continue;
            }
            if (obj instanceof CTag) {
                int id;
                CTag ctag = (CTag)obj;
                Code code = null;
                switch (ctag.getTagType()) {
                    case CLOSING: {
                        code = new Code(TextFragment.TagType.CLOSING, ctag.getType());
                        break;
                    }
                    case OPENING: {
                        code = new Code(TextFragment.TagType.OPENING, ctag.getType());
                        break;
                    }
                    case STANDALONE: {
                        code = new Code(TextFragment.TagType.PLACEHOLDER, ctag.getType());
                    }
                }
                try {
                    id = Integer.parseInt(ctag.getId());
                }
                catch (NumberFormatException e) {
                    id = ctag.getId().hashCode();
                    code.setOriginalId(ctag.getId());
                }
                code.setId(id);
                code.setCloneable(ctag.getCanCopy());
                code.setDeleteable(ctag.getCanDelete());
                code.setData(ctag.getData());
                code.setDisplayText(ctag.getDisp());
                tf.append(code);
                continue;
            }
            if (!(obj instanceof MTag)) continue;
            MTag mtag = (MTag)obj;
            tf.append("[MARKER]");
        }
    }
}

