/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.filters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.extra.filters.AbstractBaseFilter;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;

public abstract class AbstractLineFilter
extends AbstractBaseFilter {
    public static final String LINE_NUMBER = "line_number";
    private BufferedReader reader;
    private boolean canceled;
    private String encoding;
    private LinkedList<Event> queue;
    private String lineRead;
    private long lineNumber = 0L;
    private TextProcessingResult lastResult;
    private int tuId;
    private int otherId;
    private String lineBreak;
    private int parseState = 0;
    private String docName;
    protected LocaleId srcLang;
    protected LocaleId trgLang;
    private boolean hasUTF8BOM;
    private IFilterWriter filterWriter;
    private boolean multilingual;
    protected StartDocument startDoc;
    protected RawDocument input;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public final void close() {
        if (this.input != null) {
            this.input.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
                this.docName = null;
            }
            this.parseState = 0;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    public IFilterWriter getFilterWriter() {
        return this.filterWriter;
    }

    public void setFilterWriter(IFilterWriter filterWriter) {
        this.filterWriter = filterWriter;
    }

    protected void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    @Override
    protected void component_init() {
        this.setFilterWriter(this.createFilterWriter());
    }

    protected TextProcessingResult component_exec(TextContainer lineContainer) {
        return TextProcessingResult.REJECTED;
    }

    protected void component_idle(boolean lastChance) {
    }

    public boolean notify(String notification, Object info) {
        if ("filter_line_before_processing".equals(notification)) {
            if (this.lastResult == TextProcessingResult.DELAYED_DECISION) {
                this.addLineBreak();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.parseState > 0;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (input == null) {
            throw new OkapiBadFilterInputException("RawDocument is not defined in open(RawDocument, boolean).");
        }
        this.input = input;
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = detector.getEncoding();
        this.srcLang = input.getSourceLocale();
        this.trgLang = input.getTargetLocale();
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        this.commonOpen(input.getReader());
    }

    private void commonOpen(Reader inputReader) {
        this.parseState = 1;
        this.canceled = false;
        this.reader = inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader);
        try {
            this.reader.mark(1024);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tuId = 0;
        this.otherId = 0;
        this.lineNumber = 0L;
        this.lastResult = TextProcessingResult.NONE;
        this.queue = new LinkedList();
        this.component_init();
        this.startDoc = new StartDocument(String.valueOf(++this.otherId));
        this.startDoc.setName(this.docName);
        this.startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        this.startDoc.setLocale(this.srcLang);
        this.startDoc.setFilterParameters(this.getParameters());
        this.startDoc.setFilterWriter(this.getFilterWriter());
        this.startDoc.setLineBreak(this.lineBreak);
        this.startDoc.setType(this.getMimeType());
        this.startDoc.setMimeType(this.getMimeType());
        this.startDoc.setSkeleton(new GenericSkeleton());
        this.startDoc.setMultilingual(this.isMultilingual());
        this.sendEvent(EventType.START_DOCUMENT, this.startDoc);
        if (!Util.isEmpty(((ISimplifierRulesParameters)((Object)this.getParameters())).getSimplifierRules())) {
            Event cs = FilterUtil.createCodeSimplifierEvent(((ISimplifierRulesParameters)((Object)this.getParameters())).getSimplifierRules());
            this.queue.add(cs);
        }
    }

    private Event getQueueEvent() {
        Event event = this.queue.poll();
        return event;
    }

    protected ITextUnit getFirstTextUnit() {
        for (Event event : this.queue) {
            if (event.getEventType() != EventType.TEXT_UNIT) continue;
            return event.getTextUnit();
        }
        return null;
    }

    protected DocumentPart getFirstDocumentPart() {
        for (Event event : this.queue) {
            if (event.getEventType() != EventType.DOCUMENT_PART) continue;
            return (DocumentPart)event.getResource();
        }
        return null;
    }

    protected LocaleId getTargetLocale() {
        return this.trgLang;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.parseState = 0;
            this.queue.clear();
            this.sendEvent(EventType.CANCELED, null);
            return this.getQueueEvent();
        }
        if (this.queue.size() > 1) {
            return this.getQueueEvent();
        }
        try {
            GenericSkeleton skel;
            while (this.getNextLine()) {
                switch (this.lastResult) {
                    case REJECTED: 
                    case ACCEPTED: {
                        this.addLineBreak();
                        break;
                    }
                    case DELAYED_DECISION: {
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
                TextContainer lineContainer = new TextContainer(this.lineRead);
                lineContainer.setProperty(new Property(LINE_NUMBER, String.valueOf(this.lineNumber), true));
                this.lastResult = this.component_exec(lineContainer);
                switch (this.lastResult) {
                    case REJECTED: {
                        skel = this.getActiveSkeleton();
                        if (skel == null) break;
                        skel.append(lineContainer.toString());
                        break;
                    }
                    case ACCEPTED: {
                        break;
                    }
                    case DELAYED_DECISION: {
                        break;
                    }
                    case NONE: {
                        break;
                    }
                }
                if (this.queue.size() <= 1) continue;
                return this.getQueueEvent();
            }
            if (this.queue.size() > 1) {
                return this.getQueueEvent();
            }
            this.component_idle(this.queue.size() == 0);
            if (this.queue.size() > 0) {
                return this.getQueueEvent();
            }
            this.component_done();
            Ending ending = new Ending(String.valueOf(++this.otherId));
            skel = new GenericSkeleton();
            ending.setSkeleton(skel);
            String tail = this.getFileTail();
            if (!Util.isEmpty(tail) && skel != null) {
                skel.append(tail);
            }
            this.parseState = 0;
            return new Event(EventType.END_DOCUMENT, ending);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    protected final boolean sendEvent(EventType eventType, IResource res) {
        return this.sendEvent(-1, eventType, res);
    }

    protected final GenericSkeleton getActiveSkeleton() {
        if (this.queue == null) {
            return null;
        }
        if (Util.isEmpty(this.queue)) {
            return null;
        }
        Event event = this.queue.getLast();
        if (event == null) {
            return null;
        }
        if (event.getEventType() == EventType.PIPELINE_PARAMETERS) {
            return null;
        }
        IResource res = event.getResource();
        if (res == null) {
            return null;
        }
        ISkeleton skel = res.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            res.setSkeleton(skel);
        }
        if (!(skel instanceof GenericSkeleton)) {
            return null;
        }
        return (GenericSkeleton)skel;
    }

    protected final GenericSkeleton getHeadSkeleton() {
        if (this.queue == null) {
            return null;
        }
        if (Util.isEmpty(this.queue)) {
            return null;
        }
        Event event = this.queue.getFirst();
        if (event == null) {
            return null;
        }
        IResource res = event.getResource();
        if (res == null) {
            return null;
        }
        ISkeleton skel = res.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            res.setSkeleton(skel);
        }
        if (!(skel instanceof GenericSkeleton)) {
            return null;
        }
        return (GenericSkeleton)skel;
    }

    protected final int getQueueSize() {
        return this.queue.size();
    }

    protected final boolean sendEvent(int index, EventType eventType, IResource res) {
        Event event = new Event(eventType, res);
        int saveSize = this.queue.size();
        boolean result = false;
        if (res != null && Util.isEmpty(res.getId())) {
            if (event.getEventType() == EventType.TEXT_UNIT) {
                res.setId(String.valueOf(++this.tuId));
            } else {
                res.setId(String.valueOf(++this.otherId));
            }
        }
        if (index == -1) {
            this.queue.add(event);
            result = this.queue.size() > saveSize;
            return result;
        }
        this.queue.add(index, event);
        result = this.queue.size() > saveSize;
        return result;
    }

    private boolean getNextLine() throws IOException {
        if (this.reader.markSupported() && this.reader.ready()) {
            this.reader.mark(1024);
        }
        this.lineRead = this.reader.readLine();
        if (this.lineRead != null) {
            ++this.lineNumber;
        }
        return this.lineRead != null;
    }

    private String getFileTail() throws IOException {
        if (!this.reader.markSupported()) {
            return "";
        }
        String st = null;
        try {
            this.reader.reset();
            st = this.reader.readLine();
        }
        catch (Exception e) {
            return "";
        }
        if (st == null) {
            return "";
        }
        this.reader.reset();
        char[] buf = new char[st.length() + 100];
        int count = this.reader.read(buf);
        if (count != -1) {
            return new String(buf).substring(st.length(), count);
        }
        return "";
    }

    protected final String getLineBreak() {
        return this.lineBreak;
    }

    protected final void addLineBreak() {
        GenericSkeleton skel = this.getActiveSkeleton();
        if (skel != null) {
            skel.append(this.lineBreak);
        }
    }
}

