/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.scorer;

import gnu.trove.map.hash.TIntIntHashMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetIterator;

public class SimpleConcordanceFuzzyScorer
extends Scorer {
    private List<Term> terms;
    private IndexReader reader;
    private float threshold;
    private float score;
    private int currentDoc;
    private int roughThresholdFreq;
    private OpenBitSetIterator docPointerIterator;
    private TIntIntHashMap scoredDocs;
    private int uniqueTermSize;

    public SimpleConcordanceFuzzyScorer(float threshold, Similarity similarity, List<Term> terms, IndexReader reader) throws IOException {
        super(similarity);
        this.reader = reader;
        this.threshold = threshold;
        this.terms = terms;
        this.scoredDocs = new TIntIntHashMap();
        this.currentDoc = -1;
    }

    private void calculateScores() throws IOException {
        OpenBitSet docPointers = new OpenBitSet(this.reader.maxDoc());
        LinkedList<Term> uniqueTerms = new LinkedList<Term>(new LinkedHashSet<Term>(this.terms));
        this.uniqueTermSize = uniqueTerms.size();
        this.roughThresholdFreq = (int)((float)this.uniqueTermSize * (this.threshold * 0.01f));
        Iterator iter = uniqueTerms.iterator();
        while (iter.hasNext()) {
            TermPositions tp = this.reader.termPositions((Term)iter.next());
            Throwable throwable = null;
            try {
                while (tp.next()) {
                    int f = this.scoredDocs.adjustOrPutValue(tp.doc(), 1, 1);
                    if (f <= this.roughThresholdFreq) continue;
                    docPointers.fastSet(tp.doc());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tp == null) continue;
                if (throwable != null) {
                    try {
                        tp.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tp.close();
            }
        }
        if (docPointers.cardinality() > 0L) {
            this.docPointerIterator = (OpenBitSetIterator)docPointers.iterator();
        }
    }

    @Override
    public int advance(int target) throws IOException {
        if (target == Integer.MAX_VALUE) {
            this.currentDoc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        while ((this.currentDoc = this.nextDoc()) < target) {
        }
        return this.currentDoc;
    }

    @Override
    public float score() throws IOException {
        return this.score;
    }

    public boolean scoresDocsOutOfOrder() {
        return false;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docPointerIterator == null) {
            this.calculateScores();
            if (this.docPointerIterator == null) {
                this.currentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
        }
        do {
            this.currentDoc = this.docPointerIterator.nextDoc();
            if (this.currentDoc != Integer.MAX_VALUE) continue;
            return this.currentDoc;
        } while (!(this.calculateScore() >= this.threshold));
        return this.currentDoc;
    }

    private float calculateScore() throws IOException {
        this.score = (float)this.scoredDocs.get(this.currentDoc) / (float)this.uniqueTermSize * 100.0f;
        return this.score;
    }

    @Override
    public int docID() {
        return this.currentDoc;
    }
}

