/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;

class AlignedParagraphs {
    private List<List<ITextUnit>> sourceParas = new LinkedList<List<ITextUnit>>();
    private List<List<ITextUnit>> targetParas = new LinkedList<List<ITextUnit>>();
    private List<ITextUnit> alignedParas = new LinkedList<ITextUnit>();
    private LocaleId targetLocale;

    public AlignedParagraphs(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public void addAlignment(ITextUnit srcTu, ITextUnit trgTu) {
        LinkedList<ITextUnit> srcParas = new LinkedList<ITextUnit>();
        if (srcTu != null) {
            srcParas.add(srcTu);
        }
        LinkedList<ITextUnit> trgParas = new LinkedList<ITextUnit>();
        if (trgTu != null) {
            trgParas.add(trgTu);
        }
        this.sourceParas.add(srcParas);
        this.targetParas.add(trgParas);
    }

    public void addAlignment(List<ITextUnit> srcTus, List<ITextUnit> trgTus) {
        this.sourceParas.add(srcTus);
        this.targetParas.add(trgTus);
    }

    public List<ITextUnit> align() {
        for (List<ITextUnit> stus : this.sourceParas) {
            ITextUnit stu = null;
            List<ITextUnit> ttus = this.targetParas.remove(0);
            if (stus != null) {
                stu = this.combineTextUnits(stus);
                if (ttus != null) {
                    stu = this.addTargetTextUnitAsTarget(stu, this.combineTextUnits(ttus), this.targetLocale);
                }
            } else if (ttus != null) {
                ITextUnit tempTarget = this.combineTextUnits(ttus);
                tempTarget.createTarget(this.targetLocale, true, 7);
                tempTarget.setSource(null);
                stu = tempTarget;
            }
            this.alignedParas.add(stu);
        }
        return this.alignedParas;
    }

    private ITextUnit combineTextUnits(List<ITextUnit> tus) {
        Iterator<ITextUnit> its = tus.iterator();
        ITextUnit tuNew = its.next().clone();
        TextContainer tcAligned = tuNew.getSource();
        while (its.hasNext()) {
            ITextUnit tu2combin = its.next();
            TextContainer tcSource = tu2combin.getSource();
            tcSource.joinAll();
            ISegments segs2add = tcSource.getSegments();
            Iterator<Segment> itSeg = segs2add.iterator();
            while (itSeg.hasNext()) {
                String sCurNoTrim = tcAligned.toString();
                String sCur = sCurNoTrim.trim();
                int lonny = sCur.length();
                if (lonny > 0) {
                    String cLast = sCur.substring(lonny - 1);
                    if (sCur.equals(sCurNoTrim)) {
                        if (cLast.equals("!") || cLast.equals(".") || cLast.equals("?")) {
                            tcAligned.append(" ");
                        } else {
                            tcAligned.append(". ");
                        }
                    }
                }
                tcAligned.append(itSeg.next().getContent());
            }
        }
        tcAligned.joinAll();
        return tuNew;
    }

    private ITextUnit addTargetTextUnitAsTarget(ITextUnit tuSource, ITextUnit tuTarget, LocaleId targetLocale) {
        tuSource.setTarget(targetLocale, tuTarget.getSource());
        return tuSource;
    }
}

