/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.rainbowkit.RainbowKitFilter;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.processor.DefaultEventHandler;
import net.sf.okapi.lib.xliff2.processor.IEventHandler;
import net.sf.okapi.lib.xliff2.processor.XLIFFProcessor;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.rainbowkit.creation.ExtractionStep;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;
import net.sf.okapi.steps.rainbowkit.postprocess.MergingStep;

public class Main {
    static LocaleId locEN = LocaleId.ENGLISH;
    static LocaleId locFR = LocaleId.fromString((String)"fr");
    static String root;

    public static void main(String[] args) throws URISyntaxException {
        URL inputUrl = Main.class.getResource("myDoc.docx");
        File inputFile = new File(inputUrl.toURI());
        root = inputFile.getParent();
        Main.extract(inputFile);
        File xliffFile = new File(root + File.separator + "pack1" + File.separator + "work" + File.separator + inputFile.getName() + ".xlf");
        Main.modifyXLIFF(xliffFile);
        File manifestFile = new File(root + File.separator + "pack1" + File.separator + "manifest.rkm");
        Main.merge(manifestFile);
    }

    private static void extract(File inputFile) {
        try {
            IPipelineDriver driver = Main.createDriver(root);
            driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
            ExtractionStep extStep = new ExtractionStep();
            Parameters params = (Parameters)extStep.getParameters();
            params.setWriterClass("net.sf.okapi.steps.rainbowkit.xliff.XLIFF2PackageWriter");
            driver.addStep((IPipelineStep)extStep);
            RawDocument rawDoc = new RawDocument(inputFile.toURI(), "UTF-8", locEN, locFR, "okf_openxml");
            String path = inputFile.getAbsolutePath();
            String outputPath = Util.getDirectoryName((String)path) + File.separator + Util.getFilename((String)path, (boolean)false) + ".out" + Util.getExtension((String)path);
            File outputFile = new File(outputPath);
            BatchItemContext item = new BatchItemContext(rawDoc, outputFile.toURI(), "UTF-8");
            driver.addBatchItem((IBatchItemContext)item);
            driver.processBatch();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void modifyXLIFF(File file) {
        try {
            XLIFFProcessor proc = new XLIFFProcessor();
            proc.add((IEventHandler)new DefaultEventHandler(){

                public Event handleUnit(Event event) {
                    Unit unit = event.getUnit();
                    for (Segment segment : unit.getSegments()) {
                        if (segment.getSource().isEmpty()) continue;
                        segment.getTarget(Part.GetTarget.CLONE_SOURCE).append((CharSequence)" blah blah...");
                    }
                    return event;
                }
            });
            File tmpFile = new File(file.getAbsolutePath() + ".tmp");
            proc.run(file, tmpFile);
            file.delete();
            tmpFile.renameTo(file);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static void merge(File manifestFile) {
        try {
            IPipelineDriver driver = Main.createDriver(root);
            driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
            driver.addStep((IPipelineStep)new MergingStep());
            RawDocument rawDoc = new RawDocument(manifestFile.toURI(), "UTF-8", locEN, locFR, "okf_rainbowkit-noprompt");
            driver.addBatchItem(new RawDocument[]{rawDoc});
            driver.processBatch();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static IPipelineDriver createDriver(String root) {
        PipelineDriver driver = new PipelineDriver();
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations(OpenXMLFilter.class.getName());
        fcMapper.addConfigurations(RainbowKitFilter.class.getName());
        driver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        driver.setRootDirectories(root, root);
        driver.setOutputDirectory(root);
        return driver;
    }
}

