/*===========================================================================
  Copyright (C) 2011 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.lib.xliff;

public class Part {

	protected String id;
	protected Fragment source;
	protected Fragment target;
	protected int targetOrder;
	
	public Part () {
		source = new Fragment();
	}
	
	public Part (Fragment source) {
		this.source = source;
	}
	
	public Part (String sourceContent) {
		source = new Fragment(sourceContent);
	}
	
	public String getId () {
		return id;
	}
	
	public void setId (String id) {
		this.id = id;
	}
	
	public Fragment getSource () {
		return source;
	}
	
	public Fragment setSource (Fragment fragment) {
		source = fragment;
		return source;
	}
	
	public boolean hasTarget () {
		return (target != null);
	}

	public Fragment getTarget () {
		return target;
	}
	
	public Fragment setTarget (Fragment fragment) {
		target = fragment;
		return target;
	}
	
	public void setTargetOrder (int targetOrder) {
		this.targetOrder = targetOrder;
	}
	
}
