package net.sf.okapi.common;

/**
 * An extensive list of {@link LocaleId}s predefined for easy access. 
 * 
 * @author hargraveje
 * 
 */
public interface IPredefinedLocales {
	static public final LocaleId Afrikaans = new LocaleId("af_ZA", true);
	static public final LocaleId Albanian = new LocaleId("sq_AL", true);
	static public final LocaleId Amharic = new LocaleId("amh_ET", true);
	static public final LocaleId Armenian = new LocaleId("hy_AM", true);
	static public final LocaleId Aymara = new LocaleId("ayc_PE", true);
	
	static public final LocaleId Basque = new LocaleId("eu_ES", true);
	static public final LocaleId Bikolano = new LocaleId("bik_PH", true);
	static public final LocaleId Bislama = new LocaleId("bis_VU", true);
	static public final LocaleId Bulgarian = new LocaleId("bg_BG", true);
	static public final LocaleId Burmese = new LocaleId("mya_MM", true);
	
	static public final LocaleId Cebuano = new LocaleId("ceb_PH", true);
	static public final LocaleId Chuukese = new LocaleId("chk_FM", true);
	static public final LocaleId Croatian = new LocaleId("hr_HR", true);
	static public final LocaleId Czech = new LocaleId("cs_CZ", true);
	
	static public final LocaleId Danish = new LocaleId("da_DK", true);
	static public final LocaleId Dutch = new LocaleId("nl_NL", true);
	
	static public final LocaleId Efik = new LocaleId("efi_NG", true);
	static public final LocaleId Estonian = new LocaleId("et_EE", true);
	
	static public final LocaleId Fante = new LocaleId("fan_GH", true);
	static public final LocaleId Fijian = new LocaleId("fij_FJ", true);
	static public final LocaleId Finnish = new LocaleId("fi_FI", true);
	
	static public final LocaleId Georgian = new LocaleId("ka_GE", true);
	static public final LocaleId Greek = new LocaleId("el_GR", true);
	static public final LocaleId Guarani = new LocaleId("gug_PY", true);
	
	static public final LocaleId Haitian = new LocaleId("hat_HT", true);
	static public final LocaleId Hiligaynon = new LocaleId("hil_PH", true);
	static public final LocaleId Hindi = new LocaleId("hi_IN", true);
	static public final LocaleId Hindi_Fiji = new LocaleId("hin_FJ", true);
	static public final LocaleId Hmong = new LocaleId("mww_CN", true);
	static public final LocaleId Hungarian = new LocaleId("hu_HU", true);
	
	static public final LocaleId Iban = new LocaleId("iba_MY", true);
	static public final LocaleId Icelandic = new LocaleId("is_IS", true);
	static public final LocaleId Igbo = new LocaleId("ib_NG", true);
	static public final LocaleId Ilocano = new LocaleId("ilo_PH", true);
	static public final LocaleId Indonesian = new LocaleId("id_ID", true);
	
	static public final LocaleId Kannada = new LocaleId("kn_IN", true);
	static public final LocaleId Kazakh = new LocaleId("kk_KZ", true);
	static public final LocaleId Kekchi = new LocaleId("kek_GT", true);
	static public final LocaleId Khmer = new LocaleId("khm_KH", true);
	static public final LocaleId Kirghiz = new LocaleId("ky_KG", true);
	static public final LocaleId Kiribati = new LocaleId("gil_KI", true);
	static public final LocaleId Korean = new LocaleId("ko_KR", true);
	static public final LocaleId Kosraean = new LocaleId("kos_FM", true);
	
	static public final LocaleId Lao = new LocaleId("lo_LA", true);
	static public final LocaleId Latvian = new LocaleId("lv_LV", true);
	static public final LocaleId Lingala = new LocaleId("lin_CD", true);
	static public final LocaleId Lithuanian = new LocaleId("lt_LT", true);
		
	static public final LocaleId Macedonian = new LocaleId("mk_MK", true);
	static public final LocaleId Malagasy = new LocaleId("msh_MG", true);
	static public final LocaleId Malay_Malaysia = new LocaleId("ms_MY", true);
	static public final LocaleId Malayalam = new LocaleId("ml_IN", true);
	static public final LocaleId Maltese = new LocaleId("mt_MT", true);
	static public final LocaleId Mam = new LocaleId("mvc_GT", true);
	static public final LocaleId Marshallese = new LocaleId("mah_MH", true);
	static public final LocaleId Mongolian = new LocaleId("mn_MN", true);
	
	static public final LocaleId Navajo = new LocaleId("nav_US", true);
	static public final LocaleId Neomelanesian = new LocaleId("tpi_PG", true); // Tok Pisin
	static public final LocaleId Norwegian = new LocaleId("no_NO", true);
	
	static public final LocaleId Palauan = new LocaleId("pau_PW", true);
	static public final LocaleId Pohnpeian = new LocaleId("pon_FM", true);
	static public final LocaleId Polish = new LocaleId("pl_PL", true);
	
	static public final LocaleId Quechua = new LocaleId("qul_BO", true); // Bolivia
	static public final LocaleId Quichua = new LocaleId("qur_EC", true); // Ecuador
	
	static public final LocaleId Rarotongan = new LocaleId("rar_CK", true);
	static public final LocaleId Romanian = new LocaleId("ro_RO", true);
	static public final LocaleId Rwanda = new LocaleId("kin_RW", true);
	
	static public final LocaleId Samoan = new LocaleId("smo_WS", true);
	static public final LocaleId Serbian = new LocaleId("sr_SP", true);	
	static public final LocaleId Shona = new LocaleId("sna_ZW", true);
	static public final LocaleId Slovak = new LocaleId("sk_SK", true);
	static public final LocaleId Slovenian = new LocaleId("sl_SI", true);
	static public final LocaleId South_Sotho = new LocaleId("sot_LS", true); // Sesotho
	static public final LocaleId Swahili = new LocaleId("sw_KE", true);
	static public final LocaleId Swedish = new LocaleId("sv_SE", true);
	
	static public final LocaleId Tagalog = new LocaleId("tgl_PH", true);	
	static public final LocaleId Tahitian = new LocaleId("tah_PF", true);
	static public final LocaleId Thai = new LocaleId("th_TH", true);
	static public final LocaleId Tongan = new LocaleId("ton_TO", true);
	static public final LocaleId Tswana = new LocaleId("tsn_BW", true);
	static public final LocaleId Turkish = new LocaleId("tr_TR", true);
	
	static public final LocaleId Twi = new LocaleId("twi_GH", true);
	
	static public final LocaleId Ukrainian = new LocaleId("uk_UA", true);
	
	static public final LocaleId Vietnamese = new LocaleId("vi_VN", true);
	
	static public final LocaleId Waray = new LocaleId("war_PH", true); // aka Samarnon, Warai
	
	static public final LocaleId Xhosa = new LocaleId("xho_ZA", true);
	
	static public final LocaleId Yapese = new LocaleId("yap_FM", true);
	static public final LocaleId Yoruba = new LocaleId("yor_NG", true);
	static public final LocaleId Yupik = new LocaleId("ess_US", true);	
	
	static public final LocaleId Zulu = new LocaleId("zu_ZA", true);
}
