/*===========================================================================
  Copyright (C) 2011-2012 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.filters.txml;

import net.sf.okapi.common.annotation.IAnnotation;

public class TXMLSegAnnotation implements IAnnotation {

	private String value;

	/**
	 * Create a new TXMLSegAnnotation object.
	 * @param value the value: 'b'=ws before, 'a'=ws after, 'ba'=ws before and after
	 */
	public TXMLSegAnnotation (String value) {
		this.value = (value==null ? "" : value);
	}
	
	public boolean hasWSBefore () {
		return (value.indexOf('b') > -1);
	}
	
	public boolean hasWSAfter () {
		return (value.indexOf('a') > -1);
	}
	
	@Override
	public String toString () {
		return value;
	}

}
