/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.application;

import java.util.Collection;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.eclipse.rwt.engine.RWTServlet;
import org.eclipse.rwt.internal.application.ApplicationContext;
import org.eclipse.rwt.internal.engine.RWTClusterSupport;
import org.eclipse.rwt.internal.lifecycle.SimpleLifeCycle;

class SessionFailoverConfigurator {
    private final ApplicationContext applicationContext;
    private final ServletContext servletContext;

    SessionFailoverConfigurator(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.servletContext = applicationContext.getServletContext();
    }

    void configure() {
        this.checkServletVersion();
        ServletRegistration servletRegistration = this.findRWTServletRegistration();
        this.checkRWTServletRegistration(servletRegistration);
        this.configureJEECompatibility();
        this.configureSessionFailoverFilter(servletRegistration);
    }

    private void configureJEECompatibility() {
        this.applicationContext.getLifeCycleFactory().configure(SimpleLifeCycle.class);
    }

    private void configureSessionFailoverFilter(ServletRegistration servletRegistration) {
        FilterRegistration.Dynamic filterRegistration = this.registerSessionFailoverFilter();
        SessionFailoverConfigurator.mapFilterToServlet((FilterRegistration)filterRegistration, servletRegistration);
    }

    private FilterRegistration.Dynamic registerSessionFailoverFilter() {
        RWTClusterSupport filter = new RWTClusterSupport();
        String filterName = filter.getClass().getName();
        return this.servletContext.addFilter(filterName, (Filter)filter);
    }

    private static void mapFilterToServlet(FilterRegistration filterRegistration, ServletRegistration servletRegistration) {
        EnumSet<DispatcherType> dispatcherType = EnumSet.of(DispatcherType.REQUEST);
        String servletName = servletRegistration.getName();
        filterRegistration.addMappingForServletNames(dispatcherType, false, new String[]{servletName});
    }

    private void checkServletVersion() {
        if (this.servletContext.getMajorVersion() < 3) {
            throw new IllegalStateException("Session failover support requires Servlet 3.0 or later.");
        }
    }

    private void checkRWTServletRegistration(ServletRegistration servletRegistration) {
        if (servletRegistration == null) {
            throw new IllegalStateException("The RWT servlet registration could not be found.");
        }
    }

    private ServletRegistration findRWTServletRegistration() {
        ServletRegistration result = null;
        ServletRegistration[] servletRegistrations = this.getSerlvetRegistrations();
        int i = 0;
        while (result == null && i < servletRegistrations.length) {
            if (RWTServlet.class.getName().equals(servletRegistrations[i].getClassName())) {
                result = servletRegistrations[i];
            }
            ++i;
        }
        return result;
    }

    private ServletRegistration[] getSerlvetRegistrations() {
        Collection servletRegistrations = this.servletContext.getServletRegistrations().values();
        return servletRegistrations.toArray(new ServletRegistration[servletRegistrations.size()]);
    }
}

