package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.xml.stream.XMLInputFactory;

import net.sf.okapi.filters.openxml.Relationships.Rel;

import org.junit.*;
import static org.junit.Assert.*;

public class TestRelationships {
	private XMLInputFactory factory = XMLInputFactory.newInstance();
	
	@Test
	public void testBasicRels() throws Exception {
		Reader reader = getReader("/presentation.xml.rels");
		Relationships rels = new Relationships(factory);
		rels.parseFromXML("/ppt/_rels/presentation.xml.rels", reader);
		reader.close();
		checkRel(rels, "/ppt/presProps.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/presProps", "rId2");
		checkRel(rels, "/ppt/theme/theme2.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme", "rId1");
		checkRel(rels, "/ppt/slideMasters/slideMaster1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideMaster", "rId4");
		checkRel(rels, "/ppt/tableStyles.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/tableStyles", "rId3");
		checkRel(rels, "/ppt/slides/slide4.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", "rId9");
		checkRel(rels, "/ppt/slides/slide1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", "rId6");
		checkRel(rels, "/ppt/notesMasters/notesMaster1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesMaster", "rId5");
		checkRel(rels, "/ppt/slides/slide3.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", "rId8");
		checkRel(rels, "/ppt/slides/slide2.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", "rId7");
	}
	
	@Test
	public void testNormalizedRels() throws Exception {
		Reader reader = getReader("/slide1.xml.rels");
		Relationships rels = new Relationships(factory);
		rels.parseFromXML("/ppt/slides/_rels/slide1.xml.rels", reader);
		reader.close();
		checkRel(rels, "/ppt/notesSlides/notesSlide1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesSlide", "rId2");
		checkRel(rels, "/ppt/slideLayouts/slideLayout1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout", "rId1");
	}
	
	private Reader getReader(String resource) throws IOException {
		InputStream input = getClass().getResourceAsStream(resource);
		return new InputStreamReader(input, "UTF-8");
	}
	
	private void checkRel(Relationships rels, String target, String type, String id) {
		Rel r = rels.getRelById(id);
		assertNotNull(r);
		assertEquals(target, r.target);
		assertEquals(type, r.type);
		assertEquals(id, r.id);
	}
}
