/*===========================================================================
  Copyright (C) 2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.events.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Representation of a <its:provenanceRecords> element.
 */
public class ITSProvenanceCollection {

	private final Logger logger = LoggerFactory.getLogger(getClass());
	private String resource;
	private String xmlid, xmlns, version;
	private LinkedList<ITSProvenance> records = new LinkedList<ITSProvenance>();

	public ITSProvenanceCollection(Iterator<Attribute> attrs, String resource) {
		this.resource = resource;
		while (attrs.hasNext()) {
			Attribute attr = attrs.next();
			String prefix = attr.getName().getPrefix();
			String name = attr.getName().getLocalPart();
			String value = attr.getValue();
			if (!prefix.isEmpty()) {
				name = prefix + ":" + name;
			}

			if (name.equals("xml:id")) {
				xmlid = value;
			} else if (name.equals("xmlns:its")) {
				xmlns = value;
			} else if (name.equals("version")) {
				version = value;
			} else {
				logger.warn("Unrecognized attribute: " + name);
			}
		}
	}

	public void addProv(Iterator<Attribute> attrs) {
		records.add(new ITSProvenance(attrs));
	}

	public String getXMLId() {
		return this.xmlid;
	}

	public String getURI() {
		return this.resource + "#" + this.xmlid;
	}

	public Iterator<ITSProvenance> iterator() {
		return records.iterator();
	}
}
