/*===========================================================================
  Copyright (C) 2008-2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.lib.preprocessing.filters.simplification;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(Parameters.class)
public class Parameters extends BaseParameters implements IEditorDescriptionProvider {

	private String filterConfigId; // Config ID of the internal filter 
	private boolean simplifyResources; // Simplify filter resources 
	private boolean simplifyCodes; // Simplify inline codes
	
	public Parameters() {
		reset();
		toString();
	}
	
	@Override
	public void reset() {
		filterConfigId = "okf_xmlstream";
		simplifyResources = true;
		simplifyCodes = false;
	}

	@Override
	public void fromString(String data) {
		reset();
		buffer.fromString(data);
		filterConfigId = buffer.getString("filterConfigId", filterConfigId);
		simplifyResources = buffer.getBoolean("simplifyResources", simplifyResources);
		simplifyCodes = buffer.getBoolean("simplifyCodes", simplifyCodes);
	}
	
	@Override
	public String toString() {
		buffer.reset();
		buffer.setString("filterConfigId", filterConfigId);
		buffer.setBoolean("simplifyResources", simplifyResources);
		buffer.setBoolean("simplifyCodes", simplifyCodes);
		return buffer.toString();
	}

	public String getFilterConfigId() {
		return filterConfigId;
	}

	public void setFilterConfigId(String filterConfigId) {
		this.filterConfigId = filterConfigId;
	}

	public boolean isSimplifyResources() {
		return simplifyResources;
	}

	public void setSimplifyResources(boolean simplifyResources) {
		this.simplifyResources = simplifyResources;
	}

	public boolean isSimplifyCodes() {
		return simplifyCodes;
	}

	public void setSimplifyCodes(boolean simplifyCodes) {
		this.simplifyCodes = simplifyCodes;
	}
	
	@Override
	public ParametersDescription getParametersDescription() {
		ParametersDescription desc = new ParametersDescription(this);
		desc.add("filterConfigId", "Filter configuration ID", null);
		desc.add("simplifyResources", "Simplify resources", "Simplify resources generated by the filter removing references in resources (resource flattening)");
		desc.add("simplifyCodes", "Simplify codes", "Merge adjacent inline codes in the source part of a text unit, moves leading and trailing codes to the skeleton");
		return desc;
	}
	
	@Override
	public EditorDescription createEditorDescription(
			ParametersDescription parametersDescription) {
		EditorDescription desc = new EditorDescription("Simplification Filter Parameters", true, false);
		
		desc.addTextInputPart(parametersDescription.get("filterConfigId"));
		desc.addCheckboxPart(parametersDescription.get("simplifyResources"));
		desc.addCheckboxPart(parametersDescription.get("simplifyCodes"));
		
		return desc;
	}

}
