/*===========================================================================
  Copyright (C) 2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.filters.xliff.its;

import java.util.Iterator;
import javax.xml.stream.events.Attribute;
import net.sf.okapi.common.annotation.GenericAnnotationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Representation of a &lt;its:provenanceRecord/> element.
 */
public class ITSProvenance {
	
	private final Logger logger = LoggerFactory.getLogger(getClass());
	private String person, org, tool, revPerson, revOrg, revTool, provRef;

	public ITSProvenance (Iterator<Attribute> attrs) {
		while (attrs.hasNext()) {
			Attribute attr = attrs.next();
			String prefix = attr.getName().getPrefix();
			String name = attr.getName().getLocalPart();
			String value = attr.getValue();
			if ( !prefix.isEmpty() && !prefix.equals("its") ) {
				name = prefix + ":" + name;
			}

			if ( name.equals("person") ) {
				setPerson(value);
			}
			else if ( name.equals("personRef") ) {
				setPerson(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("org") ) {
				setOrg(value);
			}
			else if ( name.equals("orgRef") ) {
				setOrg(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("tool") ) {
				setTool(value);
			}
			else if ( name.equals("toolRef") ) {
				setTool(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("revPerson") ) {
				setRevPerson(value);
			}
			else if ( name.equals("revPersonRef") ) {
				setRevPerson(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("revOrg") ) {
				setRevOrg(value);
			}
			else if ( name.equals("revOrgRef") ) {
				setRevOrg(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("revTool") ) {
				setRevTool(value);
			}
			else if ( name.equals("revToolRef") ) {
				setRevTool(GenericAnnotationType.REF_PREFIX + value);
			}
			else if ( name.equals("provRef") ) {
				this.provRef = value;
			}
			else {
				logger.warn("Unrecognized ITS Provenance attribute: " + name);
			}
		}
	}

	public String getPerson() {
		return person;
	}

	public final void setPerson(String person) {
		if (this.person != null) {
			logger.warn("Provenance person redefined from \"" + this.person
				+ "\" to \"" + person + "\"");
		}
		this.person = person;
	}

	public String getOrg() {
		return org;
	}

	public final void setOrg(String org) {
		if (this.org != null) {
			logger.warn("Provenance org redefined from \"" + this.org
				+ "\" to \"" + org + "\"");
		}
		this.org = org;
	}

	public String getTool() {
		return tool;
	}

	public final void setTool(String tool) {
		if (this.tool != null) {
			logger.warn("Provenance tool redefined from \"" + this.tool
				+ "\" to \"" + tool + "\"");
		}
		this.tool = tool;
	}

	public String getRevPerson() {
		return revPerson;
	}

	public final void setRevPerson(String revPerson) {
		if (this.revPerson != null) {
			logger.warn("Provenance revPerson redefined from \"" + this.revPerson
				+ "\" to \"" + revPerson + "\"");
		}
		this.revPerson = revPerson;
	}

	public String getRevOrg() {
		return revOrg;
	}

	public final void setRevOrg(String revOrg) {
		if (this.revOrg != null) {
			logger.warn("Provenance revOrg redefined from \"" + this.revOrg
				+ "\" to \"" + revOrg + "\"");
		}
		this.revOrg = revOrg;
	}

	public String getRevTool() {
		return revTool;
	}

	public final void setRevTool(String revTool) {
		if (this.revTool != null) {
			logger.warn("Provenance revTool redefined from \"" + this.revTool
				+ "\" to \"" + revTool + "\"");
		}
		this.revTool = revTool;
	}

	public String getProvRef() {
		return provRef;
	}
}
