/*===========================================================================
  Copyright (C) 2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.steps.inconsistencycheck;

import java.io.File;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;

@EditorFor(Parameters.class)
public class Parameters extends BaseParameters implements IEditorDescriptionProvider {

    private static final String CHECKINCONSISTENCIES = "checkInconststencies";
    private static final String CHECKPERFILE = "checkPerFile";
    private static final String OUTPUTPATH = "outputPath";
    private static final String DISPLAYOPTION = "displayOption";
    private static final String AUTOOPEN = "autoOpen";
    
    public static final String DISPLAYOPTION_ORIGINAL = "original";
    public static final String DISPLAYOPTION_GENERIC = "generic";
    public static final String DISPLAYOPTION_PLAIN = "plain";
    
    private boolean checkInconststencies;
    private boolean checkPerFile;
    private String outputPath;
    private String displayOption;
    private boolean autoOpen;

    public Parameters() {
        reset();
    }

    public boolean getCheckInconststencies () {
    	return checkInconststencies;
    }
    
    public void setCheckInconststencies (boolean checkInconststencies) {
    	this.checkInconststencies = checkInconststencies;
    }
    
    public boolean getCheckPerFile() {
        return this.checkPerFile;
    }

    public void setCheckPerFile(boolean checkPerFile) {
        this.checkPerFile = checkPerFile;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getDisplayOption () {
        return this.displayOption;
    }
    
    public void setDisplayOption (String displayOption) {
        this.displayOption = displayOption;
    }

    public boolean isAutoOpen() {
        return autoOpen;
    }

    public void setAutoOpen(boolean autoOpen) {
        this.autoOpen = autoOpen;
    }

    @Override
    public void reset() {
    	checkInconststencies = true;
        checkPerFile = false;
        outputPath = Util.ROOT_DIRECTORY_VAR + File.separator + "inconsistency-report.xml";
        displayOption = DISPLAYOPTION_GENERIC;
        autoOpen = true;
    }

    @Override
    public void fromString(String data) {
        reset();
        buffer.fromString(data);
        checkInconststencies = buffer.getBoolean(CHECKINCONSISTENCIES, checkInconststencies);
        checkPerFile = buffer.getBoolean(CHECKPERFILE, checkPerFile);
        outputPath = buffer.getString(OUTPUTPATH, outputPath);
        displayOption = buffer.getString(DISPLAYOPTION, displayOption);
        autoOpen = buffer.getBoolean(AUTOOPEN, autoOpen);
    }

    @Override
    public String toString() {
        buffer.reset();
        buffer.setBoolean(CHECKINCONSISTENCIES, checkInconststencies);
        buffer.setBoolean(CHECKPERFILE, checkPerFile);
        buffer.setString(OUTPUTPATH, outputPath);
        buffer.setString(DISPLAYOPTION, displayOption);
        buffer.setParameter(AUTOOPEN, autoOpen);
        return buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription () {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CHECKINCONSISTENCIES, "Check inconsistencies", null);
        desc.add(CHECKPERFILE, "Check for inconsistencies on a file-by-file basis", null);
        desc.add(OUTPUTPATH, "Path of the report file:", null);
        desc.add(DISPLAYOPTION, "Representation of the inline codes in the report", null);
        desc.add(AUTOOPEN, "Open the report file after completion", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription (ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Inconsistency Check", true, false);

        CheckboxPart master = desc.addCheckboxPart(paramDesc.get(CHECKINCONSISTENCIES));
        
        CheckboxPart cbp = desc.addCheckboxPart(paramDesc.get(CHECKPERFILE));
        cbp.setMasterPart(master, true);
        
        PathInputPart pip = desc.addPathInputPart(paramDesc.get(OUTPUTPATH), "Inconsistency Report File", true);
        pip.setMasterPart(master, true);
        
        cbp = desc.addCheckboxPart(paramDesc.get(AUTOOPEN));
        cbp.setMasterPart(master, true);
        
        String[] values = {DISPLAYOPTION_ORIGINAL, DISPLAYOPTION_GENERIC, DISPLAYOPTION_PLAIN};
        String[] labels = {"Original codes", "Generic markers", "Plain text"};
		ListSelectionPart lsp = desc.addListSelectionPart(paramDesc.get(DISPLAYOPTION), values);
        lsp.setChoicesLabels(labels);
        lsp.setListType(ListSelectionPart.LISTTYPE_DROPDOWN);
        lsp.setMasterPart(master, true);
        
        return desc;
    }
}
