/*===========================================================================
  Copyright (C) 2011 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  This library is free software; you can redistribute it and/or modify it 
  under the terms of the GNU Lesser General Public License as published by 
  the Free Software Foundation; either version 2.1 of the License, or (at 
  your option) any later version.

  This library is distributed in the hope that it will be useful, but 
  WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser 
  General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License 
  along with this library; if not, write to the Free Software Foundation, 
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

  See also the full LGPL text here: http://www.gnu.org/copyleft/lesser.html
===========================================================================*/

package net.sf.okapi.steps.rainbowkit.omegat;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Options extends BaseParameters implements IEditorDescriptionProvider {

	private static final String PLACEHOLDERMODE = "placeholderMode"; //$NON-NLS-1$
	private static final String ALLOWSEGMENTATION = "allowSegmentation"; //$NON-NLS-1$
	private static final String INCLUDEPOSTPROCESSINGHOOK = "includePostProcessingHook"; //$NON-NLS-1$
	
	private boolean placeholderMode;
	private boolean allowSegmentation;
	private boolean includePostProcessingHook;

	public Options () {
		reset();
	}
	
	@Override
	public void reset() {
		placeholderMode = true;
		allowSegmentation = true;
		includePostProcessingHook = true;
	}

	@Override
	public void fromString (String data) {
		reset();
		buffer.fromString(data);
		placeholderMode = buffer.getBoolean(PLACEHOLDERMODE, placeholderMode);
		allowSegmentation = buffer.getBoolean(ALLOWSEGMENTATION, allowSegmentation);
		includePostProcessingHook = buffer.getBoolean(INCLUDEPOSTPROCESSINGHOOK, includePostProcessingHook);
	}

	@Override
	public String toString () {
		buffer.reset();
		buffer.setParameter(PLACEHOLDERMODE, placeholderMode);
		buffer.setParameter(ALLOWSEGMENTATION, allowSegmentation);
		buffer.setParameter(INCLUDEPOSTPROCESSINGHOOK, includePostProcessingHook);
		return buffer.toString();
	}
	
	public boolean getPlaceholderMode () {
		return placeholderMode;
	}

	public void setPlaceholderMode (boolean placeholderMode) {
		this.placeholderMode = placeholderMode;
	}

	public boolean getAllowSegmentation () {
		return allowSegmentation;
	}
	
	public boolean getIncludePostProcessingHook () {
		return includePostProcessingHook;
	}

	public void setAllowSegmentation (boolean allowSegmentation) {
		this.allowSegmentation = allowSegmentation;
	}
	
	public void setIncludePostProcessingHook (boolean includePostProcessingHook) {
		this.includePostProcessingHook = includePostProcessingHook;
	}
	
	@Override
	public ParametersDescription getParametersDescription() {
		ParametersDescription desc = new ParametersDescription(this);
		desc.add(PLACEHOLDERMODE, "Use <g></g> and <x/> notation", null);
		desc.add(ALLOWSEGMENTATION, "Allow segmentation in the OmegaT project",
			"Allow or not segmentation in the project. Ignored if there is a segmentation step.");
		desc.add(INCLUDEPOSTPROCESSINGHOOK, "Include post-processing hook",
			"Set up the project so that OmegaT's \"Create Translated Documents\" command will "
		  + "automatically trigger Okapi's Translation Kit Post-Processing pipeline.");
		return desc;
	}

	@Override
	public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
		EditorDescription desc = new EditorDescription("OmegaT Project", true, false);
		desc.addCheckboxPart(paramsDesc.get(PLACEHOLDERMODE));
		desc.addCheckboxPart(paramsDesc.get(ALLOWSEGMENTATION));
		desc.addCheckboxPart(paramsDesc.get(INCLUDEPOSTPROCESSINGHOOK));
		return desc;
	}

}
