/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.Hashtable;

public class HTMLCharacterEntities {
    private Hashtable<String, Character> charEntities;

    public void ensureInitialization(boolean includeSpecialChars) {
        if (this.charEntities == null) {
            this.createCharEntitiesTable(includeSpecialChars);
        }
    }

    public int lookupReference(String ref) {
        if (ref == null || ref.length() < 3) {
            return -1;
        }
        return this.lookupName(ref.substring(1, ref.length() - 1));
    }

    public int lookupName(String name) {
        if (this.charEntities.containsKey(name)) {
            return this.charEntities.get(name).charValue();
        }
        return -1;
    }

    public String getName(char value) {
        for (String key : this.charEntities.keySet()) {
            if (value != this.charEntities.get(key).charValue()) continue;
            return key;
        }
        return null;
    }

    private void createCharEntitiesTable(boolean includeSpecialChars) {
        this.charEntities = new Hashtable();
        if (includeSpecialChars) {
            this.charEntities.put("amp", Character.valueOf('&'));
            this.charEntities.put("lt", Character.valueOf('<'));
            this.charEntities.put("apos", Character.valueOf('\''));
            this.charEntities.put("gt", Character.valueOf('>'));
            this.charEntities.put("quot", Character.valueOf('\"'));
        }
        this.charEntities.put("nbsp", Character.valueOf('\u00a0'));
        this.charEntities.put("iexcl", Character.valueOf('\u00a1'));
        this.charEntities.put("cent", Character.valueOf('\u00a2'));
        this.charEntities.put("pound", Character.valueOf('\u00a3'));
        this.charEntities.put("curren", Character.valueOf('\u00a4'));
        this.charEntities.put("yen", Character.valueOf('\u00a5'));
        this.charEntities.put("brvbar", Character.valueOf('\u00a6'));
        this.charEntities.put("sect", Character.valueOf('\u00a7'));
        this.charEntities.put("uml", Character.valueOf('\u00a8'));
        this.charEntities.put("copy", Character.valueOf('\u00a9'));
        this.charEntities.put("ordf", Character.valueOf('\u00aa'));
        this.charEntities.put("laquo", Character.valueOf('\u00ab'));
        this.charEntities.put("not", Character.valueOf('\u00ac'));
        this.charEntities.put("shy", Character.valueOf('\u00ad'));
        this.charEntities.put("reg", Character.valueOf('\u00ae'));
        this.charEntities.put("macr", Character.valueOf('\u00af'));
        this.charEntities.put("deg", Character.valueOf('\u00b0'));
        this.charEntities.put("plusmn", Character.valueOf('\u00b1'));
        this.charEntities.put("sup2", Character.valueOf('\u00b2'));
        this.charEntities.put("sup3", Character.valueOf('\u00b3'));
        this.charEntities.put("acute", Character.valueOf('\u00b4'));
        this.charEntities.put("micro", Character.valueOf('\u00b5'));
        this.charEntities.put("para", Character.valueOf('\u00b6'));
        this.charEntities.put("middot", Character.valueOf('\u00b7'));
        this.charEntities.put("cedil", Character.valueOf('\u00b8'));
        this.charEntities.put("sup1", Character.valueOf('\u00b9'));
        this.charEntities.put("ordm", Character.valueOf('\u00ba'));
        this.charEntities.put("raquo", Character.valueOf('\u00bb'));
        this.charEntities.put("frac14", Character.valueOf('\u00bc'));
        this.charEntities.put("frac12", Character.valueOf('\u00bd'));
        this.charEntities.put("frac34", Character.valueOf('\u00be'));
        this.charEntities.put("iquest", Character.valueOf('\u00bf'));
        this.charEntities.put("Agrave", Character.valueOf('\u00c0'));
        this.charEntities.put("Aacute", Character.valueOf('\u00c1'));
        this.charEntities.put("Acirc", Character.valueOf('\u00c2'));
        this.charEntities.put("Atilde", Character.valueOf('\u00c3'));
        this.charEntities.put("Auml", Character.valueOf('\u00c4'));
        this.charEntities.put("Aring", Character.valueOf('\u00c5'));
        this.charEntities.put("AElig", Character.valueOf('\u00c6'));
        this.charEntities.put("Ccedil", Character.valueOf('\u00c7'));
        this.charEntities.put("Egrave", Character.valueOf('\u00c8'));
        this.charEntities.put("Eacute", Character.valueOf('\u00c9'));
        this.charEntities.put("Ecirc", Character.valueOf('\u00ca'));
        this.charEntities.put("Euml", Character.valueOf('\u00cb'));
        this.charEntities.put("Igrave", Character.valueOf('\u00cc'));
        this.charEntities.put("Iacute", Character.valueOf('\u00cd'));
        this.charEntities.put("Icirc", Character.valueOf('\u00ce'));
        this.charEntities.put("Iuml", Character.valueOf('\u00cf'));
        this.charEntities.put("ETH", Character.valueOf('\u00d0'));
        this.charEntities.put("Ntilde", Character.valueOf('\u00d1'));
        this.charEntities.put("Ograve", Character.valueOf('\u00d2'));
        this.charEntities.put("Oacute", Character.valueOf('\u00d3'));
        this.charEntities.put("Ocirc", Character.valueOf('\u00d4'));
        this.charEntities.put("Otilde", Character.valueOf('\u00d5'));
        this.charEntities.put("Ouml", Character.valueOf('\u00d6'));
        this.charEntities.put("times", Character.valueOf('\u00d7'));
        this.charEntities.put("Oslash", Character.valueOf('\u00d8'));
        this.charEntities.put("Ugrave", Character.valueOf('\u00d9'));
        this.charEntities.put("Uacute", Character.valueOf('\u00da'));
        this.charEntities.put("Ucirc", Character.valueOf('\u00db'));
        this.charEntities.put("Uuml", Character.valueOf('\u00dc'));
        this.charEntities.put("Yacute", Character.valueOf('\u00dd'));
        this.charEntities.put("THORN", Character.valueOf('\u00de'));
        this.charEntities.put("szlig", Character.valueOf('\u00df'));
        this.charEntities.put("agrave", Character.valueOf('\u00e0'));
        this.charEntities.put("aacute", Character.valueOf('\u00e1'));
        this.charEntities.put("acirc", Character.valueOf('\u00e2'));
        this.charEntities.put("atilde", Character.valueOf('\u00e3'));
        this.charEntities.put("auml", Character.valueOf('\u00e4'));
        this.charEntities.put("aring", Character.valueOf('\u00e5'));
        this.charEntities.put("aelig", Character.valueOf('\u00e6'));
        this.charEntities.put("ccedil", Character.valueOf('\u00e7'));
        this.charEntities.put("egrave", Character.valueOf('\u00e8'));
        this.charEntities.put("eacute", Character.valueOf('\u00e9'));
        this.charEntities.put("ecirc", Character.valueOf('\u00ea'));
        this.charEntities.put("euml", Character.valueOf('\u00eb'));
        this.charEntities.put("igrave", Character.valueOf('\u00ec'));
        this.charEntities.put("iacute", Character.valueOf('\u00ed'));
        this.charEntities.put("icirc", Character.valueOf('\u00ee'));
        this.charEntities.put("iuml", Character.valueOf('\u00ef'));
        this.charEntities.put("eth", Character.valueOf('\u00f0'));
        this.charEntities.put("ntilde", Character.valueOf('\u00f1'));
        this.charEntities.put("ograve", Character.valueOf('\u00f2'));
        this.charEntities.put("oacute", Character.valueOf('\u00f3'));
        this.charEntities.put("ocirc", Character.valueOf('\u00f4'));
        this.charEntities.put("otilde", Character.valueOf('\u00f5'));
        this.charEntities.put("ouml", Character.valueOf('\u00f6'));
        this.charEntities.put("divide", Character.valueOf('\u00f7'));
        this.charEntities.put("oslash", Character.valueOf('\u00f8'));
        this.charEntities.put("ugrave", Character.valueOf('\u00f9'));
        this.charEntities.put("uacute", Character.valueOf('\u00fa'));
        this.charEntities.put("ucirc", Character.valueOf('\u00fb'));
        this.charEntities.put("uuml", Character.valueOf('\u00fc'));
        this.charEntities.put("yacute", Character.valueOf('\u00fd'));
        this.charEntities.put("thorn", Character.valueOf('\u00fe'));
        this.charEntities.put("yuml", Character.valueOf('\u00ff'));
        this.charEntities.put("OElig", Character.valueOf('\u0152'));
        this.charEntities.put("oelig", Character.valueOf('\u0153'));
        this.charEntities.put("Scaron", Character.valueOf('\u0160'));
        this.charEntities.put("scaron", Character.valueOf('\u0161'));
        this.charEntities.put("Yuml", Character.valueOf('\u0178'));
        this.charEntities.put("circ", Character.valueOf('\u02c6'));
        this.charEntities.put("tilde", Character.valueOf('\u02dc'));
        this.charEntities.put("ensp", Character.valueOf('\u2002'));
        this.charEntities.put("emsp", Character.valueOf('\u2003'));
        this.charEntities.put("thinsp", Character.valueOf('\u2009'));
        this.charEntities.put("zwnj", Character.valueOf('\u200c'));
        this.charEntities.put("zwj", Character.valueOf('\u200d'));
        this.charEntities.put("lrm", Character.valueOf('\u200e'));
        this.charEntities.put("rlm", Character.valueOf('\u200f'));
        this.charEntities.put("ndash", Character.valueOf('\u2013'));
        this.charEntities.put("mdash", Character.valueOf('\u2014'));
        this.charEntities.put("lsquo", Character.valueOf('\u2018'));
        this.charEntities.put("rsquo", Character.valueOf('\u2019'));
        this.charEntities.put("sbquo", Character.valueOf('\u201a'));
        this.charEntities.put("ldquo", Character.valueOf('\u201c'));
        this.charEntities.put("rdquo", Character.valueOf('\u201d'));
        this.charEntities.put("bdquo", Character.valueOf('\u201e'));
        this.charEntities.put("dagger", Character.valueOf('\u2020'));
        this.charEntities.put("Dagger", Character.valueOf('\u2021'));
        this.charEntities.put("permil", Character.valueOf('\u2030'));
        this.charEntities.put("lsaquo", Character.valueOf('\u2039'));
        this.charEntities.put("rsaquo", Character.valueOf('\u203a'));
        this.charEntities.put("euro", Character.valueOf('\u20ac'));
        this.charEntities.put("fnof", Character.valueOf('\u0192'));
        this.charEntities.put("Alpha", Character.valueOf('\u0391'));
        this.charEntities.put("Beta", Character.valueOf('\u0392'));
        this.charEntities.put("Gamma", Character.valueOf('\u0393'));
        this.charEntities.put("Delta", Character.valueOf('\u0394'));
        this.charEntities.put("Epsilon", Character.valueOf('\u0395'));
        this.charEntities.put("Zeta", Character.valueOf('\u0396'));
        this.charEntities.put("Eta", Character.valueOf('\u0397'));
        this.charEntities.put("Theta", Character.valueOf('\u0398'));
        this.charEntities.put("Iota", Character.valueOf('\u0399'));
        this.charEntities.put("Kappa", Character.valueOf('\u039a'));
        this.charEntities.put("Lambda", Character.valueOf('\u039b'));
        this.charEntities.put("Mu", Character.valueOf('\u039c'));
        this.charEntities.put("Nu", Character.valueOf('\u039d'));
        this.charEntities.put("Xi", Character.valueOf('\u039e'));
        this.charEntities.put("Omicron", Character.valueOf('\u039f'));
        this.charEntities.put("Pi", Character.valueOf('\u03a0'));
        this.charEntities.put("Rho", Character.valueOf('\u03a1'));
        this.charEntities.put("Sigma", Character.valueOf('\u03a3'));
        this.charEntities.put("Tau", Character.valueOf('\u03a4'));
        this.charEntities.put("Upsilon", Character.valueOf('\u03a5'));
        this.charEntities.put("Phi", Character.valueOf('\u03a6'));
        this.charEntities.put("Chi", Character.valueOf('\u03a7'));
        this.charEntities.put("Psi", Character.valueOf('\u03a8'));
        this.charEntities.put("Omega", Character.valueOf('\u03a9'));
        this.charEntities.put("alpha", Character.valueOf('\u03b1'));
        this.charEntities.put("beta", Character.valueOf('\u03b2'));
        this.charEntities.put("gamma", Character.valueOf('\u03b3'));
        this.charEntities.put("delta", Character.valueOf('\u03b4'));
        this.charEntities.put("epsilon", Character.valueOf('\u03b5'));
        this.charEntities.put("zeta", Character.valueOf('\u03b6'));
        this.charEntities.put("eta", Character.valueOf('\u03b7'));
        this.charEntities.put("theta", Character.valueOf('\u03b8'));
        this.charEntities.put("iota", Character.valueOf('\u03b9'));
        this.charEntities.put("kappa", Character.valueOf('\u03ba'));
        this.charEntities.put("lambda", Character.valueOf('\u03bb'));
        this.charEntities.put("mu", Character.valueOf('\u03bc'));
        this.charEntities.put("nu", Character.valueOf('\u03bd'));
        this.charEntities.put("xi", Character.valueOf('\u03be'));
        this.charEntities.put("omicron", Character.valueOf('\u03bf'));
        this.charEntities.put("pi", Character.valueOf('\u03c0'));
        this.charEntities.put("rho", Character.valueOf('\u03c1'));
        this.charEntities.put("sigmaf", Character.valueOf('\u03c2'));
        this.charEntities.put("sigma", Character.valueOf('\u03c3'));
        this.charEntities.put("tau", Character.valueOf('\u03c4'));
        this.charEntities.put("upsilon", Character.valueOf('\u03c5'));
        this.charEntities.put("phi", Character.valueOf('\u03c6'));
        this.charEntities.put("chi", Character.valueOf('\u03c7'));
        this.charEntities.put("psi", Character.valueOf('\u03c8'));
        this.charEntities.put("omega", Character.valueOf('\u03c9'));
        this.charEntities.put("thetasym", Character.valueOf('\u03d1'));
        this.charEntities.put("upsih", Character.valueOf('\u03d2'));
        this.charEntities.put("piv", Character.valueOf('\u03d6'));
        this.charEntities.put("bull", Character.valueOf('\u2022'));
        this.charEntities.put("hellip", Character.valueOf('\u2026'));
        this.charEntities.put("prime", Character.valueOf('\u2032'));
        this.charEntities.put("Prime", Character.valueOf('\u2033'));
        this.charEntities.put("oline", Character.valueOf('\u203e'));
        this.charEntities.put("frasl", Character.valueOf('\u2044'));
        this.charEntities.put("weierp", Character.valueOf('\u2118'));
        this.charEntities.put("image", Character.valueOf('\u2111'));
        this.charEntities.put("real", Character.valueOf('\u211c'));
        this.charEntities.put("trade", Character.valueOf('\u2122'));
        this.charEntities.put("alefsym", Character.valueOf('\u2135'));
        this.charEntities.put("larr", Character.valueOf('\u2190'));
        this.charEntities.put("uarr", Character.valueOf('\u2191'));
        this.charEntities.put("rarr", Character.valueOf('\u2192'));
        this.charEntities.put("darr", Character.valueOf('\u2193'));
        this.charEntities.put("harr", Character.valueOf('\u2194'));
        this.charEntities.put("crarr", Character.valueOf('\u21b5'));
        this.charEntities.put("lArr", Character.valueOf('\u21d0'));
        this.charEntities.put("uArr", Character.valueOf('\u21d1'));
        this.charEntities.put("rArr", Character.valueOf('\u21d2'));
        this.charEntities.put("dArr", Character.valueOf('\u21d3'));
        this.charEntities.put("hArr", Character.valueOf('\u21d4'));
        this.charEntities.put("forall", Character.valueOf('\u2200'));
        this.charEntities.put("part", Character.valueOf('\u2202'));
        this.charEntities.put("exist", Character.valueOf('\u2203'));
        this.charEntities.put("empty", Character.valueOf('\u2205'));
        this.charEntities.put("nabla", Character.valueOf('\u2207'));
        this.charEntities.put("isin", Character.valueOf('\u2208'));
        this.charEntities.put("notin", Character.valueOf('\u2209'));
        this.charEntities.put("ni", Character.valueOf('\u220b'));
        this.charEntities.put("prod", Character.valueOf('\u220f'));
        this.charEntities.put("sum", Character.valueOf('\u2211'));
        this.charEntities.put("minus", Character.valueOf('\u2212'));
        this.charEntities.put("lowast", Character.valueOf('\u2217'));
        this.charEntities.put("radic", Character.valueOf('\u221a'));
        this.charEntities.put("prop", Character.valueOf('\u221d'));
        this.charEntities.put("infin", Character.valueOf('\u221e'));
        this.charEntities.put("ang", Character.valueOf('\u2220'));
        this.charEntities.put("and", Character.valueOf('\u2227'));
        this.charEntities.put("or", Character.valueOf('\u2228'));
        this.charEntities.put("cap", Character.valueOf('\u2229'));
        this.charEntities.put("cup", Character.valueOf('\u222a'));
        this.charEntities.put("int", Character.valueOf('\u222b'));
        this.charEntities.put("there4", Character.valueOf('\u2234'));
        this.charEntities.put("sim", Character.valueOf('\u223c'));
        this.charEntities.put("cong", Character.valueOf('\u2245'));
        this.charEntities.put("asymp", Character.valueOf('\u2248'));
        this.charEntities.put("ne", Character.valueOf('\u2260'));
        this.charEntities.put("equiv", Character.valueOf('\u2261'));
        this.charEntities.put("le", Character.valueOf('\u2264'));
        this.charEntities.put("ge", Character.valueOf('\u2265'));
        this.charEntities.put("sub", Character.valueOf('\u2282'));
        this.charEntities.put("sup", Character.valueOf('\u2283'));
        this.charEntities.put("nsub", Character.valueOf('\u2284'));
        this.charEntities.put("sube", Character.valueOf('\u2286'));
        this.charEntities.put("supe", Character.valueOf('\u2287'));
        this.charEntities.put("oplus", Character.valueOf('\u2295'));
        this.charEntities.put("otimes", Character.valueOf('\u2297'));
        this.charEntities.put("perp", Character.valueOf('\u22a5'));
        this.charEntities.put("sdot", Character.valueOf('\u22c5'));
        this.charEntities.put("lceil", Character.valueOf('\u2308'));
        this.charEntities.put("rceil", Character.valueOf('\u2309'));
        this.charEntities.put("lfloor", Character.valueOf('\u230a'));
        this.charEntities.put("rfloor", Character.valueOf('\u230b'));
        this.charEntities.put("lang", Character.valueOf('\u2329'));
        this.charEntities.put("rang", Character.valueOf('\u232a'));
        this.charEntities.put("loz", Character.valueOf('\u25ca'));
        this.charEntities.put("spades", Character.valueOf('\u2660'));
        this.charEntities.put("clubs", Character.valueOf('\u2663'));
        this.charEntities.put("hearts", Character.valueOf('\u2665'));
        this.charEntities.put("diams", Character.valueOf('\u2666'));
    }
}

