/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.Util;

public class IdGenerator {
    public static final String START_DOCUMENT = "sd";
    public static final String END_DOCUMENT = "ed";
    public static final String START_GROUP = "sg";
    public static final String END_GROUP = "eg";
    public static final String TEXT_UNIT = "tu";
    public static final String DOCUMENT_PART = "dp";
    public static final String START_SUBDOCUMENT = "ssd";
    public static final String END_SUBDOCUMENT = "esd";
    public static final String DEFAULT_ROOT_ID = "noDocName";
    private long seq = 0L;
    private String rootId;
    private String prefix;

    public IdGenerator(String root) {
        this.create(root, "");
    }

    public IdGenerator(String root, String prefix) {
        this.create(root, prefix);
    }

    public String toString() {
        return this.getLastId();
    }

    public String createId() {
        if (this.rootId == null) {
            return this.prefix + Long.toString(++this.seq);
        }
        return this.rootId + "-" + this.prefix + Long.toString(++this.seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId(String prefix) {
        String orginalPrefix = this.prefix;
        this.prefix = prefix;
        try {
            if (this.rootId == null) {
                String string = prefix + Long.toString(++this.seq);
                return string;
            }
            String string = this.rootId + "-" + prefix + Long.toString(++this.seq);
            return string;
        }
        finally {
            this.prefix = orginalPrefix;
        }
    }

    public String getLastId() {
        if (this.seq <= 0L) {
            throw new RuntimeException("The method createId() has not been called yet.");
        }
        if (this.rootId == null) {
            return this.prefix + Long.toString(this.seq);
        }
        return this.rootId + "-" + this.prefix + Long.toString(this.seq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLastId(String prefix) {
        String orginalPrefix = this.prefix;
        this.prefix = prefix;
        try {
            if (this.seq <= 0L) {
                throw new RuntimeException("The method createId() has not been called yet.");
            }
            if (this.rootId == null) {
                String string = prefix + Long.toString(this.seq);
                return string;
            }
            String string = this.rootId + "-" + prefix + Long.toString(this.seq);
            return string;
        }
        finally {
            this.prefix = orginalPrefix;
        }
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setSequence(long sequence) {
        this.seq = sequence;
    }

    public long getSequence() {
        return this.seq;
    }

    public void reset(String rootId) {
        this.seq = 0L;
        this.create(rootId, this.prefix);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    private void create(String root, String prefix) {
        this.rootId = Util.isEmpty(root) ? null : Util.makeId(root);
        this.setPrefix(prefix);
    }
}

