/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.IdGenerator;
import org.junit.Assert;
import org.junit.Test;

public class IdGeneratorTest {
    private IdGenerator idGen;

    @Test
    public void testresultNotNull() {
        this.idGen = new IdGenerator("test");
        Assert.assertNotNull((Object)this.idGen.createId());
        Assert.assertNotNull((Object)this.idGen.createId());
    }

    @Test
    public void testresultNotEmpty() {
        this.idGen = new IdGenerator("test");
        Assert.assertTrue((this.idGen.createId().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.idGen.createId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreationWithNullRoot() {
        this.idGen = new IdGenerator(null);
        Assert.assertEquals((Object)"1", (Object)this.idGen.createId());
        Assert.assertEquals((Object)"1", (Object)this.idGen.getLastId());
    }

    @Test
    public void testCreationWithEmptyRoot() {
        this.idGen = new IdGenerator("");
        Assert.assertEquals((Object)"1", (Object)this.idGen.createId());
        Assert.assertEquals((Object)"1", (Object)this.idGen.getLastId());
    }

    @Test
    public void testWithNullPrefix() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        this.idGen = new IdGenerator("test", null);
        Assert.assertEquals((Object)id1, (Object)this.idGen.createId());
    }

    @Test
    public void testWithEmptyPrefix() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "");
        Assert.assertEquals((Object)id1, (Object)this.idGen.createId());
    }

    @Test
    public void testSameIdForSameRoot() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test");
        Assert.assertTrue((boolean)id1.equals(this.idGen.createId()));
        Assert.assertTrue((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRoot() {
        this.idGen = new IdGenerator("test");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test");
        Assert.assertFalse((boolean)id1.equals(this.idGen.createId()));
        Assert.assertFalse((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testresultNotNullWithPrefix() {
        this.idGen = new IdGenerator("test", "p");
        Assert.assertNotNull((Object)this.idGen.createId());
        Assert.assertNotNull((Object)this.idGen.createId());
    }

    @Test
    public void testresultNotEmptyWithPrefix() {
        this.idGen = new IdGenerator("test", "p");
        Assert.assertTrue((this.idGen.createId().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.idGen.createId().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSameIdForSameRootAndPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "p");
        Assert.assertTrue((boolean)id1.equals(this.idGen.createId()));
        Assert.assertTrue((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRootSamePrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test", "p");
        Assert.assertFalse((boolean)id1.equals(this.idGen.createId()));
        Assert.assertFalse((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForSameRootDifferentPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("test", "P");
        Assert.assertFalse((boolean)id1.equals(this.idGen.createId()));
        Assert.assertFalse((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testDifferentIdForDifferentRootAndPrefix() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        this.idGen = new IdGenerator("Test", "P");
        Assert.assertFalse((boolean)id1.equals(this.idGen.createId()));
        Assert.assertFalse((boolean)id2.equals(this.idGen.createId()));
    }

    @Test
    public void testCanReproduceValue() {
        this.idGen = new IdGenerator("test", "p");
        String id1 = this.idGen.createId();
        String id2 = this.idGen.createId();
        Assert.assertEquals((Object)"P364492-p1", (Object)id1);
        Assert.assertEquals((Object)"P364492-p2", (Object)id2);
        this.idGen = new IdGenerator("test/A/b/C");
        id1 = this.idGen.createId();
        id2 = this.idGen.createId();
        Assert.assertEquals((Object)"P269F9F4B-1", (Object)id1);
        Assert.assertEquals((Object)"P269F9F4B-2", (Object)id2);
    }

    @Test
    public void testLastId() {
        this.idGen = new IdGenerator("test", "p");
        String id = this.idGen.createId();
        String bis = null;
        for (int i = 0; i < 10; ++i) {
            bis = this.idGen.getLastId();
        }
        Assert.assertEquals((Object)id, bis);
    }

    @Test
    public void testCreateIdWithPrefix() {
        this.idGen = new IdGenerator(null, "p");
        String id = this.idGen.createId();
        Assert.assertEquals((Object)"p1", (Object)id);
        id = this.idGen.createId("xyz");
        Assert.assertEquals((Object)"xyz2", (Object)id);
        id = this.idGen.createId();
        Assert.assertEquals((Object)"p3", (Object)id);
    }

    @Test
    public void testLastIdWithPrefix() {
        this.idGen = new IdGenerator(null, "p");
        String id = this.idGen.createId("zxc");
        Assert.assertEquals((Object)"zxc1", (Object)id);
        Assert.assertEquals((Object)"zxc1", (Object)this.idGen.getLastId("zxc"));
        Assert.assertEquals((Object)"p2", (Object)this.idGen.createId());
    }

    @Test
    public void testToString() {
        this.idGen = new IdGenerator("test", "p");
        String id = this.idGen.createId();
        Assert.assertEquals((Object)this.idGen.toString(), (Object)this.idGen.getLastId());
        Assert.assertEquals((Object)id, (Object)this.idGen.toString());
    }
}

