/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.LinkedHashMap;

public class ParametersString {
    private LinkedHashMap<String, Object> list = new LinkedHashMap();

    public ParametersString() {
    }

    public ParametersString(String data) {
        this.buildList(null, data);
    }

    public String toString() {
        return this.buildString(null);
    }

    public void fromString(String data) {
        this.list.clear();
        this.buildList(null, data);
    }

    public void reset() {
        this.list.clear();
    }

    public void remove(String name) {
        if (this.list.containsKey(name)) {
            this.list.remove(name);
        }
    }

    public void removeGroup(String groupName) {
        groupName = groupName + ".";
        for (String key : this.list.keySet()) {
            if (!key.startsWith(groupName)) continue;
            this.list.remove(key);
        }
    }

    private String escape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("\r", "$0d$");
        return value.replace("\n", "$0a$");
    }

    private String unescape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("$0d$", "\r");
        return value.replace("$0a$", "\n");
    }

    private String buildString(String prefix) {
        StringBuilder tmp = new StringBuilder("#v1");
        if (prefix != null) {
            prefix = prefix + ".";
        }
        for (String key : this.list.keySet()) {
            if (prefix != null) {
                if (!key.startsWith(prefix)) continue;
                tmp.append("\n" + key.substring(prefix.length()));
            } else {
                tmp.append("\n" + key);
            }
            Object value = this.list.get(key);
            if (value instanceof String) {
                tmp.append("=" + this.escape((String)value));
                continue;
            }
            if (value instanceof Integer) {
                tmp.append(".i=" + String.valueOf(value));
                continue;
            }
            if (value instanceof Boolean) {
                tmp.append(".b=" + ((Boolean)value != false ? "true" : "false"));
                continue;
            }
            throw new RuntimeException("Invalide type: " + key);
        }
        if (tmp.length() == 3) {
            tmp.setLength(0);
        }
        return tmp.toString();
    }

    private void buildList(String prefix, String data) {
        String[] lines;
        prefix = prefix == null ? "" : prefix + ".";
        if (data == null) {
            data = "";
        }
        for (String line : lines = data.split("\n", 0)) {
            String key;
            int n;
            if (line.trim().length() == 0 || line.charAt(0) == '#' || (n = line.indexOf(61)) == -1) continue;
            String qualifiedName = line.substring(0, n).trim();
            String trimmedValue = line.substring(n + 1).trim();
            if (qualifiedName.endsWith(".b")) {
                key = prefix + qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                this.list.put(key, "true".equals(trimmedValue));
                continue;
            }
            if (qualifiedName.endsWith(".i")) {
                key = prefix + qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                this.list.put(key, (int)Integer.valueOf(trimmedValue));
                continue;
            }
            key = prefix + qualifiedName;
            this.list.put(key, this.unescape(line.substring(n + 1)));
        }
    }

    public String getGroup(String name, String defaultValue) {
        String tmp = this.buildString(name);
        if (tmp.length() > 0) {
            return tmp;
        }
        return defaultValue;
    }

    public String getGroup(String name) {
        return this.buildString(name);
    }

    public void setGroup(String name, String data) {
        this.buildList(name, data);
    }

    public void setGroup(String name, ParametersString params) {
        name = name == null ? "" : name + ".";
        for (String key : params.list.keySet()) {
            this.list.put(name + key, params.list.get(key));
        }
    }

    public String getString(String name, String defaultValue) {
        if (this.list.containsKey(name)) {
            return (String)this.list.get(name);
        }
        return defaultValue;
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public void setString(String name, String value) {
        if (value == null) {
            this.list.remove(name);
        } else {
            this.list.put(name, value);
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.list.containsKey(name)) {
            return (Boolean)this.list.get(name);
        }
        return defaultValue;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public void setBoolean(String name, boolean value) {
        this.list.put(name, value);
    }

    public int getInteger(String name, int defaultValue) {
        if (this.list.containsKey(name)) {
            return (Integer)this.list.get(name);
        }
        return defaultValue;
    }

    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public void setInteger(String name, int value) {
        this.list.put(name, value);
    }

    public void setParameter(String name, String value) {
        this.setString(name, value);
    }

    public void setParameter(String name, boolean value) {
        this.setBoolean(name, value);
    }

    public void setParameter(String name, int value) {
        this.setInteger(name, value);
    }
}

