/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.DummyParameters;
import net.sf.okapi.common.ParameterDescriptor;
import net.sf.okapi.common.ParametersDescription;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ParametersTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testDefaults() {
        DummyParameters params = new DummyParameters();
        Assert.assertTrue((boolean)params.paramBool1);
        Assert.assertEquals((long)params.paramInt1, (long)123L);
        Assert.assertEquals((Object)params.paramStr1, (Object)"test");
        params.reset();
        Assert.assertTrue((boolean)params.paramBool1);
        Assert.assertEquals((long)params.paramInt1, (long)123L);
        Assert.assertEquals((Object)params.paramStr1, (Object)"test");
    }

    @Test
    public void testLoadParametersFromString() {
        String snippet = "#v1\nparamBool1.b=false\nparamInt1.i=456";
        DummyParameters params = new DummyParameters();
        params.fromString(snippet);
        Assert.assertFalse((boolean)params.paramBool1);
        Assert.assertEquals((long)params.paramInt1, (long)456L);
        Assert.assertEquals((Object)params.paramStr1, (Object)"test");
    }

    @Test
    public void testWhitespaces() {
        String snippet = "#v1\nparamBool1.b  =  true  \nparamInt1.i  =  456 \nparamStr1  = AB  C  ";
        DummyParameters params = new DummyParameters();
        params.fromString(snippet);
        Assert.assertTrue((boolean)params.paramBool1);
        Assert.assertEquals((long)params.paramInt1, (long)456L);
        Assert.assertEquals((Object)params.paramStr1, (Object)" AB  C  ");
    }

    @Test
    public void testLoadParametersFromWindowsFile() throws URISyntaxException {
        DummyParameters params = new DummyParameters();
        URL url = ParametersTest.class.getResource("/ParamTest01.txt");
        params.load(url.toURI(), false);
        Assert.assertFalse((boolean)params.paramBool1);
        Assert.assertEquals((long)789L, (long)params.paramInt1);
        Assert.assertEquals((Object)params.paramStr1, (Object)"TestOK");
    }

    @Test
    public void testParameterDescriptor() {
        TestClass ts = new TestClass();
        ParameterDescriptor pd = new ParameterDescriptor("text", ts, "displayName", "shortDescription");
        Assert.assertEquals((Object)"displayName", (Object)pd.getDisplayName());
        Assert.assertEquals((Object)"shortDescription", (Object)pd.getShortDescription());
        Assert.assertEquals(String.class, (Object)pd.getType());
        Assert.assertEquals((Object)"text", (Object)pd.getName());
        Assert.assertEquals((Object)ts, (Object)pd.getParent());
        Assert.assertNotNull((Object)pd.getReadMethod());
        Assert.assertNotNull((Object)pd.getWriteMethod());
    }

    @Test
    public void testParametersDescription() {
        TestClass ts = new TestClass();
        ParametersDescription desc = new ParametersDescription(ts);
        desc.add("text", "displayName", "shortDescription");
        desc.add("flag", "Flag", "A flag");
        ParameterDescriptor pd = desc.get("text");
        Assert.assertEquals((long)2L, (long)desc.getDescriptors().size());
        Assert.assertEquals((Object)pd, (Object)desc.getDescriptors().get("text"));
        pd = desc.get("flag");
        Assert.assertEquals((Object)pd, (Object)desc.getDescriptors().get("flag"));
        Assert.assertEquals(Boolean.TYPE, (Object)pd.getType());
    }

    @Test
    public void testGetFromName() {
        DummyParameters natParams = new DummyParameters();
        natParams.paramStr1 = "qwerty";
        natParams.paramBool1 = false;
        natParams.paramInt1 = 98765;
        DummyParameters params = natParams;
        Assert.assertEquals((Object)"qwerty", (Object)params.getString("paramStr1"));
        Assert.assertEquals((Object)false, (Object)params.getBoolean("paramBool1"));
        Assert.assertEquals((long)98765L, (long)params.getInteger("paramInt1"));
    }

    @Test
    public void testSetFromName() {
        DummyParameters natParams = new DummyParameters();
        natParams.paramStr1 = "qwerty";
        natParams.paramBool1 = false;
        natParams.paramInt1 = 98765;
        DummyParameters params = natParams;
        Assert.assertEquals((Object)"qwerty", (Object)params.getString("paramStr1"));
        Assert.assertEquals((Object)false, (Object)params.getBoolean("paramBool1"));
        params.setString("paramStr1", "newValue");
        params.setBoolean("paramBool1", true);
        Assert.assertEquals((Object)"newValue", (Object)params.getString("paramStr1"));
        Assert.assertEquals((Object)true, (Object)params.getBoolean("paramBool1"));
        Assert.assertEquals((long)98765L, (long)params.getInteger("paramInt1"));
        params.setInteger("paramInt1", 12345678);
        Assert.assertEquals((long)12345678L, (long)params.getInteger("paramInt1"));
    }

    class TestClass {
        private String text;
        private boolean flag;

        TestClass() {
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }
    }
}

