/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class XMLWriter {
    private PrintWriter writer = null;
    private boolean inStartTag;
    private Stack<String> elements = new Stack();
    private String lineBreak = System.getProperty("line.separator");

    public XMLWriter(String path) {
        try {
            Util.createDirectories(path);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path));
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public XMLWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.elements != null) {
            this.elements.clear();
            this.elements = null;
        }
    }

    public void writeStartDocument() {
        this.writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.lineBreak);
    }

    public void writeStartHTMLDocument(String title) {
        this.writer.print("<html>" + this.lineBreak);
        this.writer.print("<head>" + this.lineBreak);
        this.writer.print("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">" + this.lineBreak);
        if (title != null) {
            this.writeElementString("title", title);
            this.writeLineBreak();
        }
        this.writer.print("</head>" + this.lineBreak);
    }

    public void writeEndDocument() {
        this.closeStartTag();
        this.writer.flush();
    }

    public void writeStartElement(String name) {
        this.closeStartTag();
        this.elements.push(name);
        this.writer.write("<" + name);
        this.inStartTag = true;
    }

    public void writeEndElement() {
        this.closeStartTag();
        this.writer.write("</" + this.elements.pop() + ">");
    }

    public void writeEndElementLineBreak() {
        this.closeStartTag();
        this.writer.write("</" + this.elements.pop() + ">" + this.lineBreak);
    }

    public void writeElementString(String name, String content) {
        this.closeStartTag();
        this.writer.write("<" + name + ">");
        this.writer.write(Util.escapeToXML(content, 0, false, null));
        this.writer.print("</" + name + ">");
    }

    public void writeAttributeString(String name, String value) {
        this.writer.write(" " + name + "=\"" + Util.escapeToXML(value, 3, false, null) + "\"");
    }

    public void writeString(String text) {
        this.closeStartTag();
        this.writer.write(Util.escapeToXML(text, 0, false, null).replace("\n", this.lineBreak));
    }

    public void writeRawXML(String xmlData) {
        this.closeStartTag();
        this.writer.write(xmlData.replace("\n", this.lineBreak));
    }

    public void writeComment(String text, boolean withLineBreak) {
        this.closeStartTag();
        this.writer.write("<!--");
        this.writer.write(text.replace("\n", this.lineBreak));
        this.writer.write("-->");
        if (withLineBreak) {
            this.writer.write(this.lineBreak);
        }
    }

    public void writeLineBreak() {
        this.closeStartTag();
        this.writer.write(this.lineBreak);
    }

    private void closeStartTag() {
        if (this.inStartTag) {
            this.writer.write(">");
            this.inStartTag = false;
        }
    }
}

