/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.nio.charset.CharsetEncoder;
import java.security.InvalidParameterException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.IEncoder;

public class EncoderManager
implements IEncoder {
    private static final Logger LOGGER = Logger.getLogger(EncoderManager.class.getName());
    private Hashtable<String, String> mimeMap = new Hashtable();
    private String mimeType = "";
    private IEncoder encoder;
    private String defEncoding;
    private String defLineBreak;
    private IParameters defParams;

    public void setAllKnownMappings() {
        this.mimeMap.put("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("application/x-xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("text/x-odf", "net.sf.okapi.common.encoder.XMLEncoder");
        this.mimeMap.put("text/x-properties", "net.sf.okapi.common.encoder.PropertiesEncoder");
        this.mimeMap.put("text/html", "net.sf.okapi.common.encoder.HtmlEncoder");
        this.mimeMap.put("text/xhtml", "net.sf.okapi.common.encoder.HtmlEncoder");
        this.mimeMap.put("application/x-gettext", "net.sf.okapi.common.encoder.POEncoder");
        this.mimeMap.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "net.sf.okapi.common.encoder.OpenXMLEncoder");
        this.mimeMap.put("application/xml+dtd", "net.sf.okapi.common.encoder.DTDEncoder");
        this.mimeMap.put("application/x-ts", "net.sf.okapi.common.encoder.TSEncoder");
        this.mimeMap.put("application/x-php", "net.sf.okapi.common.encoder.PHPContentEncoder");
        this.mimeMap.put("application/x-ttx+xml", "net.sf.okapi.common.encoder.XMLEncoder");
    }

    public void clearMap() {
        this.mimeMap.clear();
    }

    public void setMapping(String mimeType, String className) {
        this.mimeMap.put(mimeType, className);
    }

    public void removeMapping(String mimeType) {
        this.mimeMap.remove(mimeType);
    }

    public void mergeMappings(EncoderManager otherManager) {
        for (Map.Entry<String, String> entry : otherManager.mimeMap.entrySet()) {
            if (this.mimeMap.containsKey(entry.getKey())) {
                if (this.mimeMap.get(entry.getKey()).equals(entry.getValue())) continue;
                LOGGER.warning(String.format("The MIME type '%s' is currently mapped to '%s', but conflicts with another mapping ('%s').", entry.getKey(), this.mimeMap.get(entry.getKey()), entry.getValue()));
                continue;
            }
            this.setMapping(entry.getKey(), entry.getValue());
        }
    }

    public void updateEncoder(String newMimeType) {
        try {
            if (newMimeType == null) {
                return;
            }
            if (this.mimeType.equals(newMimeType)) {
                return;
            }
            this.mimeType = newMimeType;
            String name = this.mimeMap.get(this.mimeType);
            this.encoder = name == null ? new DefaultEncoder() : (IEncoder)Class.forName(name).newInstance();
            this.encoder.setOptions(this.defParams, this.defEncoding, this.defLineBreak);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String encode(String text, int context) {
        if (this.encoder != null) {
            return this.encoder.encode(text, context);
        }
        return text;
    }

    @Override
    public String encode(char value, int context) {
        if (this.encoder != null) {
            return this.encoder.encode(value, context);
        }
        return String.valueOf(value);
    }

    @Override
    public String encode(int codePoint, int context) {
        if (this.encoder != null) {
            return this.encoder.encode(codePoint, context);
        }
        if (Character.isSupplementaryCodePoint(codePoint)) {
            return new String(Character.toChars(codePoint));
        }
        return String.valueOf((char)codePoint);
    }

    public IEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        if (this.encoder != null) {
            this.encoder.setOptions(params, encoding, lineBreak);
        }
    }

    @Override
    public String toNative(String propertyName, String value) {
        if (this.encoder != null) {
            return this.encoder.toNative(propertyName, value);
        }
        return value;
    }

    public void setDefaultOptions(IParameters params, String encoding, String lineBreak) {
        this.defParams = params;
        this.defEncoding = encoding;
        if (lineBreak == null) {
            throw new InvalidParameterException("lineBreak parameter is null");
        }
        this.defLineBreak = lineBreak;
    }

    @Override
    public String getLineBreak() {
        if (this.encoder != null) {
            return this.encoder.getLineBreak();
        }
        return this.defLineBreak;
    }

    @Override
    public CharsetEncoder getCharsetEncoder() {
        if (this.encoder != null) {
            return this.encoder.getCharsetEncoder();
        }
        return null;
    }
}

