/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public abstract class AbstractFilter
implements IFilter {
    private static final Logger LOGGER = Logger.getLogger(AbstractFilter.class.getName());
    List<FilterConfiguration> configList = new ArrayList<FilterConfiguration>();
    private IdGenerator documentId;
    private boolean canceled = false;
    private String documentName;
    private String newlineType;
    private String encoding;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private String mimeType;
    private IFilterWriter filterWriter;
    private boolean generateSkeleton;
    private boolean multilingual;
    private String name;
    private String displayName;
    private EncoderManager encoderManager;
    private IFilterConfigurationMapper fcMapper;
    private String parentId;

    public AbstractFilter() {
        this.setNewlineType("\n");
        this.setMultilingual(false);
        this.fcMapper = new FilterConfigurationMapper();
        this.documentId = new IdGenerator(null, "sd");
    }

    public void setOptions(LocaleId sourceLocale, LocaleId targetLocale, String defaultEncoding, boolean generateSkeleton) {
        this.setEncoding(defaultEncoding);
        this.setTrgLoc(targetLocale);
        this.setSrcLoc(sourceLocale);
        this.setGenerateSkeleton(generateSkeleton);
    }

    protected Event createStartFilterEvent() {
        StartDocument startDocument = new StartDocument(this.documentId.createId("sd"));
        startDocument.setEncoding(this.getEncoding(), this.isUtf8Encoding() && this.isUtf8Bom());
        startDocument.setLocale(this.getSrcLoc());
        startDocument.setMimeType(this.getMimeType());
        startDocument.setLineBreak(this.getNewlineType());
        startDocument.setFilterParameters(this.getParameters());
        startDocument.setFilterWriter(this.getFilterWriter());
        startDocument.setName(this.getDocumentName());
        startDocument.setMultilingual(this.isMultilingual());
        LOGGER.log(Level.FINE, "Start Document for " + startDocument.getId());
        return new Event(EventType.START_DOCUMENT, startDocument);
    }

    protected Event createEndFilterEvent() {
        Ending endDocument = new Ending(this.documentId.getLastId("ed"));
        LOGGER.log(Level.FINE, "End Document for " + endDocument.getId());
        return new Event(EventType.END_DOCUMENT, endDocument);
    }

    public boolean addConfigurations(List<FilterConfiguration> configs) {
        if (this.configList == null) {
            return false;
        }
        return this.configList.addAll(configs);
    }

    public FilterConfiguration getConfiguration(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return config;
        }
        return null;
    }

    public boolean removeConfiguration(String configId) {
        return this.configList.remove(this.getConfiguration(configId));
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> configs = new ArrayList<FilterConfiguration>();
        for (FilterConfiguration fc : this.configList) {
            configs.add(new FilterConfiguration(fc.configId, this.getMimeType(), this.getClass().getName(), fc.name, fc.description, fc.parametersLocation, fc.extensions));
        }
        return configs;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    public void addConfiguration(FilterConfiguration configuration) {
        this.configList.add(configuration);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    protected IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    protected void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public String getNewlineType() {
        return this.newlineType;
    }

    protected void setNewlineType(String newlineType) {
        this.newlineType = newlineType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public LocaleId getSrcLoc() {
        return this.srcLoc;
    }

    protected void setSrcLoc(LocaleId srcLoc) {
        this.srcLoc = srcLoc;
    }

    protected void setTrgLoc(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTrgLoc() {
        return this.trgLoc;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public IFilterWriter getFilterWriter() {
        return this.filterWriter;
    }

    public void setFilterWriter(IFilterWriter filterWriter) {
        this.filterWriter = filterWriter;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    protected void setGenerateSkeleton(boolean generateSkeleton) {
        this.generateSkeleton = generateSkeleton;
    }

    public boolean isGenerateSkeleton() {
        return this.generateSkeleton;
    }

    protected abstract boolean isUtf8Encoding();

    protected abstract boolean isUtf8Bom();

    protected void setMultilingual(boolean multilingual) {
        this.multilingual = multilingual;
    }

    public boolean isMultilingual() {
        return this.multilingual;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    protected void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public IdGenerator getDocumentId() {
        return this.documentId;
    }

    public boolean isSubFilter() {
        return this.getClass().isAnnotationPresent(SubFilter.class);
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }
}

