/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.util.Collections;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.PropertyTextUnitPlaceholder;
import net.sf.okapi.common.filters.SubFilterAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;

public class EventBuilder {
    private static final Logger LOGGER = Logger.getLogger(EventBuilder.class.getName());
    private String mimeType;
    private IdGenerator groupId;
    private IdGenerator textUnitId;
    private IdGenerator subDocumentId;
    private IdGenerator documentPartId;
    private Stack<Event> tempFilterEventStack;
    private Stack<Code> codeStack;
    private List<Event> filterEvents;
    private List<Event> referencableFilterEvents;
    private boolean done = false;
    private boolean preserveWhitespace;
    private GenericSkeleton currentSkeleton;
    private DocumentPart currentDocumentPart;
    private String rootId;
    private boolean subFilter;

    public EventBuilder() {
        this.reset(null, false);
    }

    public EventBuilder(String rootId, boolean subFilter) {
        this.reset(rootId, subFilter);
    }

    public boolean hasNext() {
        return !this.done;
    }

    public Event next() {
        if (this.hasNext()) {
            if (!this.referencableFilterEvents.isEmpty()) {
                return this.referencableFilterEvents.remove(0);
            }
            if (!this.filterEvents.isEmpty()) {
                Event event = this.filterEvents.remove(0);
                if (event.getEventType() == EventType.END_DOCUMENT) {
                    this.done = true;
                }
                if (this.subFilter && event.getEventType() == EventType.END_GROUP && event.getEndGroup().getAnnotation(SubFilterAnnotation.class) != null) {
                    this.done = true;
                }
                return event;
            }
        }
        return null;
    }

    public void addFilterEvent(Event event) {
        switch (event.getEventType()) {
            case START_GROUP: {
                if (this.isCurrentTextUnit()) {
                    StartGroup sg = event.getStartGroup();
                    sg.setIsReferent(true);
                    Code c = new Code(TextFragment.TagType.PLACEHOLDER, sg.getName(), TextFragment.makeRefMarker(sg.getId()));
                    c.setReferenceFlag(true);
                    this.startCode(c);
                    this.endCode();
                    this.referencableFilterEvents.add(event);
                    break;
                }
                this.filterEvents.add(event);
                break;
            }
            default: {
                this.filterEvents.add(event);
            }
        }
    }

    public void cancel() {
        this.filterEvents.clear();
        this.referencableFilterEvents.clear();
        Event event = new Event(EventType.CANCELED);
        this.filterEvents.add(event);
    }

    private Event peekTempEvent() {
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        return this.tempFilterEventStack.peek();
    }

    private Event popTempEvent() {
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        return this.tempFilterEventStack.pop();
    }

    public void flushRemainingTempEvents() {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        } else if (!this.tempFilterEventStack.isEmpty()) {
            while (!this.tempFilterEventStack.isEmpty()) {
                Event fe = this.tempFilterEventStack.peek();
                if (fe.getEventType() == EventType.START_GROUP) {
                    StartGroup sg = (StartGroup)fe.getResource();
                    this.endGroup((GenericSkeleton)sg.getSkeleton());
                    continue;
                }
                if (fe.getEventType() != EventType.TEXT_UNIT) continue;
                this.endTextUnit();
            }
        }
    }

    public boolean isCurrentTextUnit() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT;
    }

    public boolean isCurrentComplexTextUnit() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT && e.getResource().getSkeleton() != null;
    }

    public boolean isCurrentGroup() {
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.START_GROUP;
    }

    public boolean isInsideTextRun() {
        return this.isCurrentTextUnit();
    }

    public boolean canStartNewTextUnit() {
        return !this.isCurrentTextUnit();
    }

    public boolean hasQueuedEvents() {
        return !this.filterEvents.isEmpty();
    }

    public String findMostRecentParentId() {
        if (this.isCurrentComplexTextUnit()) {
            return this.peekMostRecentTextUnit().getId();
        }
        if (this.isCurrentGroup()) {
            StartGroup parentGroup = this.peekMostRecentGroup();
            return parentGroup.getId();
        }
        StartSubDocument parentSubDocument = this.peekMostRecentSubDocument();
        if (parentSubDocument != null) {
            return parentSubDocument.getId();
        }
        return null;
    }

    public StartGroup peekMostRecentGroup() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (fe.getEventType() != EventType.START_GROUP) continue;
            StartGroup g = (StartGroup)fe.getResource();
            return g;
        }
        return null;
    }

    public StartSubDocument peekMostRecentSubDocument() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (fe.getEventType() != EventType.START_SUBDOCUMENT) continue;
            StartSubDocument sd = (StartSubDocument)fe.getResource();
            return sd;
        }
        return null;
    }

    public TextUnit peekMostRecentTextUnit() {
        int lastIndex;
        if (this.tempFilterEventStack.isEmpty()) {
            return null;
        }
        for (int i = lastIndex = this.tempFilterEventStack.size() - 1; i >= 0; --i) {
            Event fe = (Event)this.tempFilterEventStack.get(i);
            if (fe.getEventType() != EventType.TEXT_UNIT) continue;
            TextUnit tu = (TextUnit)fe.getResource();
            return tu;
        }
        return null;
    }

    public Code peekMostRecentCode() {
        if (this.codeStack.isEmpty()) {
            return null;
        }
        Code c = null;
        try {
            c = this.codeStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return c;
    }

    public boolean hasUnfinishedSkeleton() {
        return this.currentSkeleton != null;
    }

    public boolean hasParentTextUnit() {
        if (this.tempFilterEventStack.isEmpty()) {
            return false;
        }
        boolean first = true;
        for (Event fe : this.tempFilterEventStack) {
            if (fe.getEventType() == EventType.TEXT_UNIT && !first) {
                return true;
            }
            first = false;
        }
        return false;
    }

    public void reset(String rootId, boolean subFilter) {
        this.rootId = rootId;
        this.subFilter = subFilter;
        this.groupId = new IdGenerator(rootId, "sg");
        this.textUnitId = new IdGenerator(rootId, "tu");
        this.documentPartId = new IdGenerator(rootId, "dp");
        this.subDocumentId = new IdGenerator(rootId, "ssd");
        this.done = false;
        this.preserveWhitespace = true;
        this.referencableFilterEvents = new LinkedList<Event>();
        this.filterEvents = new LinkedList<Event>();
        this.tempFilterEventStack = new Stack();
        this.codeStack = new Stack();
        this.currentSkeleton = null;
        this.currentDocumentPart = null;
    }

    public void startSubDocument() {
        if (!this.subFilter) {
            if (this.hasUnfinishedSkeleton()) {
                this.endDocumentPart();
            }
            StartSubDocument startSubDocument = new StartSubDocument(this.subDocumentId.createId());
            Event event = new Event(EventType.START_SUBDOCUMENT, startSubDocument);
            this.filterEvents.add(event);
            LOGGER.log(Level.FINE, "Start Sub-Document for " + startSubDocument.getId());
        }
    }

    public void endSubDocument() {
        if (!this.subFilter) {
            Ending endDocument = new Ending(this.subDocumentId.createId("esd"));
            Event event = new Event(EventType.END_SUBDOCUMENT, endDocument);
            this.filterEvents.add(event);
            LOGGER.log(Level.FINE, "End Sub-Document for " + endDocument.getId());
        }
    }

    private TextUnit embeddedTextUnit(PropertyTextUnitPlaceholder propOrText, String tag) {
        TextUnit tu = new TextUnit(this.textUnitId.createId(), propOrText.getValue());
        tu.setPreserveWhitespaces(this.preserveWhitespace);
        tu.setMimeType(propOrText.getMimeType());
        tu.setIsReferent(true);
        tu.setType(propOrText.getElementType() == null ? propOrText.getName() : propOrText.getElementType());
        GenericSkeleton skel = new GenericSkeleton();
        skel.add(tag.substring(propOrText.getMainStartPos(), propOrText.getValueStartPos()));
        skel.addContentPlaceholder(tu);
        skel.add(tag.substring(propOrText.getValueEndPos(), propOrText.getMainEndPos()));
        tu.setSkeleton(skel);
        return tu;
    }

    private void embeddedWritableProp(INameable resource, PropertyTextUnitPlaceholder propOrText, String tag, LocaleId locale) {
        this.setPropertyBasedOnLocale(resource, locale, new Property(propOrText.getName(), propOrText.getValue(), false));
        this.currentSkeleton.add(tag.substring(propOrText.getMainStartPos(), propOrText.getValueStartPos()));
        this.currentSkeleton.addValuePlaceholder(resource, propOrText.getName(), locale);
        this.currentSkeleton.add(tag.substring(propOrText.getValueEndPos(), propOrText.getMainEndPos()));
    }

    private void embeddedReadonlyProp(INameable resource, PropertyTextUnitPlaceholder propOrText, String tag, LocaleId locId) {
        this.setPropertyBasedOnLocale(resource, locId, new Property(propOrText.getName(), propOrText.getValue(), true));
        this.currentSkeleton.add(tag.substring(propOrText.getMainStartPos(), propOrText.getMainEndPos()));
    }

    private INameable setPropertyBasedOnLocale(INameable resource, LocaleId locale, Property property) {
        if (locale == null) {
            resource.setSourceProperty(property);
        } else if (locale.equals(LocaleId.EMPTY)) {
            resource.setProperty(property);
        } else {
            resource.setTargetProperty(locale, property);
        }
        return resource;
    }

    private boolean processAllEmbedded(String tag, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders, boolean inlineCode) {
        return this.processAllEmbedded(tag, locale, propertyTextUnitPlaceholders, inlineCode, null);
    }

    private boolean isTextPlaceHoldersOnly(List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        boolean text = false;
        boolean nontext = false;
        for (PropertyTextUnitPlaceholder propOrText : propertyTextUnitPlaceholders) {
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE) {
                text = true;
                continue;
            }
            nontext = true;
        }
        return text && !nontext;
    }

    private boolean processAllEmbedded(String tag, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders, boolean inlineCode, TextUnit parentTu) {
        int propOrTextId = -1;
        boolean textPlaceholdersOnly = this.isTextPlaceHoldersOnly(propertyTextUnitPlaceholders);
        IReferenceable resource = null;
        Code c = this.peekMostRecentCode();
        if (c != null) {
            c.setData("");
        }
        resource = inlineCode ? (textPlaceholdersOnly ? parentTu : new DocumentPart(this.documentPartId.createId(), inlineCode)) : (parentTu != null ? parentTu : this.currentDocumentPart);
        Collections.sort(propertyTextUnitPlaceholders);
        PropertyTextUnitPlaceholder pt = propertyTextUnitPlaceholders.get(0);
        this.currentSkeleton.add(tag.substring(0, pt.getMainStartPos()));
        for (PropertyTextUnitPlaceholder propOrText : propertyTextUnitPlaceholders) {
            if (++propOrTextId >= 1 && propOrTextId < propertyTextUnitPlaceholders.size()) {
                PropertyTextUnitPlaceholder pt1 = propertyTextUnitPlaceholders.get(propOrTextId - 1);
                PropertyTextUnitPlaceholder pt2 = propertyTextUnitPlaceholders.get(propOrTextId);
                this.currentSkeleton.add(tag.substring(pt1.getMainEndPos(), pt2.getMainStartPos()));
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.TRANSLATABLE) {
                TextUnit tu = this.embeddedTextUnit(propOrText, tag);
                this.currentSkeleton.addReference(tu);
                this.referencableFilterEvents.add(new Event(EventType.TEXT_UNIT, tu));
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.WRITABLE_PROPERTY) {
                this.embeddedWritableProp((INameable)((Object)resource), propOrText, tag, locale);
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.READ_ONLY_PROPERTY) {
                this.embeddedReadonlyProp((INameable)((Object)resource), propOrText, tag, locale);
                continue;
            }
            if (propOrText.getAccessType() == PropertyTextUnitPlaceholder.PlaceholderAccessType.NAME) {
                resource.setName(propOrText.getValue() + "-" + propOrText.getName());
                this.embeddedReadonlyProp((INameable)((Object)resource), propOrText, tag, locale);
                continue;
            }
            throw new OkapiIllegalFilterOperationException("Unkown Property or TextUnit type");
        }
        pt = propertyTextUnitPlaceholders.get(propertyTextUnitPlaceholders.size() - 1);
        this.currentSkeleton.add(tag.substring(pt.getMainEndPos()));
        if (inlineCode) {
            if (!textPlaceholdersOnly) {
                this.peekMostRecentCode().appendReference(resource.getId());
                resource.setSkeleton(this.currentSkeleton);
                this.referencableFilterEvents.add(new Event(EventType.DOCUMENT_PART, (IResource)((Object)resource)));
            } else {
                this.peekMostRecentCode().append(this.currentSkeleton.toString());
                this.peekMostRecentCode().setReferenceFlag(true);
            }
        }
        return textPlaceholdersOnly;
    }

    public void addTextUnit(String text) {
        this.startTextUnit(text, null, null, null);
        this.endTextUnit();
    }

    public void startTextUnit(String text) {
        this.startTextUnit(text, null, null, null);
    }

    public void startTextUnit() {
        this.startTextUnit(null, null, null, null);
    }

    public void startTextUnit(GenericSkeleton startMarker) {
        this.startTextUnit(null, startMarker, null, null);
    }

    public void startTextUnit(GenericSkeleton startMarker, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startTextUnit(null, startMarker, null, propertyTextUnitPlaceholders);
    }

    public void startTextUnit(String text, GenericSkeleton startMarker, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startTextUnit(text, startMarker, null, propertyTextUnitPlaceholders);
    }

    public void startTextUnit(String text, GenericSkeleton startMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
        TextUnit tu = new TextUnit(this.textUnitId.createId(), text);
        tu.setMimeType(this.mimeType);
        tu.setPreserveWhitespaces(this.preserveWhitespace);
        Event e = this.peekTempEvent();
        if (e != null && e.getEventType() == EventType.TEXT_UNIT) {
            TextUnit parentTu = (TextUnit)e.getResource();
            tu.setIsReferent(true);
            GenericSkeleton skel = (GenericSkeleton)parentTu.getSkeleton();
            if (skel == null) {
                skel = new GenericSkeleton();
            }
            skel.addReference(tu);
            parentTu.setSkeleton(skel);
        }
        if (startMarker != null && propertyTextUnitPlaceholders != null) {
            this.currentSkeleton = new GenericSkeleton();
            this.processAllEmbedded(startMarker.toString(), locale, propertyTextUnitPlaceholders, false, tu);
            tu.setSkeleton(this.currentSkeleton);
            this.currentSkeleton.addContentPlaceholder(tu);
            this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu, this.currentSkeleton));
            this.currentSkeleton = null;
            return;
        }
        if (startMarker != null) {
            GenericSkeleton skel = new GenericSkeleton(startMarker);
            skel.addContentPlaceholder(tu);
            this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu, skel));
            return;
        }
        this.tempFilterEventStack.push(new Event(EventType.TEXT_UNIT, tu));
    }

    public TextUnit endTextUnit() {
        return this.endTextUnit(null, null, null);
    }

    public TextUnit endTextUnit(GenericSkeleton endMarker) {
        return this.endTextUnit(endMarker, null, null);
    }

    public TextUnit endTextUnit(GenericSkeleton endMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentTextUnit()) {
            if (endMarker != null) {
                this.addDocumentPart(endMarker.toString());
            }
            LOGGER.log(Level.FINE, "Trying to end a TextUnit that does not exist.");
            return null;
        }
        Event tempTextUnit = this.popTempEvent();
        if (endMarker != null) {
            GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
            if (skel == null) {
                skel = new GenericSkeleton();
            }
            skel.add(endMarker);
        }
        tempTextUnit.setResource(this.postProcessTextUnit((TextUnit)tempTextUnit.getResource()));
        this.filterEvents.add(tempTextUnit);
        return (TextUnit)tempTextUnit.getResource();
    }

    public void addToTextUnit(String text) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add text to a TextUnit that does not exist.");
        }
        TextUnit tu = this.peekMostRecentTextUnit();
        tu.getSource().getFirstContent().append(text);
    }

    public void addToTextUnit(TextUnit textUnit) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add a TextUnit to a TextUnit that does not exist.");
        }
        TextUnit tu = new TextUnit(this.textUnitId.createId());
        tu.setPreserveWhitespaces(this.preserveWhitespace);
        tu.setMimeType(this.mimeType);
        tu.setIsReferent(true);
        TextUnit parentTU = this.peekMostRecentTextUnit();
        GenericSkeleton skel = (GenericSkeleton)parentTU.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
        }
        skel.addReference(tu);
    }

    public void addToTextUnit(Code code) {
        this.addToTextUnit(code, true);
    }

    public void addToTextUnit(Code code, boolean endCodeNow) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add a Code to a TextUnit that does not exist.");
        }
        this.startCode(code);
        if (endCodeNow) {
            this.endCode();
        }
    }

    public void addToTextUnit(Code code, boolean endCodeNow, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.addToTextUnit(code, endCodeNow, null, propertyTextUnitPlaceholders);
    }

    public void addToTextUnit(Code code, boolean endCodeNow, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentTextUnit()) {
            throw new OkapiIllegalFilterOperationException("Trying to add Codes to a TextUnit that does not exist.");
        }
        this.currentSkeleton = new GenericSkeleton();
        TextUnit tu = this.peekMostRecentTextUnit();
        this.startCode(code);
        this.processAllEmbedded(code.toString(), locale, propertyTextUnitPlaceholders, true, tu);
        if (endCodeNow) {
            this.endCode();
        }
        this.currentSkeleton = null;
    }

    public void appendToFirstSkeletonPart(String text) {
        Event tempTextUnit = this.peekTempEvent();
        GenericSkeleton skel = (GenericSkeleton)tempTextUnit.getResource().getSkeleton();
        skel.appendToFirstPart(text);
    }

    public void startGroup(GenericSkeleton startMarker, String commonTagType) {
        this.startGroup(startMarker, commonTagType, null, null);
    }

    public void startGroup(GenericSkeleton startMarker, String commonTagType, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (startMarker == null) {
            throw new OkapiIllegalFilterOperationException("startMarker for Group is null");
        }
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        }
        if (startMarker != null && propertyTextUnitPlaceholders != null) {
            this.processAllEmbedded(startMarker.toString(), locale, propertyTextUnitPlaceholders, false);
        }
        String gid = this.groupId.createId();
        StartGroup g = new StartGroup(this.findMostRecentParentId(), gid);
        GenericSkeleton skel = new GenericSkeleton(startMarker);
        Event fe = new Event(EventType.START_GROUP, g, skel);
        if (this.isCurrentTextUnit()) {
            g.setIsReferent(true);
            Code c = new Code(TextFragment.TagType.PLACEHOLDER, commonTagType, TextFragment.makeRefMarker(gid));
            c.setReferenceFlag(true);
            this.startCode(c);
            this.endCode();
            this.referencableFilterEvents.add(fe);
        } else {
            this.filterEvents.add(fe);
        }
        this.tempFilterEventStack.push(fe);
    }

    public void endGroup(GenericSkeleton endMarker) {
        this.endGroup(endMarker, null, null);
    }

    public void endGroup(GenericSkeleton endMarker, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (!this.isCurrentGroup()) {
            if (endMarker != null) {
                this.addDocumentPart(endMarker.toString());
            }
            LOGGER.log(Level.FINE, "Trying to end a Group that does not exist.  Possible unbalanced Group tags.");
            return;
        }
        GenericSkeleton skel = new GenericSkeleton(endMarker);
        if (endMarker != null && propertyTextUnitPlaceholders != null) {
            this.processAllEmbedded(endMarker.toString(), locale, propertyTextUnitPlaceholders, false);
        }
        this.popTempEvent();
        Ending eg = new Ending(this.groupId.getLastId("eg"));
        this.filterEvents.add(new Event(EventType.END_GROUP, eg, skel));
    }

    public void startCode(Code code) {
        this.codeStack.push(code);
    }

    public void endCode() {
        Code c = null;
        try {
            c = this.codeStack.pop();
        }
        catch (EmptyStackException e) {
            throw new OkapiIllegalFilterOperationException("Trying to end a Code that does not exist. Did you call startCode?", e);
        }
        TextUnit tu = this.peekMostRecentTextUnit();
        tu.getSource().getFirstContent().append(c);
    }

    public void endCode(String tag) {
        Code c = null;
        try {
            c = this.codeStack.pop();
        }
        catch (EmptyStackException e) {
            throw new OkapiIllegalFilterOperationException("Trying to end a Code that does not exist. Did you call startCode?", e);
        }
        c.appendOuterData(tag);
        TextUnit tu = this.peekMostRecentTextUnit();
        tu.getSource().getFirstContent().append(c);
    }

    public void appendCodeOuterData(String outerData) {
        Code c = this.peekMostRecentCode();
        c.appendOuterData(outerData);
    }

    public void appendCodeData(String data) {
        Code c = this.peekMostRecentCode();
        c.append(data);
    }

    public void addDocumentPart(String part) {
        this.startDocumentPart(part);
        this.endDocumentPart();
    }

    public void startDocumentPart(String part) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        } else if (this.isCurrentTextUnit()) {
            this.endTextUnit();
        }
        this.currentSkeleton = new GenericSkeleton(part);
        this.currentDocumentPart = new DocumentPart(this.documentPartId.createId(), false);
        this.currentDocumentPart.setSkeleton(this.currentSkeleton);
    }

    public void startDocumentPart(String part, String name, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        this.startDocumentPart(part, name, null, propertyTextUnitPlaceholders);
    }

    public void startDocumentPart(String part, String name, LocaleId locale, List<PropertyTextUnitPlaceholder> propertyTextUnitPlaceholders) {
        if (this.hasUnfinishedSkeleton()) {
            this.endDocumentPart();
        } else if (this.isCurrentTextUnit()) {
            this.endTextUnit();
        }
        this.currentSkeleton = new GenericSkeleton();
        this.currentDocumentPart = new DocumentPart(this.documentPartId.createId(), false);
        this.currentDocumentPart.setSkeleton(this.currentSkeleton);
        this.processAllEmbedded(part, locale, propertyTextUnitPlaceholders, false);
    }

    public void endDocumentPart(String part) {
        if (part != null) {
            this.currentSkeleton.append(part);
        }
        this.filterEvents.add(new Event(EventType.DOCUMENT_PART, this.currentDocumentPart));
        this.currentSkeleton = null;
        this.currentDocumentPart = null;
    }

    public void endDocumentPart() {
        this.endDocumentPart(null);
    }

    public void addToDocumentPart(String part) {
        if (this.currentSkeleton == null) {
            this.startDocumentPart(part);
            return;
        }
        this.currentSkeleton.append(part);
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setTextUnitMimeType(String mimeType) {
        TextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setMimeType(mimeType);
        }
    }

    public void setPreserveWhitespace(boolean preserveWhitespace) {
        this.preserveWhitespace = preserveWhitespace;
    }

    public void setTextUnitPreserveWhitespace(boolean preserveWhitespace) {
        TextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setPreserveWhitespaces(preserveWhitespace);
        }
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public long getTextUnitId() {
        return this.textUnitId.getSequence();
    }

    public Code getCurrentCode() {
        return this.peekMostRecentCode();
    }

    public void setTextUnitId(long id) {
        this.textUnitId.setSequence(id);
    }

    public void setTextUnitName(String name) {
        TextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setName(name);
        }
    }

    public void setTextUnitType(String type) {
        TextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setType(type);
        }
    }

    public void setTextUnitTranslatable(boolean translatable) {
        TextUnit tu = this.peekMostRecentTextUnit();
        if (tu != null) {
            tu.setIsTranslatable(translatable);
        }
    }

    public long getDocumentPartId() {
        return this.documentPartId.getSequence();
    }

    public void setDocumentPartId(long id) {
        this.documentPartId.setSequence(id);
    }

    public String getRootId() {
        return this.rootId;
    }

    protected TextUnit postProcessTextUnit(TextUnit textUnit) {
        return textUnit;
    }

    public boolean isTextUnitWithSameType(String type) {
        TextUnit tu;
        Event e = this.peekTempEvent();
        return e != null && e.getEventType() == EventType.TEXT_UNIT && (tu = (TextUnit)e.getResource()) != null && tu.getType() != null && tu.getType().equals(type);
    }

    public IdGenerator getGroupId() {
        return this.groupId;
    }

    public IdGenerator getSubDocumentId() {
        return this.subDocumentId;
    }
}

